/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.blocks;

import com.dairymoose.modernlife.blocks.PavedRoadBlock;
import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.util.ModernLifeUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public class RampBlock
extends Block {
    protected static final VoxelShape SHAPE_WEST = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)0.0, (double)1.0, (double)0.0, (double)15.0, (double)2.0, (double)16.0), Block.func_208617_a((double)0.0, (double)2.0, (double)0.0, (double)14.0, (double)3.0, (double)16.0), Block.func_208617_a((double)0.0, (double)3.0, (double)0.0, (double)13.0, (double)4.0, (double)16.0), Block.func_208617_a((double)0.0, (double)4.0, (double)0.0, (double)12.0, (double)5.0, (double)16.0), Block.func_208617_a((double)0.0, (double)5.0, (double)0.0, (double)11.0, (double)6.0, (double)16.0), Block.func_208617_a((double)0.0, (double)6.0, (double)0.0, (double)10.0, (double)7.0, (double)16.0), Block.func_208617_a((double)0.0, (double)7.0, (double)0.0, (double)9.0, (double)8.0, (double)16.0), Block.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)8.0, (double)9.0, (double)16.0), Block.func_208617_a((double)0.0, (double)9.0, (double)0.0, (double)7.0, (double)10.0, (double)16.0), Block.func_208617_a((double)0.0, (double)10.0, (double)0.0, (double)6.0, (double)11.0, (double)16.0), Block.func_208617_a((double)0.0, (double)11.0, (double)0.0, (double)5.0, (double)12.0, (double)16.0), Block.func_208617_a((double)0.0, (double)12.0, (double)0.0, (double)4.0, (double)13.0, (double)16.0), Block.func_208617_a((double)0.0, (double)13.0, (double)0.0, (double)3.0, (double)14.0, (double)16.0), Block.func_208617_a((double)0.0, (double)14.0, (double)0.0, (double)2.0, (double)15.0, (double)16.0), Block.func_208617_a((double)0.0, (double)15.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0)}).func_197753_c();
    protected static final VoxelShape SHAPE_NORTH = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_WEST);
    protected static final VoxelShape SHAPE_EAST = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_NORTH);
    protected static final VoxelShape SHAPE_SOUTH = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_EAST);
    protected static final VoxelShape SHAPE_EAST_CORNER = Stream.of(Block.func_208617_a((double)-0.75, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), Block.func_208617_a((double)0.5, (double)1.0, (double)0.0, (double)16.0, (double)2.0, (double)15.0), Block.func_208617_a((double)1.5, (double)2.0, (double)0.0, (double)16.0, (double)3.0, (double)14.0), Block.func_208617_a((double)2.5, (double)3.0, (double)0.0, (double)16.0, (double)4.0, (double)13.0), Block.func_208617_a((double)3.5, (double)4.0, (double)0.0, (double)16.0, (double)5.0, (double)12.0), Block.func_208617_a((double)4.5, (double)5.0, (double)0.0, (double)16.0, (double)6.0, (double)11.0), Block.func_208617_a((double)5.5, (double)6.0, (double)0.0, (double)16.0, (double)7.0, (double)10.0), Block.func_208617_a((double)6.5, (double)7.0, (double)0.0, (double)16.0, (double)8.0, (double)9.0), Block.func_208617_a((double)7.5, (double)8.0, (double)0.0, (double)16.0, (double)9.0, (double)8.0), Block.func_208617_a((double)8.5, (double)9.0, (double)0.0, (double)16.0, (double)10.0, (double)7.0), Block.func_208617_a((double)9.5, (double)10.0, (double)0.0, (double)16.0, (double)11.0, (double)6.0), Block.func_208617_a((double)10.5, (double)11.0, (double)0.0, (double)16.0, (double)12.0, (double)5.0), Block.func_208617_a((double)11.5, (double)12.0, (double)0.0, (double)16.0, (double)13.0, (double)4.0), Block.func_208617_a((double)12.5, (double)13.0, (double)0.0, (double)16.0, (double)14.0, (double)3.0), Block.func_208617_a((double)13.5, (double)14.0, (double)0.0, (double)16.0, (double)15.0, (double)2.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    protected static final VoxelShape SHAPE_SOUTH_CORNER = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_EAST_CORNER);
    protected static final VoxelShape SHAPE_WEST_CORNER = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_SOUTH_CORNER);
    protected static final VoxelShape SHAPE_NORTH_CORNER = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_WEST_CORNER);
    protected static final Map<Direction, VoxelShape> SHAPE_MAP;
    protected static final Map<Direction, VoxelShape> SHAPE_MAP_CORNER;
    public static final EnumProperty<Direction> FACING;
    public static final EnumProperty<PartType> PART;

    public RampBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).harvestTool(ToolType.PICKAXE).harvestLevel(0).func_200947_a(SoundType.field_185848_a).func_200943_b(1.0f));
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(FACING, (Comparable)Direction.EAST)).func_206870_a(PART, (Comparable)((Object)PartType.straight)));
    }

    public int getFlammability(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        if (this.field_149764_J.func_76217_h()) {
            return 20;
        }
        return 0;
    }

    public int getFireSpreadSpeed(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        if (this.field_149764_J.func_76217_h()) {
            return 5;
        }
        return 0;
    }

    public RampBlock(AbstractBlock.Properties props) {
        super(props);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(FACING, (Comparable)Direction.EAST));
    }

    public void func_176199_a(World p_176199_1_, BlockPos p_176199_2_, Entity entity) {
        if (p_176199_1_.func_180495_p(p_176199_2_).func_203425_a(CustomBlocks.BLOCK_PAVED_ROAD_RAMP)) {
            PavedRoadBlock.steppedOn(entity);
        }
    }

    public boolean func_220074_n(BlockState p_220074_1_) {
        return true;
    }

    private boolean isOpposite(BlockState first, BlockState second) {
        return first.func_177230_c() == second.func_177230_c() && first.func_177229_b(PART) == second.func_177229_b(PART) && first.func_177229_b(FACING) == ((Direction)second.func_177229_b(FACING)).func_176734_d();
    }

    private BlockState setPartType(IWorld world, BlockState state, BlockPos pos) {
        BlockState nRamp = world.func_180495_p(pos.func_177972_a(Direction.NORTH));
        BlockState eRamp = world.func_180495_p(pos.func_177972_a(Direction.EAST));
        BlockState sRamp = world.func_180495_p(pos.func_177972_a(Direction.SOUTH));
        BlockState wRamp = world.func_180495_p(pos.func_177972_a(Direction.WEST));
        boolean hasNramp = nRamp.func_203425_a((Block)this);
        boolean hasEramp = eRamp.func_203425_a((Block)this);
        boolean hasSramp = sRamp.func_203425_a((Block)this);
        boolean hasWramp = wRamp.func_203425_a((Block)this);
        int adjacentRampCount = (hasNramp ? 1 : 0) + (hasEramp ? 1 : 0) + (hasSramp ? 1 : 0) + (hasWramp ? 1 : 0);
        BlockState forwardState = world.func_180495_p(pos.func_177972_a((Direction)state.func_177229_b(FACING)));
        if (adjacentRampCount >= 2) {
            if (hasSramp && hasWramp && !this.isOpposite(state, forwardState)) {
                state = (BlockState)state.func_206870_a(PART, (Comparable)((Object)PartType.corner));
                state = (BlockState)state.func_206870_a(FACING, (Comparable)Direction.WEST);
            } else if (hasSramp && hasEramp && !this.isOpposite(state, forwardState)) {
                state = (BlockState)state.func_206870_a(PART, (Comparable)((Object)PartType.corner));
                state = (BlockState)state.func_206870_a(FACING, (Comparable)Direction.SOUTH);
            } else if (hasNramp && hasWramp && !this.isOpposite(state, forwardState)) {
                state = (BlockState)state.func_206870_a(PART, (Comparable)((Object)PartType.corner));
                state = (BlockState)state.func_206870_a(FACING, (Comparable)Direction.NORTH);
            } else if (hasNramp && hasEramp && !this.isOpposite(state, forwardState)) {
                state = (BlockState)state.func_206870_a(PART, (Comparable)((Object)PartType.corner));
                state = (BlockState)state.func_206870_a(FACING, (Comparable)Direction.EAST);
            }
        } else {
            if (state.func_177229_b(PART) == PartType.corner) {
                boolean cornerAdjustment = false;
                if (hasNramp && nRamp.func_177229_b(PART) == PartType.corner) {
                    cornerAdjustment = true;
                    state = nRamp.func_177229_b(FACING) == Direction.WEST ? (BlockState)state.func_206870_a(FACING, (Comparable)Direction.WEST) : (BlockState)state.func_206870_a(FACING, (Comparable)Direction.EAST);
                }
                if (hasEramp && eRamp.func_177229_b(PART) == PartType.corner) {
                    cornerAdjustment = true;
                    state = eRamp.func_177229_b(FACING) == Direction.NORTH ? (BlockState)state.func_206870_a(FACING, (Comparable)Direction.NORTH) : (BlockState)state.func_206870_a(FACING, (Comparable)Direction.SOUTH);
                }
                if (hasSramp && sRamp.func_177229_b(PART) == PartType.corner) {
                    cornerAdjustment = true;
                    state = sRamp.func_177229_b(FACING) == Direction.EAST ? (BlockState)state.func_206870_a(FACING, (Comparable)Direction.EAST) : (BlockState)state.func_206870_a(FACING, (Comparable)Direction.WEST);
                }
                if (hasWramp && wRamp.func_177229_b(PART) == PartType.corner) {
                    cornerAdjustment = true;
                    state = wRamp.func_177229_b(FACING) == Direction.EAST ? (BlockState)state.func_206870_a(FACING, (Comparable)Direction.NORTH) : (BlockState)state.func_206870_a(FACING, (Comparable)Direction.SOUTH);
                }
                if (!cornerAdjustment) {
                    if (hasNramp) {
                        state = (BlockState)state.func_206870_a(FACING, nRamp.func_177229_b(FACING));
                    }
                    if (hasEramp) {
                        state = (BlockState)state.func_206870_a(FACING, eRamp.func_177229_b(FACING));
                    }
                    if (hasSramp) {
                        state = (BlockState)state.func_206870_a(FACING, sRamp.func_177229_b(FACING));
                    }
                    if (hasWramp) {
                        state = (BlockState)state.func_206870_a(FACING, wRamp.func_177229_b(FACING));
                    }
                }
            }
            state = (BlockState)state.func_206870_a(PART, (Comparable)((Object)PartType.straight));
        }
        return state;
    }

    public BlockState func_196271_a(BlockState state, Direction p_196271_2_, BlockState p_196271_3_, IWorld world, BlockPos pos, BlockPos p_196271_6_) {
        return this.setPartType(world, state, pos);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, PART});
    }

    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        if (p_220053_1_.func_177229_b(PART) == PartType.corner) {
            VoxelShape result = SHAPE_MAP_CORNER.get(p_220053_1_.func_177229_b(FACING));
            return result == null ? SHAPE_EAST_CORNER : result;
        }
        VoxelShape result = SHAPE_MAP.get(p_220053_1_.func_177229_b(FACING));
        return result == null ? SHAPE_EAST : result;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return this.setPartType((IWorld)context.func_195991_k(), (BlockState)this.func_176223_P().func_206870_a(FACING, (Comparable)context.func_195992_f()), context.func_195995_a());
    }

    static {
        HashMap<Direction, VoxelShape> shapes = new HashMap<Direction, VoxelShape>();
        shapes.put(Direction.EAST, SHAPE_EAST);
        shapes.put(Direction.SOUTH, SHAPE_SOUTH);
        shapes.put(Direction.WEST, SHAPE_WEST);
        shapes.put(Direction.NORTH, SHAPE_NORTH);
        SHAPE_MAP = Collections.unmodifiableMap(shapes);
        shapes = new HashMap();
        shapes.put(Direction.EAST, SHAPE_EAST_CORNER);
        shapes.put(Direction.SOUTH, SHAPE_SOUTH_CORNER);
        shapes.put(Direction.WEST, SHAPE_WEST_CORNER);
        shapes.put(Direction.NORTH, SHAPE_NORTH_CORNER);
        SHAPE_MAP_CORNER = Collections.unmodifiableMap(shapes);
        FACING = BlockStateProperties.field_208157_J;
        PART = EnumProperty.func_177709_a((String)"part", PartType.class);
    }

    public static enum PartType implements IStringSerializable
    {
        straight,
        corner;


        public String func_176610_l() {
            return this.name().toLowerCase();
        }
    }
}

