/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.blocks;

import com.dairymoose.modernlife.blocks.AbstractWallBlock;
import com.dairymoose.modernlife.tileentities.ShowerHeadTileEntity;
import com.dairymoose.modernlife.util.ModernLifeUtil;
import java.util.stream.Stream;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class ShowerHeadBlock
extends AbstractWallBlock {
    protected static final VoxelShape SHAPE_NORTH = Stream.of(Block.func_208617_a((double)6.5, (double)9.0, (double)10.75, (double)9.5, (double)12.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    protected static final VoxelShape SHAPE_EAST = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_NORTH);
    protected static final VoxelShape SHAPE_SOUTH = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_EAST);
    protected static final VoxelShape SHAPE_WEST = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_SOUTH);

    public ShowerHeadBlock(AbstractBlock.Properties props) {
        super(props);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.SOUTH));
    }

    public boolean hasTileEntity(BlockState bs) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ShowerHeadTileEntity.SHOWER_HEAD.func_200968_a();
    }

    public ActionResultType func_225533_a_(BlockState blockState, World world, BlockPos pos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult rayTrace) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof ShowerHeadTileEntity) {
            ShowerHeadTileEntity showerHead = (ShowerHeadTileEntity)tileEntity;
            if (!showerHead.isRunning()) {
                showerHead.startRunning();
            } else {
                showerHead.stopRunning();
            }
            if (!world.field_72995_K) {
                ((ServerWorld)world).func_184138_a(pos, blockState, blockState, 2);
            }
        }
        return ActionResultType.CONSUME;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }

    public VoxelShape func_220053_a(BlockState bs, IBlockReader reader, BlockPos pos, ISelectionContext sel) {
        switch ((Direction)bs.func_177229_b((Property)FACING)) {
            case NORTH: {
                return SHAPE_NORTH;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case EAST: {
                return SHAPE_EAST;
            }
            case WEST: {
                return SHAPE_WEST;
            }
        }
        return SHAPE_NORTH;
    }
}

