/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.blocks;

import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;

public class SmallTableBlock
extends Block {
    protected static final VoxelShape SHAPE_NORMAL = Stream.of(Block.func_208617_a((double)0.01, (double)0.0, (double)0.01, (double)15.99, (double)16.0, (double)15.99)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    public static final EnumProperty<TableType> TYPE = EnumProperty.func_177709_a((String)"type", TableType.class);

    public SmallTableBlock(AbstractBlock.Properties p_i48377_1_) {
        super(p_i48377_1_);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a(TYPE, (Comparable)((Object)TableType.single)));
    }

    public SmallTableBlock(AbstractBlock.Properties p_i48377_1_, boolean skipDefaultState) {
        super(p_i48377_1_);
        if (!skipDefaultState) {
            this.func_180632_j((BlockState)this.func_176223_P().func_206870_a(TYPE, (Comparable)((Object)TableType.single)));
        }
    }

    public int getFlammability(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        if (this.field_149764_J.func_76217_h()) {
            return 20;
        }
        return 0;
    }

    public int getFireSpreadSpeed(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        if (this.field_149764_J.func_76217_h()) {
            return 5;
        }
        return 0;
    }

    public BlockState func_196271_a(BlockState state, Direction dir, BlockState updater, IWorld world, BlockPos pos, BlockPos updaterPos) {
        return this.getNewState(world, pos);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{TYPE});
    }

    protected BlockState getNewState(IWorld world, BlockPos pos) {
        BlockState nState = world.func_180495_p(pos.func_177978_c());
        BlockState eState = world.func_180495_p(pos.func_177974_f());
        BlockState sState = world.func_180495_p(pos.func_177968_d());
        BlockState wState = world.func_180495_p(pos.func_177976_e());
        int adjacentTableCount = 0;
        boolean nTable = nState.func_203425_a((Block)this);
        boolean eTable = eState.func_203425_a((Block)this);
        boolean sTable = sState.func_203425_a((Block)this);
        boolean wTable = wState.func_203425_a((Block)this);
        if (nTable) {
            ++adjacentTableCount;
        }
        if (eTable) {
            ++adjacentTableCount;
        }
        if (sTable) {
            ++adjacentTableCount;
        }
        if (wTable) {
            ++adjacentTableCount;
        }
        if (adjacentTableCount >= 2) {
            if (nTable && eTable && !sTable && !wTable) {
                return (BlockState)this.func_176223_P().func_206870_a(TYPE, (Comparable)((Object)TableType.sw_corner));
            }
            if (nTable && wTable && !sTable && !eTable) {
                return (BlockState)this.func_176223_P().func_206870_a(TYPE, (Comparable)((Object)TableType.se_corner));
            }
            if (sTable && eTable && !nTable && !wTable) {
                return (BlockState)this.func_176223_P().func_206870_a(TYPE, (Comparable)((Object)TableType.nw_corner));
            }
            if (sTable && wTable && !nTable && !eTable) {
                return (BlockState)this.func_176223_P().func_206870_a(TYPE, (Comparable)((Object)TableType.ne_corner));
            }
            return (BlockState)this.func_176223_P().func_206870_a(TYPE, (Comparable)((Object)TableType.mid));
        }
        if (adjacentTableCount == 1) {
            if (nTable) {
                return (BlockState)this.func_176223_P().func_206870_a(TYPE, (Comparable)((Object)TableType.s_end));
            }
            if (eTable) {
                return (BlockState)this.func_176223_P().func_206870_a(TYPE, (Comparable)((Object)TableType.w_end));
            }
            if (sTable) {
                return (BlockState)this.func_176223_P().func_206870_a(TYPE, (Comparable)((Object)TableType.n_end));
            }
            if (wTable) {
                return (BlockState)this.func_176223_P().func_206870_a(TYPE, (Comparable)((Object)TableType.e_end));
            }
        }
        return this.func_176223_P();
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return this.getNewState((IWorld)context.func_195991_k(), context.func_195995_a());
    }

    public VoxelShape func_220053_a(BlockState bs, IBlockReader reader, BlockPos pos, ISelectionContext sel) {
        return SHAPE_NORMAL;
    }

    public static enum TableType implements IStringSerializable
    {
        single,
        mid,
        s_end,
        w_end,
        n_end,
        e_end,
        ne_corner,
        se_corner,
        nw_corner,
        sw_corner;


        public String func_176610_l() {
            return this.name().toLowerCase();
        }
    }
}

