/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.blocks;

import com.dairymoose.entity.DummyEntity;
import com.dairymoose.modernlife.util.ModernLifeUtil;
import java.util.stream.Stream;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class SofaBlock
extends Block {
    protected static final VoxelShape SHAPE_SOUTH_SINGLE = Stream.of(Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)17.0, (double)3.0), Block.func_208617_a((double)13.0, (double)0.0, (double)3.0, (double)16.0, (double)11.0, (double)16.0), Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)4.0, (double)16.0), Block.func_208617_a((double)3.25, (double)4.0, (double)4.0, (double)12.75, (double)7.0, (double)15.0), Block.func_208617_a((double)0.0, (double)0.0, (double)3.0, (double)3.0, (double)11.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    protected static final VoxelShape SHAPE_WEST_SINGLE = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_SOUTH_SINGLE);
    protected static final VoxelShape SHAPE_NORTH_SINGLE = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_WEST_SINGLE);
    protected static final VoxelShape SHAPE_EAST_SINGLE = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_NORTH_SINGLE);
    protected static final VoxelShape SHAPE_SOUTH_MIDDLE = Stream.of(Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)17.0, (double)3.0), Block.func_208617_a((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)4.0, (double)16.0), Block.func_208617_a((double)0.0, (double)4.0, (double)4.0, (double)16.0, (double)7.0, (double)15.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    protected static final VoxelShape SHAPE_WEST_MIDDLE = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_SOUTH_MIDDLE);
    protected static final VoxelShape SHAPE_NORTH_MIDDLE = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_WEST_MIDDLE);
    protected static final VoxelShape SHAPE_EAST_MIDDLE = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_NORTH_MIDDLE);
    protected static final VoxelShape SHAPE_SOUTH_LEFT = Stream.of(Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)17.0, (double)3.0), Block.func_208617_a((double)0.0, (double)0.0, (double)3.0, (double)3.0, (double)11.0, (double)16.0), Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)16.0, (double)4.0, (double)16.0), Block.func_208617_a((double)3.25, (double)4.0, (double)4.0, (double)16.0, (double)7.0, (double)15.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    protected static final VoxelShape SHAPE_WEST_LEFT = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_SOUTH_LEFT);
    protected static final VoxelShape SHAPE_NORTH_LEFT = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_WEST_LEFT);
    protected static final VoxelShape SHAPE_EAST_LEFT = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_NORTH_LEFT);
    protected static final VoxelShape SHAPE_SOUTH_RIGHT = Stream.of(Block.func_208617_a((double)13.0, (double)0.0, (double)3.0, (double)16.0, (double)11.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)17.0, (double)3.0), Block.func_208617_a((double)0.0, (double)0.0, (double)3.0, (double)13.0, (double)4.0, (double)16.0), Block.func_208617_a((double)0.0, (double)4.0, (double)4.0, (double)12.75, (double)7.0, (double)15.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    protected static final VoxelShape SHAPE_WEST_RIGHT = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_SOUTH_RIGHT);
    protected static final VoxelShape SHAPE_NORTH_RIGHT = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_WEST_RIGHT);
    protected static final VoxelShape SHAPE_EAST_RIGHT = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_NORTH_RIGHT);
    protected static final VoxelShape SHAPE_SOUTH_CORNER = Stream.of(Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)16.0, (double)4.0, (double)16.0), Block.func_208617_a((double)4.0, (double)4.0, (double)4.0, (double)15.0, (double)7.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)17.0, (double)3.0), Block.func_208617_a((double)0.0, (double)0.0, (double)3.0, (double)3.0, (double)17.0, (double)16.0), Block.func_208617_a((double)15.0, (double)4.0, (double)4.0, (double)16.0, (double)7.0, (double)15.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    protected static final VoxelShape SHAPE_WEST_CORNER = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_SOUTH_CORNER);
    protected static final VoxelShape SHAPE_NORTH_CORNER = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_WEST_CORNER);
    protected static final VoxelShape SHAPE_EAST_CORNER = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_NORTH_CORNER);
    public static final EnumProperty<SofaType> TYPE;
    public static final DirectionProperty FACING;

    public SofaBlock(AbstractBlock.Properties p_i48377_1_) {
        super(p_i48377_1_);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a(TYPE, (Comparable)((Object)SofaType.single)));
    }

    public ActionResultType func_225533_a_(BlockState p_225533_1_, World p_225533_2_, BlockPos p_225533_3_, PlayerEntity player, Hand p_225533_5_, BlockRayTraceResult p_225533_6_) {
        if (!p_225533_2_.field_72995_K) {
            DummyEntity dummy = DummyEntity.getEntity(0.23f, p_225533_2_, p_225533_3_, false);
            dummy.ride(player);
        }
        return ActionResultType.CONSUME;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction newFacing = context.func_195992_f().func_176734_d();
        BlockState state = this.getNewState(null, (IWorld)context.func_195991_k(), context.func_195995_a(), newFacing);
        if (state == null) {
            state = this.func_176223_P();
        }
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)newFacing);
    }

    public BlockState func_196271_a(BlockState state, Direction dir, BlockState updater, IWorld world, BlockPos pos, BlockPos updaterPos) {
        return this.getNewState(state, world, pos, (Direction)state.func_177229_b((Property)FACING));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, TYPE});
    }

    private BlockState getNewState(BlockState currentState, IWorld world, BlockPos pos, Direction facing) {
        if (currentState == null) {
            currentState = this.func_176223_P();
        }
        BlockState cwState = world.func_180495_p(pos.func_177972_a(facing.func_176746_e()));
        BlockState ccwState = world.func_180495_p(pos.func_177972_a(facing.func_176735_f()));
        BlockState frontState = world.func_180495_p(pos.func_177972_a(facing));
        int adjacentSofaCount = 0;
        boolean cwSofa = cwState.func_203425_a((Block)this) && (cwState.func_177229_b((Property)FACING) == facing || cwState.func_177229_b(TYPE) == SofaType.corner);
        boolean ccwSofa = ccwState.func_203425_a((Block)this) && (ccwState.func_177229_b((Property)FACING) == facing || ccwState.func_177229_b(TYPE) == SofaType.corner);
        boolean frontSofa = frontState.func_203425_a((Block)this);
        if (cwSofa) {
            ++adjacentSofaCount;
        }
        if (ccwSofa) {
            ++adjacentSofaCount;
        }
        if (adjacentSofaCount >= 2) {
            return (BlockState)currentState.func_206870_a(TYPE, (Comparable)((Object)SofaType.middle));
        }
        if (adjacentSofaCount == 1) {
            if (frontSofa) {
                BlockState adjacentSofa = null;
                adjacentSofa = cwState.func_203425_a((Block)this) ? cwState : ccwState;
                if (adjacentSofa.func_177229_b((Property)FACING) == facing) {
                    Direction withDirection = facing;
                    if (adjacentSofa != ccwState) {
                        withDirection = (Direction)frontState.func_177229_b((Property)FACING);
                    }
                    return (BlockState)((BlockState)currentState.func_206870_a(TYPE, (Comparable)((Object)SofaType.corner))).func_206870_a((Property)FACING, (Comparable)withDirection);
                }
            }
            if (cwSofa) {
                return (BlockState)currentState.func_206870_a(TYPE, (Comparable)((Object)SofaType.right));
            }
            if (ccwSofa) {
                return (BlockState)currentState.func_206870_a(TYPE, (Comparable)((Object)SofaType.left));
            }
        }
        return (BlockState)currentState.func_206870_a(TYPE, (Comparable)((Object)SofaType.single));
    }

    public VoxelShape func_220053_a(BlockState bs, IBlockReader reader, BlockPos pos, ISelectionContext sel) {
        if (bs.func_177229_b(TYPE) == SofaType.single) {
            switch ((Direction)bs.func_177229_b((Property)FACING)) {
                case NORTH: {
                    return SHAPE_NORTH_SINGLE;
                }
                case SOUTH: {
                    return SHAPE_SOUTH_SINGLE;
                }
                case EAST: {
                    return SHAPE_EAST_SINGLE;
                }
                case WEST: {
                    return SHAPE_WEST_SINGLE;
                }
            }
        } else if (bs.func_177229_b(TYPE) == SofaType.middle) {
            switch ((Direction)bs.func_177229_b((Property)FACING)) {
                case NORTH: {
                    return SHAPE_NORTH_MIDDLE;
                }
                case SOUTH: {
                    return SHAPE_SOUTH_MIDDLE;
                }
                case EAST: {
                    return SHAPE_EAST_MIDDLE;
                }
                case WEST: {
                    return SHAPE_WEST_MIDDLE;
                }
            }
        } else if (bs.func_177229_b(TYPE) == SofaType.left) {
            switch ((Direction)bs.func_177229_b((Property)FACING)) {
                case NORTH: {
                    return SHAPE_NORTH_LEFT;
                }
                case SOUTH: {
                    return SHAPE_SOUTH_LEFT;
                }
                case EAST: {
                    return SHAPE_EAST_LEFT;
                }
                case WEST: {
                    return SHAPE_WEST_LEFT;
                }
            }
        } else if (bs.func_177229_b(TYPE) == SofaType.right) {
            switch ((Direction)bs.func_177229_b((Property)FACING)) {
                case NORTH: {
                    return SHAPE_NORTH_RIGHT;
                }
                case SOUTH: {
                    return SHAPE_SOUTH_RIGHT;
                }
                case EAST: {
                    return SHAPE_EAST_RIGHT;
                }
                case WEST: {
                    return SHAPE_WEST_RIGHT;
                }
            }
        } else if (bs.func_177229_b(TYPE) == SofaType.corner) {
            switch ((Direction)bs.func_177229_b((Property)FACING)) {
                case NORTH: {
                    return SHAPE_NORTH_CORNER;
                }
                case SOUTH: {
                    return SHAPE_SOUTH_CORNER;
                }
                case EAST: {
                    return SHAPE_EAST_CORNER;
                }
                case WEST: {
                    return SHAPE_WEST_CORNER;
                }
            }
        }
        return SHAPE_NORTH_SINGLE;
    }

    static {
        FACING = BlockStateProperties.field_208157_J;
        TYPE = EnumProperty.func_177709_a((String)"type", SofaType.class);
    }

    public static enum SofaType implements IStringSerializable
    {
        single,
        middle,
        left,
        right,
        corner;


        public String func_176610_l() {
            return this.name().toLowerCase();
        }
    }
}

