/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.blocks;

import com.dairymoose.modernlife.blocks.StandardHorizontalBlock;
import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.tileentities.StoveTileEntity;
import com.dairymoose.modernlife.util.ModernLifeUtil;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CampfireCookingRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class StoveBlock
extends StandardHorizontalBlock {
    protected static final VoxelShape SHAPE_NORTH = Stream.of(Block.func_208617_a((double)0.0, (double)12.75, (double)0.0, (double)16.0, (double)16.0, (double)1.5), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.75, (double)15.5)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    protected static final VoxelShape SHAPE_EAST = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_NORTH);
    protected static final VoxelShape SHAPE_SOUTH = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_EAST);
    protected static final VoxelShape SHAPE_WEST = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_SOUTH);
    public static final BooleanProperty OPEN_DOOR = BooleanProperty.func_177716_a((String)"open_door");

    public StoveBlock(AbstractBlock.Properties p_i48377_1_) {
        super(p_i48377_1_);
        this.func_180632_j((BlockState)super.func_176223_P().func_206870_a((Property)OPEN_DOOR, (Comparable)Boolean.valueOf(false)));
    }

    public boolean hasTileEntity(BlockState bs) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        StoveTileEntity toReturn = (StoveTileEntity)StoveTileEntity.STOVE.func_200968_a();
        return toReturn;
    }

    public void func_196243_a(BlockState newBlockState, World world, BlockPos pos, BlockState oldBlockState, boolean b) {
        if (!newBlockState.func_203425_a(oldBlockState.func_177230_c())) {
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof StoveTileEntity) {
                InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((StoveTileEntity)tileEntity));
                world.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(newBlockState, world, pos, oldBlockState, b);
        }
    }

    public ActionResultType func_225533_a_(BlockState blockState, World world, BlockPos blockPos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTrace) {
        if (!world.field_72995_K) {
            if (blockState.func_203425_a(CustomBlocks.BLOCK_STOVE) && !((Boolean)blockState.func_177229_b((Property)OPEN_DOOR)).booleanValue()) {
                world.func_175656_a(blockPos, (BlockState)blockState.func_206870_a((Property)OPEN_DOOR, (Comparable)Boolean.valueOf(true)));
            } else {
                int slot;
                ItemStack itemStack = player.func_184586_b(hand);
                TileEntity tileEntity = world.func_175625_s(blockPos);
                StoveTileEntity stoveTileEntity = null;
                if (tileEntity instanceof StoveTileEntity) {
                    stoveTileEntity = (StoveTileEntity)tileEntity;
                }
                boolean tookItem = false;
                boolean placedItem = false;
                if (!itemStack.equals(ItemStack.field_190927_a)) {
                    Optional optional = world.func_199532_z().func_215371_a(IRecipeType.field_222153_e, (IInventory)new Inventory(new ItemStack[]{itemStack}), world);
                    if (optional.isPresent() && stoveTileEntity != null && !stoveTileEntity.isFull()) {
                        ItemStack oneItem = itemStack.func_77979_a(1);
                        stoveTileEntity.cookItem(oneItem, (int)((float)((CampfireCookingRecipe)optional.get()).func_222137_e() / 1.5f));
                        placedItem = true;
                    }
                } else if (stoveTileEntity != null && !stoveTileEntity.func_191420_l() && player.func_226271_bk_() && (slot = stoveTileEntity.getNextOccupiedSlot()) != -1) {
                    player.func_191521_c(stoveTileEntity.func_70301_a(slot).func_77946_l());
                    stoveTileEntity.func_70299_a(slot, ItemStack.field_190927_a);
                    tookItem = true;
                }
                if (!tookItem && !placedItem) {
                    world.func_175656_a(blockPos, (BlockState)blockState.func_206870_a((Property)OPEN_DOOR, (Comparable)Boolean.valueOf(false)));
                } else if (!tookItem && stoveTileEntity.isFull()) {
                    world.func_175656_a(blockPos, (BlockState)blockState.func_206870_a((Property)OPEN_DOOR, (Comparable)Boolean.valueOf(false)));
                }
                world.func_184138_a(blockPos, blockState, blockState, 2);
            }
        }
        return ActionResultType.CONSUME;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_185512_D, OPEN_DOOR});
    }

    public VoxelShape func_220053_a(BlockState bs, IBlockReader reader, BlockPos pos, ISelectionContext sel) {
        switch ((Direction)bs.func_177229_b((Property)field_185512_D)) {
            case NORTH: {
                return SHAPE_NORTH;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case EAST: {
                return SHAPE_EAST;
            }
            case WEST: {
                return SHAPE_WEST;
            }
        }
        return SHAPE_NORTH;
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)context.func_195992_f());
    }
}

