/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.blocks;

import com.dairymoose.modernlife.blocks.LightBulbBlock;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalFaceBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileLightBlock
extends HorizontalFaceBlock {
    protected static final VoxelShape SHAPE_NORTH = Stream.of(Block.func_208617_a((double)5.0, (double)15.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0), Block.func_208617_a((double)5.5, (double)14.0, (double)5.5, (double)10.5, (double)15.0, (double)10.5)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack itemStack, @Nullable IBlockReader blockReader, List<ITextComponent> list, ITooltipFlag tooltipFlag) {
        list.add((ITextComponent)new StringTextComponent("Requires redstone power to operate"));
    }

    public TileLightBlock(AbstractBlock.Properties props) {
        super(props.func_235838_a_(LightBulbBlock::getLightLevel).func_235856_e_(new AbstractBlock.IPositionPredicate(){

            public boolean test(BlockState state, IBlockReader reader, BlockPos pos) {
                return (Boolean)state.func_177229_b((Property)POWERED) != false;
            }
        }));
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_196366_M, (Comparable)AttachFace.CEILING)).func_206870_a((Property)field_185512_D, (Comparable)Direction.NORTH)).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public static int getLightLevel(BlockState state) {
        if (((Boolean)state.func_177229_b((Property)POWERED)).booleanValue()) {
            return 15;
        }
        return 0;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        boolean signal = false;
        BlockPos pos = context.func_195995_a();
        signal = context.func_195991_k().func_175640_z(pos);
        return (BlockState)this.func_176223_P().func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(signal));
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos neighborPos, boolean p_220069_6_) {
        boolean signal = world.func_175640_z(pos);
        if (block != this && signal != (Boolean)state.func_177229_b((Property)POWERED)) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(signal)), 2);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_196366_M, field_185512_D, POWERED});
    }

    public VoxelShape func_220053_a(BlockState bs, IBlockReader reader, BlockPos pos, ISelectionContext sel) {
        switch ((Direction)bs.func_177229_b((Property)field_185512_D)) {
            case NORTH: {
                return SHAPE_NORTH;
            }
            case SOUTH: {
                return SHAPE_NORTH;
            }
            case EAST: {
                return SHAPE_NORTH;
            }
            case WEST: {
                return SHAPE_NORTH;
            }
        }
        return SHAPE_NORTH;
    }
}

