/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.blocks;

import com.dairymoose.modernlife.blocks.StandardHorizontalBlock;
import com.dairymoose.modernlife.util.ModernLifeUtil;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TurntableBlock
extends StandardHorizontalBlock {
    protected static final VoxelShape SHAPE_NORTH = Stream.of(Block.func_208617_a((double)8.7, (double)0.0, (double)7.585786437626905, (double)9.0, (double)15.0, (double)8.414213562373096), Block.func_208617_a((double)6.408701060962736, (double)15.0, (double)0.0, (double)9.591298939037264, (double)16.0, (double)7.0), Block.func_208617_a((double)6.408701060962736, (double)15.0, (double)0.0, (double)9.591298939037264, (double)15.975000000000001, (double)7.0), Block.func_208617_a((double)6.408701060962736, (double)15.0, (double)0.0, (double)9.591298939037264, (double)16.0, (double)7.0), Block.func_208617_a((double)6.408701060962736, (double)15.0, (double)0.0, (double)9.591298939037264, (double)15.975000000000001, (double)7.0), Block.func_208617_a((double)6.408701060962736, (double)15.0, (double)0.0, (double)9.591298939037264, (double)16.0, (double)7.0), Block.func_208617_a((double)6.408701060962736, (double)15.0, (double)9.0, (double)9.591298939037264, (double)16.0, (double)16.0), Block.func_208617_a((double)6.408701060962736, (double)15.0, (double)9.0, (double)9.591298939037264, (double)15.975000000000001, (double)16.0), Block.func_208617_a((double)6.408701060962736, (double)15.0, (double)9.0, (double)9.591298939037264, (double)16.0, (double)16.0), Block.func_208617_a((double)6.408701060962736, (double)15.0, (double)9.0, (double)9.591298939037264, (double)15.975000000000001, (double)16.0), Block.func_208617_a((double)6.408701060962736, (double)15.0, (double)9.0, (double)9.591298939037264, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)15.0, (double)6.408701060962736, (double)7.0, (double)15.975000000000001, (double)9.591298939037264), Block.func_208617_a((double)0.0, (double)15.0, (double)6.408701060962736, (double)7.0, (double)16.0, (double)9.591298939037264), Block.func_208617_a((double)0.0, (double)15.0, (double)6.408701060962736, (double)7.0, (double)15.975000000000001, (double)9.591298939037264), Block.func_208617_a((double)9.0, (double)15.0, (double)6.408701060962736, (double)16.0, (double)15.975000000000001, (double)9.591298939037264), Block.func_208617_a((double)9.0, (double)15.0, (double)6.408701060962736, (double)16.0, (double)16.0, (double)9.591298939037264), Block.func_208617_a((double)9.0, (double)15.0, (double)6.408701060962736, (double)16.0, (double)15.975000000000001, (double)9.591298939037264), Block.func_208617_a((double)4.5, (double)15.5, (double)4.5, (double)11.5, (double)16.002, (double)11.5), Block.func_208617_a((double)7.585786437626905, (double)0.0, (double)7.0, (double)8.414213562373096, (double)15.0, (double)7.3), Block.func_208617_a((double)7.585786437626905, (double)0.0, (double)7.0, (double)8.414213562373096, (double)15.0, (double)7.3), Block.func_208617_a((double)7.585786437626905, (double)0.0, (double)8.7, (double)8.414213562373096, (double)15.0, (double)9.0), Block.func_208617_a((double)7.585786437626905, (double)0.0, (double)8.7, (double)8.414213562373096, (double)15.0, (double)9.0), Block.func_208617_a((double)7.0, (double)0.0, (double)7.585786437626905, (double)7.3, (double)15.0, (double)8.414213562373096), Block.func_208617_a((double)7.0, (double)0.0, (double)7.585786437626905, (double)7.3, (double)15.0, (double)8.414213562373096), Block.func_208617_a((double)8.7, (double)0.0, (double)7.585786437626905, (double)9.0, (double)15.0, (double)8.414213562373096)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    protected static final VoxelShape SHAPE_EAST = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_NORTH);
    protected static final VoxelShape SHAPE_SOUTH = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_EAST);
    protected static final VoxelShape SHAPE_WEST = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_SOUTH);
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack itemStack, @Nullable IBlockReader blockReader, List<ITextComponent> list, ITooltipFlag tooltipFlag) {
        list.add((ITextComponent)new StringTextComponent("Rotates clockwise when powered by redstone"));
    }

    public TurntableBlock(AbstractBlock.Properties p_i48377_1_) {
        super(p_i48377_1_);
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos neighborPos, boolean p_220069_6_) {
        boolean signal = world.func_175640_z(pos);
        Boolean currentPoweredState = (Boolean)state.func_177229_b((Property)POWERED);
        if (block != this && signal != currentPoweredState) {
            BlockState newFacing = state;
            if (signal) {
                List aboveEntities;
                Direction currentFacing;
                Direction turntableFacing = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J);
                turntableFacing = turntableFacing.func_176746_e();
                newFacing = (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)turntableFacing);
                BlockPos abovePos = pos.func_177984_a();
                BlockState aboveState = world.func_180495_p(abovePos);
                if (aboveState.func_203425_a(Blocks.field_150331_J)) {
                    world.func_180501_a(abovePos, (BlockState)aboveState.func_206870_a((Property)BlockStateProperties.field_208181_h, (Comparable)Boolean.valueOf(false)), 2);
                }
                if (aboveState.func_235903_d_((Property)BlockStateProperties.field_208157_J).isPresent()) {
                    currentFacing = (Direction)aboveState.func_177229_b((Property)BlockStateProperties.field_208157_J);
                    currentFacing = currentFacing.func_176746_e();
                    aboveState = (BlockState)aboveState.func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)currentFacing);
                    world.func_180501_a(abovePos, aboveState, 2);
                }
                if (aboveState.func_235903_d_((Property)BlockStateProperties.field_208155_H).isPresent()) {
                    if (aboveState.func_177229_b((Property)BlockStateProperties.field_208155_H) == Direction.UP) {
                        world.func_180501_a(abovePos, (BlockState)aboveState.func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)Direction.DOWN), 2);
                    } else if (aboveState.func_177229_b((Property)BlockStateProperties.field_208155_H) == Direction.DOWN) {
                        world.func_180501_a(abovePos, (BlockState)aboveState.func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)Direction.UP), 2);
                    } else {
                        currentFacing = (Direction)aboveState.func_177229_b((Property)BlockStateProperties.field_208155_H);
                        currentFacing = currentFacing.func_176746_e();
                        aboveState = (BlockState)aboveState.func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)currentFacing);
                        world.func_180501_a(abovePos, aboveState, 2);
                    }
                }
                if (aboveState.func_235903_d_((Property)BlockStateProperties.field_208156_I).isPresent() && (currentFacing = (Direction)aboveState.func_177229_b((Property)BlockStateProperties.field_208156_I)) != Direction.DOWN) {
                    currentFacing = currentFacing.func_176746_e();
                    aboveState = (BlockState)aboveState.func_206870_a((Property)BlockStateProperties.field_208156_I, (Comparable)currentFacing);
                    world.func_180501_a(abovePos, aboveState, 2);
                }
                if ((aboveEntities = world.func_72839_b(null, AxisAlignedBB.func_241550_g_((double)1.0, (double)1.0, (double)1.0).func_72317_d((double)abovePos.func_177958_n() + 0.5, (double)abovePos.func_177956_o() + 0.5, (double)abovePos.func_177952_p() + 0.5))) != null && aboveEntities.size() > 0) {
                    for (Entity entity : aboveEntities) {
                        double centX = (double)abovePos.func_177958_n() + 0.5;
                        double centY = abovePos.func_177956_o();
                        double centZ = (double)abovePos.func_177952_p() + 0.5;
                        double distToCenter = Math.sqrt(entity.func_70092_e(centX, centY, centZ));
                        double xDiff = entity.func_226277_ct_() - centX;
                        double zDiff = entity.func_226281_cx_() - centZ;
                        double entityAngle = Math.toDegrees(Math.atan2(zDiff, xDiff));
                        entityAngle = (entityAngle + 90.0) % 360.0;
                        entity.field_70177_z = entity.func_184229_a(Rotation.CLOCKWISE_90) % 360.0f;
                        double newX = centX + distToCenter * Math.cos(Math.toRadians(entityAngle));
                        double newZ = centZ + distToCenter * Math.sin(Math.toRadians(entityAngle));
                        entity.func_70634_a(newX, entity.func_226278_cu_(), newZ);
                    }
                }
            }
            world.func_180501_a(pos, (BlockState)newFacing.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(signal)), 2);
        }
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_185512_D, POWERED});
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)super.func_196258_a(context).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(context.func_195991_k().func_175640_z(context.func_195995_a())));
    }

    public VoxelShape func_220053_a(BlockState blockState, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        switch ((Direction)blockState.func_177229_b((Property)field_185512_D)) {
            case NORTH: {
                return SHAPE_NORTH;
            }
            case SOUTH: {
                return SHAPE_NORTH;
            }
            case EAST: {
                return SHAPE_NORTH;
            }
            case WEST: {
                return SHAPE_NORTH;
            }
        }
        return SHAPE_NORTH;
    }
}

