/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.blocks.gui;

import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.core.ModernLifeNetwork;
import com.dairymoose.modernlife.items.GuitarItem;
import com.dairymoose.modernlife.network.play.client.CGuitarPacket;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class GuitarScreen
extends Screen {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation GUITAR_GUI = new ResourceLocation("modernlife", "textures/gui/mc_guitar_keys_full.png");
    final int GUI_WIDTH = 256;
    final int GUI_HEIGHT = 134;
    private World world;
    private PlayerEntity player;
    GuitarItem.Tuning string = GuitarItem.Tuning.STRING_E;
    int lastPlayedFret = -1;
    int counter = 1;
    char[] fretKeys = new char[]{'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I', 'O', 'P', 'A', 'S', 'D', 'F', 'G', 'H', 'J', 'K', 'L', 'Z', 'X', 'C', 'V', 'B', 'N'};
    char[] stringKeys = new char[]{'1', '2', '3', '4', '5', '6'};

    public GuitarScreen(World world, PlayerEntity player) {
        super((ITextComponent)new StringTextComponent("Guitar").func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)0x404040))));
        this.world = world;
        this.player = player;
    }

    protected void func_231160_c_() {
        LOGGER.debug("in init!");
        int startX = (this.field_230708_k_ - 256) / 2;
        int startY = (this.field_230709_l_ - 134) / 2;
    }

    public boolean func_231177_au__() {
        return false;
    }

    private boolean areaContainsAmplifier(BlockPos pos) {
        BlockState state = this.world.func_180495_p(pos);
        if (state.func_203425_a(CustomBlocks.BLOCK_GUITAR_AMPLIFIER)) {
            return true;
        }
        state = this.world.func_180495_p(pos.func_177984_a());
        if (state.func_203425_a(CustomBlocks.BLOCK_GUITAR_AMPLIFIER)) {
            return true;
        }
        state = this.world.func_180495_p(pos.func_177977_b());
        return state.func_203425_a(CustomBlocks.BLOCK_GUITAR_AMPLIFIER);
    }

    public boolean isNearAmplifier(World world, BlockPos pos) {
        if (world == null || pos == null) {
            return false;
        }
        for (int x = -6; x < 6; ++x) {
            for (int z = -6; z < 6; ++z) {
                BlockPos searchPos = pos.func_177965_g(x);
                if (!this.areaContainsAmplifier(searchPos = searchPos.func_177970_e(z))) continue;
                return true;
            }
        }
        return false;
    }

    public void applyGuitarStringChange(int stringNo) {
        if (stringNo == 1) {
            this.string = GuitarItem.Tuning.STRING_E;
        } else if (stringNo == 2) {
            this.string = GuitarItem.Tuning.STRING_A;
        } else if (stringNo == 3) {
            this.string = GuitarItem.Tuning.STRING_D;
        } else if (stringNo == 4) {
            this.string = GuitarItem.Tuning.STRING_G;
        } else if (stringNo == 5) {
            this.string = GuitarItem.Tuning.STRING_B;
        } else if (stringNo == 6) {
            this.string = GuitarItem.Tuning.STRING_HI_E;
        }
    }

    public int getGuitarStringNo() {
        if (this.string == GuitarItem.Tuning.STRING_E) {
            return 1;
        }
        if (this.string == GuitarItem.Tuning.STRING_A) {
            return 2;
        }
        if (this.string == GuitarItem.Tuning.STRING_D) {
            return 3;
        }
        if (this.string == GuitarItem.Tuning.STRING_G) {
            return 4;
        }
        if (this.string == GuitarItem.Tuning.STRING_B) {
            return 5;
        }
        if (this.string == GuitarItem.Tuning.STRING_HI_E) {
            return 6;
        }
        return 1;
    }

    public boolean func_231043_a_(double a, double b, double c) {
        int currentStringNo = this.getGuitarStringNo();
        if (c > 0.0) {
            this.applyGuitarStringChange(currentStringNo - 1);
        } else {
            this.applyGuitarStringChange(currentStringNo + 1);
        }
        return super.func_231043_a_(a, b, c);
    }

    public boolean func_231046_a_(int key, int p_231046_2_, int p_231046_3_) {
        LOGGER.debug("key press: " + key);
        int keyIndex = ArrayUtils.indexOf((char[])this.stringKeys, (char)((char)key));
        if (keyIndex != -1) {
            int stringNo = keyIndex + 1;
            this.applyGuitarStringChange(stringNo);
        }
        keyIndex = ArrayUtils.indexOf((char[])this.fretKeys, (char)((char)key));
        boolean distorted = this.isNearAmplifier(this.world, this.player.func_233580_cy_());
        if (keyIndex != -1) {
            int fret = keyIndex + 1;
            if (this.player != null && this.world != null) {
                CGuitarPacket.playGuitarSound(this.world, this.player, this.player.func_233580_cy_(), CGuitarPacket.getSoundEvent(this.string, distorted), distorted, fret);
            }
            CGuitarPacket packet = new CGuitarPacket(this.string, fret, distorted);
            ModernLifeNetwork.INSTANCE.sendToServer((Object)packet);
            this.lastPlayedFret = fret - 1;
        }
        return super.func_231046_a_(key, p_231046_2_, p_231046_3_);
    }

    private void drawCenteredStringNoShadow(MatrixStack p_238472_0_, FontRenderer p_238472_1_, ITextComponent p_238472_2_, int p_238472_3_, int p_238472_4_, int p_238472_5_) {
        IReorderingProcessor lvt_6_1_ = p_238472_2_.func_241878_f();
        p_238472_1_.func_238422_b_(p_238472_0_, lvt_6_1_, (float)(p_238472_3_ - p_238472_1_.func_243245_a(lvt_6_1_) / 2), (float)p_238472_4_, p_238472_5_);
    }

    private String numberSuffix(int fret) {
        int lastDigit = fret % 10;
        if (fret == 11) {
            return "th";
        }
        if (fret == 12) {
            return "th";
        }
        if (fret == 13) {
            return "th";
        }
        if (lastDigit == 1) {
            return "st";
        }
        if (lastDigit == 2) {
            return "nd";
        }
        if (lastDigit == 3) {
            return "rd";
        }
        return "th";
    }

    public void func_230430_a_(MatrixStack p_230430_1_, int p_230430_2_, int p_230430_3_, float p_230430_4_) {
        this.field_230706_i_.func_110434_K().func_110577_a(GUITAR_GUI);
        int lvt_5_1_ = (this.field_230708_k_ - 256) / 2;
        int lvt_6_1_ = (this.field_230709_l_ - 134) / 2;
        this.func_238474_b_(p_230430_1_, lvt_5_1_, lvt_6_1_, 0, 0, 256, 134);
        String stringText = "";
        if (this.string == GuitarItem.Tuning.STRING_E) {
            stringText = "E String";
        } else if (this.string == GuitarItem.Tuning.STRING_A) {
            stringText = "A String";
        } else if (this.string == GuitarItem.Tuning.STRING_D) {
            stringText = "D String";
        } else if (this.string == GuitarItem.Tuning.STRING_G) {
            stringText = "G String";
        } else if (this.string == GuitarItem.Tuning.STRING_B) {
            stringText = "B String";
        } else if (this.string == GuitarItem.Tuning.STRING_HI_E) {
            stringText = "High E String";
        }
        this.drawCenteredStringNoShadow(p_230430_1_, this.field_230706_i_.field_71466_p, (ITextComponent)new StringTextComponent(stringText).func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)0xFFFFFF))), lvt_5_1_ + 128, lvt_6_1_ + 53, 0);
        if (this.lastPlayedFret != -1) {
            String fretText = this.lastPlayedFret + this.numberSuffix(this.lastPlayedFret) + " fret";
            this.drawCenteredStringNoShadow(p_230430_1_, this.field_230706_i_.field_71466_p, (ITextComponent)new StringTextComponent(fretText).func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)0xFFFFFF))), lvt_5_1_ + 128, lvt_6_1_ + 140, 0);
        }
        super.func_230430_a_(p_230430_1_, p_230430_2_, p_230430_3_, p_230430_4_);
    }
}

