/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.blocks.gui.chess;

import com.dairymoose.modernlife.blocks.gui.chess.BishopPiece;
import com.dairymoose.modernlife.blocks.gui.chess.CheckState;
import com.dairymoose.modernlife.blocks.gui.chess.ImageButtonXDiff;
import com.dairymoose.modernlife.blocks.gui.chess.InvertedImageButton;
import com.dairymoose.modernlife.blocks.gui.chess.InvertedImageButtonXDiff;
import com.dairymoose.modernlife.blocks.gui.chess.KingPiece;
import com.dairymoose.modernlife.blocks.gui.chess.KnightPiece;
import com.dairymoose.modernlife.blocks.gui.chess.PawnPiece;
import com.dairymoose.modernlife.blocks.gui.chess.Piece;
import com.dairymoose.modernlife.blocks.gui.chess.PieceIds;
import com.dairymoose.modernlife.blocks.gui.chess.QueenPiece;
import com.dairymoose.modernlife.blocks.gui.chess.RookPiece;
import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.core.ModernLifeNetwork;
import com.dairymoose.modernlife.network.play.client.CChessStatePacket;
import com.dairymoose.modernlife.tileentities.ChessBoardTileEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ChessScreen
extends Screen {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation CHESS_UI = new ResourceLocation("modernlife", "textures/gui/gui_chess_blank.png");
    final int GUI_WIDTH = 230;
    final int GUI_HEIGHT = 230;
    final int ROW_WIDTH = 23;
    final int ROW_HEIGHT = 23;
    final int BORDERED_ROW_WIDTH = 24;
    final int BORDERED_ROW_HEIGHT = 24;
    public static final int BOARD_WIDTH = 8;
    public static final int BOARD_HEIGHT = 8;
    int currentTurn = 0;
    private BlockPos chessBoardPos;
    private String whitePlayer = null;
    private String blackPlayer = null;
    private Button leftRook;
    private Button rightRook;
    private Button leftBishop;
    private Button rightBishop;
    private Button pawn1;
    private Button leftKnight;
    private Button rightKnight;
    private Button king;
    private Button queen;
    private Piece selectedPiece;
    private Piece movedPiece;
    public boolean playerIsWhite = true;
    private boolean canPlay = true;
    private boolean isWhiteTurn = true;
    private boolean isExpectedPlayer = false;
    CheckState cachedCheckState;
    public List<Piece> blackPieces = new ArrayList<Piece>(16);
    public List<Piece> whitePieces = new ArrayList<Piece>(16);
    public KingPiece whiteKing;
    public KingPiece blackKing;
    int drawSelectionX = -1;
    int drawSelectionY = -1;

    public ChessScreen(BlockPos chessBoardPos) {
        super((ITextComponent)new StringTextComponent("Chess").func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)0x404040))));
        this.chessBoardPos = chessBoardPos;
    }

    public boolean handleMouseEvent(double clickX, double clickY, boolean mouseDown) {
        if (mouseDown && this.selectedPiece != null) {
            int boardX = this.screenXtoBoardX((int)clickX);
            int boardY = this.screenYtoBoardY((int)clickY);
            if ((this.selectedPiece.x != boardX || this.selectedPiece.y != boardY) && this.selectedPiece.move(boardX, boardY)) {
                this.movedPiece = this.selectedPiece;
                this.selectedPiece = null;
                if (this.whitePlayer == null || this.whitePlayer.isEmpty()) {
                    this.whitePlayer = Minecraft.func_71410_x().field_71439_g.func_200200_C_().getString();
                } else if (this.blackPlayer == null || this.blackPlayer.isEmpty()) {
                    this.blackPlayer = Minecraft.func_71410_x().field_71439_g.func_200200_C_().getString();
                }
                this.canPlay = false;
                CheckState newCheckState = this.getCheckState();
                ModernLifeNetwork.INSTANCE.sendToServer((Object)new CChessStatePacket(this.currentTurn + 1, newCheckState.ordinal(), this.whitePlayer, this.blackPlayer, !this.isWhiteTurn, this.chessBoardPos, this.whitePieces, this.blackPieces, this.movedPiece));
                return true;
            }
        }
        return false;
    }

    public boolean func_231045_a_(double dragX, double dragY, int p_231045_5_, double p_231045_6_, double p_231045_8_) {
        if (p_231045_5_ == 0) {
            this.handleMouseEvent(dragX, dragY, true);
        }
        return super.func_231045_a_(dragX, dragY, p_231045_5_, p_231045_6_, p_231045_8_);
    }

    public boolean func_231044_a_(double clickX, double clickY, int p_231044_5_) {
        if (p_231044_5_ == 0) {
            this.func_231037_b__(true);
            if (this.handleMouseEvent(clickX, clickY, true)) {
                return false;
            }
        }
        return super.func_231044_a_(clickX, clickY, p_231044_5_);
    }

    public boolean func_231048_c_(double clickX, double clickY, int p_231044_5_) {
        this.func_231037_b__(false);
        if (p_231044_5_ == 0) {
            this.handleMouseEvent(clickX, clickY, false);
        }
        return super.func_231048_c_(clickX, clickY, p_231044_5_);
    }

    protected Button addSingularPiece(boolean black, int p_i51134_1_, int p_i51134_2_, int p_i51134_3_, int p_i51134_4_, int p_i51134_5_, int p_i51134_6_, int p_i51134_7_, ResourceLocation p_i51134_8_, Button.IPressable p_i51134_9_) {
        if (!black) {
            return new InvertedImageButton(p_i51134_1_, p_i51134_2_, p_i51134_3_, p_i51134_4_, p_i51134_5_, p_i51134_6_, p_i51134_7_, p_i51134_8_, p_i51134_9_);
        }
        return new ImageButton(p_i51134_1_, p_i51134_2_, p_i51134_3_, p_i51134_4_, p_i51134_5_, p_i51134_6_, p_i51134_7_, p_i51134_8_, p_i51134_9_);
    }

    protected Button addSingularPieceXDiff(boolean black, int p_i51134_1_, int p_i51134_2_, int p_i51134_3_, int p_i51134_4_, int p_i51134_5_, int p_i51134_6_, int p_i51134_7_, ResourceLocation p_i51134_8_, Button.IPressable p_i51134_9_) {
        if (!black) {
            return new InvertedImageButtonXDiff(p_i51134_1_, p_i51134_2_, p_i51134_3_, p_i51134_4_, p_i51134_5_, p_i51134_6_, p_i51134_7_, p_i51134_8_, p_i51134_9_);
        }
        return new ImageButtonXDiff(p_i51134_1_, p_i51134_2_, p_i51134_3_, p_i51134_4_, p_i51134_5_, p_i51134_6_, p_i51134_7_, p_i51134_8_, p_i51134_9_);
    }

    protected int getBottomStartX() {
        return (this.field_230708_k_ - 230) / 2 + 20;
    }

    protected int getBottomStartY() {
        return (this.field_230709_l_ - 230) / 2 + 188;
    }

    protected int getTopStartX() {
        return (this.field_230708_k_ - 230) / 2 + 20;
    }

    protected int getTopStartY() {
        return (this.field_230709_l_ - 230) / 2 + 20;
    }

    public int screenXtoBoardX(int screenX) {
        if (screenX < this.getTopStartX()) {
            return -1;
        }
        return (screenX - this.getTopStartX()) / 24;
    }

    public int screenYtoBoardY(int screenY) {
        if (screenY < this.getTopStartY()) {
            return -1;
        }
        return (screenY - this.getTopStartY()) / 24;
    }

    public int boardXtoScreenX(int boardX) {
        return boardX * 24 + this.getTopStartX();
    }

    public int boardYtoScreenY(int boardY) {
        return boardY * 24 + this.getTopStartY();
    }

    public Piece getPieceAt(int x, int y) {
        for (Piece p : this.whitePieces) {
            if (p.x != x || p.y != y) continue;
            return p;
        }
        for (Piece p : this.blackPieces) {
            if (p.x != x || p.y != y) continue;
            return p;
        }
        return null;
    }

    protected CheckState getCheckState() {
        if (this.blackKing.inCheck()) {
            int moveCount = this.blackAvailableMoveCount();
            if (moveCount == 0) {
                return CheckState.BLACK_CHECKMATE;
            }
            return CheckState.BLACK_CHECK;
        }
        if (this.whiteKing.inCheck()) {
            int moveCount = this.whiteAvailableMoveCount();
            if (moveCount == 0) {
                return CheckState.WHITE_CHECKMATE;
            }
            return CheckState.WHITE_CHECK;
        }
        return CheckState.NONE;
    }

    protected void initPieceXandY() {
        for (Piece p : this.whitePieces) {
            if (p.button == null) continue;
            p.x = this.screenXtoBoardX(p.button.field_230690_l_);
            p.y = this.screenYtoBoardY(p.button.field_230691_m_);
            p.screen = this;
            p.black = false;
            p.top = !this.playerIsWhite;
        }
        for (Piece p : this.blackPieces) {
            if (p.button == null) continue;
            p.x = this.screenXtoBoardX(p.button.field_230690_l_);
            p.y = this.screenYtoBoardY(p.button.field_230691_m_);
            p.screen = this;
            p.black = true;
            p.top = this.playerIsWhite;
        }
    }

    protected void initPieceInitialXY() {
        for (Piece p : this.whitePieces) {
            p.initialX = p.x;
            p.initialY = p.y;
        }
        for (Piece p : this.blackPieces) {
            p.initialX = p.x;
            p.initialY = p.y;
        }
    }

    protected int getTexOffsetX(Piece p) {
        if (p.getId() == PieceIds.QUEEN.ordinal()) {
            return 0;
        }
        return 233;
    }

    protected int getTexOffsetY(Piece p) {
        if (p.getId() == PieceIds.QUEEN.ordinal()) {
            return 233;
        }
        return 46 * p.getId();
    }

    protected void addPieceWithButton(Piece p, boolean top, boolean black, int boardX, int boardY) {
        int startX = this.getBottomStartX();
        int startY = this.getBottomStartY();
        if (top) {
            startX = this.getTopStartX();
            startY = this.getTopStartY();
        }
        int rowSwitch = -24;
        if (top) {
            rowSwitch = 24;
        }
        if (p instanceof QueenPiece) {
            Button b;
            ButtonPressResult press = new ButtonPressResult(p, top, black);
            press.piece.button = b = (Button)this.func_230480_a_((Widget)this.addSingularPieceXDiff(black, this.boardXtoScreenX(boardX), this.boardYtoScreenY(boardY), 23, 23, this.getTexOffsetX(p), this.getTexOffsetY(p), 23, CHESS_UI, press));
        } else {
            Button b;
            ButtonPressResult press = new ButtonPressResult(p, top, black);
            press.piece.button = b = (Button)this.func_230480_a_((Widget)this.addSingularPiece(black, this.boardXtoScreenX(boardX), this.boardYtoScreenY(boardY), 23, 23, this.getTexOffsetX(p), this.getTexOffsetY(p), 23, CHESS_UI, press));
        }
    }

    protected void addPieces(boolean black, boolean top) {
        int startX = this.getBottomStartX();
        int startY = this.getBottomStartY();
        if (top) {
            startX = this.getTopStartX();
            startY = this.getTopStartY();
        }
        int rowSwitch = -24;
        if (top) {
            rowSwitch = 24;
        }
        ButtonPressResult press = null;
        press = new ButtonPressResult(new RookPiece(), top, black);
        press.piece.button = this.leftRook = (Button)this.func_230480_a_((Widget)this.addSingularPiece(black, startX + 0, startY, 23, 23, 233, 0, 23, CHESS_UI, press));
        press = new ButtonPressResult(new RookPiece(), top, black);
        press.piece.button = this.rightRook = (Button)this.func_230480_a_((Widget)this.addSingularPiece(black, startX + 168, startY, 23, 23, 233, 0, 23, CHESS_UI, press));
        press = new ButtonPressResult(new BishopPiece(), top, black);
        press.piece.button = this.leftBishop = (Button)this.func_230480_a_((Widget)this.addSingularPiece(black, startX + 48, startY, 23, 23, 233, 46, 23, CHESS_UI, press));
        press = new ButtonPressResult(new BishopPiece(), top, black);
        press.piece.button = this.rightBishop = (Button)this.func_230480_a_((Widget)this.addSingularPiece(black, startX + 120, startY, 23, 23, 233, 46, 23, CHESS_UI, press));
        for (int p = 0; p < 8; ++p) {
            press = new ButtonPressResult(new PawnPiece(), top, black);
            press.piece.button = this.pawn1 = (Button)this.func_230480_a_((Widget)this.addSingularPiece(black, startX + 24 * p, startY + rowSwitch, 23, 23, 233, 92, 23, CHESS_UI, press));
        }
        press = new ButtonPressResult(new KnightPiece(), top, black);
        press.piece.button = this.leftKnight = (Button)this.func_230480_a_((Widget)this.addSingularPiece(black, startX + 24, startY, 23, 23, 233, 138, 23, CHESS_UI, press));
        press = new ButtonPressResult(new KnightPiece(), top, black);
        press.piece.button = this.rightKnight = (Button)this.func_230480_a_((Widget)this.addSingularPiece(black, startX + 144, startY, 23, 23, 233, 138, 23, CHESS_UI, press));
        press = new ButtonPressResult(new KingPiece(), top, black);
        press.piece.button = this.king = (Button)this.func_230480_a_((Widget)this.addSingularPiece(black, startX + 96, startY, 23, 23, 233, 184, 23, CHESS_UI, press));
        press = new ButtonPressResult(new QueenPiece(), top, black);
        press.piece.button = this.queen = (Button)this.func_230480_a_((Widget)this.addSingularPieceXDiff(black, startX + 72, startY, 23, 23, 0, 233, 23, CHESS_UI, press));
        this.initPieceXandY();
        this.initPieceInitialXY();
    }

    protected void mirrorBoard() {
        for (Piece p : this.whitePieces) {
            p.absMoveTo(7 - p.x, 7 - p.y);
        }
        for (Piece p : this.blackPieces) {
            p.absMoveTo(7 - p.x, 7 - p.y);
        }
        if (this.movedPiece != null) {
            this.movedPiece.x = 7 - this.movedPiece.x;
            this.movedPiece.y = 7 - this.movedPiece.y;
        }
    }

    protected void addPieces() {
        CheckState checkState;
        ChessBoardTileEntity chessBoard;
        ItemStack itemStack;
        boolean addedPieces = false;
        TileEntity tileEntity = this.getMinecraft().field_71441_e.func_175625_s(this.chessBoardPos);
        if (tileEntity instanceof ChessBoardTileEntity && (itemStack = (chessBoard = (ChessBoardTileEntity)tileEntity).func_70301_a(0)).func_77973_b() == CustomBlocks.ITEM_CHESS_BOARD && itemStack.func_77978_p() != null && itemStack.func_77978_p().func_74764_b("BoardState")) {
            addedPieces = true;
            CChessStatePacket packet = CChessStatePacket.fromNbt(itemStack.func_77978_p());
            this.whitePieces.clear();
            this.blackPieces.clear();
            this.currentTurn = packet.currentTurn;
            this.whitePlayer = packet.whitePlayer;
            this.blackPlayer = packet.blackPlayer;
            this.isWhiteTurn = packet.isWhiteTurn;
            this.movedPiece = packet.movedPiece;
            this.assignWhitePlayer();
            for (Piece p : packet.whitePieces) {
                this.addPieceWithButton(p, !this.playerIsWhite, false, p.x, p.y);
            }
            for (Piece p : packet.blackPieces) {
                this.addPieceWithButton(p, this.playerIsWhite, true, p.x, p.y);
            }
            this.initPieceXandY();
            if (this.isExpectedPlayer) {
                this.mirrorBoard();
            }
        }
        if (!addedPieces) {
            this.assignWhitePlayer();
            if (this.playerIsWhite) {
                this.addPieces(false, false);
                this.addPieces(true, true);
            } else {
                this.addPieces(true, false);
                this.addPieces(false, true);
            }
        }
        this.assignKingReferences();
        this.cachedCheckState = checkState = this.getCheckState();
        if (checkState == CheckState.BLACK_CHECKMATE || checkState == CheckState.WHITE_CHECKMATE) {
            this.canPlay = false;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void assignWhitePlayer() {
        block9: {
            block11: {
                block10: {
                    block8: {
                        if (this.whitePlayer != null && !this.whitePlayer.isEmpty()) break block8;
                        ChessScreen.LOGGER.debug("white null");
                        this.playerIsWhite = true;
                        this.isExpectedPlayer = true;
                        break block9;
                    }
                    if (this.blackPlayer != null && !this.blackPlayer.isEmpty()) break block10;
                    v0 = this;
                    if (this.whitePlayer.equals(v0.field_230706_i_.func_71410_x().field_71439_g.func_200200_C_().getString())) break block10;
                    ChessScreen.LOGGER.debug("black null");
                    this.playerIsWhite = false;
                    this.isExpectedPlayer = true;
                    break block9;
                }
                if (!this.isWhiteTurn) break block11;
                v1 = this;
                if (!this.whitePlayer.equals(v1.field_230706_i_.func_71410_x().field_71439_g.func_200200_C_().getString())) break block11;
                ChessScreen.LOGGER.debug("white name match");
                this.playerIsWhite = true;
                this.isExpectedPlayer = true;
                break block9;
            }
            if (this.isWhiteTurn) ** GOTO lbl-1000
            v2 = this;
            if (this.blackPlayer.equals(v2.field_230706_i_.func_71410_x().field_71439_g.func_200200_C_().getString())) {
                ChessScreen.LOGGER.debug("black name match");
                this.playerIsWhite = false;
                this.isExpectedPlayer = true;
            } else lbl-1000:
            // 2 sources

            {
                v3 = this;
                if (this.whitePlayer.equals(v3.field_230706_i_.func_71410_x().field_71439_g.func_200200_C_().getString())) {
                    ChessScreen.LOGGER.debug("player is white");
                    this.playerIsWhite = true;
                } else {
                    v4 = this;
                    if (this.blackPlayer.equals(v4.field_230706_i_.func_71410_x().field_71439_g.func_200200_C_().getString())) {
                        ChessScreen.LOGGER.debug("player is black");
                        this.playerIsWhite = false;
                    }
                }
                this.canPlay = false;
            }
        }
        if (this.playerIsWhite && !this.isWhiteTurn) {
            this.canPlay = false;
        } else if (!this.playerIsWhite && this.isWhiteTurn) {
            this.canPlay = false;
        }
    }

    private void assignKingReferences() {
        for (Piece p : this.whitePieces) {
            if (!(p instanceof KingPiece)) continue;
            this.whiteKing = (KingPiece)p;
        }
        for (Piece p : this.blackPieces) {
            if (!(p instanceof KingPiece)) continue;
            this.blackKing = (KingPiece)p;
        }
    }

    protected void func_231160_c_() {
        this.addPieces();
    }

    public boolean func_231177_au__() {
        return false;
    }

    private void drawCenteredStringNoShadow(MatrixStack p_238472_0_, FontRenderer p_238472_1_, ITextComponent p_238472_2_, int p_238472_3_, int p_238472_4_, int p_238472_5_) {
        IReorderingProcessor lvt_6_1_ = p_238472_2_.func_241878_f();
        p_238472_1_.func_238422_b_(p_238472_0_, lvt_6_1_, (float)(p_238472_3_ - p_238472_1_.func_243245_a(lvt_6_1_) / 2), (float)p_238472_4_, p_238472_5_);
    }

    int availableMoveCount(Piece p) {
        int moveCount = 0;
        int x = 0;
        while (true) {
            if (x >= 8) break;
            int y = 0;
            while (true) {
                if (y >= 8) break;
                if (p.canMove(x, y)) {
                    ++moveCount;
                }
                ++y;
            }
            ++x;
        }
        return moveCount;
    }

    int whiteAvailableMoveCount() {
        int moveCount = 0;
        for (Piece p : this.whitePieces) {
            moveCount += this.availableMoveCount(p);
        }
        return moveCount;
    }

    int blackAvailableMoveCount() {
        int moveCount = 0;
        for (Piece p : this.blackPieces) {
            moveCount += this.availableMoveCount(p);
        }
        return moveCount;
    }

    public void showTooltipForPiece(MatrixStack matrixStack, Piece p) {
        String pieceName = "";
        if (p instanceof RookPiece) {
            pieceName = "Rook";
        } else if (p instanceof BishopPiece) {
            pieceName = "Bishop";
        } else if (p instanceof PawnPiece) {
            pieceName = "Pawn";
        } else if (p instanceof KnightPiece) {
            pieceName = "Knight";
        } else if (p instanceof KingPiece) {
            pieceName = "King";
        } else if (p instanceof QueenPiece) {
            pieceName = "Queen";
        }
        this.func_238652_a_(matrixStack, (ITextComponent)new StringTextComponent(pieceName), this.boardXtoScreenX(p.x), this.boardYtoScreenY(p.y));
    }

    public void func_230430_a_(MatrixStack matrixStack, int p_230430_2_, int p_230430_3_, float p_230430_4_) {
        CheckState checkState;
        this.func_230446_a_(matrixStack);
        this.field_230706_i_.func_110434_K().func_110577_a(CHESS_UI);
        int xStart = (this.field_230708_k_ - 230) / 2;
        int yStart = (this.field_230709_l_ - 230) / 2;
        this.func_238474_b_(matrixStack, xStart, yStart, 0, 0, 230, 230);
        if (this.movedPiece != null) {
            int screenX = this.boardXtoScreenX(this.movedPiece.x);
            int screenY = this.boardYtoScreenY(this.movedPiece.y);
            this.func_238468_a_(matrixStack, screenX, screenY, screenX + 23 - 1, screenY + 23 - 1, 1348134655, 1348134655);
        }
        if (this.drawSelectionX != -1 && this.drawSelectionY != -1 && this.selectedPiece != null) {
            this.func_238468_a_(matrixStack, this.drawSelectionX, this.drawSelectionY, this.drawSelectionX + 23 - 1, this.drawSelectionY + 23 - 1, 0x50FF0000, 0x50000000);
            int x = 0;
            while (true) {
                if (x >= 8) break;
                int y = 0;
                while (true) {
                    if (y >= 8) break;
                    if (this.selectedPiece.canMove(x, y)) {
                        int screenX = this.boardXtoScreenX(x);
                        int screenY = this.boardYtoScreenY(y);
                        this.func_238468_a_(matrixStack, screenX, screenY, screenX + 23 - 1, screenY + 23 - 1, 0x5000FF00, 0x50000000);
                    }
                    ++y;
                }
                ++x;
            }
        }
        if ((checkState = this.cachedCheckState) == CheckState.BLACK_CHECKMATE || checkState == CheckState.WHITE_CHECKMATE) {
            String toDisplay = "";
            if (checkState == CheckState.BLACK_CHECKMATE) {
                toDisplay = "WHITE WINS!  Black checkmate";
            } else if (checkState == CheckState.WHITE_CHECKMATE) {
                toDisplay = "BLACK WINS!  White checkmate";
            }
            ChessScreen.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230706_i_.field_71466_p, (ITextComponent)new StringTextComponent(toDisplay).func_240703_c_(Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)-65536))), (int)(xStart + 115), (int)(yStart + 2), (int)0);
        } else if (checkState != CheckState.NONE) {
            String toDisplay = "";
            if (checkState == CheckState.BLACK_CHECK) {
                toDisplay = "BLACK CHECK";
            } else if (checkState == CheckState.WHITE_CHECK) {
                toDisplay = "WHITE CHECK";
            }
            ChessScreen.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230706_i_.field_71466_p, (ITextComponent)new StringTextComponent(toDisplay).func_240703_c_(Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)-65536))), (int)(xStart + 115), (int)(yStart + 2), (int)0);
        }
        if (this.canPlay) {
            String turnText = "It's your turn";
            ChessScreen.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230706_i_.field_71466_p, (ITextComponent)new StringTextComponent(turnText).func_240703_c_(Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)-1))), (int)(xStart + 115), (int)(yStart + 230 - 13), (int)0);
        }
        for (Piece p : this.whitePieces) {
            if (!p.button.func_230449_g_()) continue;
            this.showTooltipForPiece(matrixStack, p);
        }
        for (Piece p : this.blackPieces) {
            if (!p.button.func_230449_g_()) continue;
            this.showTooltipForPiece(matrixStack, p);
        }
        super.func_230430_a_(matrixStack, p_230430_2_, p_230430_3_, p_230430_4_);
    }

    public class ButtonPressResult
    implements Button.IPressable {
        Piece piece;
        boolean top;
        boolean black;

        ButtonPressResult(Piece piece, boolean top, boolean black) {
            this.piece = piece;
            this.top = top;
            this.black = black;
            if (this.black) {
                ChessScreen.this.blackPieces.add(piece);
            } else {
                ChessScreen.this.whitePieces.add(piece);
            }
        }

        public void onPress(Button button) {
            if (!ChessScreen.this.canPlay) {
                return;
            }
            if (!this.top) {
                if (ChessScreen.this.selectedPiece == this.piece) {
                    ChessScreen.this.selectedPiece = null;
                } else {
                    ChessScreen.this.drawSelectionX = button.field_230690_l_;
                    ChessScreen.this.drawSelectionY = button.field_230691_m_;
                    ChessScreen.this.selectedPiece = this.piece;
                }
            }
        }
    }
}

