/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.core;

import com.dairymoose.modernlife.core.AutoRegister;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.item.BlockItem;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ToolItem;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AutoRegisterProcessor {
    private static final Logger LOGGER = LogManager.getLogger();
    private static Map<String, Block> blockInstances = new HashMap<String, Block>();

    public static void processAnnotations(DeferredRegister<Block> BLOCKS, DeferredRegister<Item> ITEMS, Class cls) {
        int registerBlockCount = 0;
        int registerItemCount = 0;
        HashMap soundTypes = new HashMap();
        Field[] soundTypeFields = SoundType.class.getDeclaredFields();
        for (int i = 0; i < soundTypeFields.length; ++i) {
            Field f = soundTypeFields[i];
            if (!SoundType.class.isAssignableFrom(f.getType())) continue;
        }
        HashMap itemGroups = new HashMap();
        Field[] itemGroupFields = ItemGroup.class.getDeclaredFields();
        for (int i = 0; i < itemGroupFields.length; ++i) {
            Field f = itemGroupFields[i];
            if (!ItemGroup.class.isAssignableFrom(f.getType())) continue;
        }
        HashMap materials = new HashMap();
        Field[] materialFields = Material.class.getDeclaredFields();
        for (int i = 0; i < materialFields.length; ++i) {
            Field f = materialFields[i];
            if (!Material.class.isAssignableFrom(f.getType())) continue;
        }
        HashMap inheritBlocks = new HashMap();
        Field[] inheritBlockFields = Blocks.class.getDeclaredFields();
        for (int i = 0; i < inheritBlockFields.length; ++i) {
            Field f = inheritBlockFields[i];
            if (!Block.class.isAssignableFrom(f.getType())) continue;
        }
        Field[] fields = cls.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Class blockClass;
            Block blockInstance;
            Field f = fields[i];
            AutoRegister autoReg = f.getDeclaredAnnotation(AutoRegister.class);
            if (autoReg == null) continue;
            if (Block.class.isAssignableFrom(f.getType())) {
                blockInstance = null;
                blockClass = autoReg.blockClass();
                if (!autoReg.customInstance()) {
                    AbstractBlock.Properties props;
                    Constructor blockConstructor = null;
                    try {
                        blockConstructor = blockClass.getConstructor(AbstractBlock.Properties.class);
                    }
                    catch (NoSuchMethodException | SecurityException e1) {
                        LOGGER.error((Object)e1);
                    }
                    if (!autoReg.inheritFrom().isEmpty()) {
                        Block inherit = (Block)inheritBlocks.get(autoReg.inheritFrom());
                        if (inherit != null) {
                            props = AbstractBlock.Properties.func_200950_a((AbstractBlock)inherit);
                            if (blockConstructor != null) {
                                try {
                                    blockInstance = (Block)blockConstructor.newInstance(props);
                                }
                                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                                    LOGGER.error("Constructor error", (Throwable)e);
                                }
                            }
                        }
                    } else if (!autoReg.material().isEmpty()) {
                        Material material = (Material)materials.get(autoReg.material());
                        if (material != null) {
                            props = AbstractBlock.Properties.func_200945_a((Material)material);
                            SoundType soundType = (SoundType)soundTypes.get(autoReg.soundType());
                            if (soundType != null) {
                                props.func_200947_a(soundType);
                            }
                            ToolType toolType = null;
                            try {
                                toolType = ToolType.get((String)autoReg.harvestTool().toLowerCase());
                            }
                            catch (Exception e) {
                                LOGGER.error("Invalid toolType");
                            }
                            if (toolType != null) {
                                props.harvestTool(toolType);
                            }
                            if (autoReg.harvestLevel() != -1) {
                                props.harvestLevel(autoReg.harvestLevel());
                            }
                            if (autoReg.strength() != 0.0f) {
                                props.func_200943_b(autoReg.strength());
                            }
                            if (blockConstructor != null) {
                                try {
                                    blockInstance = (Block)blockConstructor.newInstance(props);
                                }
                                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                                    LOGGER.error("Constructor error", (Throwable)e);
                                }
                            }
                        } else {
                            LOGGER.error("Unknown material!");
                        }
                    } else {
                        try {
                            blockInstance = (Block)blockClass.newInstance();
                        }
                        catch (IllegalAccessException | InstantiationException e) {
                            LOGGER.error("Constructor error", (Throwable)e);
                        }
                    }
                } else {
                    try {
                        blockInstance = (Block)f.get(null);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        LOGGER.error("customInstance was invalid", (Throwable)e);
                    }
                }
                if (blockInstance == null) {
                    LOGGER.error("blockInstance is null");
                    continue;
                }
                try {
                    f.set(null, blockInstance);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    LOGGER.error((Object)e);
                }
                Block registryBlock = blockInstance;
                RegistryObject REG_OBJECT = BLOCKS.register(autoReg.name(), () -> {
                    try {
                        return registryBlock;
                    }
                    catch (IllegalArgumentException e) {
                        LOGGER.debug("Error");
                        return null;
                    }
                });
                blockInstances.put(autoReg.name(), blockInstance);
                LOGGER.debug("Registered block: " + autoReg.name());
                ++registerBlockCount;
                continue;
            }
            if (Item.class.isAssignableFrom(f.getType())) {
                blockInstance = null;
                blockClass = autoReg.blockClass();
                Item itemInstance = null;
                if (!autoReg.customInstance()) {
                    block70: {
                        try {
                            Item.Properties itemProps;
                            ItemGroup tab;
                            Constructor constructor;
                            Class itemClass = autoReg.itemClass();
                            if (BlockItem.class.isAssignableFrom(itemClass)) {
                                blockInstance = blockInstances.get(autoReg.name());
                                if (blockInstance == null) {
                                    LOGGER.error("item blockInstance is null");
                                    continue;
                                }
                                constructor = null;
                                try {
                                    constructor = itemClass.getConstructor(Block.class, Item.Properties.class);
                                }
                                catch (NoSuchMethodException | SecurityException e1) {
                                    LOGGER.error((Object)e1);
                                }
                                tab = (ItemGroup)itemGroups.get(autoReg.tab());
                                if (constructor != null) {
                                    try {
                                        itemProps = new Item.Properties();
                                        if (tab != null) {
                                            itemProps.func_200916_a(tab);
                                        }
                                        if (autoReg.fireResistant()) {
                                            itemProps.func_234689_a_();
                                        }
                                        itemInstance = (BlockItem)constructor.newInstance(blockInstance, itemProps);
                                    }
                                    catch (IllegalArgumentException | InvocationTargetException e) {
                                        LOGGER.error("Constructor error", (Throwable)e);
                                    }
                                }
                                break block70;
                            }
                            if (ToolItem.class.isAssignableFrom(itemClass)) {
                                constructor = null;
                                try {
                                    constructor = itemClass.getConstructor(Float.TYPE, Float.TYPE, IItemTier.class, Set.class, Item.Properties.class);
                                }
                                catch (NoSuchMethodException | SecurityException e1) {
                                    LOGGER.error((Object)e1);
                                }
                                tab = (ItemGroup)itemGroups.get(autoReg.tab());
                                if (constructor != null) {
                                    try {
                                        itemProps = new Item.Properties();
                                        if (tab != null) {
                                            itemProps.func_200916_a(tab);
                                        }
                                        if (autoReg.fireResistant()) {
                                            itemProps.func_234689_a_();
                                        }
                                        itemInstance = (Item)constructor.newInstance(blockInstance, itemProps);
                                    }
                                    catch (IllegalArgumentException | InvocationTargetException e) {
                                        LOGGER.error("Constructor error", (Throwable)e);
                                    }
                                }
                                break block70;
                            }
                            if (!Item.class.isAssignableFrom(itemClass)) break block70;
                            constructor = null;
                            try {
                                constructor = itemClass.getConstructor(Item.Properties.class);
                            }
                            catch (NoSuchMethodException | SecurityException e1) {
                                LOGGER.error((Object)e1);
                            }
                            tab = (ItemGroup)itemGroups.get(autoReg.tab());
                            if (constructor != null) {
                                try {
                                    itemProps = new Item.Properties();
                                    if (tab != null) {
                                        itemProps.func_200916_a(tab);
                                    }
                                    if (autoReg.fireResistant()) {
                                        itemProps.func_234689_a_();
                                    }
                                    itemInstance = (Item)constructor.newInstance(blockInstance, itemProps);
                                }
                                catch (IllegalArgumentException | InvocationTargetException e) {
                                    LOGGER.error("Constructor error", (Throwable)e);
                                }
                            }
                        }
                        catch (IllegalAccessException | InstantiationException e) {
                            LOGGER.error((Object)e);
                        }
                    }
                    if (itemInstance == null) {
                        LOGGER.error("itemInstance is null");
                        continue;
                    }
                    try {
                        f.set(null, itemInstance);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        LOGGER.error((Object)e);
                    }
                } else {
                    try {
                        itemInstance = (Item)f.get(null);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        LOGGER.error("customInstance was invalid", (Throwable)e);
                    }
                }
                Item registryItem = itemInstance;
                RegistryObject REG_OBJECT = ITEMS.register(autoReg.name(), () -> {
                    try {
                        return registryItem;
                    }
                    catch (IllegalArgumentException e) {
                        LOGGER.error("Error", (Throwable)e);
                        return null;
                    }
                });
                LOGGER.debug("Registered item: " + autoReg.name());
                ++registerItemCount;
                continue;
            }
            LOGGER.error("Not assignable: " + f.getType());
        }
        LOGGER.debug("Registered " + registerBlockCount + " blocks");
        LOGGER.debug("Registered " + registerItemCount + " items");
    }

    public static void processRenderTypes(Class cls) {
        int renderTypeCount = 0;
        HashMap<String, RenderType> renderTypes = new HashMap<String, RenderType>();
        Method[] renderTypeMethods = RenderType.class.getDeclaredMethods();
        for (int i = 0; i < renderTypeMethods.length; ++i) {
            Method m = renderTypeMethods[i];
            if (m.getReturnType() == RenderType.class && m.getParameterCount() != 0) continue;
        }
        renderTypes.put("solid", RenderType.func_228639_c_());
        renderTypes.put("translucent", RenderType.func_228645_f_());
        renderTypes.put("cutout", RenderType.func_228643_e_());
        renderTypes.put("cutoutmipped", RenderType.func_228641_d_());
        Field[] fields = cls.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            RenderType renderType;
            Field f = fields[i];
            AutoRegister autoReg = f.getDeclaredAnnotation(AutoRegister.class);
            if (autoReg == null || autoReg.renderType().isEmpty() || (renderType = (RenderType)renderTypes.get(autoReg.renderType().toLowerCase())) == null) continue;
            ++renderTypeCount;
            Block blockInstance = blockInstances.get(autoReg.name());
            if (blockInstance == null) {
                LOGGER.error("blockInstance was null for " + autoReg.name());
                continue;
            }
            RenderTypeLookup.setRenderLayer((Block)blockInstance, (RenderType)renderType);
        }
        LOGGER.debug("Set " + renderTypeCount + " render types");
    }
}

