/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.core;

import com.dairymoose.entity.BicycleEntity;
import com.dairymoose.entity.BicycleRenderer;
import com.dairymoose.entity.DummyEntity;
import com.dairymoose.entity.DummyRenderer;
import com.dairymoose.entity.projectile.ThrownSeedEntity;
import com.dairymoose.inventory.container.TrashCanContainer;
import com.dairymoose.modernlife.blocks.CCTVCameraBlock;
import com.dairymoose.modernlife.blocks.MirrorBlock;
import com.dairymoose.modernlife.blocks.gui.EaselScreen;
import com.dairymoose.modernlife.blocks.gui.TrashCanScreen;
import com.dairymoose.modernlife.core.AutoRegisterProcessor;
import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.core.ModernLifeCommon;
import com.dairymoose.modernlife.core.ModernLifeConfig;
import com.dairymoose.modernlife.core.ModernLifeNetwork;
import com.dairymoose.modernlife.items.CameraItem;
import com.dairymoose.modernlife.items.ChainsawItem;
import com.dairymoose.modernlife.items.FlashlightItem;
import com.dairymoose.modernlife.items.HandgunItem;
import com.dairymoose.modernlife.items.SpeedometerItem;
import com.dairymoose.modernlife.network.play.client.CMultipartCameraPacket;
import com.dairymoose.modernlife.network.play.client.CRequestCanvasPacket;
import com.dairymoose.modernlife.network.play.client.CStopUsingCameraPacket;
import com.dairymoose.modernlife.renderer.tileentity.AlarmClockTileEntityRenderer;
import com.dairymoose.modernlife.renderer.tileentity.CanvasTileEntityRenderer;
import com.dairymoose.modernlife.renderer.tileentity.ChessBoardTileEntityRenderer;
import com.dairymoose.modernlife.renderer.tileentity.MicrowaveTileEntityRenderer;
import com.dairymoose.modernlife.renderer.tileentity.MirrorTileEntityRenderer;
import com.dairymoose.modernlife.renderer.tileentity.StoveTileEntityRenderer;
import com.dairymoose.modernlife.renderer.tileentity.WallShelfTileEntityRenderer;
import com.dairymoose.modernlife.tileentities.AlarmClockTileEntity;
import com.dairymoose.modernlife.tileentities.CCTVCameraTileEntity;
import com.dairymoose.modernlife.tileentities.CanvasTileEntity;
import com.dairymoose.modernlife.tileentities.ChessBoardTileEntity;
import com.dairymoose.modernlife.tileentities.MicrowaveTileEntity;
import com.dairymoose.modernlife.tileentities.MirrorTileEntity;
import com.dairymoose.modernlife.tileentities.PowerReceiverTileEntity;
import com.dairymoose.modernlife.tileentities.PowerTransmitterTileEntity;
import com.dairymoose.modernlife.tileentities.StoveTileEntity;
import com.dairymoose.modernlife.tileentities.WallShelfTileEntity;
import com.dairymoose.modernlife.util.CanvasData;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.entity.SpriteRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.DrawHighlightEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.InputUpdateEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL30;

@OnlyIn(value=Dist.CLIENT)
public class ModernLifeClient {
    public static final String MODID = "modernlife";
    private static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"modernlife");
    private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"modernlife");
    private static final DeferredRegister<TileEntityType<?>> TILE_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.TILE_ENTITIES, (String)"modernlife");
    private static final DeferredRegister<SoundEvent> SOUND_EVENTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"modernlife");
    private static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"modernlife");
    private static final DeferredRegister<ContainerType<?>> CONTAINERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.CONTAINERS, (String)"modernlife");
    private ResourceLocation CAMERA_VIEWFINDER_LOCATION = new ResourceLocation("modernlife", "textures/item/camera_viewfinder.png");
    private int CAMERA_VIEWFINDER_WIDTH = 256;
    private int CAMERA_VIEWFINDER_HEIGHT = 256;
    private ResourceLocation CANVAS_TOOLTIP_LOCATION = new ResourceLocation("modernlife", "textures/gui/canvas_tooltip.png");
    private int CANVAS_TOOLTIP_SIZE = 64;
    private CanvasData canvasTooltipData = new CanvasData();
    private DynamicTexture canvasTexture;
    private ResourceLocation dynamicTextureLocation;
    private int lastCanvasHashCode = 0;
    private long lastUniqueId = 0L;
    private int CANVAS_TOOLTIP_DYN_TEX_SIZE = 62;
    private ResourceLocation BULLET_HOLE_1_TEX = new ResourceLocation("modernlife", "textures/item/bullet_hole_1.png");
    private ResourceLocation BULLET_HOLE_2_TEX = new ResourceLocation("modernlife", "textures/item/bullet_hole_2.png");
    private ResourceLocation BULLET_HOLE_3_TEX = new ResourceLocation("modernlife", "textures/item/bullet_hole_3.png");
    private int BULLET_HOLE_TEX_SIZE = 32;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private static final Logger LOGGER = LogManager.getLogger();
    Queue<BlockEvent.NeighborNotifyEvent> snowEvents = new LinkedList<BlockEvent.NeighborNotifyEvent>();
    private static final boolean ON_OSX = Util.func_110647_a() == Util.OS.OSX;
    int capturedWidth = 0;
    int capturedHeight = 0;
    private boolean isMirrorRendering = false;
    DummyEntity currentMirrorCamera = null;
    public static CCTVCameraTileEntity cctvCurrentCamera = null;
    public static List<BulletHoleInfo> bulletHoles = new ArrayList<BulletHoleInfo>();
    private int renderTicker = 0;
    int x = 0;
    int kk = 0;
    private static Boolean originalFastRender = null;
    private boolean foundMirror = false;
    static float cameraZoomFactor = 1.0f;
    private static final int CANVAS_CACHE_EXPIRY_MINUTES = 30;
    private static Map<Long, CachedCanvasData> cachedData = new ConcurrentHashMap<Long, CachedCanvasData>();
    private static Map<Long, Long> uniqueIdToTimestampMap = new ConcurrentHashMap<Long, Long>();
    static double originalFov = -1.0;

    public ModernLifeClient() {
        ModernLifeCommon mlc = new ModernLifeCommon();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::registerBlockColors);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::registerItemColors);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerTileEntityRenderers() {
        ClientRegistry.bindTileEntityRenderer(CanvasTileEntity.CANVAS, CanvasTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer(MicrowaveTileEntity.MICROWAVE, MicrowaveTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer(StoveTileEntity.STOVE, StoveTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer(ChessBoardTileEntity.CHESS_BOARD, ChessBoardTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer(MirrorTileEntity.MIRROR, MirrorTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer(AlarmClockTileEntity.ALARM_CLOCK, AlarmClockTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer(WallShelfTileEntity.WALL_SHELF, WallShelfTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer(WallShelfTileEntity.DOUBLE_WALL_SHELF, WallShelfTileEntityRenderer::new);
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        LOGGER.debug("Got game settings {}", (Object)((Minecraft)event.getMinecraftSupplier().get()).field_71474_y);
        ScreenManager.func_216911_a(TrashCanContainer.TRASH_CAN_CONTAINER_TYPE, TrashCanScreen::new);
        this.registerTileEntityRenderers();
        AutoRegisterProcessor.processRenderTypes(CustomBlocks.class);
        RenderTypeLookup.setRenderLayer((Block)CustomBlocks.BLOCK_BIRCH_GLASS_DOOR, (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Block)CustomBlocks.BLOCK_CRIMSON_GLASS_DOOR, (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Block)CustomBlocks.BLOCK_DARK_OAK_GLASS_DOOR, (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Block)CustomBlocks.BLOCK_IRON_GLASS_DOOR, (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Block)CustomBlocks.BLOCK_JUNGLE_GLASS_DOOR, (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Block)CustomBlocks.BLOCK_OAK_GLASS_DOOR, (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Block)CustomBlocks.BLOCK_SPRUCE_GLASS_DOOR, (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Block)CustomBlocks.BLOCK_WARPED_GLASS_DOOR, (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Block)CustomBlocks.BLOCK_EXTRACTOR, (RenderType)RenderType.func_228645_f_());
        RenderingRegistry.registerEntityRenderingHandler(ThrownSeedEntity.THROWN_SEED_ENTITY, manager -> new SpriteRenderer(manager, Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(BicycleEntity.BICYCLE_ENTITY, manager -> new BicycleRenderer(manager));
        RenderingRegistry.registerEntityRenderingHandler(DummyEntity.DUMMY_ENTITY, manager -> new DummyRenderer(manager));
        ItemModelsProperties.func_239418_a_((Item)CustomBlocks.ITEM_CHAINSAW, (ResourceLocation)new ResourceLocation(MODID, "running"), (IItemPropertyGetter)new IItemPropertyGetter(){

            public float call(ItemStack paramItemStack, ClientWorld paramClientWorld, LivingEntity paramLivingEntity) {
                if (!(paramItemStack.func_77973_b() instanceof ChainsawItem) || paramLivingEntity == null) {
                    return 0.0f;
                }
                if (paramLivingEntity.func_184587_cr() && paramLivingEntity.func_184607_cu() == paramItemStack) {
                    return 1.0f;
                }
                return 0.0f;
            }
        });
        ItemModelsProperties.func_239418_a_((Item)CustomBlocks.ITEM_HANDGUN, (ResourceLocation)new ResourceLocation(MODID, "running"), (IItemPropertyGetter)new IItemPropertyGetter(){

            public float call(ItemStack paramItemStack, ClientWorld paramClientWorld, LivingEntity paramLivingEntity) {
                if (!(paramItemStack.func_77973_b() instanceof HandgunItem) || paramLivingEntity == null) {
                    return 0.0f;
                }
                Integer tickValue = HandgunItem.firingTickMap.get(paramLivingEntity);
                if (tickValue != null && tickValue >= 4) {
                    return 1.0f;
                }
                return 0.0f;
            }
        });
        ItemModelsProperties.func_239418_a_((Item)CustomBlocks.ITEM_FLASHLIGHT, (ResourceLocation)new ResourceLocation(MODID, "on"), (IItemPropertyGetter)new IItemPropertyGetter(){

            public float call(ItemStack paramItemStack, ClientWorld paramClientWorld, LivingEntity paramLivingEntity) {
                if (!(paramItemStack.func_77973_b() instanceof FlashlightItem) || paramLivingEntity == null) {
                    return 0.0f;
                }
                Boolean usingFlashlight = FlashlightItem.usingFlashlight.get(paramLivingEntity);
                if (usingFlashlight != null && usingFlashlight.booleanValue() && (paramItemStack.equals(paramLivingEntity.func_184614_ca()) || paramItemStack.equals(paramLivingEntity.func_184592_cb()))) {
                    return 1.0f;
                }
                return 0.0f;
            }
        });
    }

    public static MirrorTileEntity getChosenMirror() {
        MirrorTileEntity chosenMirror = null;
        double leastDistance = -1.0;
        ArrayList<BlockPos> posToRemove = new ArrayList<BlockPos>();
        for (Map.Entry<BlockPos, MirrorTileEntity> entry : MirrorTileEntityRenderer.mirrorMap.entrySet()) {
            BlockPos pos = entry.getKey();
            MirrorTileEntity mirror = entry.getValue();
            if (!mirror.func_145837_r()) continue;
            posToRemove.add(pos);
        }
        for (BlockPos pos : posToRemove) {
            MirrorTileEntityRenderer.mirrorMap.remove(pos);
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        RayTraceResult picked = null;
        if (player != null) {
            picked = player.func_213324_a(100.0, 1.0f, false);
        }
        for (Map.Entry<BlockPos, MirrorTileEntity> entry : MirrorTileEntityRenderer.mirrorMap.entrySet()) {
            BlockPos pos = entry.getKey();
            MirrorTileEntity mirror = entry.getValue();
            if (player == null || picked == null) continue;
            Vector3d pickedLocation = picked.func_216347_e();
            double distSqr = pickedLocation.func_186679_c((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
            double playerDistSqr = player.func_70092_e((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
            if (!(distSqr < 225.0) || !(playerDistSqr < 225.0)) continue;
            if (leastDistance < 0.0) {
                chosenMirror = mirror;
                leastDistance = distSqr;
                continue;
            }
            if (!(distSqr < leastDistance)) continue;
            chosenMirror = mirror;
            leastDistance = distSqr;
        }
        return chosenMirror;
    }

    float fixYaw(float yaw) {
        if ((yaw %= 360.0f) > 180.0f) {
            yaw -= 360.0f;
        }
        if (yaw < -180.0f) {
            yaw += 360.0f;
        }
        return yaw;
    }

    private double getAngularDifferenceTo(PlayerEntity player, double mirrorX, double mirrorZ) {
        double playerX = player.func_226277_ct_();
        double playerZ = player.func_226281_cx_();
        double xDiff = playerX - mirrorX;
        double zDiff = playerZ - mirrorZ;
        double angleOfIncidence = Math.toDegrees(Math.atan2(zDiff, xDiff));
        return angleOfIncidence;
    }

    private float getMirrorReflectedYaw(PlayerEntity player, double mirrorX, double mirrorZ) {
        double angleOfIncidence = this.getAngularDifferenceTo(player, mirrorX, mirrorZ);
        float reflectedYaw = (float)angleOfIncidence;
        reflectedYaw += 90.0f;
        reflectedYaw = this.fixYaw(reflectedYaw);
        return reflectedYaw;
    }

    public static List<CCTVCameraTileEntity> eligibleCameras(PlayerEntity player, BlockPos screenPos) {
        ArrayList<CCTVCameraTileEntity> eligible = new ArrayList<CCTVCameraTileEntity>();
        if (CCTVCameraTileEntity.cctvCameras.size() > 0) {
            for (CCTVCameraTileEntity cctvCamera : CCTVCameraTileEntity.cctvCameras) {
                BlockPos camPos = cctvCamera.func_174877_v();
                Vector3i camVec = new Vector3i(camPos.func_177958_n(), camPos.func_177956_o(), camPos.func_177952_p());
                double blockRange = 50.0;
                Double configRange = (Double)ModernLifeConfig.CLIENT.cctvCameraRange.get();
                if (configRange != null && configRange >= 0.0) {
                    blockRange = configRange;
                }
                if (!player.field_70170_p.func_180495_p(cctvCamera.func_174877_v()).func_203425_a(CustomBlocks.BLOCK_CCTV_CAMERA) || !(screenPos.func_177951_i(camVec) <= blockRange * blockRange)) continue;
                eligible.add(cctvCamera);
            }
            if (eligible.size() > 1) {
                eligible.sort(new Comparator<CCTVCameraTileEntity>(){

                    @Override
                    public int compare(CCTVCameraTileEntity var1, CCTVCameraTileEntity var2) {
                        return var1.getInternalId() - var2.getInternalId();
                    }
                });
            }
        }
        return eligible;
    }

    private void setupNewCamera(PlayerEntity player, MirrorTileEntity chosenMirror, ActiveRenderInfo activeRenderInfo, EntityViewRenderEvent.CameraSetup event) {
        DummyEntity mirrorCamera;
        if (this.currentMirrorCamera != null) {
            this.currentMirrorCamera.func_70106_y();
        }
        this.currentMirrorCamera = mirrorCamera = new DummyEntity(DummyEntity.DUMMY_ENTITY, (World)Minecraft.func_71410_x().field_71441_e);
        float yaw = 0.0f;
        if (chosenMirror.func_195044_w().func_177230_c() == CustomBlocks.BLOCK_CCTV_SCREEN) {
            List<CCTVCameraTileEntity> cameras;
            cctvCurrentCamera = null;
            if (CCTVCameraTileEntity.cctvCameras.size() > 0 && (cameras = ModernLifeClient.eligibleCameras(player, chosenMirror.func_174877_v())).size() > 0) {
                BlockPos camPos;
                int camNo = chosenMirror.cctvScreenCurrentCamera % cameras.size();
                if (camNo < 0) {
                    camNo = cameras.size() + camNo;
                }
                chosenMirror.cctvScreenCurrentCameraDisplayValue = camNo;
                cctvCurrentCamera = cameras.get(camNo);
                BlockState state = cctvCurrentCamera.func_195044_w();
                if (state.func_203425_a(CustomBlocks.BLOCK_CCTV_CAMERA) && (camPos = cctvCurrentCamera.func_174877_v()) != null) {
                    double camX = (double)camPos.func_177958_n() + 0.5;
                    double camY = (double)camPos.func_177956_o() - 1.0;
                    double camZ = (double)camPos.func_177952_p() + 0.5;
                    Direction facing = (Direction)state.func_177229_b((Property)CCTVCameraBlock.FACING);
                    yaw = facing.func_185119_l();
                    double viewOffset = 0.08;
                    switch (facing) {
                        case EAST: {
                            camX += viewOffset;
                            break;
                        }
                        case SOUTH: {
                            camZ += viewOffset;
                            break;
                        }
                        case WEST: {
                            camX -= viewOffset;
                            break;
                        }
                        case NORTH: {
                            camZ -= viewOffset;
                        }
                    }
                    yaw = this.fixYaw(yaw);
                    mirrorCamera.func_226286_f_(camX, camY, camZ);
                    mirrorCamera.field_70177_z = yaw;
                    mirrorCamera.field_70125_A = 0.0f;
                }
            }
        } else {
            BlockPos mirrorPos = chosenMirror.func_174877_v();
            double mirrorX = (double)mirrorPos.func_177958_n() + 0.5;
            double mirrorY = (double)mirrorPos.func_177956_o() - 1.0;
            double mirrorZ = (double)mirrorPos.func_177952_p() + 0.5;
            double mirrorStart = 0.4375;
            if (chosenMirror.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208157_J) == Direction.NORTH) {
                mirrorZ += mirrorStart;
            } else if (chosenMirror.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208157_J) == Direction.EAST) {
                mirrorX -= mirrorStart;
            } else if (chosenMirror.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208157_J) == Direction.SOUTH) {
                mirrorZ -= mirrorStart;
            } else if (chosenMirror.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208157_J) == Direction.WEST) {
                mirrorX += mirrorStart;
            }
            float reflectedYaw = this.getMirrorReflectedYaw(player, mirrorX, mirrorZ);
            if (chosenMirror.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208157_J) == Direction.NORTH) {
                yaw = 180.0f - reflectedYaw;
            } else if (chosenMirror.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208157_J) == Direction.EAST) {
                yaw = -90.0f - (reflectedYaw - 90.0f);
            } else if (chosenMirror.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208157_J) == Direction.SOUTH) {
                yaw = 0.0f - (reflectedYaw - 180.0f);
            } else if (chosenMirror.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208157_J) == Direction.WEST) {
                yaw = 90.0f - (reflectedYaw + 90.0f);
            }
            yaw = this.fixYaw(yaw);
            float yBoost = 0.0f;
            if (chosenMirror.func_195044_w().func_177230_c() != CustomBlocks.BLOCK_MIRROR && chosenMirror.func_195044_w().func_177230_c() != CustomBlocks.BLOCK_CCTV_SCREEN) {
                yBoost = 0.25f;
            }
            mirrorCamera.func_226286_f_(mirrorX, mirrorY + (double)yBoost, mirrorZ);
            mirrorCamera.field_70177_z = yaw;
            mirrorCamera.field_70125_A = 0.0f;
        }
        activeRenderInfo.func_216772_a((IBlockReader)Minecraft.func_71410_x().field_71441_e, (Entity)mirrorCamera, false, false, 1.0f);
        if (event != null) {
            event.setYaw(yaw);
            event.setPitch(0.0f);
        }
    }

    @SubscribeEvent
    public void onCameraSetup(EntityViewRenderEvent.CameraSetup event) {
        if (this.isMirrorRendering) {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            MirrorTileEntity chosenMirror = ModernLifeClient.getChosenMirror();
            if (player != null && chosenMirror != null) {
                ActiveRenderInfo activeRenderInfo = event.getInfo();
                this.setupNewCamera((PlayerEntity)player, chosenMirror, activeRenderInfo, event);
            }
        }
    }

    @SubscribeEvent
    public void onRenderWorld(RenderWorldLastEvent renderWorldLastEvent) {
        MatrixStack matrixStack = renderWorldLastEvent.getMatrixStack();
        matrixStack.func_227860_a_();
        ArrayList<BulletHoleInfo> bulletHolesToRemove = new ArrayList<BulletHoleInfo>();
        try {
            Vector3d cam = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c();
            matrixStack.func_227861_a_(-cam.field_72450_a, -cam.field_72448_b, -cam.field_72449_c);
            for (int i = 0; i < bulletHoles.size(); ++i) {
                boolean timestampExpired;
                BulletHoleInfo bulletHole = bulletHoles.get(i);
                if (!Minecraft.func_71410_x().field_71439_g.field_70170_p.func_234923_W_().func_240901_a_().toString().equals(bulletHole.dim) || !Minecraft.func_71410_x().field_71439_g.field_70170_p.func_195588_v(bulletHole.pos)) continue;
                long timeDiff = System.currentTimeMillis() - bulletHole.timestamp;
                boolean bl = timestampExpired = timeDiff > 60000L;
                if (!Minecraft.func_71410_x().field_71439_g.field_70170_p.func_180495_p(bulletHole.pos).func_196958_f() && !timestampExpired) {
                    matrixStack.func_227860_a_();
                    double yBoost = 0.0;
                    matrixStack.func_227861_a_(bulletHole.loc.field_72450_a, bulletHole.loc.field_72448_b + yBoost, bulletHole.loc.field_72449_c);
                    if (bulletHole.holeNo == 0) {
                        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.BULLET_HOLE_1_TEX);
                    } else if (bulletHole.holeNo == 1) {
                        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.BULLET_HOLE_2_TEX);
                    } else {
                        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.BULLET_HOLE_3_TEX);
                    }
                    if (bulletHole.facing == Direction.EAST) {
                        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(270.0f));
                    } else if (bulletHole.facing == Direction.SOUTH) {
                        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
                    } else if (bulletHole.facing == Direction.WEST) {
                        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
                    } else if (bulletHole.facing == Direction.UP) {
                        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
                    } else if (bulletHole.facing == Direction.DOWN) {
                        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f));
                    }
                    matrixStack.func_227861_a_(0.0, 0.0, -0.001);
                    if (bulletHole.randomDepth == null) {
                        double randomAvoidCollision = Math.random() * 0.001;
                        bulletHole.randomDepth = randomAvoidCollision;
                    }
                    matrixStack.func_227861_a_(0.0, 0.0, -bulletHole.randomDepth.doubleValue());
                    matrixStack.func_227861_a_(-0.08, -0.08, 0.0);
                    matrixStack.func_227862_a_(0.005f, 0.005f, 0.005f);
                    int brightness = Minecraft.func_71410_x().field_71439_g.field_70170_p.func_201696_r(bulletHole.pos.func_177972_a(bulletHole.facing));
                    if (--brightness < 1) {
                        brightness = 1;
                    }
                    if (brightness > 8) {
                        brightness = 8;
                    }
                    float bright = (float)brightness / 15.0f;
                    RenderSystem.color3f((float)bright, (float)bright, (float)bright);
                    AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)this.BULLET_HOLE_TEX_SIZE, (int)this.BULLET_HOLE_TEX_SIZE, (int)this.BULLET_HOLE_TEX_SIZE, (int)this.BULLET_HOLE_TEX_SIZE);
                    matrixStack.func_227865_b_();
                    continue;
                }
                bulletHolesToRemove.add(bulletHole);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bulletHolesToRemove.size() > 0) {
            bulletHoles.removeAll(bulletHolesToRemove);
        }
        matrixStack.func_227865_b_();
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent e) {
        if (e.phase == TickEvent.Phase.START && e.side == LogicalSide.CLIENT) {
            ArrayList<PlayerEntity> toRemove = new ArrayList<PlayerEntity>();
            for (Map.Entry<PlayerEntity, Integer> entry : HandgunItem.firingTickMap.entrySet()) {
                float progress;
                PlayerEntity player = entry.getKey();
                Integer tickValue = entry.getValue();
                if (player.field_70128_L) {
                    toRemove.add(player);
                    continue;
                }
                if (tickValue == null || tickValue <= 0) continue;
                if (player.func_145782_y() == Minecraft.func_71410_x().field_71439_g.func_145782_y() && (progress = (float)(6 - tickValue) / 6.0f) < 0.4f) {
                    player.field_70125_A -= 0.5f;
                }
                entry.setValue(tickValue - 1);
            }
            if (toRemove.size() > 0) {
                for (int i = 0; i < toRemove.size(); ++i) {
                    HandgunItem.firingTickMap.remove(toRemove.get(i));
                }
            }
            if (HandgunItem.reloadingTick > 0) {
                if (HandgunItem.reloadingTick == 26) {
                    Minecraft.func_71410_x().field_71441_e.func_184133_a((PlayerEntity)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71439_g.func_233580_cy_(), CustomBlocks.SOUND_GUN_RELOAD, SoundCategory.BLOCKS, 1.5f, 1.0f);
                }
                --HandgunItem.reloadingTick;
            }
        }
    }

    public void copyFramebufferTexture(int width, int height, int fboIn, int fboOut) {
        RenderSystem.clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        RenderSystem.clear((int)16640, (boolean)false);
        GL30.glBindFramebuffer((int)36009, (int)fboOut);
        GL30.glDrawBuffer((int)36064);
        GL30.glBindFramebuffer((int)36008, (int)fboIn);
        GL30.glReadBuffer((int)36065);
        GL30.glBlitFramebuffer((int)0, (int)0, (int)width, (int)height, (int)0, (int)0, (int)width, (int)height, (int)16384, (int)9728);
    }

    @SubscribeEvent
    public void prerenderEvent(TickEvent.RenderTickEvent e) {
        if (e.phase == TickEvent.Phase.START && this.renderTicker++ % 3 == 0) {
            this.foundMirror = false;
            Boolean disableMirrorRender = (Boolean)ModernLifeConfig.CLIENT.disableMirrorRendering.get();
            Boolean disableCCTVRender = (Boolean)ModernLifeConfig.CLIENT.disableCCTVRendering.get();
            if (disableMirrorRender != null && disableMirrorRender.booleanValue() && disableCCTVRender != null && disableCCTVRender.booleanValue()) {
                return;
            }
            Boolean configSpectatorMirror = (Boolean)ModernLifeConfig.CLIENT.mirrorRendersInSpectatorMode.get();
            if (configSpectatorMirror != null && !configSpectatorMirror.booleanValue() && Minecraft.func_71410_x() != null && Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71439_g.func_175149_v()) {
                return;
            }
            MirrorTileEntity chosenMirror = ModernLifeClient.getChosenMirror();
            if (chosenMirror != null) {
                if (chosenMirror.func_195044_w().func_177230_c() == CustomBlocks.BLOCK_CCTV_SCREEN && disableCCTVRender != null && disableCCTVRender.booleanValue()) {
                    return;
                }
                if (chosenMirror.func_195044_w().func_177230_c() != CustomBlocks.BLOCK_CCTV_SCREEN && disableMirrorRender != null && disableMirrorRender.booleanValue()) {
                    return;
                }
                this.foundMirror = true;
            }
            Framebuffer mirrorFramebuffer = MirrorTileEntityRenderer.mirrorFramebuffer;
            int newWidth = Minecraft.func_71410_x().func_228018_at_().func_198109_k();
            int newHeight = Minecraft.func_71410_x().func_228018_at_().func_198091_l();
            if (mirrorFramebuffer == null) {
                this.capturedWidth = newWidth;
                this.capturedHeight = newHeight;
                mirrorFramebuffer = MirrorTileEntityRenderer.mirrorFramebuffer = new Framebuffer(newWidth, newHeight, true, ON_OSX);
            } else if (this.capturedWidth != newWidth || this.capturedHeight != newHeight) {
                this.capturedWidth = newWidth;
                this.capturedHeight = newHeight;
                mirrorFramebuffer.func_216491_a(this.capturedWidth, this.capturedHeight, ON_OSX);
            }
            if (chosenMirror != null) {
                switch ((Direction)chosenMirror.func_195044_w().func_177229_b((Property)MirrorBlock.FACING)) {
                    case EAST: {
                        if (Minecraft.func_71410_x().field_71439_g.func_233580_cy_().func_177958_n() >= chosenMirror.func_174877_v().func_177958_n()) break;
                        return;
                    }
                    case WEST: {
                        if (Minecraft.func_71410_x().field_71439_g.func_233580_cy_().func_177958_n() <= chosenMirror.func_174877_v().func_177958_n()) break;
                        return;
                    }
                    case NORTH: {
                        if (Minecraft.func_71410_x().field_71439_g.func_233580_cy_().func_177952_p() <= chosenMirror.func_174877_v().func_177952_p()) break;
                        return;
                    }
                    case SOUTH: {
                        if (Minecraft.func_71410_x().field_71439_g.func_233580_cy_().func_177952_p() >= chosenMirror.func_174877_v().func_177952_p()) break;
                        return;
                    }
                }
                Minecraft.func_71410_x().func_147110_a().func_147609_e();
                RenderSystem.pushMatrix();
                mirrorFramebuffer.func_147610_a(true);
                long nanos = Util.func_211178_c();
                ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
                if (player != null) {
                    BlockPos mirrorPos = chosenMirror.func_174877_v();
                    float mirrorX = (float)mirrorPos.func_177958_n() + 0.5f;
                    float mirrorY = (float)mirrorPos.func_177956_o() + 0.5f;
                    float mirrorZ = (float)mirrorPos.func_177952_p() + 0.5f;
                    float xDiff = (float)(player.func_226277_ct_() - (double)mirrorX);
                    float yDiff = (float)(player.func_226280_cw_() - (double)mirrorY);
                    float zDiff = (float)(player.func_226281_cx_() - (double)mirrorZ);
                    Entity camera = Minecraft.func_71410_x().func_175606_aa();
                    if (camera != null) {
                        // empty if block
                    }
                    this.isMirrorRendering = true;
                }
                boolean bobViewOriginal = Minecraft.func_71410_x().field_71474_y.field_74336_f;
                Minecraft.func_71410_x().field_71474_y.field_74336_f = false;
                GameRenderer renderer = Minecraft.func_71410_x().field_71460_t;
                Double xTransparentOld = 0.0;
                Double yTransparentOld = 0.0;
                Double zTransparentOld = 0.0;
                Entity originalCamera = Minecraft.func_71410_x().func_175606_aa();
                try {
                    Class<?> optShaders = Class.forName("net.optifine.shaders.Shaders");
                    RenderSystem.glMultiTexCoord2f((int)33986, (float)240.0f, (float)240.0f);
                    if (this.currentMirrorCamera != null) {
                        Field previousCameraPositionZ;
                        Field previousCameraPositionY;
                        Field previousCameraPositionX = optShaders.getDeclaredField("previousCameraPositionX");
                        if (previousCameraPositionX != null) {
                            previousCameraPositionX.setAccessible(true);
                            previousCameraPositionX.setDouble(null, this.currentMirrorCamera.func_226277_ct_());
                        }
                        if ((previousCameraPositionY = optShaders.getDeclaredField("previousCameraPositionY")) != null) {
                            previousCameraPositionY.setAccessible(true);
                            double newY = this.currentMirrorCamera.func_226278_cu_() + (double)Minecraft.func_71410_x().field_71439_g.func_70047_e();
                            previousCameraPositionY.setDouble(null, newY);
                        }
                        if ((previousCameraPositionZ = optShaders.getDeclaredField("previousCameraPositionZ")) != null) {
                            previousCameraPositionZ.setAccessible(true);
                            previousCameraPositionZ.setDouble(null, this.currentMirrorCamera.func_226281_cx_());
                        }
                    }
                    ModernLifeClient.optifineDisableFastRender();
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException optShaders) {
                    // empty catch block
                }
                Field f = null;
                try {
                    try {
                        f = WorldRenderer.class.getDeclaredField("field_175015_z");
                    }
                    catch (Exception previousCameraPositionX) {
                        // empty catch block
                    }
                    if (f == null) {
                        f = WorldRenderer.class.getDeclaredField("entityTarget");
                    }
                    f.setAccessible(true);
                    f.set(Minecraft.func_71410_x().field_71438_f, null);
                    f = null;
                    try {
                        f = WorldRenderer.class.getDeclaredField("field_147596_f");
                    }
                    catch (Exception previousCameraPositionX) {
                        // empty catch block
                    }
                    if (f == null) {
                        f = WorldRenderer.class.getDeclaredField("xTransparentOld");
                    }
                    f.setAccessible(true);
                    xTransparentOld = (Double)f.get(Minecraft.func_71410_x().field_71438_f);
                    f = null;
                    try {
                        f = WorldRenderer.class.getDeclaredField("field_147597_g");
                    }
                    catch (Exception previousCameraPositionX) {
                        // empty catch block
                    }
                    if (f == null) {
                        f = WorldRenderer.class.getDeclaredField("yTransparentOld");
                    }
                    f.setAccessible(true);
                    yTransparentOld = (Double)f.get(Minecraft.func_71410_x().field_71438_f);
                    f = null;
                    try {
                        f = WorldRenderer.class.getDeclaredField("field_147602_h");
                    }
                    catch (Exception previousCameraPositionX) {
                        // empty catch block
                    }
                    if (f == null) {
                        f = WorldRenderer.class.getDeclaredField("zTransparentOld");
                    }
                    f.setAccessible(true);
                    zTransparentOld = (Double)f.get(Minecraft.func_71410_x().field_71438_f);
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e1) {
                    e1.printStackTrace();
                }
                try {
                    Minecraft.func_71410_x().field_71460_t.func_195458_a(e.renderTickTime, nanos, true);
                }
                catch (Exception e1) {
                    // empty catch block
                }
                Minecraft.func_71410_x().field_71474_y.field_74336_f = bobViewOriginal;
                this.isMirrorRendering = false;
                try {
                    Field fDFB;
                    Class<?> optShaders = Class.forName("net.optifine.shaders.Shaders");
                    if (optShaders != null && (fDFB = optShaders.getDeclaredField("dfb")) != null) {
                        fDFB.setAccessible(true);
                        Object dfb = fDFB.get(null);
                        if (dfb != null) {
                            Field fGLFB = dfb.getClass().getDeclaredField("glFramebuffer");
                            if (dfb != null && fGLFB != null) {
                                fGLFB.setAccessible(true);
                                int inputFramebuffer = fGLFB.getInt(dfb);
                                this.copyFramebufferTexture(mirrorFramebuffer.field_147622_a, mirrorFramebuffer.field_147620_b, inputFramebuffer, mirrorFramebuffer.field_147616_f);
                            }
                        }
                    }
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException optShaders) {
                    // empty catch block
                }
                mirrorFramebuffer.func_147609_e();
                RenderSystem.popMatrix();
                if (xTransparentOld != null && yTransparentOld != null && zTransparentOld != null) {
                    f = null;
                    try {
                        f = null;
                        try {
                            f = WorldRenderer.class.getDeclaredField("field_147596_f");
                        }
                        catch (Exception optShaders) {
                            // empty catch block
                        }
                        if (f == null) {
                            f = WorldRenderer.class.getDeclaredField("xTransparentOld");
                        }
                        f.setAccessible(true);
                        f.set(Minecraft.func_71410_x().field_71438_f, xTransparentOld);
                        f = null;
                        try {
                            f = WorldRenderer.class.getDeclaredField("field_147597_g");
                        }
                        catch (Exception optShaders) {
                            // empty catch block
                        }
                        if (f == null) {
                            f = WorldRenderer.class.getDeclaredField("yTransparentOld");
                        }
                        f.setAccessible(true);
                        f.set(Minecraft.func_71410_x().field_71438_f, yTransparentOld);
                        f = null;
                        try {
                            f = WorldRenderer.class.getDeclaredField("field_147602_h");
                        }
                        catch (Exception optShaders) {
                            // empty catch block
                        }
                        if (f == null) {
                            f = WorldRenderer.class.getDeclaredField("zTransparentOld");
                        }
                        f.setAccessible(true);
                        f.set(Minecraft.func_71410_x().field_71438_f, zTransparentOld);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e1) {
                        e1.printStackTrace();
                    }
                }
                Minecraft.func_71410_x().func_147110_a().func_147610_a(true);
            }
        } else if (e.phase == TickEvent.Phase.END && !this.foundMirror) {
            ModernLifeClient.optifineResetFastRenderToNormal();
        }
    }

    public static void optifineDisableFastRender() {
        try {
            Class<?> optConfig = Class.forName("net.optifine.Config");
            if (optConfig != null) {
                Field fGameSettings = optConfig.getDeclaredField("gameSettings");
                fGameSettings.setAccessible(true);
                Object gameSettingsObject = fGameSettings.get(null);
                if (gameSettingsObject != null) {
                    Field fFastRender = gameSettingsObject.getClass().getDeclaredField("ofFastRender");
                    if (originalFastRender == null) {
                        originalFastRender = fFastRender.getBoolean(gameSettingsObject);
                    }
                    fFastRender.setBoolean(gameSettingsObject, false);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void optifineResetFastRenderToNormal() {
        try {
            Class<?> optConfig = Class.forName("net.optifine.Config");
            if (optConfig != null && originalFastRender != null) {
                Field fGameSettings = optConfig.getDeclaredField("gameSettings");
                fGameSettings.setAccessible(true);
                Object gameSettingsObject = fGameSettings.get(null);
                if (gameSettingsObject != null) {
                    Field fFastRender = gameSettingsObject.getClass().getDeclaredField("ofFastRender");
                    LOGGER.info("reset FR to: " + originalFastRender);
                    fFastRender.setBoolean(gameSettingsObject, originalFastRender);
                    originalFastRender = null;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int materialColorToTintColor(int materialColorRgb) {
        int r = materialColorRgb & 0xFF;
        int g = (materialColorRgb & 0xFF00) >> 8;
        int b = (materialColorRgb & 0xFF0000) >> 16;
        return materialColorRgb & 0xFF000000 | r << 16 | g << 8 | b;
    }

    public int colorWithAlpha(int materialColorRgb, int alpha) {
        int a = alpha << 24;
        return materialColorRgb & 0xFFFFFF | a;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerBlockColors(ColorHandlerEvent.Block event) {
        event.getBlockColors().func_186722_a(new IBlockColor(){

            public int getColor(BlockState paramBlockState, IBlockDisplayReader paramIBlockDisplayReader, BlockPos paramBlockPos, int paramInt) {
                return ModernLifeClient.this.materialColorToTintColor(MaterialColor.field_151669_i.func_151643_b(1));
            }
        }, new Block[]{CustomBlocks.BLOCK_HEDGE});
        event.getBlockColors().func_186722_a(new IBlockColor(){

            public int getColor(BlockState paramBlockState, IBlockDisplayReader paramIBlockDisplayReader, BlockPos paramBlockPos, int paramInt) {
                return ModernLifeClient.this.colorWithAlpha(ModernLifeClient.this.materialColorToTintColor(MaterialColor.field_151662_n.func_151643_b(1)), 127);
            }
        }, new Block[]{CustomBlocks.BLOCK_TOILET, CustomBlocks.BLOCK_BATHTUB});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerItemColors(ColorHandlerEvent.Item event) {
        event.getItemColors().func_199877_a(new IItemColor(){

            public int getColor(ItemStack paramItemStack, int paramInt) {
                return ModernLifeClient.this.materialColorToTintColor(MaterialColor.field_151669_i.func_151643_b(1));
            }
        }, new IItemProvider[]{CustomBlocks.ITEM_HEDGE});
        event.getItemColors().func_199877_a(new IItemColor(){

            public int getColor(ItemStack paramItemStack, int paramInt) {
                return ModernLifeClient.this.materialColorToTintColor(MaterialColor.field_151662_n.func_151643_b(1));
            }
        }, new IItemProvider[]{CustomBlocks.ITEM_TOILET});
    }

    @SubscribeEvent
    public void onClientLogin(ClientPlayerNetworkEvent.LoggedInEvent e) {
        LOGGER.info("Client login");
        if (cachedData != null) {
            cachedData.clear();
        }
    }

    @SubscribeEvent
    public void fovModifierEvent(EntityViewRenderEvent.FOVModifier fovEvent) {
        if (HandgunItem.originalFov > 0.0) {
            fovEvent.setFOV(fovEvent.getFOV() / 1.2);
        }
    }

    @SubscribeEvent
    public void onClientLogout(ClientPlayerNetworkEvent.LoggedOutEvent e) {
        LOGGER.info("Client logout");
        if (MirrorTileEntityRenderer.mirrorMap != null) {
            MirrorTileEntityRenderer.mirrorMap.clear();
        }
        if (PowerReceiverTileEntity.perChannelPowerReceivers.size() > 0) {
            LOGGER.debug("Clearing power receivers: size = " + PowerReceiverTileEntity.perChannelPowerReceivers.size());
            PowerReceiverTileEntity.perChannelPowerReceivers.clear();
        }
        if (PowerTransmitterTileEntity.perChannelPowerTransmitters.size() > 0) {
            LOGGER.debug("Clearing power transmitters: size = " + PowerTransmitterTileEntity.perChannelPowerTransmitters.size());
            PowerTransmitterTileEntity.perChannelPowerTransmitters.clear();
        }
        HandgunItem.resetFov();
        bulletHoles.clear();
        HandgunItem.firingTickMap.clear();
        ModernLifeClient.optifineResetFastRenderToNormal();
    }

    private static void purgeOldCanvasData() {
        long currentTimestamp = System.currentTimeMillis();
        for (Map.Entry<Long, CachedCanvasData> entry : cachedData.entrySet()) {
            CachedCanvasData ccd = entry.getValue();
            long timeDiff = currentTimestamp - ccd.timestamp;
            if (timeDiff < 1800000L) continue;
            cachedData.remove(entry.getKey());
        }
    }

    public static void requestUpdateForCanvas(long currentTime, long uniqueId) {
        long timeDiff;
        long timestamp = 0L;
        Long timestampData = uniqueIdToTimestampMap.get(uniqueId);
        if (timestampData != null) {
            timestamp = timestampData;
        }
        if ((timeDiff = currentTime - timestamp) >= 3000L) {
            uniqueIdToTimestampMap.put(uniqueId, currentTime);
            ModernLifeNetwork.INSTANCE.sendToServer((Object)new CRequestCanvasPacket(uniqueId));
        }
    }

    public static byte[] getCanvasData(long uniqueId) {
        ModernLifeClient.purgeOldCanvasData();
        CachedCanvasData ccd = cachedData.get(uniqueId);
        if (ccd != null) {
            return ccd.data;
        }
        long currentTime = System.currentTimeMillis();
        CMultipartCameraPacket.PngSizeHolder sizeHolder = new CMultipartCameraPacket.PngSizeHolder();
        byte[] data = CMultipartCameraPacket.loadPng(uniqueId, sizeHolder);
        if (data == null) {
            ModernLifeClient.requestUpdateForCanvas(currentTime, uniqueId);
            return null;
        }
        ModernLifeClient.putCachedData(currentTime, uniqueId, data, sizeHolder.width);
        return data;
    }

    public static byte[] putCachedData(long currentTime, long uniqueId, byte[] data, int size) {
        CachedCanvasData ccd = new CachedCanvasData();
        ccd.data = data;
        ccd.timestamp = currentTime;
        ccd.hashCode = ModernLifeClient.getHashCodeForBytes(data);
        ccd.texSize = size;
        cachedData.put(uniqueId, ccd);
        return data;
    }

    public static int getCanvasSize(long uniqueId) {
        CachedCanvasData ccd = cachedData.get(uniqueId);
        if (ccd != null) {
            return ccd.texSize;
        }
        return 0;
    }

    public static void removeCachedCanvasData(long uniqueId) {
        cachedData.remove(uniqueId);
    }

    public static long getCanvasHashCode(long uniqueId) {
        CachedCanvasData ccd = cachedData.get(uniqueId);
        if (ccd != null) {
            return ccd.hashCode;
        }
        return 0L;
    }

    public static int getHashCodeForBytes(byte[] data) {
        return Arrays.hashCode(data);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void renderTooltipEvent(RenderTooltipEvent.PostText tooltipEvent) {
        boolean shouldDrawImage = true;
        ItemStack itemStack = tooltipEvent.getStack();
        if (itemStack != null && itemStack.func_77973_b() == CustomBlocks.ITEM_CANVAS && itemStack.func_77978_p() != null && itemStack.func_77978_p().func_74764_b("UniqueId")) {
            long uniqueId = itemStack.func_77978_p().func_74763_f("UniqueId");
            byte[] compressed = ModernLifeClient.getCanvasData(uniqueId);
            int newHashCode = ModernLifeClient.getHashCodeForBytes(compressed);
            if (uniqueId != this.lastUniqueId || compressed != null && newHashCode != this.lastCanvasHashCode) {
                this.lastUniqueId = uniqueId;
                this.lastCanvasHashCode = newHashCode;
                if (Minecraft.func_71410_x().field_71456_v != null) {
                    this.canvasTooltipData.disable();
                    int tex = ModernLifeClient.getCanvasSize(uniqueId);
                    if (tex != 0) {
                        this.canvasTooltipData.setTextureSize(tex);
                    } else {
                        this.canvasTooltipData.setTextureSize(64);
                    }
                    if (itemStack.func_77978_p().func_74764_b("UniqueId") && compressed != null) {
                        this.canvasTooltipData.fromCompressedNbt(compressed);
                        this.canvasTooltipData.initImage();
                        if (this.canvasTexture != null) {
                            this.canvasTexture.close();
                            this.canvasTexture = null;
                        }
                        if (this.canvasTexture == null) {
                            this.canvasTexture = new DynamicTexture(this.canvasTooltipData.textureSize(), this.canvasTooltipData.textureSize(), true);
                            this.dynamicTextureLocation = Minecraft.func_71410_x().field_71446_o.func_110578_a("artpad/dyn", this.canvasTexture);
                            this.canvasTooltipData.reenable();
                            EaselScreen.updateTexture(this.canvasTooltipData, this.canvasTexture);
                        }
                    }
                    this.canvasTooltipData.reenable();
                }
            }
            if (compressed == null) {
                shouldDrawImage = false;
            }
            Minecraft.func_71410_x().field_71446_o.func_110577_a(this.CANVAS_TOOLTIP_LOCATION);
            int blitY = tooltipEvent.getY() - this.CANVAS_TOOLTIP_SIZE;
            if (blitY < 2) {
                blitY = 2;
            }
            MatrixStack matrixStack = tooltipEvent.getMatrixStack();
            float xTexStart = 0.0f;
            float xTexDiff = 0.0f;
            AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)tooltipEvent.getX(), (int)blitY, (float)xTexStart, (float)xTexDiff, (int)this.CANVAS_TOOLTIP_SIZE, (int)this.CANVAS_TOOLTIP_SIZE, (int)this.CANVAS_TOOLTIP_SIZE, (int)this.CANVAS_TOOLTIP_SIZE);
            if (shouldDrawImage && this.dynamicTextureLocation != null) {
                Minecraft.func_71410_x().field_71446_o.func_110577_a(this.dynamicTextureLocation);
                AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)(tooltipEvent.getX() + 1), (int)(blitY + 1), (float)xTexStart, (float)xTexDiff, (int)this.CANVAS_TOOLTIP_DYN_TEX_SIZE, (int)this.CANVAS_TOOLTIP_DYN_TEX_SIZE, (int)this.CANVAS_TOOLTIP_DYN_TEX_SIZE, (int)this.CANVAS_TOOLTIP_DYN_TEX_SIZE);
            }
        }
    }

    @SubscribeEvent
    public void renderItemInHandEvent(RenderHandEvent renderHandEvent) {
        Integer tickValue;
        ItemStack itemStack;
        if (this.isMirrorRendering) {
            renderHandEvent.setCanceled(true);
        }
        if (CameraItem.usingCamera || CameraItem.pendingSnapshot) {
            renderHandEvent.setCanceled(true);
        }
        if ((itemStack = renderHandEvent.getItemStack()) != null && itemStack.func_77973_b() == CustomBlocks.ITEM_HANDGUN) {
            if (Minecraft.func_71410_x().field_71439_g.func_184587_cr()) {
                renderHandEvent.getMatrixStack().func_227861_a_(-0.38, 0.2, 0.0);
                renderHandEvent.getMatrixStack().func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-4.0f));
                renderHandEvent.getMatrixStack().func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(8.0f));
                renderHandEvent.getMatrixStack().func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-10.0f));
            }
            if ((tickValue = HandgunItem.firingTickMap.get(Minecraft.func_71410_x().field_71439_g)) != null && tickValue > 0) {
                float progress = (float)(6 - tickValue) / 6.0f;
                float upswingProgress = progress / 0.75f;
                if (progress <= 0.75f) {
                    renderHandEvent.getMatrixStack().func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(upswingProgress * 35.0f));
                } else {
                    float downswingProgress = (progress - 0.75f) / 0.25f;
                    renderHandEvent.getMatrixStack().func_227863_a_(Vector3f.field_229179_b_.func_229187_a_((1.0f - downswingProgress) * 35.0f));
                }
            }
            if (HandgunItem.reloadingTick > 0) {
                renderHandEvent.getMatrixStack().func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(45.0f));
            }
        }
        if (Minecraft.func_71410_x() != null && Minecraft.func_71410_x().field_71439_g != null && itemStack != null && itemStack.func_77973_b() == CustomBlocks.ITEM_HANDGUN && (tickValue = HandgunItem.firingTickMap.get(Minecraft.func_71410_x().field_71439_g)) != null && tickValue > 0) {
            int xOffset = 20;
            int yOffset = 20;
            if (!Minecraft.func_71410_x().field_71439_g.func_184587_cr()) {
                xOffset = 80;
                yOffset = 40;
            }
            int x = Minecraft.func_71410_x().func_228018_at_().func_198107_o() / 2 + xOffset;
            int y = Minecraft.func_71410_x().func_228018_at_().func_198087_p() / 2 + yOffset;
            int w = 20;
            int h = 20;
            AbstractGui.func_238467_a_((MatrixStack)renderHandEvent.getMatrixStack(), (int)x, (int)y, (int)(x + w), (int)(y + h), (int)-256);
        }
    }

    public static void stopUsingCamera() {
        CameraItem.usingCamera = false;
        ModernLifeNetwork.INSTANCE.sendToServer((Object)new CStopUsingCameraPacket());
        ModernLifeClient.resetCameraZoom();
    }

    public static void resetCameraZoom() {
        cameraZoomFactor = 1.0f;
        if (originalFov > 0.0) {
            Minecraft.func_71410_x().field_71474_y.field_74334_X = originalFov;
        }
        originalFov = -1.0;
    }

    @SubscribeEvent
    public void keyInputEvent(InputEvent.KeyInputEvent keyEvent) {
        if (CameraItem.usingCamera && keyEvent.getKey() == 256) {
            this.stopUsingCamera();
            Minecraft.func_71410_x().field_195559_v.func_197961_a(Minecraft.func_71410_x().func_228018_at_().func_198092_i(), 256, 256, 1, 0);
        }
    }

    @SubscribeEvent
    public void onDrawHighlight(DrawHighlightEvent highlightEvent) {
        if (CameraItem.usingCamera || CameraItem.pendingSnapshot) {
            highlightEvent.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onInteractEvent(PlayerInteractEvent interactEvent) {
        ItemStack itemStack;
        block5: {
            block7: {
                block6: {
                    if (!CameraItem.usingCamera || interactEvent instanceof PlayerInteractEvent.RightClickItem) break block5;
                    if (interactEvent instanceof PlayerInteractEvent.LeftClickBlock) break block6;
                    if (!(interactEvent instanceof PlayerInteractEvent.LeftClickEmpty)) break block7;
                }
                this.stopUsingCamera();
            }
            if (interactEvent != null && interactEvent.isCancelable()) {
                interactEvent.setCanceled(true);
            }
        }
        if ((itemStack = interactEvent.getPlayer().func_184614_ca()) != null && itemStack.func_77973_b() == CustomBlocks.ITEM_HANDGUN && (interactEvent instanceof PlayerInteractEvent.LeftClickBlock || interactEvent instanceof PlayerInteractEvent.LeftClickEmpty) && interactEvent.isCancelable()) {
            interactEvent.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onClick(InputEvent.RawMouseEvent mouseEvent) {
        if (Minecraft.func_71410_x().field_71439_g != null && !Minecraft.func_71410_x().field_71439_g.func_175149_v()) {
            ItemStack item = Minecraft.func_71410_x().field_71439_g.func_184614_ca();
            if (mouseEvent.getButton() == 0 && mouseEvent.getAction() == 1 && item != null && item.func_77973_b() == CustomBlocks.ITEM_HANDGUN && !Minecraft.func_71410_x().func_147113_T() && Minecraft.func_71410_x().field_71462_r == null) {
                ((HandgunItem)CustomBlocks.ITEM_HANDGUN).fireGun((PlayerEntity)Minecraft.func_71410_x().field_71439_g);
            }
        }
    }

    @SubscribeEvent
    public void mouseScrollEvent(InputEvent.MouseScrollEvent scrollEvent) {
        if (CameraItem.usingCamera) {
            if (originalFov < 0.0) {
                originalFov = Minecraft.func_71410_x().field_71474_y.field_74334_X;
            }
            cameraZoomFactor = scrollEvent.getScrollDelta() > 0.0 ? (cameraZoomFactor += 0.5f) : (cameraZoomFactor -= 0.5f);
            cameraZoomFactor = Math.min(cameraZoomFactor, 4.5f);
            cameraZoomFactor = Math.max(cameraZoomFactor, 1.0f);
            Minecraft.func_71410_x().field_71474_y.field_74334_X = originalFov * 1.0 / (double)cameraZoomFactor;
            scrollEvent.setCanceled(true);
        }
    }

    private void drawCrosshairLine(MatrixStack matrixStack, int x0, int y0, int w0, int h0) {
        int xOffset = x0;
        int yOffset = y0;
        int x = Minecraft.func_71410_x().func_228018_at_().func_198107_o() / 2 + xOffset;
        int y = Minecraft.func_71410_x().func_228018_at_().func_198087_p() / 2 + yOffset;
        int w = w0;
        int h = h0;
        AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)x, (int)y, (int)(x + w), (int)(y + h), (int)-1);
    }

    private void drawSizedCrosshair(MatrixStack matrixStack, int size, int lineLength) {
        this.drawCrosshairLine(matrixStack, size, 0, lineLength, 1);
        this.drawCrosshairLine(matrixStack, -size - lineLength + 1, 0, lineLength, 1);
        this.drawCrosshairLine(matrixStack, 0, size, 1, lineLength);
        this.drawCrosshairLine(matrixStack, 0, -size - lineLength + 1, 1, lineLength);
    }

    @SubscribeEvent
    public void renderPlayerEvent(RenderPlayerEvent.Pre event) {
        ItemStack itemStack = event.getPlayer().func_184614_ca();
        if (itemStack != null && itemStack.func_77973_b() == CustomBlocks.ITEM_HANDGUN) {
            ((PlayerModel)event.getRenderer().func_217764_d()).field_187076_m = BipedModel.ArmPose.CROSSBOW_HOLD;
        }
    }

    @SubscribeEvent
    public void renderOverlayEvent(RenderGameOverlayEvent.Pre overlayEvent) {
        if (this.isMirrorRendering) {
            return;
        }
        if (overlayEvent.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS && Minecraft.func_71410_x().field_71439_g.func_184614_ca().func_77973_b() == CustomBlocks.ITEM_HANDGUN) {
            overlayEvent.setCanceled(true);
            int movementFactor = 0;
            boolean useMovementSpread = true;
            boolean useAdsSpread = true;
            if (useMovementSpread) {
                Vector3d movement = Minecraft.func_71410_x().field_71439_g.func_213322_ci();
                movementFactor = (int)((movement.field_72450_a * movement.field_72450_a + movement.field_72449_c * movement.field_72449_c) / 0.002);
            }
            if (useAdsSpread && !Minecraft.func_71410_x().field_71439_g.func_184587_cr()) {
                this.drawSizedCrosshair(overlayEvent.getMatrixStack(), 5 + movementFactor, 3);
            } else {
                this.drawSizedCrosshair(overlayEvent.getMatrixStack(), 2 + movementFactor, 3);
            }
        }
        if (overlayEvent.getType() == RenderGameOverlayEvent.ElementType.TEXT && Minecraft.func_71410_x() != null && Minecraft.func_71410_x().field_71439_g != null && (Minecraft.func_71410_x().field_71439_g.func_184614_ca().func_77973_b() == CustomBlocks.ITEM_SPEEDOMETER || Minecraft.func_71410_x().field_71439_g.func_184592_cb().func_77973_b() == CustomBlocks.ITEM_SPEEDOMETER) && overlayEvent.getMatrixStack() != null && Minecraft.func_71410_x() != null && overlayEvent.getWindow() != null && Minecraft.func_71410_x().field_71466_p != null) {
            String speedText = String.format("%.1f bps", Float.valueOf(SpeedometerItem.speed));
            IFormattableTextComponent component = new StringTextComponent(speedText).func_240703_c_(Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)0xFF0000)));
            Minecraft.func_71410_x().field_71466_p.func_243246_a(overlayEvent.getMatrixStack(), (ITextComponent)component, (float)((overlayEvent.getWindow().func_198107_o() - Minecraft.func_71410_x().field_71466_p.func_243245_a(component.func_241878_f())) / 2), (float)overlayEvent.getWindow().func_198087_p() * 0.74f, 0);
        }
        if (overlayEvent.getType() == RenderGameOverlayEvent.ElementType.TEXT && Minecraft.func_71410_x() != null && Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71439_g.func_184614_ca().func_77973_b() == CustomBlocks.ITEM_HANDGUN) {
            HandgunItem handgun = (HandgunItem)CustomBlocks.ITEM_HANDGUN;
            String speedText = String.format("%d/%d (%d)", handgun.getCurrentMagazineAmmo((PlayerEntity)Minecraft.func_71410_x().field_71439_g), handgun.getCurrentMagazineCapacity((PlayerEntity)Minecraft.func_71410_x().field_71439_g), handgun.getAmmoTotal((PlayerEntity)Minecraft.func_71410_x().field_71439_g));
            IFormattableTextComponent component = new StringTextComponent(speedText).func_240703_c_(Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)0xFFFFFF)));
            Minecraft.func_71410_x().field_71466_p.func_243246_a(overlayEvent.getMatrixStack(), (ITextComponent)component, (float)(overlayEvent.getWindow().func_198107_o() - Minecraft.func_71410_x().field_71466_p.func_243245_a(component.func_241878_f())) * 0.08f, (float)overlayEvent.getWindow().func_198087_p() * 0.85f, 0);
        }
        if (CameraItem.pendingSnapshot) {
            CameraItem.pendingSnapshot = false;
            CameraItem.takePhoto();
            this.stopUsingCamera();
        }
        if (CameraItem.usingCamera && Minecraft.func_71410_x() != null && Minecraft.func_71410_x().field_71439_g != null) {
            if (Minecraft.func_71410_x().field_71439_g.func_184614_ca().func_77973_b() == CustomBlocks.ITEM_CAMERA) {
                if (overlayEvent.getMatrixStack() != null && Minecraft.func_71410_x() != null && Minecraft.func_71410_x().func_228018_at_() != null && Minecraft.func_71410_x().field_71466_p != null) {
                    MatrixStack matrixStack = overlayEvent.getMatrixStack();
                    MainWindow window = Minecraft.func_71410_x().func_228018_at_();
                    if (((Boolean)ModernLifeConfig.CLIENT.enableCameraViewfinder.get()).booleanValue()) {
                        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.CAMERA_VIEWFINDER_LOCATION);
                        int xStart = (window.func_198107_o() - this.CAMERA_VIEWFINDER_WIDTH) / 2;
                        int yStart = (window.func_198087_p() - this.CAMERA_VIEWFINDER_HEIGHT) / 2;
                        int xStartTexture = 0;
                        int yStartTexture = 0;
                        if (Minecraft.func_71410_x().field_71456_v != null) {
                            Minecraft.func_71410_x().field_71456_v.func_238474_b_(matrixStack, xStart, yStart, xStartTexture, yStartTexture, this.CAMERA_VIEWFINDER_WIDTH, this.CAMERA_VIEWFINDER_HEIGHT);
                        }
                        String zoomText = "";
                        zoomText = cameraZoomFactor - (float)((int)cameraZoomFactor) == 0.0f ? String.format("%dx zoom", (int)cameraZoomFactor) : String.format("%.1fx zoom", Float.valueOf(cameraZoomFactor));
                        IFormattableTextComponent component = new StringTextComponent(zoomText).func_240703_c_(Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)0x202020)));
                        Minecraft.func_71410_x().field_71466_p.func_243246_a(matrixStack, (ITextComponent)component, (float)((window.func_198107_o() - Minecraft.func_71410_x().field_71466_p.func_243245_a(component.func_241878_f())) / 2), (float)window.func_198087_p() * 0.88f, 0);
                    }
                    overlayEvent.setCanceled(true);
                }
            } else {
                ModernLifeClient.stopUsingCamera();
            }
        }
    }

    @SubscribeEvent
    public void inputUpdateEvent(InputUpdateEvent event) {
        if (event != null && event.getMovementInput() != null && event.getPlayer() != null) {
            if (event.getPlayer().func_184587_cr()) {
                if (event.getPlayer().func_184607_cu().func_77973_b() == CustomBlocks.ITEM_CHAINSAW || event.getPlayer().func_184607_cu().func_77973_b() == CustomBlocks.ITEM_FLASHLIGHT) {
                    if (event.getPlayer().func_184187_bx() == null && !((Boolean)ModernLifeConfig.CLIENT.chainsawSlowsMovementWhenUsed.get()).booleanValue()) {
                        event.getMovementInput().field_192832_b *= 5.0f;
                        event.getMovementInput().field_78902_a *= 5.0f;
                    }
                } else if (event.getPlayer().func_184607_cu().func_77973_b() == CustomBlocks.ITEM_HANDGUN && event.getPlayer().func_184187_bx() == null) {
                    event.getMovementInput().field_192832_b *= 2.0f;
                    event.getMovementInput().field_78902_a *= 2.0f;
                }
            }
            if (event.getPlayer().func_184187_bx() instanceof BicycleEntity && event.getPlayer().field_70170_p.func_180495_p(event.getPlayer().func_184187_bx().func_233580_cy_().func_177977_b()).func_203425_a(CustomBlocks.BLOCK_PAVED_ROAD)) {
                BicycleEntity bike = (BicycleEntity)event.getPlayer().func_184187_bx();
                event.getMovementInput().field_192832_b = (float)((double)event.getMovementInput().field_192832_b * 1.2);
                event.getMovementInput().field_78902_a *= 1.0f;
                bike.setSpeedBoost(1.2f);
            }
        }
    }

    private static class CachedCanvasData {
        long timestamp;
        byte[] data;
        int hashCode;
        int texSize;

        private CachedCanvasData() {
        }
    }

    public static class BulletHoleInfo {
        public BlockPos pos;
        public Vector3d loc;
        public int holeNo;
        public String dim;
        public Direction facing;
        public long timestamp;
        public Double randomDepth;
    }
}

