/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.core;

import com.dairymoose.entity.BicycleEntity;
import com.dairymoose.entity.DummyEntity;
import com.dairymoose.entity.projectile.ThrownSeedEntity;
import com.dairymoose.inventory.container.TrashCanContainer;
import com.dairymoose.modernlife.blocks.CanvasBlock;
import com.dairymoose.modernlife.blocks.EaselBlock;
import com.dairymoose.modernlife.blocks.ExtractorBlock;
import com.dairymoose.modernlife.blocks.LightSwitchBlock;
import com.dairymoose.modernlife.blocks.OakPostBlock;
import com.dairymoose.modernlife.blocks.RadiatorBlock;
import com.dairymoose.modernlife.core.AutoRegisterProcessor;
import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.core.ModernLifeClient;
import com.dairymoose.modernlife.core.ModernLifeConfig;
import com.dairymoose.modernlife.core.ModernLifeConfigPrepopulator;
import com.dairymoose.modernlife.core.ModernLifeCraftingFlags;
import com.dairymoose.modernlife.core.ModernLifeNetwork;
import com.dairymoose.modernlife.items.BicycleItem;
import com.dairymoose.modernlife.items.CameraItem;
import com.dairymoose.modernlife.items.ChainsawItem;
import com.dairymoose.modernlife.items.FlashlightItem;
import com.dairymoose.modernlife.items.GuitarItem;
import com.dairymoose.modernlife.items.HandgunItem;
import com.dairymoose.modernlife.items.RoadMarkerItem;
import com.dairymoose.modernlife.items.SpeedometerItem;
import com.dairymoose.modernlife.network.play.client.CBikeDismountPacket;
import com.dairymoose.modernlife.network.play.client.CCameraPacket;
import com.dairymoose.modernlife.network.play.client.CCanvasPacket;
import com.dairymoose.modernlife.network.play.client.CChainsawTargetPacket;
import com.dairymoose.modernlife.network.play.client.CChessStatePacket;
import com.dairymoose.modernlife.network.play.client.CGuitarPacket;
import com.dairymoose.modernlife.network.play.client.CHitscanPacket;
import com.dairymoose.modernlife.network.play.client.CMultipartCameraPacket;
import com.dairymoose.modernlife.network.play.client.CMultipartEaselPacket;
import com.dairymoose.modernlife.network.play.client.CPrintSizePacket;
import com.dairymoose.modernlife.network.play.client.CRadiatorPacket;
import com.dairymoose.modernlife.network.play.client.CRequestCanvasPacket;
import com.dairymoose.modernlife.network.play.client.CStopUsingCameraPacket;
import com.dairymoose.modernlife.network.play.client.CTrashCanPacket;
import com.dairymoose.modernlife.network.play.client.CWirelessChannelPacket;
import com.dairymoose.modernlife.network.play.client.SBulletHolePacket;
import com.dairymoose.modernlife.network.play.client.SFlashlightUpdatePacket;
import com.dairymoose.modernlife.network.play.client.SMultipartCanvasPacket;
import com.dairymoose.modernlife.tileentities.AlarmClockTileEntity;
import com.dairymoose.modernlife.tileentities.CCTVCameraTileEntity;
import com.dairymoose.modernlife.tileentities.CanvasTileEntity;
import com.dairymoose.modernlife.tileentities.ChessBoardTileEntity;
import com.dairymoose.modernlife.tileentities.EaselTileEntity;
import com.dairymoose.modernlife.tileentities.ExtractorTileEntity;
import com.dairymoose.modernlife.tileentities.MicrowaveTileEntity;
import com.dairymoose.modernlife.tileentities.MirrorTileEntity;
import com.dairymoose.modernlife.tileentities.NightStandTileEntity;
import com.dairymoose.modernlife.tileentities.PhotonTileEntity;
import com.dairymoose.modernlife.tileentities.PowerReceiverTileEntity;
import com.dairymoose.modernlife.tileentities.PowerTransmitterTileEntity;
import com.dairymoose.modernlife.tileentities.PrinterTileEntity;
import com.dairymoose.modernlife.tileentities.RadiatorTileEntity;
import com.dairymoose.modernlife.tileentities.RefrigeratorTileEntity;
import com.dairymoose.modernlife.tileentities.SeedSpreaderTileEntity;
import com.dairymoose.modernlife.tileentities.ShowerHeadTileEntity;
import com.dairymoose.modernlife.tileentities.StoveTileEntity;
import com.dairymoose.modernlife.tileentities.ToiletTileEntity;
import com.dairymoose.modernlife.tileentities.TrashCanTileEntity;
import com.dairymoose.modernlife.tileentities.WallShelfTileEntity;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.TallBlockItem;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.FolderName;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModernLifeCommon {
    public static final String MODID = "modernlife";
    private int flashlightTickCounter = 0;
    private int speedometerTickCounter = 0;
    private static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"modernlife");
    private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"modernlife");
    private static final DeferredRegister<TileEntityType<?>> TILE_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.TILE_ENTITIES, (String)"modernlife");
    private static final DeferredRegister<SoundEvent> SOUND_EVENTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"modernlife");
    private static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"modernlife");
    private static final DeferredRegister<ContainerType<?>> CONTAINERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.CONTAINERS, (String)"modernlife");
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private static final Logger LOGGER = LogManager.getLogger();
    private BlockItem itemOakPost;
    private OakPostBlock blockOakPost;
    private final boolean shouldUseNotifyNeighborLogic = false;
    private static long nextUniqueCanvasId = 1L;
    Queue<BlockEvent.NeighborNotifyEvent> snowEvents = new LinkedList<BlockEvent.NeighborNotifyEvent>();
    private static ModernLifeCraftingFlags craftingFlags;
    Container lastContainer = null;
    public static String serverWorldFolderName;

    public ModernLifeCommon() {
        ModernLifeConfigPrepopulator prepop = new ModernLifeConfigPrepopulator();
        prepop.parseFile(MODID, "common", ModernLifeConfig.COMMON.flashlightLightLevel, ModernLifeConfig.COMMON.flashlightFullChargeDuration);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        craftingFlags = new ModernLifeCraftingFlags();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, ModernLifeConfig.commonSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, ModernLifeConfig.clientSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, ModernLifeConfig.serverSpec);
        this.blockOakPost = new OakPostBlock();
        this.itemOakPost = new BlockItem((Block)this.blockOakPost, new Item.Properties().func_200916_a(ItemGroup.field_78026_f).func_234689_a_().addToolType(ToolType.PICKAXE, 1).func_200917_a(64));
        CustomBlocks.BLOCK_RADIATOR = new RadiatorBlock();
        CustomBlocks.ITEM_RADIATOR = new BlockItem((Block)CustomBlocks.BLOCK_RADIATOR, new Item.Properties().func_200916_a(ItemGroup.field_78026_f).func_234689_a_().addToolType(ToolType.PICKAXE, 1).func_200917_a(64));
        CustomBlocks.BLOCK_BIRCH_GLASS_DOOR = new DoorBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)Blocks.field_196666_p.func_235697_s_()).func_200943_b(3.0f).func_200947_a(SoundType.field_185848_a).func_226896_b_());
        CustomBlocks.ITEM_BIRCH_GLASS_DOOR = new TallBlockItem(CustomBlocks.BLOCK_BIRCH_GLASS_DOOR, new Item.Properties().func_200916_a(ItemGroup.field_78028_d));
        CustomBlocks.BLOCK_CRIMSON_GLASS_DOOR = new DoorBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)Blocks.field_235344_mC_.func_235697_s_()).func_200943_b(3.0f).func_200947_a(SoundType.field_185848_a).func_226896_b_());
        CustomBlocks.ITEM_CRIMSON_GLASS_DOOR = new TallBlockItem(CustomBlocks.BLOCK_CRIMSON_GLASS_DOOR, new Item.Properties().func_200916_a(ItemGroup.field_78028_d));
        CustomBlocks.BLOCK_DARK_OAK_GLASS_DOOR = new DoorBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)Blocks.field_196672_s.func_235697_s_()).func_200943_b(3.0f).func_200947_a(SoundType.field_185848_a).func_226896_b_());
        CustomBlocks.ITEM_DARK_OAK_GLASS_DOOR = new TallBlockItem(CustomBlocks.BLOCK_DARK_OAK_GLASS_DOOR, new Item.Properties().func_200916_a(ItemGroup.field_78028_d));
        CustomBlocks.BLOCK_IRON_GLASS_DOOR = new DoorBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)MaterialColor.field_151668_h).func_235861_h_().func_200943_b(5.0f).func_200947_a(SoundType.field_185852_e).func_226896_b_());
        CustomBlocks.ITEM_IRON_GLASS_DOOR = new TallBlockItem(CustomBlocks.BLOCK_IRON_GLASS_DOOR, new Item.Properties().func_200916_a(ItemGroup.field_78028_d));
        CustomBlocks.BLOCK_JUNGLE_GLASS_DOOR = new DoorBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)Blocks.field_196668_q.func_235697_s_()).func_200943_b(3.0f).func_200947_a(SoundType.field_185848_a).func_226896_b_());
        CustomBlocks.ITEM_JUNGLE_GLASS_DOOR = new TallBlockItem(CustomBlocks.BLOCK_JUNGLE_GLASS_DOOR, new Item.Properties().func_200916_a(ItemGroup.field_78028_d));
        CustomBlocks.BLOCK_OAK_GLASS_DOOR = new DoorBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)Blocks.field_196662_n.func_235697_s_()).func_200943_b(3.0f).func_200947_a(SoundType.field_185848_a).func_226896_b_());
        CustomBlocks.ITEM_OAK_GLASS_DOOR = new TallBlockItem(CustomBlocks.BLOCK_OAK_GLASS_DOOR, new Item.Properties().func_200916_a(ItemGroup.field_78028_d));
        CustomBlocks.BLOCK_SPRUCE_GLASS_DOOR = new DoorBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)Blocks.field_196664_o.func_235697_s_()).func_200943_b(3.0f).func_200947_a(SoundType.field_185848_a).func_226896_b_());
        CustomBlocks.ITEM_SPRUCE_GLASS_DOOR = new TallBlockItem(CustomBlocks.BLOCK_SPRUCE_GLASS_DOOR, new Item.Properties().func_200916_a(ItemGroup.field_78028_d));
        CustomBlocks.BLOCK_WARPED_GLASS_DOOR = new DoorBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)Blocks.field_235345_mD_.func_235697_s_()).func_200943_b(3.0f).func_200947_a(SoundType.field_185848_a).func_226896_b_());
        CustomBlocks.ITEM_WARPED_GLASS_DOOR = new TallBlockItem(CustomBlocks.BLOCK_WARPED_GLASS_DOOR, new Item.Properties().func_200916_a(ItemGroup.field_78028_d));
        CustomBlocks.BLOCK_EASEL = new EaselBlock();
        CustomBlocks.ITEM_EASEL = new BlockItem((Block)CustomBlocks.BLOCK_EASEL, new Item.Properties().func_200916_a(ItemGroup.field_78031_c).addToolType(ToolType.AXE, 0).func_200917_a(64));
        CustomBlocks.BLOCK_LIGHTSWITCH = new LightSwitchBlock();
        CustomBlocks.ITEM_LIGHTSWITCH = new BlockItem((Block)CustomBlocks.BLOCK_LIGHTSWITCH, new Item.Properties().func_200916_a(ItemGroup.field_78028_d).addToolType(ToolType.PICKAXE, 0).func_200917_a(64));
        CustomBlocks.BLOCK_CANVAS = new CanvasBlock();
        CustomBlocks.ITEM_CANVAS = new BlockItem((Block)CustomBlocks.BLOCK_CANVAS, new Item.Properties().func_200916_a(ItemGroup.field_78031_c).addToolType(ToolType.AXE, 0).func_200917_a(1));
        CustomBlocks.BLOCK_EXTRACTOR = new ExtractorBlock();
        CustomBlocks.ITEM_EXTRACTOR = new BlockItem(CustomBlocks.BLOCK_EXTRACTOR, new Item.Properties().func_200916_a(ItemGroup.field_78028_d));
        RegistryObject RADIATOR_BLOCK = BLOCKS.register("steam_radiator", () -> CustomBlocks.BLOCK_RADIATOR);
        RegistryObject RADIATOR_ITEM = ITEMS.register("steam_radiator", () -> CustomBlocks.ITEM_RADIATOR);
        RegistryObject EASEL_BLOCK = BLOCKS.register("easel", () -> CustomBlocks.BLOCK_EASEL);
        RegistryObject EASEL_ITEM = ITEMS.register("easel", () -> CustomBlocks.ITEM_EASEL);
        RegistryObject LIGHTSWITCH_BLOCK = BLOCKS.register("light_switch", () -> CustomBlocks.BLOCK_LIGHTSWITCH);
        RegistryObject LIGHTSWITCH_ITEM = ITEMS.register("light_switch", () -> CustomBlocks.ITEM_LIGHTSWITCH);
        RegistryObject EASEL_CANVAS_BLOCK = BLOCKS.register("canvas", () -> CustomBlocks.BLOCK_CANVAS);
        RegistryObject EASEL_CANVAS_ITEM = ITEMS.register("canvas", () -> CustomBlocks.ITEM_CANVAS);
        RegistryObject BIRCH_GLASS_DOOR_BLOCK = BLOCKS.register("birch_glass_door", () -> CustomBlocks.BLOCK_BIRCH_GLASS_DOOR);
        RegistryObject BIRCH_GLASS_DOOR_ITEM = ITEMS.register("birch_glass_door", () -> CustomBlocks.ITEM_BIRCH_GLASS_DOOR);
        RegistryObject CRIMSON_GLASS_DOOR_BLOCK = BLOCKS.register("crimson_glass_door", () -> CustomBlocks.BLOCK_CRIMSON_GLASS_DOOR);
        RegistryObject CRIMSON_GLASS_DOOR_ITEM = ITEMS.register("crimson_glass_door", () -> CustomBlocks.ITEM_CRIMSON_GLASS_DOOR);
        RegistryObject DARK_OAK_GLASS_DOOR_BLOCK = BLOCKS.register("dark_oak_glass_door", () -> CustomBlocks.BLOCK_DARK_OAK_GLASS_DOOR);
        RegistryObject DARK_OAK_GLASS_DOOR_ITEM = ITEMS.register("dark_oak_glass_door", () -> CustomBlocks.ITEM_DARK_OAK_GLASS_DOOR);
        RegistryObject IRON_GLASS_DOOR_BLOCK = BLOCKS.register("iron_glass_door", () -> CustomBlocks.BLOCK_IRON_GLASS_DOOR);
        RegistryObject IRON_GLASS_DOOR_ITEM = ITEMS.register("iron_glass_door", () -> CustomBlocks.ITEM_IRON_GLASS_DOOR);
        RegistryObject JUNGLE_GLASS_DOOR_BLOCK = BLOCKS.register("jungle_glass_door", () -> CustomBlocks.BLOCK_JUNGLE_GLASS_DOOR);
        RegistryObject JUNGLE_GLASS_DOOR_ITEM = ITEMS.register("jungle_glass_door", () -> CustomBlocks.ITEM_JUNGLE_GLASS_DOOR);
        RegistryObject OAK_GLASS_DOOR_BLOCK = BLOCKS.register("oak_glass_door", () -> CustomBlocks.BLOCK_OAK_GLASS_DOOR);
        RegistryObject OAK_GLASS_DOOR_ITEM = ITEMS.register("oak_glass_door", () -> CustomBlocks.ITEM_OAK_GLASS_DOOR);
        RegistryObject SPRUCE_GLASS_DOOR_BLOCK = BLOCKS.register("spruce_glass_door", () -> CustomBlocks.BLOCK_SPRUCE_GLASS_DOOR);
        RegistryObject SPRUCE_GLASS_DOOR_ITEM = ITEMS.register("spruce_glass_door", () -> CustomBlocks.ITEM_SPRUCE_GLASS_DOOR);
        RegistryObject WARPED_GLASS_DOOR_BLOCK = BLOCKS.register("warped_glass_door", () -> CustomBlocks.BLOCK_WARPED_GLASS_DOOR);
        RegistryObject WARPED_GLASS_DOOR_ITEM = ITEMS.register("warped_glass_door", () -> CustomBlocks.ITEM_WARPED_GLASS_DOOR);
        RegistryObject EXTRACTOR_BLOCK = BLOCKS.register("extractor", () -> CustomBlocks.BLOCK_EXTRACTOR);
        RegistryObject EXTRACTOR_ITEM = ITEMS.register("extractor", () -> CustomBlocks.ITEM_EXTRACTOR);
        TILE_ENTITIES.register("steam_radiator", () -> RadiatorTileEntity.RADIATOR);
        TILE_ENTITIES.register("canvas", () -> CanvasTileEntity.CANVAS);
        TILE_ENTITIES.register("easel", () -> EaselTileEntity.EASEL);
        TILE_ENTITIES.register("extractor", () -> ExtractorTileEntity.EXTRACTOR);
        TILE_ENTITIES.register("seed_spreader", () -> SeedSpreaderTileEntity.SEED_SPREADER);
        TILE_ENTITIES.register("power_transmitter", () -> PowerTransmitterTileEntity.POWER_TRANSMITTER);
        TILE_ENTITIES.register("power_receiver", () -> PowerReceiverTileEntity.POWER_RECEIVER);
        TILE_ENTITIES.register("photon", () -> PhotonTileEntity.PHOTON);
        TILE_ENTITIES.register("night_stand", () -> NightStandTileEntity.NIGHT_STAND);
        TILE_ENTITIES.register("trash_can", () -> TrashCanTileEntity.TRASH_CAN);
        TILE_ENTITIES.register("shower_head", () -> ShowerHeadTileEntity.SHOWER_HEAD);
        TILE_ENTITIES.register("chess_board", () -> ChessBoardTileEntity.CHESS_BOARD);
        TILE_ENTITIES.register("microwave", () -> MicrowaveTileEntity.MICROWAVE);
        TILE_ENTITIES.register("stove", () -> StoveTileEntity.STOVE);
        TILE_ENTITIES.register("printer", () -> PrinterTileEntity.PRINTER);
        TILE_ENTITIES.register("refrigerator", () -> RefrigeratorTileEntity.REFRIGERATOR);
        TILE_ENTITIES.register("toilet", () -> ToiletTileEntity.TOILET);
        TILE_ENTITIES.register("mirror", () -> MirrorTileEntity.MIRROR);
        TILE_ENTITIES.register("cctv_camera", () -> CCTVCameraTileEntity.CCTV_CAMERA);
        TILE_ENTITIES.register("alarm_clock", () -> AlarmClockTileEntity.ALARM_CLOCK);
        TILE_ENTITIES.register("wall_shelf", () -> WallShelfTileEntity.WALL_SHELF);
        TILE_ENTITIES.register("double_wall_shelf", () -> WallShelfTileEntity.DOUBLE_WALL_SHELF);
        ENTITIES.register("thrown_seed", () -> ThrownSeedEntity.THROWN_SEED_ENTITY);
        ENTITIES.register("bicycle", () -> BicycleEntity.BICYCLE_ENTITY);
        ENTITIES.register("dummy", () -> DummyEntity.DUMMY_ENTITY);
        CONTAINERS.register("trash_can", () -> TrashCanContainer.TRASH_CAN_CONTAINER_TYPE);
        CustomBlocks.ITEM_CHAINSAW = new ChainsawItem(new IItemTier(){

            public int func_200926_a() {
                return 0;
            }

            public float func_200928_b() {
                return 2.0f;
            }

            public float func_200929_c() {
                return 0.0f;
            }

            public int func_200925_d() {
                return 1;
            }

            public int func_200927_e() {
                return 0;
            }

            public Ingredient func_200924_f() {
                return Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{CustomBlocks.ITEM_CHAINSAW});
            }
        }, 0.0f, 0.0f, new Item.Properties().func_200915_b(1000).func_200916_a(ItemGroup.field_78040_i));
        CustomBlocks.SOUND_CHAINSAW_RUNNING = new SoundEvent(new ResourceLocation(MODID, "chainsaw_running"));
        SOUND_EVENTS.register("chainsaw_running", () -> CustomBlocks.SOUND_CHAINSAW_RUNNING);
        CustomBlocks.SOUND_TOILET_FLUSH = new SoundEvent(new ResourceLocation(MODID, "toilet_flush"));
        SOUND_EVENTS.register("toilet_flush", () -> CustomBlocks.SOUND_TOILET_FLUSH);
        CustomBlocks.SOUND_GUN_FIRE = new SoundEvent(new ResourceLocation(MODID, "gun_fire"));
        SOUND_EVENTS.register("gun_fire", () -> CustomBlocks.SOUND_GUN_FIRE);
        CustomBlocks.SOUND_GUN_RELOAD = new SoundEvent(new ResourceLocation(MODID, "gun_reload"));
        SOUND_EVENTS.register("gun_reload", () -> CustomBlocks.SOUND_GUN_RELOAD);
        CustomBlocks.ITEM_HANDGUN = new HandgunItem(new IItemTier(){

            public int func_200926_a() {
                return 0;
            }

            public float func_200928_b() {
                return 1.0f;
            }

            public float func_200929_c() {
                return 0.0f;
            }

            public int func_200925_d() {
                return 1;
            }

            public int func_200927_e() {
                return 0;
            }

            public Ingredient func_200924_f() {
                return Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{CustomBlocks.ITEM_HANDGUN});
            }
        }, 0.0f, 20.0f, new Item.Properties().func_200915_b(1000).func_200916_a(ItemGroup.field_78040_i));
        CustomBlocks.ITEM_GUITAR = new GuitarItem(new IItemTier(){

            public int func_200926_a() {
                return 0;
            }

            public float func_200928_b() {
                return 1.2f;
            }

            public float func_200929_c() {
                return 0.0f;
            }

            public int func_200925_d() {
                return 0;
            }

            public int func_200927_e() {
                return 0;
            }

            public Ingredient func_200924_f() {
                return Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{CustomBlocks.ITEM_GUITAR});
            }
        }, 0.0f, 0.0f, new Item.Properties().func_200915_b(50).func_200916_a(ItemGroup.field_78040_i));
        CustomBlocks.SOUND_GUITAR_E = new SoundEvent(new ResourceLocation(MODID, "note_e_plus_one_octave"));
        SOUND_EVENTS.register("note_e_plus_one_octave", () -> CustomBlocks.SOUND_GUITAR_E);
        CustomBlocks.SOUND_GUITAR_A = new SoundEvent(new ResourceLocation(MODID, "note_a_plus_one_octave"));
        SOUND_EVENTS.register("note_a_plus_one_octave", () -> CustomBlocks.SOUND_GUITAR_A);
        CustomBlocks.SOUND_GUITAR_D = new SoundEvent(new ResourceLocation(MODID, "note_d_plus_one_octave"));
        SOUND_EVENTS.register("note_d_plus_one_octave", () -> CustomBlocks.SOUND_GUITAR_D);
        CustomBlocks.SOUND_GUITAR_G = new SoundEvent(new ResourceLocation(MODID, "note_g_plus_one_octave"));
        SOUND_EVENTS.register("note_g_plus_one_octave", () -> CustomBlocks.SOUND_GUITAR_G);
        CustomBlocks.SOUND_GUITAR_B = new SoundEvent(new ResourceLocation(MODID, "note_b_plus_one_octave"));
        SOUND_EVENTS.register("note_b_plus_one_octave", () -> CustomBlocks.SOUND_GUITAR_B);
        CustomBlocks.SOUND_GUITAR_HI_E = new SoundEvent(new ResourceLocation(MODID, "note_hi_e_plus_one_octave"));
        SOUND_EVENTS.register("note_hi_e_plus_one_octave", () -> CustomBlocks.SOUND_GUITAR_HI_E);
        CustomBlocks.SOUND_DIST_GUITAR_E = new SoundEvent(new ResourceLocation(MODID, "dist_e_plus_one_octave"));
        SOUND_EVENTS.register("dist_e_plus_one_octave", () -> CustomBlocks.SOUND_DIST_GUITAR_E);
        CustomBlocks.SOUND_DIST_GUITAR_A = new SoundEvent(new ResourceLocation(MODID, "dist_a_plus_one_octave"));
        SOUND_EVENTS.register("dist_a_plus_one_octave", () -> CustomBlocks.SOUND_DIST_GUITAR_A);
        CustomBlocks.SOUND_DIST_GUITAR_D = new SoundEvent(new ResourceLocation(MODID, "dist_d_plus_one_octave"));
        SOUND_EVENTS.register("dist_d_plus_one_octave", () -> CustomBlocks.SOUND_DIST_GUITAR_D);
        CustomBlocks.SOUND_DIST_GUITAR_G = new SoundEvent(new ResourceLocation(MODID, "dist_g_plus_one_octave"));
        SOUND_EVENTS.register("dist_g_plus_one_octave", () -> CustomBlocks.SOUND_DIST_GUITAR_G);
        CustomBlocks.SOUND_DIST_GUITAR_B = new SoundEvent(new ResourceLocation(MODID, "dist_b_plus_one_octave"));
        SOUND_EVENTS.register("dist_b_plus_one_octave", () -> CustomBlocks.SOUND_DIST_GUITAR_B);
        CustomBlocks.SOUND_DIST_GUITAR_HI_E = new SoundEvent(new ResourceLocation(MODID, "dist_hi_e_plus_one_octave"));
        SOUND_EVENTS.register("dist_hi_e_plus_one_octave", () -> CustomBlocks.SOUND_DIST_GUITAR_HI_E);
        int FLASHLIGHT_DURATION_MINUTES = 20;
        Integer durationConfig = ModernLifeConfig.COMMON.flashlightFullChargeDuration.getValue();
        if (durationConfig != null) {
            FLASHLIGHT_DURATION_MINUTES = durationConfig;
        }
        CustomBlocks.ITEM_FLASHLIGHT = new FlashlightItem(new IItemTier(){

            public int func_200926_a() {
                return 0;
            }

            public float func_200928_b() {
                return 1.0f;
            }

            public float func_200929_c() {
                return 0.0f;
            }

            public int func_200925_d() {
                return 1;
            }

            public int func_200927_e() {
                return 0;
            }

            public Ingredient func_200924_f() {
                return Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{CustomBlocks.ITEM_BATTERY});
            }
        }, 0.0f, 0.0f, new Item.Properties().func_200915_b(FLASHLIGHT_DURATION_MINUTES * 60 * 20).func_200916_a(ItemGroup.field_78040_i));
        CustomBlocks.ITEM_SPEEDOMETER = new SpeedometerItem(new Item.Properties().func_200915_b(50).func_200916_a(ItemGroup.field_78040_i));
        CustomBlocks.ITEM_BICYCLE = new BicycleItem(new Item.Properties().func_200916_a(ItemGroup.field_78029_e).func_200915_b(100));
        CustomBlocks.ITEM_ROAD_MARKER = new RoadMarkerItem(new Item.Properties().func_200916_a(ItemGroup.field_78029_e).func_200915_b(1000));
        AutoRegisterProcessor.processAnnotations(BLOCKS, ITEMS, CustomBlocks.class);
        BLOCKS.register(FMLJavaModLoadingContext.get().getModEventBus());
        ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
        TILE_ENTITIES.register(FMLJavaModLoadingContext.get().getModEventBus());
        SOUND_EVENTS.register(FMLJavaModLoadingContext.get().getModEventBus());
        ENTITIES.register(FMLJavaModLoadingContext.get().getModEventBus());
        CONTAINERS.register(FMLJavaModLoadingContext.get().getModEventBus());
        int msgId = 0;
        ModernLifeNetwork.INSTANCE.registerMessage(msgId++, CCanvasPacket.class, CCanvasPacket::func_148840_b, CCanvasPacket::new, CCanvasPacket::handle);
        ModernLifeNetwork.INSTANCE.registerMessage(msgId++, CGuitarPacket.class, CGuitarPacket::func_148840_b, CGuitarPacket::new, CGuitarPacket::handle);
        ModernLifeNetwork.INSTANCE.registerMessage(msgId++, CWirelessChannelPacket.class, CWirelessChannelPacket::func_148840_b, CWirelessChannelPacket::new, CWirelessChannelPacket::handle);
        ModernLifeNetwork.INSTANCE.registerMessage(msgId++, CBikeDismountPacket.class, CBikeDismountPacket::func_148840_b, CBikeDismountPacket::new, CBikeDismountPacket::handle);
        ModernLifeNetwork.INSTANCE.registerMessage(msgId++, CTrashCanPacket.class, CTrashCanPacket::func_148840_b, CTrashCanPacket::new, CTrashCanPacket::handle);
        ModernLifeNetwork.INSTANCE.registerMessage(msgId++, CChainsawTargetPacket.class, CChainsawTargetPacket::func_148840_b, CChainsawTargetPacket::new, CChainsawTargetPacket::handle);
        ModernLifeNetwork.INSTANCE.registerMessage(msgId++, CRadiatorPacket.class, CRadiatorPacket::func_148840_b, CRadiatorPacket::new, CRadiatorPacket::handle);
        ModernLifeNetwork.INSTANCE.registerMessage(msgId++, SFlashlightUpdatePacket.class, SFlashlightUpdatePacket::func_148840_b, SFlashlightUpdatePacket::new, SFlashlightUpdatePacket::handle);
        ModernLifeNetwork.INSTANCE.registerMessage(msgId++, CChessStatePacket.class, CChessStatePacket::func_148840_b, CChessStatePacket::new, CChessStatePacket::handle);
        ModernLifeNetwork.INSTANCE.registerMessage(msgId++, CCameraPacket.class, CCameraPacket::func_148840_b, CCameraPacket::new, CCameraPacket::handle);
        ModernLifeNetwork.INSTANCE.registerMessage(msgId++, CMultipartCameraPacket.class, CMultipartCameraPacket::func_148840_b, CMultipartCameraPacket::new, CMultipartCameraPacket::handle);
        ModernLifeNetwork.INSTANCE.registerMessage(msgId++, CMultipartEaselPacket.class, CMultipartEaselPacket::func_148840_b, CMultipartEaselPacket::new, CMultipartEaselPacket::handle);
        ModernLifeNetwork.INSTANCE.registerMessage(msgId++, SMultipartCanvasPacket.class, SMultipartCanvasPacket::func_148840_b, SMultipartCanvasPacket::new, SMultipartCanvasPacket::handle);
        ModernLifeNetwork.INSTANCE.registerMessage(msgId++, CRequestCanvasPacket.class, CRequestCanvasPacket::func_148840_b, CRequestCanvasPacket::new, CRequestCanvasPacket::handle);
        ModernLifeNetwork.INSTANCE.registerMessage(msgId++, CPrintSizePacket.class, CPrintSizePacket::func_148840_b, CPrintSizePacket::new, CPrintSizePacket::handle);
        ModernLifeNetwork.INSTANCE.registerMessage(msgId++, CStopUsingCameraPacket.class, CStopUsingCameraPacket::func_148840_b, CStopUsingCameraPacket::new, CStopUsingCameraPacket::handle);
        ModernLifeNetwork.INSTANCE.registerMessage(msgId++, CHitscanPacket.class, CHitscanPacket::func_148840_b, CHitscanPacket::new, CHitscanPacket::handle);
        ModernLifeNetwork.INSTANCE.registerMessage(msgId++, SBulletHolePacket.class, SBulletHolePacket::func_148840_b, SBulletHolePacket::new, SBulletHolePacket::handle);
    }

    private void setup(FMLCommonSetupEvent event) {
        ModernLifeConfig.reinit();
    }

    public int materialColorToTintColor(int materialColorRgb) {
        int r = materialColorRgb & 0xFF;
        int g = (materialColorRgb & 0xFF00) >> 8;
        int b = (materialColorRgb & 0xFF0000) >> 16;
        return materialColorRgb & 0xFF000000 | r << 16 | g << 8 | b;
    }

    @SubscribeEvent
    public void onInteractEventServer(PlayerInteractEvent interactEvent) {
        if (!interactEvent.getWorld().field_72995_K) {
            ItemStack itemStack;
            Boolean result = CameraItem.usingCameraServer.get(interactEvent.getPlayer());
            if (result != null && result.booleanValue() && !(interactEvent instanceof PlayerInteractEvent.RightClickItem) && interactEvent != null && interactEvent.isCancelable()) {
                interactEvent.setCanceled(true);
            }
            if (interactEvent.getPlayer() != null && (itemStack = interactEvent.getPlayer().func_184614_ca()) != null && itemStack.func_77973_b() == CustomBlocks.ITEM_HANDGUN && (interactEvent instanceof PlayerInteractEvent.LeftClickBlock || interactEvent instanceof PlayerInteractEvent.LeftClickEmpty) && interactEvent != null && interactEvent.isCancelable()) {
                interactEvent.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onAttackEvent(AttackEntityEvent e) {
        ItemStack itemStack;
        if (e.getPlayer() != null && (itemStack = e.getPlayer().func_184614_ca()) != null && itemStack.func_77973_b() == CustomBlocks.ITEM_HANDGUN && e != null && e.isCancelable()) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent serverTick) {
        if (serverTick.phase == TickEvent.Phase.END) {
            ++this.flashlightTickCounter;
        }
    }

    private void cleanupCanvasData(ItemStack itemStack) {
        if (itemStack != null & itemStack.func_77973_b() == CustomBlocks.ITEM_CANVAS) {
            LOGGER.debug("cleanup canvas data");
            if (itemStack.func_77978_p() != null && itemStack.func_77978_p().func_74764_b("UniqueId")) {
                long uniqueId = itemStack.func_77978_p().func_74763_f("UniqueId");
                CMultipartCameraPacket.deletePng(uniqueId);
            }
        }
    }

    @SubscribeEvent
    public void onItemDestroyedEvent(PlayerDestroyItemEvent destroyEvent) {
        if (destroyEvent != null) {
            ItemStack itemStack = destroyEvent.getOriginal();
        }
    }

    @SubscribeEvent
    public void onItemExpiredEvent(ItemExpireEvent expireEvent) {
        if (expireEvent.getEntityItem() != null) {
            ItemStack itemStack = expireEvent.getEntityItem().func_92059_d();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent serverTick) {
        if (serverTick.phase == TickEvent.Phase.END) {
            ++this.speedometerTickCounter;
        }
    }

    private void requestContainerImages(PlayerEntity player) {
        if (player.field_70170_p.field_72995_K) {
            if (player != Minecraft.func_71410_x().field_71439_g) {
                return;
            }
            Container menu = player.field_71070_bA;
            if (menu != null && menu != this.lastContainer) {
                this.lastContainer = menu;
                LOGGER.debug("check container for images: " + menu);
                NonNullList items = menu.func_75138_a();
                if (items != null) {
                    for (int i = 0; i < items.size(); ++i) {
                        ItemStack itemStack = (ItemStack)items.get(i);
                        if (itemStack == null || itemStack.func_77973_b() != CustomBlocks.ITEM_CANVAS || itemStack.func_77978_p() == null || !itemStack.func_77978_p().func_74764_b("UniqueId")) continue;
                        long uniqueId = itemStack.func_77978_p().func_74763_f("UniqueId");
                        ModernLifeClient.getCanvasData(uniqueId);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void playerTickEvent(TickEvent.PlayerTickEvent pte) {
        if (pte.side == LogicalSide.SERVER && pte.phase == TickEvent.Phase.START && !pte.player.field_70170_p.field_72995_K) {
            boolean usedFlashlight = false;
            PlayerEntity player = pte.player;
            Boolean result = FlashlightItem.usingFlashlight.get(player);
            if (result != null && result.booleanValue()) {
                ItemStack flashlight = null;
                if (player.func_184614_ca().func_77973_b().equals(CustomBlocks.ITEM_FLASHLIGHT)) {
                    flashlight = player.func_184614_ca();
                } else if (player.func_184592_cb().func_77973_b().equals(CustomBlocks.ITEM_FLASHLIGHT)) {
                    flashlight = player.func_184592_cb();
                }
                if (flashlight != null) {
                    CustomBlocks.ITEM_FLASHLIGHT.onUsingTick(flashlight, (LivingEntity)player, this.flashlightTickCounter);
                    usedFlashlight = true;
                } else {
                    ((FlashlightItem)CustomBlocks.ITEM_FLASHLIGHT).removePhoton((LivingEntity)player);
                }
            }
        } else if (pte.side == LogicalSide.CLIENT && pte.phase == TickEvent.Phase.START && pte.player.field_70170_p.field_72995_K) {
            this.requestContainerImages(pte.player);
            boolean usedSpeedometer = false;
            PlayerEntity player = pte.player;
            ItemStack speedometer = null;
            if (player.func_184614_ca().func_77973_b().equals(CustomBlocks.ITEM_SPEEDOMETER)) {
                speedometer = player.func_184614_ca();
            } else if (player.func_184592_cb().func_77973_b().equals(CustomBlocks.ITEM_SPEEDOMETER)) {
                speedometer = player.func_184592_cb();
            }
            if (speedometer != null && pte.player.equals((Object)Minecraft.func_71410_x().field_71439_g)) {
                CustomBlocks.ITEM_SPEEDOMETER.onUsingTick(speedometer, (LivingEntity)player, this.speedometerTickCounter);
                boolean bl = true;
            }
        }
    }

    public static synchronized long getNextCanvasId() {
        long toReturn = nextUniqueCanvasId++;
        String subFolder = CMultipartCameraPacket.getSubFolderPrepend();
        File canvasInfo = new File(subFolder + "canvasInfo.txt");
        try {
            FileWriter fw = new FileWriter(canvasInfo);
            String toWrite = String.valueOf(nextUniqueCanvasId);
            fw.write(toWrite);
            fw.close();
        }
        catch (IOException e) {
            LOGGER.debug("Error writing to canvasInfo.txt");
        }
        return toReturn;
    }

    public static void ensureDirectory(String directory) {
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
        Path path;
        if (event != null && event.getServer() != null && (path = event.getServer().func_240776_a_(FolderName.field_237253_i_)) != null && !(serverWorldFolderName = path.toString()).isEmpty() && !(serverWorldFolderName = serverWorldFolderName.replace('\\', '/')).endsWith("/")) {
            serverWorldFolderName = serverWorldFolderName + "/";
        }
        String subFolder = CMultipartCameraPacket.getSubFolderPrepend();
        LOGGER.debug("use folder: " + subFolder);
        File canvasInfo = new File(subFolder + "canvasInfo.txt");
        if (canvasInfo.exists()) {
            try {
                FileReader fr = new FileReader(canvasInfo);
                BufferedReader br = new BufferedReader(fr);
                String line = br.readLine();
                nextUniqueCanvasId = Long.valueOf(line);
            }
            catch (IOException | NumberFormatException e) {
                LOGGER.error("canvasInfo.txt not found", (Throwable)e);
            }
        }
    }

    @SubscribeEvent
    public void onServerStopping(FMLServerStoppingEvent event) {
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerEntity player = event.getPlayer();
        if (player instanceof ServerPlayerEntity) {
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
            MinecraftServer server = serverPlayer.func_184102_h();
            Collection recipes = server.func_199529_aN().func_199510_b();
            ArrayList<IRecipe> modRecipes = new ArrayList<IRecipe>();
            for (IRecipe recipe : recipes) {
                if (!MODID.equals(recipe.func_199560_c().func_110624_b())) continue;
                modRecipes.add(recipe);
            }
            serverPlayer.func_195065_a(modRecipes);
        }
    }

    @SubscribeEvent
    public void onNotifyNeighbor(BlockEvent.NeighborNotifyEvent event) {
        String updatedBlockName = null;
        Block updatedBlock = null;
        try {
            updatedBlock = event.getWorld().func_180495_p(event.getPos()).func_177230_c();
            if (updatedBlock != null) {
                updatedBlockName = updatedBlock.getRegistryName().func_110623_a();
            }
        }
        catch (Exception e) {
            LOGGER.error("Error while checking block in onNotifyNeighbor");
        }
        ServerWorld world = null;
        if (event.getWorld() instanceof ServerWorld) {
            world = (ServerWorld)event.getWorld();
        }
    }

    static {
        serverWorldFolderName = null;
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> blockRegistryEvent) {
            LOGGER.debug("HELLO from Register Block");
        }
    }
}

