/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.core;

import com.dairymoose.modernlife.core.IConfigOverride;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModernLifeConfigPrepopulator {
    private static final Logger LOGGER = LogManager.getLogger();

    public void parseFile(String modName, String fileSuffix, IConfigOverride ... configOverride) {
        if (modName == null || fileSuffix == null) {
            return;
        }
        if (!fileSuffix.endsWith(".toml")) {
            fileSuffix = fileSuffix + ".toml";
        }
        String CONFIG_PREFIX = "config/";
        String finalPath = CONFIG_PREFIX + modName + "-" + fileSuffix;
        File f = new File(finalPath);
        try {
            String line;
            FileReader fr = new FileReader(f);
            BufferedReader br = new BufferedReader(fr);
            while ((line = br.readLine()) != null) {
                String trimmed = line.trim();
                if (trimmed == null || trimmed.length() == 0) continue;
                for (IConfigOverride configSpec : configOverride) {
                    String key;
                    if (configSpec == null || (key = configSpec.getKey()) == null || !trimmed.startsWith(key)) continue;
                    LOGGER.debug("key match: " + key);
                    String[] keyValue = trimmed.split("=");
                    if (keyValue.length != 2) continue;
                    String value = keyValue[1];
                    String trimmedValue = value.trim();
                    Integer configValue = null;
                    try {
                        configValue = Integer.valueOf(trimmedValue);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (configValue == null) continue;
                    LOGGER.debug("value = " + configValue);
                    configSpec.setOverride(configValue);
                }
            }
            fr.close();
        }
        catch (IOException e) {
            LOGGER.error("File not found", (Throwable)e);
        }
    }
}

