/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.items;

import com.dairymoose.modernlife.core.ModernLifeConfig;
import com.dairymoose.modernlife.core.ModernLifeNetwork;
import com.dairymoose.modernlife.network.play.client.CMultipartCameraPacket;
import com.dairymoose.modernlife.util.CanvasData;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.ScreenShotHelper;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CameraItem
extends Item {
    private static final Logger LOGGER = LogManager.getLogger();
    public static boolean usingCamera = false;
    public static Map<PlayerEntity, Boolean> usingCameraServer = new HashMap<PlayerEntity, Boolean>();
    public static boolean pendingSnapshot = false;

    public CameraItem(Item.Properties p_i48530_4_) {
        super(p_i48530_4_);
    }

    private static int toInternalRgbFormat(int nativeRgb) {
        int r = nativeRgb & 0xFF;
        int g = (nativeRgb & 0xFF00) >> 8;
        int b = (nativeRgb & 0xFF0000) >> 16;
        return r << 16 | g << 8 | b;
    }

    private static int getAverageRgbAt(NativeImage img, int x, int y, float pixelSampleWidth, float pixelSampleHeight) {
        int destX = (int)((float)x * pixelSampleWidth);
        int destY = (int)((float)y * pixelSampleHeight);
        int rSum = 0;
        int gSum = 0;
        int bSum = 0;
        int iterations = 0;
        int hStart = (int)(-pixelSampleHeight / 2.0f);
        int hEnd = (int)(pixelSampleHeight / 2.0f);
        int wStart = (int)(-pixelSampleWidth / 2.0f);
        int wEnd = (int)(pixelSampleWidth / 2.0f);
        if (hStart == hEnd) {
            hStart = 0;
            hEnd = 1;
            wStart = 0;
            wEnd = 1;
        }
        for (int h = hStart; h < hEnd; ++h) {
            for (int w = wStart; w < wEnd; ++w) {
                int finalX = destX + w;
                int finalY = destY + h;
                finalX = Math.max(finalX, 0);
                finalY = Math.max(finalY, 0);
                finalX = Math.min(finalX, img.func_195702_a() - 1);
                finalY = Math.min(finalY, img.func_195714_b() - 1);
                int rgb = CameraItem.toInternalRgbFormat(img.func_195709_a(finalX, finalY));
                rSum += CanvasData.getRValue(rgb);
                gSum += CanvasData.getGValue(rgb);
                bSum += CanvasData.getBValue(rgb);
                ++iterations;
            }
        }
        int rAvg = rSum / iterations;
        int gAvg = gSum / iterations;
        int bAvg = bSum / iterations;
        return rAvg << 16 | gAvg << 8 | bAvg;
    }

    public static void takePhoto() {
        Minecraft.func_71410_x().field_71439_g.func_184185_a(SoundEvents.field_187886_fs, 1.0f, 2.0f);
        NativeImage img = ScreenShotHelper.func_198052_a((int)1, (int)1, (Framebuffer)Minecraft.func_71410_x().func_147110_a());
        int tex = 512;
        Integer configInt = (Integer)ModernLifeConfig.COMMON.cameraResolution.get();
        if (configInt != null) {
            tex = configInt;
        }
        float pixelsPerWidth = (float)img.func_195702_a() / (float)tex;
        float pixelsPerHeight = (float)img.func_195714_b() / (float)tex;
        pixelsPerWidth = Math.max(pixelsPerWidth, 1.0f);
        pixelsPerHeight = Math.max(pixelsPerHeight, 1.0f);
        CanvasData cameraData = new CanvasData();
        cameraData.setTextureSize(tex);
        cameraData.initImage();
        for (int h = 0; h < tex; ++h) {
            for (int w = 0; w < tex; ++w) {
                cameraData.setRgbPixel(w, h, CameraItem.getAverageRgbAt(img, w, h, pixelsPerWidth, pixelsPerHeight));
            }
        }
        int MAX_IMAGE_PART = 30000;
        byte[] compressed = cameraData.toCompressedNbt();
        ArrayList<byte[]> parts = new ArrayList<byte[]>();
        int i = 0;
        while ((double)i < Math.ceil((float)compressed.length / (float)MAX_IMAGE_PART)) {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            int startIndex = i * MAX_IMAGE_PART;
            int bytesToWrite = Math.min(compressed.length - startIndex, MAX_IMAGE_PART);
            stream.write(compressed, startIndex, bytesToWrite);
            byte[] part = stream.toByteArray();
            parts.add(part);
            ++i;
        }
        for (i = 0; i < parts.size(); ++i) {
            int seqNo = i + 1;
            boolean last = false;
            if (seqNo == parts.size()) {
                last = true;
            }
            ModernLifeNetwork.INSTANCE.sendToServer((Object)new CMultipartCameraPacket(seqNo, last, (byte[])parts.get(i), tex));
        }
    }

    public boolean onDroppedByPlayer(ItemStack item, PlayerEntity player) {
        return true;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack itemStack, @Nullable World world, List<ITextComponent> text, ITooltipFlag flag) {
        int photoCount = 0;
        if (itemStack.func_77978_p() != null && itemStack.func_77978_p().func_74764_b("ImageList")) {
            INBT imageListNbt = itemStack.func_77978_p().func_74781_a("ImageList");
            ListNBT imageList = null;
            if (imageListNbt instanceof ListNBT) {
                imageList = (ListNBT)imageListNbt;
                photoCount = imageList.size();
            }
        }
        int maxPhotos = itemStack.func_77958_k();
        text.add((ITextComponent)new StringTextComponent(String.valueOf(photoCount) + "/" + String.valueOf(maxPhotos) + " photos stored in memory card"));
        text.add((ITextComponent)new StringTextComponent(""));
        text.add((ITextComponent)new StringTextComponent("* Does not break when durability hits 0"));
        text.add((ITextComponent)new StringTextComponent("* Take to a printer to print your photos"));
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (itemStack.func_77952_i() < itemStack.func_77958_k()) {
            if (world.field_72995_K) {
                if (usingCamera) {
                    pendingSnapshot = true;
                }
                usingCamera = !usingCamera;
            } else {
                Boolean result = usingCameraServer.get(player);
                if (result == null) {
                    result = false;
                }
                result = result == false;
                usingCameraServer.put(player, result);
            }
        }
        return ActionResult.func_226249_b_((Object)itemStack);
    }
}

