/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.items;

import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.core.ModernLifeConfig;
import com.dairymoose.modernlife.core.ModernLifeNetwork;
import com.dairymoose.modernlife.network.play.client.CChainsawTargetPacket;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ToolItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChainsawItem
extends ToolItem {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(3);
    private static final Set<Material> CHAINSAW_MATERIALS = Sets.newHashSet((Object[])new Material[]{Material.field_151584_j, Material.field_151575_d, Material.field_237214_y_, Material.field_151585_k, Material.field_151582_l, Material.field_215713_z, Material.field_151572_C});
    private static final Set<Block> CHAINSAW_BLOCKS = Sets.newHashSet((Object[])new Block[]{Blocks.field_189878_dg, Blocks.field_196553_aF});
    private static final Set<Block> OTHER_DIGGABLE_BLOCKS = Sets.newHashSet((Object[])new Block[]{Blocks.field_150468_ap, Blocks.field_222420_lI, Blocks.field_196689_eF, Blocks.field_196691_eG, Blocks.field_196693_eH, Blocks.field_196695_eI, Blocks.field_196699_eK, Blocks.field_196697_eJ, Blocks.field_235358_mQ_, Blocks.field_235359_mR_, Blocks.field_189878_dg, Blocks.field_196553_aF});
    public static Map<PlayerEntity, MiningInfo> mineMap = new HashMap<PlayerEntity, MiningInfo>();

    public ChainsawItem(IItemTier p_i48530_1_, float p_i48530_2_, float p_i48530_3_, Item.Properties p_i48530_4_) {
        super(p_i48530_2_, p_i48530_3_, p_i48530_1_, OTHER_DIGGABLE_BLOCKS, p_i48530_4_.addToolType(ToolType.AXE, p_i48530_1_.func_200925_d()));
    }

    public float func_150893_a(ItemStack p_150893_1_, BlockState p_150893_2_) {
        Material material = p_150893_2_.func_185904_a();
        return CHAINSAW_MATERIALS.contains(material) ? this.field_77864_a : super.func_150893_a(p_150893_1_, p_150893_2_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void chainsawAttack(World world, PlayerEntity player, ItemStack itemStack, Entity targetEntity, Vector3d loc) {
        LivingEntity livingEntity = (LivingEntity)targetEntity;
        if (livingEntity.func_70089_S() && livingEntity.func_70075_an()) {
            int initialInvulnerableTime = livingEntity.field_70172_ad;
            ModifiableAttributeInstance kbResist = livingEntity.func_110148_a(Attributes.field_233820_c_);
            double kbResistInitial = kbResist.func_111125_b();
            try {
                double pickRange = player.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e();
                double chainsawRange = pickRange * 1.0;
                double chainsawRangeSqr = chainsawRange * chainsawRange;
                if (livingEntity.func_195048_a(player.func_174824_e(1.0f)) <= chainsawRangeSqr && world instanceof ServerWorld) {
                    livingEntity.field_70172_ad = 0;
                    kbResist.func_111128_a(1.0);
                    if (livingEntity.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), 1.87f)) {
                        ((ServerWorld)world).func_195598_a((IParticleData)ParticleTypes.field_239814_an_, livingEntity.func_226277_ct_() + (Math.random() * 0.5 - 0.25), loc.field_72448_b, livingEntity.func_226281_cx_() + (Math.random() * 0.5 - 0.25), 30, 0.0, 0.0, 0.0, 0.0);
                        int durabilityDamage = 26;
                        Integer chainsawConfigDamage = (Integer)ModernLifeConfig.SERVER.chainsawDurabilityDamageOnAttack.get();
                        if (chainsawConfigDamage != null) {
                            durabilityDamage = chainsawConfigDamage;
                        }
                        itemStack.func_222118_a(durabilityDamage, (LivingEntity)player, t -> {});
                        if (itemStack.func_190916_E() <= 0) {
                            return;
                        }
                    }
                }
            }
            finally {
                livingEntity.field_70172_ad = initialInvulnerableTime;
                kbResist.func_111128_a(kbResistInitial);
            }
        }
    }

    private void chainsawSound(World world, PlayerEntity player, int count) {
        if (count % 4 == 0) {
            float volume = 0.7f;
            world.func_184133_a(player, player.func_233580_cy_(), CustomBlocks.SOUND_CHAINSAW_RUNNING, SoundCategory.BLOCKS, volume, 1.0f);
        }
    }

    public void onUsingTick(ItemStack itemStack, LivingEntity livingEntity, int count) {
        if (livingEntity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)livingEntity;
            if (livingEntity.field_70170_p.field_72995_K) {
                if (livingEntity != Minecraft.func_71410_x().field_71439_g) {
                    return;
                }
                RayTraceResult rayTrace = this.getRayTraceForPlayer(player.field_70170_p, player);
                BlockRayTraceResult blockRayTrace = null;
                int entityId = -1;
                if (rayTrace.func_216346_c() == RayTraceResult.Type.ENTITY) {
                    EntityRayTraceResult entityRayTrace = (EntityRayTraceResult)rayTrace;
                    Entity entity = entityRayTrace.func_216348_a();
                    if (entity instanceof LivingEntity) {
                        entityId = entity.func_145782_y();
                        Vector3d loc = entityRayTrace.func_216347_e();
                        blockRayTrace = BlockRayTraceResult.func_216352_a((Vector3d)loc, (Direction)Direction.UP, (BlockPos)new BlockPos(loc.field_72450_a, loc.field_72448_b, loc.field_72449_c));
                    }
                } else if (rayTrace.func_216346_c() == RayTraceResult.Type.BLOCK) {
                    blockRayTrace = (BlockRayTraceResult)rayTrace;
                }
                this.chainsawSound(player.field_70170_p, player, count);
                CChainsawTargetPacket chainsawTarget = new CChainsawTargetPacket(blockRayTrace, entityId);
                ModernLifeNetwork.INSTANCE.sendToServer((Object)chainsawTarget);
            } else {
                MiningInfo mInfo = mineMap.get(player);
                if (mInfo == null) {
                    mInfo = new MiningInfo();
                    mineMap.put(player, mInfo);
                }
                World world = livingEntity.field_70170_p;
                RayTraceResult rayTrace = null;
                rayTrace = mInfo.rayTrace;
                if (rayTrace == null) {
                    return;
                }
                this.chainsawSound(player.field_70170_p, player, count);
                Vector3d loc = rayTrace.func_216347_e();
                Entity entity = null;
                if (rayTrace.func_216346_c() == RayTraceResult.Type.ENTITY) {
                    mInfo.rayTrace = rayTrace;
                    EntityRayTraceResult entityRayTrace = (EntityRayTraceResult)rayTrace;
                    entity = entityRayTrace.func_216348_a();
                    if (entity instanceof LivingEntity) {
                        Entity targetEntity = entity;
                        if (itemStack != null && itemStack.func_77973_b() == CustomBlocks.ITEM_CHAINSAW && itemStack.func_190916_E() > 0) {
                            this.chainsawAttack(world, player, itemStack, targetEntity, loc);
                            if (!targetEntity.func_70089_S()) {
                                mInfo.rayTrace = null;
                            }
                        }
                    }
                } else if (rayTrace.func_216346_c() == RayTraceResult.Type.BLOCK) {
                    BlockRayTraceResult blockRayTrace = (BlockRayTraceResult)rayTrace;
                    double pickRange = player.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e();
                    double chainsawRange = pickRange * 1.0;
                    double chainsawRangeSqr = chainsawRange * chainsawRange;
                    if (blockRayTrace.func_216347_e().func_72436_e(player.func_174824_e(1.0f)) > chainsawRangeSqr) {
                        return;
                    }
                    BlockPos pos = blockRayTrace.func_216350_a();
                    BlockState state = world.func_180495_p(pos);
                    if (!state.func_196958_f()) {
                        ParticleType particles = (ParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(ForgeRegistries.PARTICLE_TYPES.getKey((IForgeRegistryEntry)ParticleTypes.field_197611_d));
                        if (particles != null) {
                            BlockParticleData blockParticle = new BlockParticleData(particles, state);
                            if (world instanceof ServerWorld) {
                                for (int i = 0; i < 10; ++i) {
                                    ((ServerWorld)world).func_195598_a((IParticleData)blockParticle, loc.field_72450_a + (Math.random() * 1.0 - 0.5), loc.field_72448_b + (Math.random() * 1.0 - 0.5), loc.field_72449_c + (Math.random() * 1.0 - 0.5), 1, 0.0, 0.0, 0.0, 0.0);
                                }
                            }
                        }
                        this.mineIfPossible(player, world, pos, mInfo);
                    }
                }
            }
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public void destroyGrid(World world, BlockPos center, int width, int height) {
        BlockPos newCenter = center.func_177979_c(height / 2);
        for (int h = 0; h < height; ++h) {
            BlockPos westPos = newCenter.func_177985_f(width / 2);
            for (int w = 0; w < width; ++w) {
                BlockPos destroyPos = westPos.func_177964_d(width / 2);
                for (int slice = 0; slice < width; ++slice) {
                    if (!destroyPos.equals((Object)center) && world.func_180495_p(destroyPos).func_203425_a(world.func_180495_p(center).func_177230_c())) {
                        this.destroyIfPossible(world, destroyPos);
                    }
                    destroyPos = destroyPos.func_177968_d();
                }
                westPos = westPos.func_177974_f();
            }
            newCenter = newCenter.func_177984_a();
        }
    }

    public boolean mineIfPossible(PlayerEntity player, World world, BlockPos pos, MiningInfo mInfo) {
        if (!pos.equals((Object)mInfo.pos)) {
            mInfo.pos = pos;
            mInfo.miningProgress = 0.0f;
        } else {
            BlockState state = world.func_180495_p(pos);
            float toolMult = this.func_150893_a(player.func_184607_cu(), state);
            float usingChainsawMult = 2.0f;
            ItemStack itemStack = player.func_184607_cu();
            float enchantMult = 1.0f;
            if (CHAINSAW_MATERIALS.contains(state.func_185904_a()) || CHAINSAW_BLOCKS.contains(state.func_177230_c())) {
                usingChainsawMult = 6.0f;
                if (itemStack.func_77948_v()) {
                    ListNBT enchantmentTags = itemStack.func_77986_q();
                    for (int i = 0; i < enchantmentTags.size(); ++i) {
                        INBT iNbt = enchantmentTags.get(i);
                        if (!(iNbt instanceof CompoundNBT)) continue;
                        CompoundNBT nbt = (CompoundNBT)iNbt;
                        String id = nbt.func_74779_i("id");
                        int level = nbt.func_74762_e("lvl");
                        if (id == null || !"minecraft:efficiency".equals(id) || level <= 0) continue;
                        enchantMult = 1.0f + (float)level / 5.0f;
                    }
                }
            }
            float blockDestroySpeed = state.func_185887_b((IBlockReader)world, pos);
            float progressIncrement = usingChainsawMult * toolMult * enchantMult / blockDestroySpeed;
            mInfo.miningProgress += progressIncrement;
            float destroyProgress = state.func_185903_a(player, (IBlockReader)world, pos);
            int newProgressValueToSet = (int)(mInfo.miningProgress / 10.0f);
            world.func_175715_c(-1, pos, --newProgressValueToSet);
            if (mInfo.miningProgress >= 100.0f && world instanceof ServerWorld) {
                mInfo.pos = null;
                mInfo.miningProgress = 0.0f;
                if (CHAINSAW_MATERIALS.contains(state.func_185904_a()) || CHAINSAW_BLOCKS.contains(state.func_177230_c())) {
                    this.destroyGrid(world, pos, 3, 3);
                    if (state.func_185904_a() == Material.field_151584_j) {
                        itemStack.func_222118_a(1, (LivingEntity)player, x -> {});
                    } else {
                        itemStack.func_222118_a(3, (LivingEntity)player, x -> {});
                    }
                } else {
                    itemStack.func_222118_a(6, (LivingEntity)player, x -> {});
                }
                world.func_175715_c(player.func_145782_y(), pos, 10);
                return world.func_175655_b(pos, true);
            }
        }
        return false;
    }

    public boolean destroyIfPossible(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        if (CHAINSAW_MATERIALS.contains(state.func_185904_a()) || CHAINSAW_BLOCKS.contains(state.func_177230_c())) {
            return world.func_175655_b(pos, true);
        }
        return false;
    }

    private RayTraceResult getRayTraceForPlayer(World world, PlayerEntity player) {
        double d0 = Minecraft.func_71410_x().field_71442_b.func_78757_d();
        BlockRayTraceResult rayTrace = Item.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.NONE);
        Vector3d vector3d = player.func_174824_e(1.0f);
        boolean flag = false;
        int i = 3;
        double d1 = d0;
        if (Minecraft.func_71410_x().field_71442_b.func_78749_i()) {
            d0 = d1 = 6.0;
        } else if (d0 > 3.0) {
            flag = true;
        }
        d1 *= d1;
        if (rayTrace != null) {
            d1 = rayTrace.func_216347_e().func_72436_e(vector3d);
        }
        Vector3d vector3d1 = player.func_70676_i(1.0f);
        Vector3d vector3d2 = vector3d.func_72441_c(vector3d1.field_72450_a * d0, vector3d1.field_72448_b * d0, vector3d1.field_72449_c * d0);
        float f = 1.0f;
        AxisAlignedBB axisalignedbb = player.func_174813_aQ().func_216361_a(vector3d1.func_186678_a(d0)).func_72314_b(1.0, 1.0, 1.0);
        EntityRayTraceResult entityraytraceresult = ProjectileHelper.func_221273_a((Entity)player, (Vector3d)vector3d, (Vector3d)vector3d2, (AxisAlignedBB)axisalignedbb, entity -> !entity.func_175149_v() && entity.func_70067_L(), (double)d1);
        if (entityraytraceresult != null) {
            Entity entity1 = entityraytraceresult.func_216348_a();
            Vector3d vector3d3 = entityraytraceresult.func_216347_e();
            double d2 = vector3d.func_72436_e(vector3d3);
            if (flag && d2 > 9.0) {
                rayTrace = BlockRayTraceResult.func_216352_a((Vector3d)vector3d3, (Direction)Direction.func_210769_a((double)vector3d1.field_72450_a, (double)vector3d1.field_72448_b, (double)vector3d1.field_72449_c), (BlockPos)new BlockPos(vector3d3));
            } else if (d2 < d1 || rayTrace == null) {
                rayTrace = entityraytraceresult;
            }
        }
        return rayTrace;
    }

    public void func_77624_a(ItemStack itemStack, @Nullable World world, List<ITextComponent> text, ITooltipFlag flag) {
        text.add((ITextComponent)new StringTextComponent("Right click to use"));
        text.add((ITextComponent)new StringTextComponent("* Highly effective on trees and leaves"));
    }

    public void func_77615_a(ItemStack itemStack, World p_77615_2_, LivingEntity entity, int p_77615_4_) {
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            player.func_184602_cy();
            MiningInfo mInfo = mineMap.get(player);
            if (mInfo != null) {
                mInfo.pos = null;
            }
        }
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand p_77659_3_) {
        ItemStack itemStack = player.func_184586_b(p_77659_3_);
        player.func_184598_c(p_77659_3_);
        return super.func_77659_a(world, player, p_77659_3_);
    }

    public static class MiningInfo {
        public float miningProgress;
        public BlockPos pos;
        public RayTraceResult rayTrace;
    }
}

