/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.items;

import com.dairymoose.modernlife.blocks.PhotonBlock;
import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.core.ModernLifeConfig;
import com.dairymoose.modernlife.core.ModernLifeNetwork;
import com.dairymoose.modernlife.network.play.client.SFlashlightUpdatePacket;
import com.dairymoose.modernlife.tileentities.PhotonTileEntity;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ToolItem;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FlashlightItem
extends ToolItem {
    private static final Logger LOGGER = LogManager.getLogger();
    private int tickUpdatePeriod = 8;
    public static Map<PlayerEntity, Boolean> usingFlashlight = new HashMap<PlayerEntity, Boolean>();
    private Set<PlayerEntity> canRelease = new HashSet<PlayerEntity>();

    public FlashlightItem(IItemTier p_i48530_1_, float p_i48530_2_, float p_i48530_3_, Item.Properties p_i48530_4_) {
        super(p_i48530_2_, p_i48530_3_, p_i48530_1_, new HashSet(), p_i48530_4_.addToolType(ToolType.AXE, p_i48530_1_.func_200925_d()));
    }

    public boolean onDroppedByPlayer(ItemStack item, PlayerEntity player) {
        usingFlashlight.put(player, false);
        this.removePhoton((LivingEntity)player);
        return super.onDroppedByPlayer(item, player);
    }

    private boolean tryAddPhoton(World world, Vector3d scaledView, LivingEntity livingEntity) {
        Vector3d entityPos = livingEntity.func_174824_e(1.0f);
        Vector3d photonPos = entityPos.func_178787_e(scaledView);
        BlockRayTraceResult result = world.func_217299_a(new RayTraceContext(entityPos, photonPos, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, (Entity)livingEntity));
        photonPos = result.func_216347_e();
        BlockPos photonBlockPos = new BlockPos(photonPos.field_72450_a, photonPos.field_72448_b, photonPos.field_72449_c);
        BlockState state = world.func_180495_p(photonBlockPos);
        if (state.func_203425_a(CustomBlocks.BLOCK_PHOTON)) {
            if (!((Boolean)state.func_177229_b((Property)PhotonBlock.EXTINGUISHED)).booleanValue()) {
                return true;
            }
            world.func_180501_a(photonBlockPos, (BlockState)CustomBlocks.BLOCK_PHOTON.func_176223_P().func_206870_a((Property)PhotonBlock.EXTINGUISHED, (Comparable)Boolean.valueOf(false)), 3);
            return true;
        }
        if (state.func_196958_f()) {
            world.func_180501_a(photonBlockPos, CustomBlocks.BLOCK_PHOTON.func_176223_P(), 3);
            this.removePhoton(livingEntity);
            PhotonTileEntity.existingPhotons.add(photonBlockPos);
            PhotonTileEntity.photonPos.put((Entity)livingEntity, photonBlockPos);
            return true;
        }
        return false;
    }

    public void onUsingTick(ItemStack itemStack, LivingEntity livingEntity, int count) {
        Integer configUpdatePeriod = (Integer)ModernLifeConfig.SERVER.flashlightUpdatePeriod.get();
        if (configUpdatePeriod != null) {
            this.tickUpdatePeriod = configUpdatePeriod;
        }
        if (count % this.tickUpdatePeriod == 0 && livingEntity.field_70170_p instanceof ServerWorld) {
            if (itemStack.func_77952_i() < itemStack.func_77958_k()) {
                Vector3d scaledView;
                World world = livingEntity.field_70170_p;
                Vector3d view = livingEntity.func_70676_i(1.0f);
                float scaleValue = 6.0f;
                Double configRange = (Double)ModernLifeConfig.SERVER.flashlightRange.get();
                if (configRange != null) {
                    scaleValue = configRange.floatValue();
                }
                while (scaleValue >= 0.0f && !this.tryAddPhoton(world, scaledView = view.func_186678_a((double)scaleValue), livingEntity)) {
                    scaleValue -= 1.0f;
                }
                itemStack.func_96631_a(this.tickUpdatePeriod, field_77697_d, null);
                if (itemStack.func_77952_i() >= itemStack.func_77958_k()) {
                    itemStack.func_196085_b(itemStack.func_77958_k());
                    if (livingEntity instanceof PlayerEntity) {
                        PlayerEntity player = (PlayerEntity)livingEntity;
                        usingFlashlight.put(player, false);
                        this.removePhoton(livingEntity);
                    }
                }
            } else {
                this.removePhoton(livingEntity);
            }
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public void func_77624_a(ItemStack itemStack, @Nullable World world, List<ITextComponent> text, ITooltipFlag flag) {
        String currentMinutes = String.valueOf((int)Math.floor((double)(itemStack.func_77958_k() - itemStack.func_77952_i()) / 1200.0));
        String maxMinutes = String.valueOf(itemStack.func_77958_k() / 1200);
        text.add((ITextComponent)new StringTextComponent("Right click to use"));
        text.add((ITextComponent)new StringTextComponent("* Using it will deplete the battery but it will not break"));
        text.add((ITextComponent)new StringTextComponent("* " + currentMinutes + " minutes remaining before drained"));
        text.add((ITextComponent)new StringTextComponent("* Lasts " + maxMinutes + " minutes at full charge"));
        text.add((ITextComponent)new StringTextComponent("* Repair at anvil using a battery"));
    }

    public int func_77626_a(ItemStack stack) {
        return 2700000;
    }

    public void func_77663_a(ItemStack itemStack, World p_77663_2_, Entity p_77663_3_, int p_77663_4_, boolean p_77663_5_) {
    }

    public void func_77615_a(ItemStack itemStack, World world, LivingEntity livingEntity, int p_77615_4_) {
        if (world instanceof ServerWorld && livingEntity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)livingEntity;
            if (this.canRelease.contains(player)) {
                this.canRelease.remove(player);
                world.func_184133_a((PlayerEntity)null, livingEntity.func_233580_cy_(), SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 0.3f, 1.0f);
                LOGGER.debug("releaseUsing: " + world);
                this.removePhoton((LivingEntity)player);
            } else {
                this.canRelease.add(player);
            }
        }
    }

    public void removePhoton(LivingEntity livingEntity) {
        BlockPos entityPhoton = PhotonTileEntity.photonPos.get(livingEntity);
        if (entityPhoton != null) {
            PhotonTileEntity.existingPhotons.remove(entityPhoton);
            PhotonTileEntity.photonPos.remove(livingEntity);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand p_77659_3_) {
        ItemStack itemStack = player.func_184586_b(p_77659_3_);
        if (world.field_72995_K && !player.equals((Object)Minecraft.func_71410_x().field_71439_g)) {
            ActionResult.func_226249_b_((Object)itemStack);
        }
        if (p_77659_3_ != Hand.MAIN_HAND) {
            return ActionResult.func_226249_b_((Object)itemStack);
        }
        Boolean result = usingFlashlight.get(player);
        if (result == null) {
            result = false;
        }
        result = result == false;
        if (itemStack.func_77952_i() >= itemStack.func_77958_k()) {
            result = false;
        }
        LOGGER.debug("flashlight state=" + result);
        world.func_184133_a((PlayerEntity)null, player.func_233580_cy_(), SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 0.3f, 1.0f);
        if (world instanceof ServerWorld) {
            if (!result.booleanValue()) {
                this.removePhoton((LivingEntity)player);
            }
            usingFlashlight.put(player, result);
            ModernLifeNetwork.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new SFlashlightUpdatePacket(player.func_145782_y(), result));
            if (player.func_184587_cr()) {
                // empty if block
            }
        }
        return ActionResult.func_226249_b_((Object)itemStack);
    }
}

