/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.items;

import com.dairymoose.modernlife.blocks.gui.GuitarScreen;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ToolItem;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GuitarItem
extends ToolItem {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Set<Material> DIGGABLE_MATERIALS = Sets.newHashSet((Object[])new Material[]{Material.field_151575_d, Material.field_237214_y_, Material.field_151585_k, Material.field_151582_l, Material.field_215713_z, Material.field_151572_C});
    private static final Set<Block> OTHER_DIGGABLE_BLOCKS = Sets.newHashSet((Object[])new Block[]{Blocks.field_150468_ap, Blocks.field_222420_lI, Blocks.field_196689_eF, Blocks.field_196691_eG, Blocks.field_196693_eH, Blocks.field_196695_eI, Blocks.field_196699_eK, Blocks.field_196697_eJ, Blocks.field_235358_mQ_, Blocks.field_235359_mR_});
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(3);
    int counter = 1;
    boolean canChange = true;

    public GuitarItem(IItemTier p_i48530_1_, float p_i48530_2_, float p_i48530_3_, Item.Properties p_i48530_4_) {
        super(p_i48530_2_, p_i48530_3_, p_i48530_1_, OTHER_DIGGABLE_BLOCKS, p_i48530_4_.addToolType(ToolType.AXE, p_i48530_1_.func_200925_d()));
    }

    public float func_150893_a(ItemStack p_150893_1_, BlockState p_150893_2_) {
        Material material = p_150893_2_.func_185904_a();
        return DIGGABLE_MATERIALS.contains(material) ? this.field_77864_a : super.func_150893_a(p_150893_1_, p_150893_2_);
    }

    public void func_77624_a(ItemStack itemStack, @Nullable World world, List<ITextComponent> text, ITooltipFlag flag) {
        text.add((ITextComponent)new StringTextComponent("Right click to use"));
        text.add((ITextComponent)new StringTextComponent("* Standard Tuning (EADGBE)"));
    }

    float getFreqForFret(Tuning string, int fret) {
        if (string == Tuning.STRING_E) {
            return (float)(77.657 * Math.exp(0.0579 * (double)fret) / (double)155.56f);
        }
        return 82.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        if (world.field_72995_K) {
            Minecraft.func_71410_x().func_147108_a((Screen)new GuitarScreen(world, player));
        }
        return super.func_77659_a(world, player, hand);
    }

    public static enum Tuning {
        STRING_E,
        STRING_A,
        STRING_D,
        STRING_G,
        STRING_B,
        STRING_HI_E;

    }
}

