/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.items;

import com.dairymoose.entity.DummyEntity;
import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.core.ModernLifeNetwork;
import com.dairymoose.modernlife.network.play.client.CHitscanPacket;
import com.dairymoose.modernlife.network.play.client.SBulletHolePacket;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SwordItem;
import net.minecraft.item.ToolItem;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HandgunItem
extends ToolItem {
    public static final int FIRING_TICK_MAX = 6;
    public static final int RELOADING_TICK_MAX = 30;
    public static int reloadingTick = -1;
    public static Map<PlayerEntity, Integer> firingTickMap = new ConcurrentHashMap<PlayerEntity, Integer>();
    public static long lastShotTimestamp = 0L;
    public static double originalFov = -1.0;
    public static final float handgunZoomFactor = 1.5f;
    public static final float DESTROY_INCREMENT = 0.49f;
    public static Map<PlayerEntity, MiningInfo> mineMap = new HashMap<PlayerEntity, MiningInfo>();
    private static final Logger LOGGER = LogManager.getLogger();

    public HandgunItem(IItemTier p_i48530_1_, float p_i48530_2_, float p_i48530_3_, Item.Properties p_i48530_4_) {
        super(p_i48530_2_, p_i48530_3_, p_i48530_1_, new HashSet(), p_i48530_4_.addToolType(ToolType.AXE, p_i48530_1_.func_200925_d()));
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return true;
    }

    public boolean onDroppedByPlayer(ItemStack item, PlayerEntity player) {
        HandgunItem.resetFov();
        return super.onDroppedByPlayer(item, player);
    }

    public void hitBlockPos(PlayerEntity player, World world, ItemStack itemStack, BlockPos pos, Vector3d loc, Direction direction) {
        BlockState state = world.func_180495_p(pos);
        Material material = state.func_185904_a();
        ItemStack stoneSword = new ItemStack(new IItemProvider(){

            public Item func_199767_j() {
                return Items.field_151052_q;
            }
        });
        float speed = ((SwordItem)stoneSword.func_77973_b()).func_150893_a(stoneSword, state);
        boolean destroyed = false;
        if (speed >= 1.5f || material == Material.field_151588_w) {
            world.func_175655_b(pos, true);
            destroyed = true;
        } else {
            float destroySpeed = state.func_185887_b((IBlockReader)world, pos);
            MiningInfo mInfo = mineMap.get(player);
            if (mInfo == null) {
                mInfo = new MiningInfo();
                mineMap.put(player, mInfo);
            }
            if (!pos.equals((Object)mInfo.pos)) {
                mInfo.pos = pos;
                if (destroySpeed < 0.0f) {
                    mInfo.pos = null;
                }
                mInfo.miningValue = destroySpeed;
                mInfo.miningInitialValue = destroySpeed;
            }
            if (mInfo.miningInitialValue > 0.0f) {
                mInfo.miningValue -= 0.49f;
            }
            if (mInfo.miningInitialValue > 0.0f) {
                if (mInfo.miningValue <= 0.0f) {
                    world.func_175715_c(-1, pos, 10);
                    world.func_175655_b(pos, true);
                    destroyed = true;
                    mInfo.pos = null;
                    mInfo.miningInitialValue = -1.0f;
                } else {
                    int progressVal = (int)(10.0 * (1.0 - (double)(mInfo.miningValue / mInfo.miningInitialValue)));
                    world.func_175715_c(-1, pos, progressVal);
                }
            }
        }
        if (!destroyed) {
            int holeNo = (int)(Math.random() * 3.0);
            ModernLifeNetwork.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new SBulletHolePacket(player.func_145782_y(), loc, pos, holeNo, direction, player.field_70170_p.func_234923_W_().func_240901_a_().toString()));
        }
    }

    public boolean hasAmmo(PlayerEntity player) {
        for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
            ItemStack itemStack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
            if (itemStack == null || itemStack.func_77973_b() != CustomBlocks.ITEM_MAGAZINE && itemStack.func_77973_b() != CustomBlocks.ITEM_EXTENDED_MAGAZINE) continue;
            return true;
        }
        return false;
    }

    public boolean removeAmmo(PlayerEntity player, int ammo) {
        for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
            ItemStack itemStack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
            if (itemStack == null || itemStack.func_77973_b() != CustomBlocks.ITEM_MAGAZINE && itemStack.func_77973_b() != CustomBlocks.ITEM_EXTENDED_MAGAZINE) continue;
            itemStack.func_222118_a(ammo, (LivingEntity)player, (Consumer)new Consumer<PlayerEntity>(){

                @Override
                public void accept(PlayerEntity t) {
                }
            });
            return true;
        }
        return false;
    }

    public int getCurrentMagazineAmmo(PlayerEntity player) {
        for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
            ItemStack itemStack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
            if (itemStack == null || itemStack.func_77973_b() != CustomBlocks.ITEM_MAGAZINE && itemStack.func_77973_b() != CustomBlocks.ITEM_EXTENDED_MAGAZINE) continue;
            int remaining = itemStack.func_77958_k() - itemStack.func_77952_i();
            return remaining;
        }
        return 0;
    }

    public int getCurrentMagazineCapacity(PlayerEntity player) {
        for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
            ItemStack itemStack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
            if (itemStack == null || itemStack.func_77973_b() != CustomBlocks.ITEM_MAGAZINE && itemStack.func_77973_b() != CustomBlocks.ITEM_EXTENDED_MAGAZINE) continue;
            return itemStack.func_77958_k();
        }
        return 0;
    }

    public int getAmmoTotal(PlayerEntity player) {
        int total = 0;
        for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
            ItemStack itemStack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
            if (itemStack == null || itemStack.func_77973_b() != CustomBlocks.ITEM_MAGAZINE && itemStack.func_77973_b() != CustomBlocks.ITEM_EXTENDED_MAGAZINE) continue;
            int remaining = itemStack.func_77958_k() - itemStack.func_77952_i();
            total += remaining;
        }
        return total;
    }

    public boolean fireGun(PlayerEntity player) {
        long timeDiff = System.currentTimeMillis() - lastShotTimestamp;
        if (timeDiff >= 275L && (reloadingTick < 0 || reloadingTick == 0 && timeDiff >= 2000L)) {
            reloadingTick = -1;
            if (!this.hasAmmo(player)) {
                player.field_70170_p.func_184133_a(player, player.func_233580_cy_(), SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 1.0f, 2.0f);
                return false;
            }
            int magAmmo = this.getCurrentMagazineAmmo(player);
            int totalAmmo = this.getAmmoTotal(player);
            lastShotTimestamp = System.currentTimeMillis();
            firingTickMap.put(player, 6);
            RayTraceResult rayTrace = this.getRayTraceForPlayer(player.field_70170_p, player, 500.0);
            BlockPos pos = null;
            int entityId = -1;
            Vector3d location = rayTrace.func_216347_e();
            Direction direction = null;
            if (rayTrace instanceof BlockRayTraceResult) {
                BlockRayTraceResult blockRayTrace = (BlockRayTraceResult)rayTrace;
                pos = blockRayTrace.func_216350_a();
                direction = blockRayTrace.func_216354_b();
            } else if (rayTrace instanceof EntityRayTraceResult) {
                EntityRayTraceResult entityRayTrace = (EntityRayTraceResult)rayTrace;
                pos = entityRayTrace.func_216348_a().func_233580_cy_();
                entityId = entityRayTrace.func_216348_a().func_145782_y();
            }
            CHitscanPacket.playGunSound(player.field_70170_p, player, pos);
            if (magAmmo == 1 && totalAmmo > 1) {
                reloadingTick = 30;
            }
            ModernLifeNetwork.INSTANCE.sendToServer((Object)new CHitscanPacket(pos, entityId, location, direction));
            return true;
        }
        return false;
    }

    private RayTraceResult getRayTraceForPlayer(World world, PlayerEntity player, double range) {
        boolean useAdsSpread;
        double d0 = range;
        Vector3d entityPos = player.func_174824_e(1.0f);
        Vector3d targetPos = entityPos.func_178787_e(player.func_70676_i(1.0f).func_186678_a(range));
        boolean useMovementSpread = true;
        double spreadFactor = 0.0;
        if (useMovementSpread) {
            Vector3d movement = player.func_213322_ci();
            double offsetFactor = 1800.0;
            boolean useAdsSpread2 = true;
            if (useAdsSpread2 && !player.func_184587_cr()) {
                offsetFactor *= 2.0;
            }
            spreadFactor = (movement.field_72450_a * movement.field_72450_a + movement.field_72449_c * movement.field_72449_c) * offsetFactor;
        }
        if ((useAdsSpread = true) && spreadFactor == 0.0 && !player.func_184587_cr()) {
            spreadFactor = 4.0;
        }
        if (spreadFactor != 0.0) {
            targetPos = targetPos.func_72441_c(Math.random() * spreadFactor - spreadFactor / 2.0, 0.0, Math.random() * spreadFactor - spreadFactor / 2.0);
        }
        BlockRayTraceResult rayTrace = world.func_217299_a(new RayTraceContext(entityPos, targetPos, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, (Entity)player));
        Vector3d vector3d = player.func_174824_e(1.0f);
        boolean flag = false;
        int i = 3;
        double d1 = d0;
        d1 *= d1;
        if (rayTrace != null) {
            d1 = rayTrace.func_216347_e().func_72436_e(vector3d);
        }
        Vector3d vector3d1 = player.func_70676_i(1.0f);
        Vector3d vector3d2 = vector3d.func_72441_c(vector3d1.field_72450_a * d0, vector3d1.field_72448_b * d0, vector3d1.field_72449_c * d0);
        if (useMovementSpread) {
            vector3d2 = vector3d2.func_72441_c(Math.random() * spreadFactor - spreadFactor / 2.0, 0.0, Math.random() * spreadFactor - spreadFactor / 2.0);
        }
        float f = 1.0f;
        DummyEntity dummy = new DummyEntity(DummyEntity.DUMMY_ENTITY, world);
        AxisAlignedBB axisalignedbb = player.func_174813_aQ().func_216361_a(vector3d1.func_186678_a(d0)).func_72314_b(1.0, 1.0, 1.0);
        EntityRayTraceResult entityraytraceresult = ProjectileHelper.func_221273_a((Entity)dummy, (Vector3d)vector3d, (Vector3d)vector3d2, (AxisAlignedBB)axisalignedbb, entity -> entity != player && !entity.func_175149_v() && entity.func_70067_L(), (double)d1);
        if (entityraytraceresult != null) {
            Entity entity1 = entityraytraceresult.func_216348_a();
            Vector3d vector3d3 = entityraytraceresult.func_216347_e();
            double d2 = vector3d.func_72436_e(vector3d3);
            rayTrace = entityraytraceresult;
        }
        return rayTrace;
    }

    public void func_77624_a(ItemStack itemStack, @Nullable World world, List<ITextComponent> text, ITooltipFlag flag) {
        text.add((ITextComponent)new StringTextComponent("Left click to fire"));
        text.add((ITextComponent)new StringTextComponent("Right click to aim down sights"));
        text.add((ITextComponent)new StringTextComponent(" * Requires at least one Magazine in order to shoot"));
    }

    public static void resetFov() {
        originalFov = -1.0;
    }

    public boolean canContinueUsing(ItemStack oldStack, ItemStack newStack) {
        if (oldStack != newStack) {
            HandgunItem.resetFov();
        }
        return super.canContinueUsing(oldStack, newStack);
    }

    public void func_77615_a(ItemStack itemStack, World p_77615_2_, LivingEntity entity, int p_77615_4_) {
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            player.func_184602_cy();
            HandgunItem.resetFov();
        }
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand p_77659_3_) {
        ItemStack itemStack = player.func_184586_b(p_77659_3_);
        player.func_184598_c(p_77659_3_);
        if (world.field_72995_K && originalFov < 0.0) {
            originalFov = Minecraft.func_71410_x().field_71474_y.field_74334_X;
        }
        return super.func_77659_a(world, player, p_77659_3_);
    }

    public static class MiningInfo {
        public float miningInitialValue;
        public float miningValue;
        public BlockPos pos;
    }
}

