/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.items;

import com.dairymoose.modernlife.blocks.RoadMarkerBlock;
import com.dairymoose.modernlife.core.CustomBlocks;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RoadMarkerItem
extends Item {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Block[] roadMarkers = new Block[]{CustomBlocks.BLOCK_ROAD_MARKER_WHITE, CustomBlocks.BLOCK_ROAD_MARKER_YELLOW, CustomBlocks.BLOCK_ROAD_MARKER_DOUBLE_YELLOW, CustomBlocks.BLOCK_ROAD_MARKER_WHITE_SHOULDER_LEFT, CustomBlocks.BLOCK_ROAD_MARKER_WHITE_SHOULDER_RIGHT};
    private static final Block[] roadMarkersIncline = new Block[]{CustomBlocks.BLOCK_ROAD_MARKER_WHITE_INCLINE, CustomBlocks.BLOCK_ROAD_MARKER_YELLOW_INCLINE, CustomBlocks.BLOCK_ROAD_MARKER_DOUBLE_YELLOW_INCLINE, CustomBlocks.BLOCK_ROAD_MARKER_WHITE_SHOULDER_LEFT_INCLINE, CustomBlocks.BLOCK_ROAD_MARKER_WHITE_SHOULDER_RIGHT_INCLINE};
    public static Map<PlayerEntity, Integer> selectedMarker = new HashMap<PlayerEntity, Integer>();
    private static final int DEFAULT_MARKER = 0;

    public RoadMarkerItem(Item.Properties p_i48530_4_) {
        super(p_i48530_4_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack p_77624_1_, @Nullable World p_77624_2_, List<ITextComponent> text, ITooltipFlag p_77624_4_) {
        text.add((ITextComponent)new StringTextComponent("* Right click paved road to apply currently selected road marker"));
        text.add((ITextComponent)new StringTextComponent("* Right click elsewhere to toggle between available road markers"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        if (world.field_72995_K) return ActionResultType.CONSUME;
        BlockState bs = world.func_180495_p(context.func_195995_a());
        if (bs.func_203425_a(CustomBlocks.BLOCK_PAVED_ROAD) || bs.func_203425_a(CustomBlocks.BLOCK_PAVED_ROAD_RAMP)) {
            boolean didAction = false;
            BlockPos above = context.func_195995_a().func_177984_a();
            BlockState aboveBs = world.func_180495_p(above);
            if (world.func_180495_p(above).func_196958_f()) {
                Integer marker = selectedMarker.get(context.func_195999_j());
                if (marker == null) {
                    marker = 0;
                }
                if (bs.func_203425_a(CustomBlocks.BLOCK_PAVED_ROAD)) {
                    world.func_175656_a(above, (BlockState)roadMarkers[marker].func_176223_P().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)context.func_195992_f()));
                } else {
                    world.func_175656_a(above, (BlockState)roadMarkersIncline[marker].func_176223_P().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)context.func_195992_f()));
                }
                world.func_184133_a(null, above, SoundEvents.field_219685_jO, SoundCategory.BLOCKS, 1.0f, 1.6f);
                didAction = true;
                ItemStack itemStack = context.func_195996_i();
                itemStack.func_222118_a(1, (LivingEntity)context.func_195999_j(), x -> {});
            } else if (aboveBs.func_177230_c() instanceof RoadMarkerBlock) {
                world.func_175656_a(above, Blocks.field_150350_a.func_176223_P());
                world.func_184133_a(null, above, SoundEvents.field_219685_jO, SoundCategory.BLOCKS, 1.0f, 1.6f);
                didAction = true;
            }
            if (!didAction) return ActionResultType.CONSUME;
        }
        this.toggleSelectedMarker(context.func_195999_j());
        return ActionResultType.CONSUME;
    }

    void toggleSelectedMarker(PlayerEntity player) {
        Integer marker = selectedMarker.get(player);
        if (marker == null) {
            marker = 0;
        }
        marker = marker + 1;
        marker = marker % roadMarkers.length;
        selectedMarker.put(player, marker);
        player.func_145747_a((ITextComponent)new StringTextComponent("Using marker: ").func_230529_a_((ITextComponent)new TranslationTextComponent(roadMarkers[marker].func_149739_a())), player.func_110124_au());
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand p_77659_3_) {
        ItemStack itemStack = player.func_184586_b(p_77659_3_);
        if (!world.field_72995_K) {
            this.toggleSelectedMarker(player);
        }
        return ActionResult.func_226249_b_((Object)itemStack);
    }
}

