/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.network.play.client;

import com.dairymoose.entity.BicycleEntity;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.IServerPlayNetHandler;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CBikeDismountPacket
implements IPacket<IServerPlayNetHandler> {
    private Vector3d position;
    private float velocity;
    private float jumpStep;
    private float downward_velocity;
    private int bikeId;
    private static final Logger LOGGER = LogManager.getLogger();

    public CBikeDismountPacket() {
    }

    public CBikeDismountPacket(PacketBuffer buffer) {
        this.func_148837_a(buffer);
    }

    public CBikeDismountPacket(Vector3d position, float jumpStep, float velocity, float downward_velocity, int bikeId) {
        this.position = position;
        this.jumpStep = jumpStep;
        this.velocity = velocity;
        this.downward_velocity = downward_velocity;
        this.bikeId = bikeId;
    }

    public void func_148837_a(PacketBuffer p_148837_1_) {
        double x = p_148837_1_.readDouble();
        double y = p_148837_1_.readDouble();
        double z = p_148837_1_.readDouble();
        this.jumpStep = p_148837_1_.readFloat();
        this.position = new Vector3d(x, y, z);
        this.velocity = p_148837_1_.readFloat();
        this.downward_velocity = p_148837_1_.readFloat();
        this.bikeId = p_148837_1_.readInt();
    }

    public void func_148840_b(PacketBuffer p_148840_1_) {
        p_148840_1_.writeDouble(this.position.field_72450_a);
        p_148840_1_.writeDouble(this.position.field_72448_b);
        p_148840_1_.writeDouble(this.position.field_72449_c);
        p_148840_1_.writeFloat(this.jumpStep);
        p_148840_1_.writeFloat(this.velocity);
        p_148840_1_.writeFloat(this.downward_velocity);
        p_148840_1_.writeInt(this.bikeId);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity sender = ((NetworkEvent.Context)ctx.get()).getSender();
            this.handle((IServerPlayNetHandler)((NetworkEvent.Context)ctx.get()).getNetworkManager().func_150729_e());
        });
        ctx.get().setPacketHandled(true);
    }

    public void handle(IServerPlayNetHandler p_148833_1_) {
        LOGGER.debug("Handle CBikeDismountPacket");
        if (this.velocity > 0.42f || this.velocity < -0.14f || this.bikeId < 0) {
            return;
        }
        if (p_148833_1_ instanceof ServerPlayNetHandler) {
            ServerPlayNetHandler serverHandler = (ServerPlayNetHandler)p_148833_1_;
            ServerWorld world = serverHandler.field_147369_b.func_71121_q();
            LOGGER.debug("world = " + world);
            if (world != null) {
                BicycleEntity bike;
                LOGGER.debug("velocity = " + this.velocity + ", bikeId=" + this.bikeId);
                Entity entity = world.func_73045_a(this.bikeId);
                if (entity instanceof BicycleEntity && world.func_195588_v((bike = (BicycleEntity)entity).func_233580_cy_()) && world.func_195588_v(new BlockPos(this.position.field_72450_a, this.position.field_72448_b, this.position.field_72449_c))) {
                    bike.func_70107_b(this.position.field_72450_a, this.position.field_72448_b, this.position.field_72449_c);
                    bike.setJumpStep(this.jumpStep);
                    bike.setVelocity(this.velocity);
                    bike.setDownwardVelocity(this.downward_velocity);
                    bike.recentDismount = true;
                }
            }
        }
    }
}

