/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.network.play.client;

import com.dairymoose.modernlife.core.CustomBlocks;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.IServerPlayNetHandler;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CCameraPacket
implements IPacket<IServerPlayNetHandler> {
    private byte[] image;
    private int texSize;
    private static final Logger LOGGER = LogManager.getLogger();
    private static long lastPacketTimestamp = 0L;
    private static int incomingPacketCounter = 0;
    private static long reenableCamera = 0L;
    private boolean enabled = false;

    public CCameraPacket() {
    }

    public CCameraPacket(byte[] image, int texSize) {
        this.image = image;
        this.texSize = texSize;
    }

    public CCameraPacket(PacketBuffer buffer) {
        this.func_148837_a(buffer);
    }

    public void func_148837_a(PacketBuffer buffer) {
        this.image = buffer.func_179251_a();
        this.texSize = buffer.readInt();
    }

    public void func_148840_b(PacketBuffer buffer) {
        buffer.func_179250_a(this.image);
        buffer.writeInt(this.texSize);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity sender = ((NetworkEvent.Context)ctx.get()).getSender();
            this.handle((IServerPlayNetHandler)((NetworkEvent.Context)ctx.get()).getNetworkManager().func_150729_e());
        });
        ctx.get().setPacketHandled(true);
    }

    public void handle(IServerPlayNetHandler p_148833_1_) {
        if (!this.enabled) {
            return;
        }
        LOGGER.debug("Handle CCameraPacket");
        if (p_148833_1_ instanceof ServerPlayNetHandler) {
            ServerPlayNetHandler serverHandler = (ServerPlayNetHandler)p_148833_1_;
            CompoundNBT nbt = new CompoundNBT();
            ServerWorld world = serverHandler.field_147369_b.func_71121_q();
            LOGGER.debug("world = " + world);
            if (world != null) {
                LOGGER.debug("image length = " + this.image.length);
                if (this.image != null && this.image.length != 0 && this.image.length < 197000 && this.texSize <= 256) {
                    long currentTimestamp = System.currentTimeMillis();
                    long timeDiff = currentTimestamp - lastPacketTimestamp;
                    long timeDiffReenableCamera = currentTimestamp - reenableCamera;
                    if (timeDiffReenableCamera >= 0L) {
                        ItemStack itemStack = new ItemStack(new IItemProvider(){

                            public Item func_199767_j() {
                                return CustomBlocks.ITEM_CANVAS;
                            }
                        });
                        itemStack.func_196082_o().func_74773_a("image", this.image);
                        if (this.texSize > 0) {
                            itemStack.func_77978_p().func_74768_a("TextureSize", this.texSize);
                        }
                        serverHandler.field_147369_b.func_191521_c(itemStack);
                        ++incomingPacketCounter;
                        if (timeDiff >= 5000L) {
                            if (incomingPacketCounter > 50) {
                                reenableCamera = currentTimestamp + 3600000L;
                            }
                            incomingPacketCounter = 0;
                            lastPacketTimestamp = System.currentTimeMillis();
                        }
                    }
                } else {
                    LOGGER.debug("incoming image is too big");
                }
            }
        }
    }

    public byte[] getImage() {
        return this.image;
    }
}

