/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.network.play.client;

import com.dairymoose.modernlife.blocks.EaselBlock;
import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.tileentities.EaselTileEntity;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.IServerPlayNetHandler;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CCanvasPacket
implements IPacket<IServerPlayNetHandler> {
    private byte[] image;
    private BlockPos easelPos;
    private static final Logger LOGGER = LogManager.getLogger();
    private boolean enabled = false;

    public CCanvasPacket() {
    }

    public CCanvasPacket(byte[] image, BlockPos easelPos) {
        this.image = image;
        this.easelPos = easelPos;
        LOGGER.debug("image length = " + image.length);
    }

    public CCanvasPacket(PacketBuffer buffer) {
        this.func_148837_a(buffer);
    }

    public void func_148837_a(PacketBuffer buffer) {
        this.image = buffer.func_179251_a();
        this.easelPos = buffer.func_179259_c();
    }

    public void func_148840_b(PacketBuffer buffer) {
        buffer.func_179250_a(this.image);
        buffer.func_179255_a(this.easelPos);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity sender = ((NetworkEvent.Context)ctx.get()).getSender();
            this.handle((IServerPlayNetHandler)((NetworkEvent.Context)ctx.get()).getNetworkManager().func_150729_e());
        });
        ctx.get().setPacketHandled(true);
    }

    public void handle(IServerPlayNetHandler p_148833_1_) {
        if (!this.enabled) {
            return;
        }
        LOGGER.debug("Handle CCanvasPacket");
        if (this.easelPos == null) {
            return;
        }
        if (p_148833_1_ instanceof ServerPlayNetHandler) {
            ServerPlayNetHandler serverHandler = (ServerPlayNetHandler)p_148833_1_;
            CompoundNBT nbt = new CompoundNBT();
            ServerWorld world = serverHandler.field_147369_b.func_71121_q();
            LOGGER.debug("world = " + world);
            if (world != null && world.func_195588_v(this.easelPos)) {
                BlockState easelState = world.func_180495_p(this.easelPos);
                LOGGER.debug("easelState = " + easelState);
                if (easelState != null && easelState.func_203425_a((Block)CustomBlocks.BLOCK_EASEL) && !((Boolean)easelState.func_177229_b((Property)EaselBlock.EMPTY)).booleanValue() && this.image != null && this.image.length != 0 && this.image.length < 100000) {
                    LOGGER.debug("easelPos = " + this.easelPos);
                    TileEntity tileEntity = world.func_175726_f(this.easelPos).func_175625_s(this.easelPos);
                    LOGGER.debug("tileEntity = " + tileEntity);
                    if (tileEntity instanceof EaselTileEntity) {
                        EaselTileEntity easelTileEntity = (EaselTileEntity)tileEntity;
                        ItemStack currentItem = easelTileEntity.func_70301_a(0).func_77946_l();
                        if (easelTileEntity != null) {
                            world.func_175656_a(this.easelPos, (BlockState)easelState.func_206870_a((Property)EaselBlock.EMPTY, (Comparable)Boolean.valueOf(true)));
                            ItemStack itemStack = currentItem;
                            itemStack.func_196082_o().func_74773_a("image", this.image);
                            serverHandler.field_147369_b.func_191521_c(itemStack);
                            easelTileEntity.func_70299_a(0, ItemStack.field_190927_a);
                        }
                    }
                }
            }
        }
    }

    public byte[] getImage() {
        return this.image;
    }
}

