/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.network.play.client;

import com.dairymoose.modernlife.items.ChainsawItem;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.IServerPlayNetHandler;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CChainsawTargetPacket
implements IPacket<IServerPlayNetHandler> {
    private BlockRayTraceResult rayTrace;
    private int targetedEntityId;
    private static final Logger LOGGER = LogManager.getLogger();

    public CChainsawTargetPacket() {
    }

    public CChainsawTargetPacket(PacketBuffer buffer) {
        this.func_148837_a(buffer);
    }

    public CChainsawTargetPacket(BlockRayTraceResult rayTrace, int targetedEntityId) {
        this.rayTrace = rayTrace;
        this.targetedEntityId = targetedEntityId;
    }

    public void func_148837_a(PacketBuffer packet) {
        this.rayTrace = packet.func_218669_q();
        this.targetedEntityId = packet.readInt();
    }

    public void func_148840_b(PacketBuffer packet) {
        if (this.rayTrace == null) {
            this.rayTrace = BlockRayTraceResult.func_216352_a((Vector3d)new Vector3d(0.0, 0.0, 0.0), (Direction)Direction.UP, (BlockPos)new BlockPos(0, 0, 0));
        }
        packet.func_218668_a(this.rayTrace);
        packet.writeInt(this.targetedEntityId);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity sender = ((NetworkEvent.Context)ctx.get()).getSender();
            this.handle((IServerPlayNetHandler)((NetworkEvent.Context)ctx.get()).getNetworkManager().func_150729_e());
        });
        ctx.get().setPacketHandled(true);
    }

    public void handle(IServerPlayNetHandler iServerHandler) {
        if (iServerHandler instanceof ServerPlayNetHandler) {
            ChainsawItem.MiningInfo mInfo;
            ServerPlayNetHandler serverHandler = (ServerPlayNetHandler)iServerHandler;
            if (this.rayTrace == null) {
                this.rayTrace = BlockRayTraceResult.func_216352_a((Vector3d)new Vector3d(0.0, 0.0, 0.0), (Direction)Direction.UP, (BlockPos)new BlockPos(0, 0, 0));
            }
            if ((mInfo = ChainsawItem.mineMap.get(serverHandler.field_147369_b)) == null) {
                mInfo = new ChainsawItem.MiningInfo();
                ChainsawItem.mineMap.put((PlayerEntity)serverHandler.field_147369_b, mInfo);
            }
            if (this.targetedEntityId != -1) {
                Entity entity = serverHandler.field_147369_b.field_70170_p.func_73045_a(this.targetedEntityId);
                if (entity != null) {
                    mInfo.rayTrace = this.rayTrace == null ? new EntityRayTraceResult(entity) : new EntityRayTraceResult(entity, this.rayTrace.func_216347_e());
                }
            } else {
                mInfo.rayTrace = this.rayTrace;
            }
        }
    }
}

