/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.network.play.client;

import com.dairymoose.modernlife.blocks.gui.chess.BishopPiece;
import com.dairymoose.modernlife.blocks.gui.chess.KingPiece;
import com.dairymoose.modernlife.blocks.gui.chess.KnightPiece;
import com.dairymoose.modernlife.blocks.gui.chess.PawnPiece;
import com.dairymoose.modernlife.blocks.gui.chess.Piece;
import com.dairymoose.modernlife.blocks.gui.chess.PieceIds;
import com.dairymoose.modernlife.blocks.gui.chess.QueenPiece;
import com.dairymoose.modernlife.blocks.gui.chess.RookPiece;
import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.tileentities.ChessBoardTileEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.IServerPlayNetHandler;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CChessStatePacket
implements IPacket<IServerPlayNetHandler> {
    public int currentTurn;
    public int newCheckState;
    public String whitePlayer;
    public String blackPlayer;
    public boolean isWhiteTurn;
    public List<Piece> whitePieces;
    public List<Piece> blackPieces;
    public Piece movedPiece;
    private BlockPos chessBoardPos;
    private static final Logger LOGGER = LogManager.getLogger();

    public CChessStatePacket() {
    }

    public CChessStatePacket(PacketBuffer buffer) {
        this.func_148837_a(buffer);
    }

    public CChessStatePacket(int currentTurn, int newCheckState, String whitePlayer, String blackPlayer, boolean isWhiteTurn, BlockPos chessBoardPos, List<Piece> whitePieces, List<Piece> blackPieces, Piece movedPiece) {
        this.currentTurn = currentTurn;
        this.newCheckState = newCheckState;
        this.whitePlayer = whitePlayer;
        this.blackPlayer = blackPlayer;
        this.isWhiteTurn = isWhiteTurn;
        this.chessBoardPos = chessBoardPos;
        this.whitePieces = whitePieces;
        this.blackPieces = blackPieces;
        this.movedPiece = movedPiece;
    }

    private void addPieceToList(List<Piece> pieceList, int type, int x, int y) {
        if (type == PieceIds.BISHOP.ordinal()) {
            pieceList.add(new BishopPiece().withXy(x, y));
        } else if (type == PieceIds.KING.ordinal()) {
            pieceList.add(new KingPiece().withXy(x, y));
        } else if (type == PieceIds.KNIGHT.ordinal()) {
            pieceList.add(new KnightPiece().withXy(x, y));
        } else if (type == PieceIds.PAWN.ordinal()) {
            pieceList.add(new PawnPiece().withXy(x, y));
        } else if (type == PieceIds.QUEEN.ordinal()) {
            pieceList.add(new QueenPiece().withXy(x, y));
        } else if (type == PieceIds.ROOK.ordinal()) {
            pieceList.add(new RookPiece().withXy(x, y));
        }
    }

    public void func_148837_a(PacketBuffer packet) {
        int y;
        int x;
        int type;
        this.whitePieces = new ArrayList<Piece>();
        this.blackPieces = new ArrayList<Piece>();
        this.currentTurn = packet.readInt();
        this.newCheckState = packet.readInt();
        this.whitePlayer = packet.func_150789_c(40);
        this.blackPlayer = packet.func_150789_c(40);
        this.isWhiteTurn = packet.readBoolean();
        this.chessBoardPos = packet.func_179259_c();
        int whiteCount = packet.readInt();
        for (int i = 0; i < whiteCount; ++i) {
            type = packet.readInt();
            x = packet.readInt();
            y = packet.readInt();
            this.addPieceToList(this.whitePieces, type, x, y);
        }
        int blackCount = packet.readInt();
        for (int i = 0; i < blackCount; ++i) {
            int type2 = packet.readInt();
            int x2 = packet.readInt();
            int y2 = packet.readInt();
            this.addPieceToList(this.blackPieces, type2, x2, y2);
        }
        type = packet.readInt();
        x = packet.readInt();
        y = packet.readInt();
        ArrayList<Piece> movedPieces = new ArrayList<Piece>();
        this.addPieceToList(movedPieces, type, x, y);
        if (movedPieces.size() == 1) {
            this.movedPiece = (Piece)movedPieces.get(0);
        }
    }

    public void func_148840_b(PacketBuffer packet) {
        packet.writeInt(this.currentTurn);
        packet.writeInt(this.newCheckState);
        if (this.whitePlayer != null) {
            packet.func_180714_a(this.whitePlayer);
        } else {
            packet.func_180714_a("");
        }
        if (this.blackPlayer != null) {
            packet.func_180714_a(this.blackPlayer);
        } else {
            packet.func_180714_a("");
        }
        packet.writeBoolean(this.isWhiteTurn);
        packet.func_179255_a(this.chessBoardPos);
        packet.writeInt(this.whitePieces.size());
        for (Piece p : this.whitePieces) {
            packet.writeInt(p.getId());
            packet.writeInt(p.x);
            packet.writeInt(p.y);
        }
        packet.writeInt(this.blackPieces.size());
        for (Piece p : this.blackPieces) {
            packet.writeInt(p.getId());
            packet.writeInt(p.x);
            packet.writeInt(p.y);
        }
        if (this.movedPiece != null) {
            packet.writeInt(this.movedPiece.getId());
            packet.writeInt(this.movedPiece.x);
            packet.writeInt(this.movedPiece.y);
        }
    }

    public static CChessStatePacket fromNbt(CompoundNBT nbt) {
        CChessStatePacket packet = new CChessStatePacket();
        packet.whitePieces = new ArrayList<Piece>();
        packet.blackPieces = new ArrayList<Piece>();
        if (nbt.func_74764_b("BoardState")) {
            int y;
            int x;
            int type;
            CompoundNBT item;
            INBT iNbt;
            CompoundNBT boardState = nbt.func_74775_l("BoardState");
            packet.currentTurn = boardState.func_74762_e("CurrentTurn");
            packet.newCheckState = boardState.func_74762_e("NewCheckState");
            packet.whitePlayer = boardState.func_74779_i("WhitePlayer");
            packet.blackPlayer = boardState.func_74779_i("BlackPlayer");
            packet.isWhiteTurn = boardState.func_74767_n("IsWhiteTurn");
            INBT movedPieceNbt = boardState.func_74781_a("MovedPiece");
            if (movedPieceNbt instanceof CompoundNBT) {
                CompoundNBT item2 = (CompoundNBT)movedPieceNbt;
                int type2 = item2.func_74762_e("id");
                int x2 = item2.func_74762_e("x");
                int y2 = item2.func_74762_e("y");
                ArrayList<Piece> movedPieces = new ArrayList<Piece>();
                packet.addPieceToList(movedPieces, type2, x2, y2);
                if (movedPieces.size() == 1) {
                    packet.movedPiece = (Piece)movedPieces.get(0);
                }
            }
            if (boardState.func_74764_b("WhitePieces") && (iNbt = boardState.func_74781_a("WhitePieces")) instanceof ListNBT) {
                ListNBT list = (ListNBT)iNbt;
                for (INBT nbtItem : list) {
                    if (!(nbtItem instanceof CompoundNBT)) continue;
                    item = (CompoundNBT)nbtItem;
                    if (item.func_74764_b("id") && item.func_74764_b("x") && item.func_74764_b("y")) {
                        type = item.func_74762_e("id");
                        x = item.func_74762_e("x");
                        y = item.func_74762_e("y");
                        packet.addPieceToList(packet.whitePieces, type, x, y);
                        continue;
                    }
                    return packet;
                }
            }
            if (boardState.func_74764_b("BlackPieces") && (iNbt = boardState.func_74781_a("BlackPieces")) instanceof ListNBT) {
                ListNBT list = (ListNBT)iNbt;
                for (INBT nbtItem : list) {
                    if (!(nbtItem instanceof CompoundNBT)) continue;
                    item = (CompoundNBT)nbtItem;
                    if (item.func_74764_b("id") && item.func_74764_b("x") && item.func_74764_b("y")) {
                        type = item.func_74762_e("id");
                        x = item.func_74762_e("x");
                        y = item.func_74762_e("y");
                        packet.addPieceToList(packet.blackPieces, type, x, y);
                        continue;
                    }
                    return packet;
                }
            }
        }
        return packet;
    }

    public CompoundNBT getPieceNbt(Piece piece) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("id", piece.getId());
        nbt.func_74768_a("x", piece.x);
        nbt.func_74768_a("y", piece.y);
        return nbt;
    }

    public void writeToNbt(CompoundNBT nbt) {
        CompoundNBT boardState = new CompoundNBT();
        ListNBT whiteNbt = new ListNBT();
        for (Piece p : this.whitePieces) {
            whiteNbt.add((Object)this.getPieceNbt(p));
        }
        ListNBT blackNbt = new ListNBT();
        for (Piece p : this.blackPieces) {
            blackNbt.add((Object)this.getPieceNbt(p));
        }
        boardState.func_218657_a("WhitePieces", (INBT)whiteNbt);
        boardState.func_218657_a("BlackPieces", (INBT)blackNbt);
        boardState.func_74768_a("CurrentTurn", this.currentTurn);
        boardState.func_74768_a("NewCheckState", this.newCheckState);
        boardState.func_74778_a("WhitePlayer", this.whitePlayer);
        boardState.func_74778_a("BlackPlayer", this.blackPlayer);
        boardState.func_74757_a("IsWhiteTurn", this.isWhiteTurn);
        if (this.movedPiece != null) {
            boardState.func_218657_a("MovedPiece", (INBT)this.getPieceNbt(this.movedPiece));
        }
        nbt.func_218657_a("BoardState", (INBT)boardState);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity sender = ((NetworkEvent.Context)ctx.get()).getSender();
            this.handle((IServerPlayNetHandler)((NetworkEvent.Context)ctx.get()).getNetworkManager().func_150729_e());
        });
        ctx.get().setPacketHandled(true);
    }

    public void handle(IServerPlayNetHandler p_148833_1_) {
        LOGGER.debug("Handle CChessStatePacket");
        if (this.chessBoardPos == null) {
            return;
        }
        if (p_148833_1_ instanceof ServerPlayNetHandler) {
            TileEntity tileEntity;
            BlockState chessBoardState;
            ServerPlayNetHandler serverHandler = (ServerPlayNetHandler)p_148833_1_;
            ServerWorld world = serverHandler.field_147369_b.func_71121_q();
            if (world != null && world.func_195588_v(this.chessBoardPos) && (chessBoardState = world.func_180495_p(this.chessBoardPos)) != null && chessBoardState.func_203425_a(CustomBlocks.BLOCK_CHESS_BOARD) && (tileEntity = world.func_175726_f(this.chessBoardPos).func_175625_s(this.chessBoardPos)) instanceof ChessBoardTileEntity) {
                ChessBoardTileEntity chessBoardTileEntity = (ChessBoardTileEntity)tileEntity;
                ItemStack currentItem = chessBoardTileEntity.func_70301_a(0);
                if (chessBoardTileEntity != null) {
                    ItemStack itemStack = currentItem;
                    this.writeToNbt(itemStack.func_196082_o());
                    world.func_184138_a(this.chessBoardPos, chessBoardState, chessBoardState, 2);
                }
            }
        }
    }
}

