/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.network.play.client;

import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.core.ModernLifeConfig;
import com.dairymoose.modernlife.items.GuitarItem;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.IServerPlayNetHandler;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CGuitarPacket
implements IPacket<IServerPlayNetHandler> {
    private boolean distorted = false;
    private GuitarItem.Tuning string;
    private int fret;
    private static final Logger LOGGER = LogManager.getLogger();
    public static final float GUITAR_VOLUME = 1.2f;
    public static final float GUITAR_VOLUME_BOOST_CLEAN = 1.4f;

    public CGuitarPacket() {
    }

    public CGuitarPacket(PacketBuffer buffer) {
        this.func_148837_a(buffer);
    }

    public CGuitarPacket(GuitarItem.Tuning string, int fret, boolean distorted) {
        this.string = string;
        this.fret = fret;
        this.distorted = distorted;
    }

    public void func_148837_a(PacketBuffer p_148837_1_) {
        this.string = (GuitarItem.Tuning)p_148837_1_.func_179257_a(GuitarItem.Tuning.class);
        this.fret = p_148837_1_.readInt();
        this.distorted = p_148837_1_.readBoolean();
    }

    public void func_148840_b(PacketBuffer p_148840_1_) {
        p_148840_1_.func_179249_a((Enum)this.string);
        p_148840_1_.writeInt(this.fret);
        p_148840_1_.writeBoolean(this.distorted);
    }

    public static float getFreqMultForFret(int fret) {
        return (float)(0.9470365854 * Math.exp(0.058 * (double)fret) / 2.0);
    }

    public static SoundEvent getSoundEvent(GuitarItem.Tuning string, boolean distorted) {
        SoundEvent soundEvent = CustomBlocks.SOUND_GUITAR_E;
        if (!distorted) {
            if (string == GuitarItem.Tuning.STRING_E) {
                soundEvent = CustomBlocks.SOUND_GUITAR_E;
            } else if (string == GuitarItem.Tuning.STRING_A) {
                soundEvent = CustomBlocks.SOUND_GUITAR_A;
            } else if (string == GuitarItem.Tuning.STRING_D) {
                soundEvent = CustomBlocks.SOUND_GUITAR_D;
            } else if (string == GuitarItem.Tuning.STRING_G) {
                soundEvent = CustomBlocks.SOUND_GUITAR_G;
            } else if (string == GuitarItem.Tuning.STRING_B) {
                soundEvent = CustomBlocks.SOUND_GUITAR_B;
            } else if (string == GuitarItem.Tuning.STRING_HI_E) {
                soundEvent = CustomBlocks.SOUND_GUITAR_HI_E;
            }
        } else if (string == GuitarItem.Tuning.STRING_E) {
            soundEvent = CustomBlocks.SOUND_DIST_GUITAR_E;
        } else if (string == GuitarItem.Tuning.STRING_A) {
            soundEvent = CustomBlocks.SOUND_DIST_GUITAR_A;
        } else if (string == GuitarItem.Tuning.STRING_D) {
            soundEvent = CustomBlocks.SOUND_DIST_GUITAR_D;
        } else if (string == GuitarItem.Tuning.STRING_G) {
            soundEvent = CustomBlocks.SOUND_DIST_GUITAR_G;
        } else if (string == GuitarItem.Tuning.STRING_B) {
            soundEvent = CustomBlocks.SOUND_DIST_GUITAR_B;
        } else if (string == GuitarItem.Tuning.STRING_HI_E) {
            soundEvent = CustomBlocks.SOUND_DIST_GUITAR_HI_E;
        }
        return soundEvent;
    }

    public static void playGuitarSound(World world, PlayerEntity player, BlockPos pos, SoundEvent soundEvent, boolean distorted, int fret) {
        Double configValue;
        if (world == null || soundEvent == null) {
            return;
        }
        float calculatedVolume = 1.2f;
        if (!distorted) {
            calculatedVolume *= 1.4f;
        }
        if ((configValue = (Double)ModernLifeConfig.COMMON.guitarVolumeBoost.get()) != null) {
            calculatedVolume *= configValue.floatValue();
        }
        LOGGER.debug("world = " + world);
        world.func_184133_a(player, pos, soundEvent, SoundCategory.BLOCKS, calculatedVolume, CGuitarPacket.getFreqMultForFret(fret));
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity sender = ((NetworkEvent.Context)ctx.get()).getSender();
            this.handle((IServerPlayNetHandler)((NetworkEvent.Context)ctx.get()).getNetworkManager().func_150729_e());
        });
        ctx.get().setPacketHandled(true);
    }

    public void handle(IServerPlayNetHandler p_148833_1_) {
        LOGGER.debug("Handle CGuitarPacket");
        if (this.string == null || this.fret < 1 || this.fret > 25) {
            return;
        }
        if (p_148833_1_ instanceof ServerPlayNetHandler) {
            Boolean configValue;
            ServerPlayNetHandler serverHandler = (ServerPlayNetHandler)p_148833_1_;
            ServerWorld world = serverHandler.field_147369_b.func_71121_q();
            LOGGER.debug("world = " + world);
            if (!(world == null || (configValue = (Boolean)ModernLifeConfig.SERVER.guitarOnlyPlaysLocally.get()) != null && configValue.booleanValue())) {
                SoundEvent soundEvent = CGuitarPacket.getSoundEvent(this.string, this.distorted);
                LOGGER.debug("play note, fret=" + this.fret + ", freq=" + CGuitarPacket.getFreqMultForFret(this.fret));
                CGuitarPacket.playGuitarSound((World)world, (PlayerEntity)serverHandler.field_147369_b, serverHandler.field_147369_b.func_233580_cy_(), soundEvent, this.distorted, this.fret);
            }
        }
    }
}

