/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.network.play.client;

import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.core.ModernLifeConfig;
import com.dairymoose.modernlife.items.HandgunItem;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.IServerPlayNetHandler;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CHitscanPacket
implements IPacket<IServerPlayNetHandler> {
    private BlockPos blockPos;
    private int entityId;
    private Vector3d location;
    private Direction direction;
    private static final Logger LOGGER = LogManager.getLogger();

    public CHitscanPacket() {
    }

    public CHitscanPacket(PacketBuffer buffer) {
        this.func_148837_a(buffer);
    }

    public CHitscanPacket(BlockPos blockPos, int entityId, Vector3d location, Direction direction) {
        this.blockPos = blockPos;
        this.entityId = entityId;
        this.location = location;
        this.direction = direction;
    }

    public void func_148837_a(PacketBuffer p_148837_1_) {
        this.blockPos = p_148837_1_.func_179259_c();
        this.entityId = p_148837_1_.readInt();
        this.location = new Vector3d(p_148837_1_.readDouble(), p_148837_1_.readDouble(), p_148837_1_.readDouble());
        int dirValue = p_148837_1_.readInt();
        this.direction = dirValue == -1 ? null : Direction.func_82600_a((int)dirValue);
    }

    public void func_148840_b(PacketBuffer p_148840_1_) {
        p_148840_1_.func_179255_a(this.blockPos);
        p_148840_1_.writeInt(this.entityId);
        p_148840_1_.writeDouble(this.location.field_72450_a);
        p_148840_1_.writeDouble(this.location.field_72448_b);
        p_148840_1_.writeDouble(this.location.field_72449_c);
        if (this.direction == null) {
            p_148840_1_.writeInt(-1);
        } else {
            p_148840_1_.writeInt(this.direction.func_176745_a());
        }
    }

    public static void playGunSound(World world, PlayerEntity player, BlockPos pos) {
        if (world == null) {
            return;
        }
        float volume = 2.0f;
        float pitch = 1.2f;
        float pitchRange = 0.6f;
        float pitchRand = (float)((double)pitchRange * Math.random());
        world.func_184133_a(player, player.func_233580_cy_(), CustomBlocks.SOUND_GUN_FIRE, SoundCategory.BLOCKS, volume, pitch += (pitchRand -= pitchRange / 2.0f));
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity sender = ((NetworkEvent.Context)ctx.get()).getSender();
            this.handle((IServerPlayNetHandler)((NetworkEvent.Context)ctx.get()).getNetworkManager().func_150729_e());
        });
        ctx.get().setPacketHandled(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(IServerPlayNetHandler p_148833_1_) {
        LOGGER.debug("Handle CHitscanPacket");
        if (p_148833_1_ instanceof ServerPlayNetHandler) {
            ItemStack itemStack;
            ServerPlayNetHandler serverHandler = (ServerPlayNetHandler)p_148833_1_;
            ServerWorld world = serverHandler.field_147369_b.func_71121_q();
            if (world != null && world instanceof ServerWorld && (itemStack = serverHandler.field_147369_b.func_184614_ca()).func_77973_b() == CustomBlocks.ITEM_HANDGUN && ((HandgunItem)CustomBlocks.ITEM_HANDGUN).removeAmmo((PlayerEntity)serverHandler.field_147369_b, 1)) {
                Entity entity;
                ServerWorld serverWorld = world;
                BasicParticleType particleType = ParticleTypes.field_197613_f;
                ParticleType particles = (ParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(ForgeRegistries.PARTICLE_TYPES.getKey((IForgeRegistryEntry)ParticleTypes.field_197611_d));
                BlockState state = world.func_180495_p(this.blockPos);
                if (!state.func_196958_f()) {
                    BlockParticleData blockParticle = new BlockParticleData(particles, state);
                    serverWorld.func_195598_a((IParticleData)blockParticle, this.location.field_72450_a, this.location.field_72448_b, this.location.field_72449_c, 30, 0.1, 0.1, 0.1, 0.1);
                }
                if ((entity = world.func_73045_a(this.entityId)) instanceof LivingEntity) {
                    float foreheadHeight = entity.func_213302_cg() - entity.func_70047_e();
                    boolean headShot = this.location.field_72448_b >= entity.func_226280_cw_() - (double)foreheadHeight;
                    int particleCount = 20;
                    int initialInvulnerableTime = entity.field_70172_ad;
                    try {
                        entity.field_70172_ad = 0;
                        double baseDamage = 19.5;
                        double critMultiplier = 2.0;
                        boolean canHeadshot = true;
                        Double configDamage = (Double)ModernLifeConfig.SERVER.handgunDamage.get();
                        Double configCritMult = (Double)ModernLifeConfig.SERVER.handgunCritMultiplier.get();
                        Boolean configEnableHeadshots = (Boolean)ModernLifeConfig.SERVER.handgunEnableHeadshots.get();
                        if (configDamage != null) {
                            baseDamage = configDamage;
                        }
                        if (configCritMult != null) {
                            critMultiplier = configCritMult;
                        }
                        if (configEnableHeadshots != null) {
                            canHeadshot = configEnableHeadshots;
                        }
                        if (!canHeadshot) {
                            headShot = false;
                        }
                        if (headShot) {
                            entity.func_70097_a(DamageSource.func_76365_a((PlayerEntity)serverHandler.field_147369_b), (float)(baseDamage * critMultiplier));
                            particleCount = 60;
                        } else {
                            entity.func_70097_a(DamageSource.func_76365_a((PlayerEntity)serverHandler.field_147369_b), (float)baseDamage);
                        }
                        if (this.entityId != -1) {
                            particleType = ParticleTypes.field_239814_an_;
                            serverWorld.func_195598_a((IParticleData)particleType, this.location.field_72450_a, this.location.field_72448_b, this.location.field_72449_c, particleCount, 0.1, 0.1, 0.1, 0.1);
                        }
                    }
                    finally {
                        entity.field_70172_ad = initialInvulnerableTime;
                    }
                }
                if (this.entityId == -1) {
                    ((HandgunItem)CustomBlocks.ITEM_HANDGUN).hitBlockPos((PlayerEntity)serverHandler.field_147369_b, (World)serverWorld, itemStack, this.blockPos, this.location, this.direction);
                }
                CHitscanPacket.playGunSound((World)world, (PlayerEntity)serverHandler.field_147369_b, serverHandler.field_147369_b.func_233580_cy_());
            }
        }
    }
}

