/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.network.play.client;

import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.core.ModernLifeCommon;
import com.dairymoose.modernlife.core.ModernLifeConfig;
import com.dairymoose.modernlife.core.ModernLifeNetwork;
import com.dairymoose.modernlife.network.play.client.SMultipartCanvasPacket;
import com.dairymoose.modernlife.util.CanvasData;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import javax.imageio.ImageIO;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.IServerPlayNetHandler;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CMultipartCameraPacket
implements IPacket<IServerPlayNetHandler> {
    private int texSize;
    private int seqNo;
    private boolean last;
    private byte[] image;
    private static final Logger LOGGER = LogManager.getLogger();
    private static long lastPacketTimestamp = 0L;
    private static int incomingPacketCounter = 0;
    private static long reenableCamera = 0L;
    private boolean provideInstantCanvas = false;
    private static Map<PlayerEntity, List<CMultipartCameraPacket>> cameraPackets = new HashMap<PlayerEntity, List<CMultipartCameraPacket>>();
    private static ReentrantLock pngMutex = new ReentrantLock();

    public static int MAX_IMAGE_LENGTH(int textureSize) {
        return textureSize * textureSize * 3;
    }

    public CMultipartCameraPacket() {
    }

    public CMultipartCameraPacket(int seqNo, boolean last, byte[] image, int texSize) {
        this.seqNo = seqNo;
        this.last = last;
        this.image = image;
        this.texSize = texSize;
    }

    public CMultipartCameraPacket(PacketBuffer buffer) {
        this.func_148837_a(buffer);
    }

    public void func_148837_a(PacketBuffer buffer) {
        this.seqNo = buffer.readInt();
        this.last = buffer.readBoolean();
        this.image = buffer.func_179251_a();
        this.texSize = buffer.readInt();
    }

    public void func_148840_b(PacketBuffer buffer) {
        buffer.writeInt(this.seqNo);
        buffer.writeBoolean(this.last);
        buffer.func_179250_a(this.image);
        buffer.writeInt(this.texSize);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity sender = ((NetworkEvent.Context)ctx.get()).getSender();
            this.handle((IServerPlayNetHandler)((NetworkEvent.Context)ctx.get()).getNetworkManager().func_150729_e());
        });
        ctx.get().setPacketHandled(true);
    }

    private CMultipartCameraPacket getLastPacket(List<CMultipartCameraPacket> packets) {
        for (CMultipartCameraPacket packet : packets) {
            if (!packet.last) continue;
            return packet;
        }
        return null;
    }

    public static void pushImageUpdate(long uniqueId, ServerPlayerEntity player) {
        int MAX_IMAGE_PART = 30000;
        PngSizeHolder sizeHolder = new PngSizeHolder();
        byte[] compressed = CMultipartCameraPacket.loadPng(uniqueId, sizeHolder);
        if (compressed != null) {
            ArrayList<byte[]> parts = new ArrayList<byte[]>();
            int i = 0;
            while ((double)i < Math.ceil((float)compressed.length / (float)MAX_IMAGE_PART)) {
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                int startIndex = i * MAX_IMAGE_PART;
                int bytesToWrite = Math.min(compressed.length - startIndex, MAX_IMAGE_PART);
                stream.write(compressed, startIndex, bytesToWrite);
                byte[] part = stream.toByteArray();
                parts.add(part);
                ++i;
            }
            int series = SMultipartCanvasPacket.seriesCounter.incrementAndGet();
            for (int i2 = 0; i2 < parts.size(); ++i2) {
                int seqNo = i2 + 1;
                boolean last = false;
                if (seqNo == parts.size()) {
                    last = true;
                }
                PacketDistributor.PacketTarget target = PacketDistributor.ALL.noArg();
                if (player != null) {
                    target = PacketDistributor.PLAYER.with(() -> player);
                }
                ModernLifeNetwork.INSTANCE.send(target, (Object)new SMultipartCanvasPacket(series, uniqueId, seqNo, last, (byte[])parts.get(i2), sizeHolder.width, new BlockPos(1, 1, 1)));
            }
        } else {
            LOGGER.error("Failed to get updateTag png for ID=" + uniqueId);
        }
    }

    public static void pushImageUpdate(ItemStack itemStack) {
        if (itemStack.func_77978_p() != null && itemStack.func_77978_p().func_74764_b("UniqueId")) {
            long uniqueId = itemStack.func_77978_p().func_74763_f("UniqueId");
            int texSize = 64;
            if (itemStack.func_77978_p() != null && itemStack.func_77978_p().func_74764_b("TextureSize")) {
                texSize = itemStack.func_77978_p().func_74762_e("TextureSize");
            }
            CMultipartCameraPacket.pushImageUpdate(uniqueId, null);
        }
    }

    public static String getSubFolderPrepend() {
        String folderName = null;
        folderName = SMultipartCanvasPacket.getFolderPath();
        String subFolder = "";
        if (folderName != null && !(subFolder = folderName).endsWith("/")) {
            subFolder = subFolder + "/";
        }
        return subFolder;
    }

    private static void addTextEntry(IIOMetadata metadata, String key, String value) throws IIOInvalidTreeException {
        IIOMetadataNode textEntry = new IIOMetadataNode("TextEntry");
        textEntry.setAttribute("keyword", key);
        textEntry.setAttribute("value", value);
        IIOMetadataNode text = new IIOMetadataNode("Text");
        text.appendChild(textEntry);
        IIOMetadataNode root = new IIOMetadataNode("javax_imageio_1.0");
        root.appendChild(text);
        metadata.mergeTree("javax_imageio_1.0", root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void savePng(long uniqueId, byte[] stitchedImage, int texSize) {
        BufferedImage bufferedImage = new BufferedImage(texSize, texSize, 1);
        CanvasData canvasData = new CanvasData();
        canvasData.setTextureSize(texSize);
        canvasData.fromCompressedNbt(stitchedImage);
        for (int x = 0; x < texSize; ++x) {
            for (int y = 0; y < texSize; ++y) {
                int rgbPixel = canvasData.getRgbPixel(x, y);
                bufferedImage.setRGB(x, y, rgbPixel);
            }
        }
        String subFolder = CMultipartCameraPacket.getSubFolderPrepend();
        LOGGER.debug("save to: " + subFolder);
        File outputFile = new File(subFolder + "canvas" + uniqueId + ".png");
        try {
            pngMutex.lock();
            ImageIO.write((RenderedImage)bufferedImage, "png", outputFile);
        }
        catch (IOException e) {
            LOGGER.error("Error saving stitched image to disk with ID=" + uniqueId, (Throwable)e);
        }
        finally {
            pngMutex.unlock();
        }
    }

    public static boolean deletePng(long uniqueId) {
        String subFolder = CMultipartCameraPacket.getSubFolderPrepend();
        File inputFile = new File(subFolder + "canvas" + uniqueId + ".png");
        if (inputFile.exists()) {
            return inputFile.delete();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadPng(long uniqueId, PngSizeHolder sizeHolder) {
        if (sizeHolder == null) {
            return null;
        }
        String subFolder = CMultipartCameraPacket.getSubFolderPrepend();
        File inputFile = new File(subFolder + "canvas" + uniqueId + ".png");
        Object lock = null;
        BufferedImage image = null;
        if (inputFile.exists()) {
            try {
                pngMutex.lock();
                image = ImageIO.read(inputFile);
            }
            catch (IOException e) {
                LOGGER.error("Error reading saved png from disk with ID=" + uniqueId);
            }
            finally {
                pngMutex.unlock();
            }
        } else {
            LOGGER.error("Canvas png did not exist for unique ID=" + uniqueId);
        }
        if (image != null) {
            sizeHolder.width = image.getWidth();
            sizeHolder.height = image.getWidth();
            return CMultipartCameraPacket.toCanvasDataFromPng(image);
        }
        return null;
    }

    public static byte[] toCanvasDataFromPng(BufferedImage bufferedImage) {
        if (bufferedImage == null) {
            LOGGER.error("bufferedImage was null");
            return null;
        }
        if (bufferedImage.getWidth() != bufferedImage.getHeight()) {
            LOGGER.error("Unexpected image size");
            return null;
        }
        int maxVal = 2048;
        Integer configInt = (Integer)ModernLifeConfig.SERVER.maxImageSizePixels.get();
        if (configInt != null) {
            maxVal = configInt;
        }
        if (bufferedImage.getWidth() > maxVal || bufferedImage.getHeight() > maxVal) {
            LOGGER.error("Image dimensions are too large");
            return null;
        }
        CanvasData canvasData = new CanvasData();
        canvasData.setTextureSize(bufferedImage.getWidth());
        canvasData.initImage();
        LOGGER.debug("width = " + bufferedImage.getWidth());
        LOGGER.debug("height = " + bufferedImage.getHeight());
        LOGGER.debug("type = " + bufferedImage.getType());
        for (int x = 0; x < bufferedImage.getWidth(); ++x) {
            for (int y = 0; y < bufferedImage.getHeight(); ++y) {
                int rgb = bufferedImage.getRGB(x, y);
                canvasData.setRgbPixel(x, y, rgb);
            }
        }
        return canvasData.toCompressedNbt();
    }

    public void handle(IServerPlayNetHandler p_148833_1_) {
        LOGGER.debug("Handle CMultipartCameraPacket");
        if (p_148833_1_ instanceof ServerPlayNetHandler) {
            ServerPlayNetHandler serverHandler = (ServerPlayNetHandler)p_148833_1_;
            CompoundNBT nbt = new CompoundNBT();
            ServerWorld world = serverHandler.field_147369_b.func_71121_q();
            LOGGER.debug("world = " + world);
            if (world != null) {
                List<CMultipartCameraPacket> packets = cameraPackets.get(serverHandler.field_147369_b);
                if (packets == null) {
                    packets = new ArrayList<CMultipartCameraPacket>();
                    cameraPackets.put((PlayerEntity)serverHandler.field_147369_b, packets);
                }
                packets.add(this);
                CMultipartCameraPacket lastPacket = this.getLastPacket(packets);
                byte[] stitchedImage = null;
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                if (lastPacket != null && packets.size() == lastPacket.seqNo) {
                    packets.sort(new Comparator<CMultipartCameraPacket>(){

                        @Override
                        public int compare(CMultipartCameraPacket var1, CMultipartCameraPacket var2) {
                            return var1.seqNo - var2.seqNo;
                        }
                    });
                    for (CMultipartCameraPacket packet : packets) {
                        try {
                            stream.write(packet.image);
                        }
                        catch (IOException e) {
                            LOGGER.debug("error writing image part", (Throwable)e);
                        }
                    }
                    stitchedImage = stream.toByteArray();
                }
                if (stitchedImage != null) {
                    LOGGER.debug("image length = " + stitchedImage.length);
                }
                int maxTexSize = 512;
                Integer configInt = (Integer)ModernLifeConfig.COMMON.cameraResolution.get();
                if (configInt != null) {
                    maxTexSize = configInt;
                }
                if (stitchedImage != null && stitchedImage.length != 0 && stitchedImage.length <= CMultipartCameraPacket.MAX_IMAGE_LENGTH(maxTexSize) && this.texSize <= maxTexSize) {
                    packets.clear();
                    long currentTimestamp = System.currentTimeMillis();
                    long timeDiff = currentTimestamp - lastPacketTimestamp;
                    long timeDiffReenableCamera = currentTimestamp - reenableCamera;
                    if (timeDiffReenableCamera >= 0L) {
                        if (this.provideInstantCanvas) {
                            ItemStack itemStack = new ItemStack(new IItemProvider(){

                                public Item func_199767_j() {
                                    return CustomBlocks.ITEM_CANVAS;
                                }
                            });
                            long uniqueId = ModernLifeCommon.getNextCanvasId();
                            itemStack.func_196082_o().func_74772_a("UniqueId", uniqueId);
                            CMultipartCameraPacket.savePng(uniqueId, stitchedImage, this.texSize);
                            if (this.texSize > 0) {
                                itemStack.func_77978_p().func_74768_a("TextureSize", this.texSize);
                            }
                            serverHandler.field_147369_b.func_191521_c(itemStack);
                        } else {
                            ItemStack itemStack = serverHandler.field_147369_b.func_184614_ca();
                            if (itemStack.func_77973_b() == CustomBlocks.ITEM_CAMERA && itemStack.func_77952_i() < itemStack.func_77958_k()) {
                                INBT imageListNbt = itemStack.func_196082_o().func_74781_a("ImageList");
                                ListNBT imageList = null;
                                imageList = imageListNbt instanceof ListNBT ? (ListNBT)imageListNbt : new ListNBT();
                                CompoundNBT imageNbt = new CompoundNBT();
                                long uniqueId = ModernLifeCommon.getNextCanvasId();
                                CMultipartCameraPacket.savePng(uniqueId, stitchedImage, this.texSize);
                                imageNbt.func_74772_a("UniqueId", uniqueId);
                                imageList.add((Object)imageNbt);
                                itemStack.func_196082_o().func_218657_a("ImageList", (INBT)imageList);
                                if (this.texSize > 0) {
                                    itemStack.func_77978_p().func_74768_a("TextureSize", this.texSize);
                                }
                                itemStack.func_96631_a(1, new Random(), null);
                                CMultipartCameraPacket.pushImageUpdate(uniqueId, serverHandler.field_147369_b);
                            }
                        }
                    }
                } else if (stitchedImage != null) {
                    packets.clear();
                    LOGGER.error("incoming image (" + this.texSize + "/" + maxTexSize + ") is too big: " + stitchedImage.length + "/" + CMultipartCameraPacket.MAX_IMAGE_LENGTH(maxTexSize));
                }
            }
        }
    }

    public byte[] getImage() {
        return this.image;
    }

    public static class PngSizeHolder {
        public int width;
        public int height;
    }
}

