/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.network.play.client;

import com.dairymoose.modernlife.blocks.EaselBlock;
import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.core.ModernLifeCommon;
import com.dairymoose.modernlife.core.ModernLifeConfig;
import com.dairymoose.modernlife.network.play.client.CMultipartCameraPacket;
import com.dairymoose.modernlife.tileentities.EaselTileEntity;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.IServerPlayNetHandler;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CMultipartEaselPacket
implements IPacket<IServerPlayNetHandler> {
    private int seqNo;
    private boolean last;
    private byte[] image;
    private int texSize;
    private BlockPos easelPos;
    private static final Logger LOGGER = LogManager.getLogger();
    private static Map<PlayerEntity, List<CMultipartEaselPacket>> canvasPackets = new HashMap<PlayerEntity, List<CMultipartEaselPacket>>();

    public CMultipartEaselPacket() {
    }

    public CMultipartEaselPacket(int seqNo, boolean last, byte[] image, int texSize, BlockPos easelPos) {
        this.seqNo = seqNo;
        this.last = last;
        this.image = image;
        this.texSize = texSize;
        this.easelPos = easelPos;
    }

    public CMultipartEaselPacket(PacketBuffer buffer) {
        this.func_148837_a(buffer);
    }

    public void func_148837_a(PacketBuffer buffer) {
        this.seqNo = buffer.readInt();
        this.last = buffer.readBoolean();
        this.image = buffer.func_179251_a();
        this.texSize = buffer.readInt();
        this.easelPos = buffer.func_179259_c();
    }

    public void func_148840_b(PacketBuffer buffer) {
        buffer.writeInt(this.seqNo);
        buffer.writeBoolean(this.last);
        buffer.func_179250_a(this.image);
        buffer.writeInt(this.texSize);
        buffer.func_179255_a(this.easelPos);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity sender = ((NetworkEvent.Context)ctx.get()).getSender();
            this.handle((IServerPlayNetHandler)((NetworkEvent.Context)ctx.get()).getNetworkManager().func_150729_e());
        });
        ctx.get().setPacketHandled(true);
    }

    private CMultipartEaselPacket getLastPacket(List<CMultipartEaselPacket> packets) {
        for (CMultipartEaselPacket packet : packets) {
            if (!packet.last) continue;
            return packet;
        }
        return null;
    }

    public void handle(IServerPlayNetHandler p_148833_1_) {
        LOGGER.debug("Handle CMultipartCanvasPacket");
        if (this.easelPos == null) {
            return;
        }
        if (p_148833_1_ instanceof ServerPlayNetHandler) {
            ServerPlayNetHandler serverHandler = (ServerPlayNetHandler)p_148833_1_;
            CompoundNBT nbt = new CompoundNBT();
            ServerWorld world = serverHandler.field_147369_b.func_71121_q();
            LOGGER.debug("world = " + world);
            if (world != null && world.func_195588_v(this.easelPos)) {
                BlockState easelState = world.func_180495_p(this.easelPos);
                LOGGER.debug("easelState = " + easelState);
                if (easelState != null && easelState.func_203425_a((Block)CustomBlocks.BLOCK_EASEL) && !((Boolean)easelState.func_177229_b((Property)EaselBlock.EMPTY)).booleanValue()) {
                    List<CMultipartEaselPacket> packets = canvasPackets.get(serverHandler.field_147369_b);
                    if (packets == null) {
                        packets = new ArrayList<CMultipartEaselPacket>();
                        canvasPackets.put((PlayerEntity)serverHandler.field_147369_b, packets);
                    }
                    packets.add(this);
                    CMultipartEaselPacket lastPacket = this.getLastPacket(packets);
                    byte[] stitchedImage = null;
                    ByteArrayOutputStream stream = new ByteArrayOutputStream();
                    LOGGER.debug("packets.size = " + packets.size() + ", lastPacket = " + lastPacket);
                    if (lastPacket != null && packets.size() == lastPacket.seqNo) {
                        packets.sort(new Comparator<CMultipartEaselPacket>(){

                            @Override
                            public int compare(CMultipartEaselPacket var1, CMultipartEaselPacket var2) {
                                return var1.seqNo - var2.seqNo;
                            }
                        });
                        for (CMultipartEaselPacket packet : packets) {
                            try {
                                stream.write(packet.image);
                            }
                            catch (IOException e) {
                                LOGGER.debug("error writing image part", (Throwable)e);
                            }
                        }
                        stitchedImage = stream.toByteArray();
                    }
                    if (stitchedImage != null) {
                        LOGGER.debug("image length = " + stitchedImage.length);
                    }
                    int maxTexSize = 512;
                    Integer configInt = (Integer)ModernLifeConfig.COMMON.cameraResolution.get();
                    if (configInt != null) {
                        maxTexSize = configInt;
                    }
                    if (stitchedImage != null && stitchedImage.length != 0 && stitchedImage.length <= CMultipartCameraPacket.MAX_IMAGE_LENGTH(maxTexSize) && this.texSize <= maxTexSize) {
                        packets.clear();
                        LOGGER.debug("easelPos = " + this.easelPos);
                        TileEntity tileEntity = world.func_175726_f(this.easelPos).func_175625_s(this.easelPos);
                        LOGGER.debug("tileEntity = " + tileEntity);
                        if (tileEntity instanceof EaselTileEntity) {
                            EaselTileEntity easelTileEntity = (EaselTileEntity)tileEntity;
                            ItemStack currentItem = easelTileEntity.func_70301_a(0).func_77946_l();
                            if (easelTileEntity != null) {
                                world.func_175656_a(this.easelPos, (BlockState)easelState.func_206870_a((Property)EaselBlock.EMPTY, (Comparable)Boolean.valueOf(true)));
                                int texSize = 64;
                                if (this.texSize > 0) {
                                    texSize = this.texSize;
                                }
                                ItemStack itemStack = currentItem;
                                long uniqueId = 0L;
                                if (itemStack.func_77978_p() != null && itemStack.func_77978_p().func_74764_b("UniqueId")) {
                                    uniqueId = itemStack.func_77978_p().func_74763_f("UniqueId");
                                }
                                if (itemStack.func_77978_p() != null && itemStack.func_77978_p().func_74764_b("TextureSize")) {
                                    texSize = itemStack.func_77978_p().func_74762_e("TextureSize");
                                }
                                if (uniqueId == 0L) {
                                    uniqueId = ModernLifeCommon.getNextCanvasId();
                                }
                                CMultipartCameraPacket.savePng(uniqueId, stitchedImage, texSize);
                                itemStack.func_196082_o().func_74772_a("UniqueId", uniqueId);
                                itemStack.func_196082_o().func_74772_a("TextureSize", (long)texSize);
                                serverHandler.field_147369_b.func_191521_c(itemStack);
                                easelTileEntity.func_70299_a(0, ItemStack.field_190927_a);
                                CMultipartCameraPacket.pushImageUpdate(itemStack);
                            }
                        }
                    } else if (stitchedImage != null) {
                        packets.clear();
                        LOGGER.error("incoming image (" + this.texSize + "/" + maxTexSize + ") is too big: " + stitchedImage.length + "/" + CMultipartCameraPacket.MAX_IMAGE_LENGTH(maxTexSize));
                    }
                }
            }
        }
    }

    public byte[] getImage() {
        return this.image;
    }
}

