/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.network.play.client;

import com.dairymoose.modernlife.blocks.CanvasBlock;
import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.tileentities.PrinterTileEntity;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.IServerPlayNetHandler;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CPrintSizePacket
implements IPacket<IServerPlayNetHandler> {
    private static final Logger LOGGER = LogManager.getLogger();
    private int printSize = 0;
    private BlockPos pos;

    public CPrintSizePacket() {
    }

    public CPrintSizePacket(int printSize, BlockPos pos) {
        this.printSize = printSize;
        this.pos = pos;
    }

    public CPrintSizePacket(PacketBuffer buffer) {
        this.func_148837_a(buffer);
    }

    public void func_148837_a(PacketBuffer buffer) {
        this.printSize = buffer.readInt();
        this.pos = buffer.func_179259_c();
    }

    public void func_148840_b(PacketBuffer buffer) {
        buffer.writeInt(this.printSize);
        buffer.func_179255_a(this.pos);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity sender = ((NetworkEvent.Context)ctx.get()).getSender();
            this.handle((IServerPlayNetHandler)((NetworkEvent.Context)ctx.get()).getNetworkManager().func_150729_e());
        });
        ctx.get().setPacketHandled(true);
    }

    public void handle(IServerPlayNetHandler p_148833_1_) {
        LOGGER.debug("Handle CPrintSizePacket");
        if (this.printSize <= 0 || this.printSize > CanvasBlock.MAX_SIZE) {
            return;
        }
        if (p_148833_1_ instanceof ServerPlayNetHandler) {
            ServerPlayNetHandler handler = (ServerPlayNetHandler)p_148833_1_;
            LOGGER.debug("check camera");
            ServerPlayerEntity player = handler.field_147369_b;
            ItemStack itemStack = handler.field_147369_b.func_184614_ca();
            if (itemStack.func_77973_b() == CustomBlocks.ITEM_CAMERA) {
                INBT imageListNbt = itemStack.func_77978_p().func_74781_a("ImageList");
                ListNBT imageList = null;
                if (imageListNbt instanceof ListNBT && (imageList = (ListNBT)imageListNbt) != null) {
                    int printedPhotoCount = 0;
                    if (!player.field_70170_p.func_195588_v(this.pos)) {
                        return;
                    }
                    TileEntity tileEntity = player.field_70170_p.func_175625_s(this.pos);
                    if (tileEntity instanceof PrinterTileEntity) {
                        PrinterTileEntity printer;
                        BlockState blockState = player.field_70170_p.func_180495_p(this.pos);
                        INamedContainerProvider containerProvider = CustomBlocks.BLOCK_PRINTER.func_220052_b(blockState, player.field_70170_p, this.pos);
                        if (containerProvider != null) {
                            player.func_213829_a(containerProvider);
                        }
                        if ((printer = (PrinterTileEntity)tileEntity).freeSlotCount() != 0) {
                            for (int i = 0; i < imageList.size(); ++i) {
                                CompoundNBT nbt;
                                INBT iNbt = imageList.get(i);
                                if (!(iNbt instanceof CompoundNBT) || !(nbt = (CompoundNBT)iNbt).func_74764_b("UniqueId")) continue;
                                int free = printer.getFirstFreeSlot();
                                if (free == -1) break;
                                imageList.remove(i);
                                --i;
                                long uniqueId = nbt.func_74763_f("UniqueId");
                                itemStack.func_196085_b(itemStack.func_77952_i() - 1);
                                ItemStack newItemStack = new ItemStack(new IItemProvider(){

                                    public Item func_199767_j() {
                                        return CustomBlocks.ITEM_CANVAS;
                                    }
                                });
                                newItemStack.func_196082_o().func_74772_a("UniqueId", uniqueId);
                                if (itemStack.func_77978_p().func_74764_b("TextureSize")) {
                                    newItemStack.func_77978_p().func_74768_a("TextureSize", itemStack.func_77978_p().func_74762_e("TextureSize"));
                                }
                                newItemStack.func_77978_p().func_74768_a("Size", this.printSize);
                                newItemStack.func_200302_a((ITextComponent)new StringTextComponent("Photograph"));
                                printer.func_70299_a(free, newItemStack);
                                ++printedPhotoCount;
                            }
                            if (printedPhotoCount > 0) {
                                String photosText = "photos";
                                if (printedPhotoCount == 1) {
                                    photosText = "photo";
                                }
                                player.func_145747_a((ITextComponent)new StringTextComponent("Printed " + String.valueOf(printedPhotoCount) + " " + photosText), player.func_110124_au());
                            }
                        } else if (imageList.size() > 0) {
                            player.func_145747_a((ITextComponent)new StringTextComponent("Printer tray is full!  Clear some space to print your photos"), player.func_110124_au());
                        }
                    }
                }
                LOGGER.debug("finished checking camera");
            } else if (itemStack.func_77973_b() == CustomBlocks.ITEM_CANVAS) {
                itemStack.func_196082_o().func_74768_a("Size", this.printSize);
            }
        }
    }
}

