/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.network.play.client;

import com.dairymoose.modernlife.blocks.RadiatorBlock;
import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.tileentities.RadiatorTileEntity;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.IServerPlayNetHandler;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CRadiatorPacket
implements IPacket<IServerPlayNetHandler> {
    private RadiatorBlock.HeatType heatType;
    private BlockPos radiatorPos;
    private static final Logger LOGGER = LogManager.getLogger();

    public CRadiatorPacket() {
    }

    public CRadiatorPacket(RadiatorBlock.HeatType heatType, BlockPos easelPos) {
        this.heatType = heatType;
        this.radiatorPos = easelPos;
    }

    public CRadiatorPacket(PacketBuffer buffer) {
        this.func_148837_a(buffer);
    }

    public void func_148837_a(PacketBuffer buffer) {
        this.heatType = (RadiatorBlock.HeatType)buffer.func_179257_a(RadiatorBlock.HeatType.class);
        this.radiatorPos = buffer.func_179259_c();
    }

    public void func_148840_b(PacketBuffer buffer) {
        buffer.func_179249_a((Enum)this.heatType);
        buffer.func_179255_a(this.radiatorPos);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity sender = ((NetworkEvent.Context)ctx.get()).getSender();
            this.handle((IServerPlayNetHandler)((NetworkEvent.Context)ctx.get()).getNetworkManager().func_150729_e());
        });
        ctx.get().setPacketHandled(true);
    }

    public void handle(IServerPlayNetHandler p_148833_1_) {
        LOGGER.debug("Handle CRadiatorPacket");
        if (this.radiatorPos == null) {
            return;
        }
        if (p_148833_1_ instanceof ServerPlayNetHandler) {
            RadiatorTileEntity radiatorTileEntity;
            TileEntity tileEntity;
            BlockState radiatorState;
            ServerPlayNetHandler serverHandler = (ServerPlayNetHandler)p_148833_1_;
            CompoundNBT nbt = new CompoundNBT();
            ServerWorld world = serverHandler.field_147369_b.func_71121_q();
            if (world != null && world.func_195588_v(this.radiatorPos) && (radiatorState = world.func_180495_p(this.radiatorPos)) != null && radiatorState.func_203425_a((Block)CustomBlocks.BLOCK_RADIATOR) && (tileEntity = world.func_175726_f(this.radiatorPos).func_175625_s(this.radiatorPos)) instanceof RadiatorTileEntity && (radiatorTileEntity = (RadiatorTileEntity)tileEntity) != null) {
                world.func_175656_a(this.radiatorPos, (BlockState)radiatorState.func_206870_a(RadiatorBlock.HEAT, (Comparable)((Object)this.heatType)));
            }
        }
    }
}

