/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.network.play.client;

import com.dairymoose.modernlife.network.play.client.CMultipartCameraPacket;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.IServerPlayNetHandler;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CRequestCanvasPacket
implements IPacket<IServerPlayNetHandler> {
    private long uniqueId;
    private static final Logger LOGGER = LogManager.getLogger();
    private static Map<PlayerEntity, Map<Long, RequestInfo>> requestTimestamps = new HashMap<PlayerEntity, Map<Long, RequestInfo>>();

    public CRequestCanvasPacket() {
    }

    public CRequestCanvasPacket(PacketBuffer buffer) {
        this.func_148837_a(buffer);
    }

    public CRequestCanvasPacket(long uniqueId) {
        this.uniqueId = uniqueId;
    }

    public void func_148837_a(PacketBuffer packet) {
        this.uniqueId = packet.readLong();
    }

    public void func_148840_b(PacketBuffer packet) {
        packet.writeLong(this.uniqueId);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity sender = ((NetworkEvent.Context)ctx.get()).getSender();
            this.handle((IServerPlayNetHandler)((NetworkEvent.Context)ctx.get()).getNetworkManager().func_150729_e());
        });
        ctx.get().setPacketHandled(true);
    }

    public void handle(IServerPlayNetHandler p_148833_1_) {
        LOGGER.debug("Handle CRequestCanvasPacket");
        if (this.uniqueId <= 0L) {
            return;
        }
        if (p_148833_1_ instanceof ServerPlayNetHandler) {
            ServerPlayNetHandler serverHandler = (ServerPlayNetHandler)p_148833_1_;
            long currentTime = System.currentTimeMillis();
            long timestamp = 0L;
            Map<Long, RequestInfo> requestMap = requestTimestamps.get(serverHandler.field_147369_b);
            if (requestMap != null) {
                RequestInfo requestInfo = requestMap.get(this.uniqueId);
                if (requestInfo != null) {
                    timestamp = requestInfo.timestamp;
                }
            } else {
                requestMap = new HashMap<Long, RequestInfo>();
            }
            long timeDiff = currentTime - timestamp;
            if (timeDiff >= 30000L) {
                RequestInfo requestInfo = new RequestInfo();
                requestInfo.timestamp = currentTime;
                requestMap.put(this.uniqueId, requestInfo);
                requestTimestamps.put((PlayerEntity)serverHandler.field_147369_b, requestMap);
                CMultipartCameraPacket.pushImageUpdate(this.uniqueId, serverHandler.field_147369_b);
                LOGGER.debug("sent reply to canvas request");
            }
        }
    }

    private static class RequestInfo {
        long timestamp;

        private RequestInfo() {
        }
    }
}

