/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.network.play.client;

import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.tileentities.IChannelHolder;
import com.dairymoose.modernlife.tileentities.PowerReceiverTileEntity;
import com.dairymoose.modernlife.tileentities.PowerTransmitterTileEntity;
import java.util.ArrayList;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.IServerPlayNetHandler;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CWirelessChannelPacket
implements IPacket<IServerPlayNetHandler> {
    private int newChannel;
    private BlockPos wirelessBlockPos;
    private static final Logger LOGGER = LogManager.getLogger();

    public CWirelessChannelPacket() {
    }

    public CWirelessChannelPacket(PacketBuffer buffer) {
        this.func_148837_a(buffer);
    }

    public CWirelessChannelPacket(int newChannel, BlockPos wirelessBlockPos) {
        this.newChannel = newChannel;
        this.wirelessBlockPos = wirelessBlockPos;
    }

    public void func_148837_a(PacketBuffer p_148837_1_) {
        this.newChannel = p_148837_1_.readInt();
        this.wirelessBlockPos = p_148837_1_.func_179259_c();
    }

    public void func_148840_b(PacketBuffer p_148840_1_) {
        p_148840_1_.writeInt(this.newChannel);
        p_148840_1_.func_179255_a(this.wirelessBlockPos);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity sender = ((NetworkEvent.Context)ctx.get()).getSender();
            this.handle((IServerPlayNetHandler)((NetworkEvent.Context)ctx.get()).getNetworkManager().func_150729_e());
        });
        ctx.get().setPacketHandled(true);
    }

    public static <T extends TileEntity> void purgeRemovedChannelHolders(Set<T> data) {
        if (data == null) {
            return;
        }
        ArrayList<TileEntity> toRemove = new ArrayList<TileEntity>();
        for (TileEntity tileEntity : data) {
            if (!tileEntity.func_145837_r()) continue;
            toRemove.add(tileEntity);
        }
        for (TileEntity t : toRemove) {
            data.remove(t);
        }
    }

    public void handle(IServerPlayNetHandler p_148833_1_) {
        LOGGER.debug("Handle CWirelessChannelPacket");
        if (this.wirelessBlockPos == null) {
            return;
        }
        if (p_148833_1_ instanceof ServerPlayNetHandler) {
            ServerPlayNetHandler serverHandler = (ServerPlayNetHandler)p_148833_1_;
            CompoundNBT nbt = new CompoundNBT();
            ServerWorld world = serverHandler.field_147369_b.func_71121_q();
            LOGGER.debug("world = " + world);
            if (world != null && world.func_195588_v(this.wirelessBlockPos)) {
                BlockState wirelessBlockState = world.func_180495_p(this.wirelessBlockPos);
                LOGGER.debug("wirelessBlockState = " + wirelessBlockState);
                if (wirelessBlockState != null && (wirelessBlockState.func_203425_a(CustomBlocks.BLOCK_POWER_TRANSMITTER) || wirelessBlockState.func_203425_a(CustomBlocks.BLOCK_POWER_RECEIVER)) && this.newChannel >= 0 && this.newChannel <= 9999) {
                    IChannelHolder iChannelHolder;
                    LOGGER.debug("wirelessBlockPos = " + this.wirelessBlockPos);
                    TileEntity tileEntity = world.func_175726_f(this.wirelessBlockPos).func_175625_s(this.wirelessBlockPos);
                    LOGGER.debug("tileEntity = " + tileEntity);
                    if (tileEntity instanceof IChannelHolder && (iChannelHolder = (IChannelHolder)tileEntity) != null) {
                        iChannelHolder.setCurrentChannel(this.newChannel);
                        Set<PowerTransmitterTileEntity> transmitters = PowerTransmitterTileEntity.perChannelPowerTransmitters.get(this.newChannel);
                        int transmitterCount = 0;
                        if (transmitters != null) {
                            CWirelessChannelPacket.purgeRemovedChannelHolders(transmitters);
                            transmitterCount = transmitters.size();
                        }
                        Set<PowerReceiverTileEntity> receivers = PowerReceiverTileEntity.perChannelPowerReceivers.get(this.newChannel);
                        int receiverCount = 0;
                        if (receivers != null) {
                            CWirelessChannelPacket.purgeRemovedChannelHolders(receivers);
                            receiverCount = receivers.size();
                        }
                        String outputText = "Channel " + this.newChannel + " now has " + transmitterCount + " transmitters and " + receiverCount + " receivers";
                        serverHandler.field_147369_b.func_145747_a((ITextComponent)new StringTextComponent(outputText), serverHandler.field_147369_b.func_110124_au());
                        if (transmitters != null) {
                            for (PowerTransmitterTileEntity transmitterNow : transmitters) {
                                String trans = "t=" + transmitterNow;
                                LOGGER.debug(trans);
                            }
                        }
                        if (receivers != null) {
                            for (PowerReceiverTileEntity receiverNow : receivers) {
                                String recv = "r=" + receiverNow;
                                LOGGER.debug(recv);
                            }
                        }
                    }
                }
            }
        }
    }
}

