/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.network.play.client;

import com.dairymoose.modernlife.core.ModernLifeClient;
import com.dairymoose.modernlife.items.HandgunItem;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.network.play.IClientPlayNetHandler;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SBulletHolePacket
implements IPacket<IClientPlayNetHandler> {
    private int playerId;
    private double x;
    private double y;
    private double z;
    private BlockPos pos;
    private int holeNo;
    private Direction facing;
    private String dim;
    private static final Logger LOGGER = LogManager.getLogger();

    public SBulletHolePacket() {
    }

    public SBulletHolePacket(PacketBuffer buffer) {
        this.func_148837_a(buffer);
    }

    public SBulletHolePacket(int playerId, Vector3d vec, BlockPos pos, int holeNo, Direction facing, String dim) {
        this.playerId = playerId;
        this.x = vec.field_72450_a;
        this.y = vec.field_72448_b;
        this.z = vec.field_72449_c;
        this.pos = pos;
        this.holeNo = holeNo;
        this.facing = facing;
        this.dim = dim;
    }

    public void func_148837_a(PacketBuffer p_148837_1_) {
        this.playerId = p_148837_1_.readInt();
        this.x = p_148837_1_.readDouble();
        this.y = p_148837_1_.readDouble();
        this.z = p_148837_1_.readDouble();
        this.pos = p_148837_1_.func_179259_c();
        this.holeNo = p_148837_1_.readInt();
        this.facing = Direction.func_82600_a((int)p_148837_1_.readInt());
        this.dim = p_148837_1_.func_218666_n();
    }

    public void func_148840_b(PacketBuffer p_148840_1_) {
        p_148840_1_.writeInt(this.playerId);
        p_148840_1_.writeDouble(this.x);
        p_148840_1_.writeDouble(this.y);
        p_148840_1_.writeDouble(this.z);
        p_148840_1_.func_179255_a(this.pos);
        p_148840_1_.writeInt(this.holeNo);
        p_148840_1_.writeInt(this.facing.func_176745_a());
        p_148840_1_.func_180714_a(this.dim);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> this.handle((IClientPlayNetHandler)((NetworkEvent.Context)ctx.get()).getNetworkManager().func_150729_e()));
        ctx.get().setPacketHandled(true);
    }

    public void handle(final IClientPlayNetHandler handler) {
        LOGGER.debug("Handle SBulletHolePacket");
        if (handler instanceof ClientPlayNetHandler) {
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> new Runnable(){

                @Override
                public void run() {
                    PlayerEntity playerEntity;
                    ClientPlayNetHandler clientHandler = (ClientPlayNetHandler)handler;
                    ClientWorld world = clientHandler.func_195514_j();
                    Entity e = world.func_73045_a(SBulletHolePacket.this.playerId);
                    if (e instanceof PlayerEntity && (playerEntity = (PlayerEntity)e).func_145782_y() != Minecraft.func_71410_x().field_71439_g.func_145782_y()) {
                        HandgunItem.firingTickMap.put(playerEntity, 6);
                    }
                    ModernLifeClient.BulletHoleInfo bulletHole = new ModernLifeClient.BulletHoleInfo();
                    bulletHole.dim = SBulletHolePacket.this.dim;
                    bulletHole.facing = SBulletHolePacket.this.facing;
                    bulletHole.holeNo = SBulletHolePacket.this.holeNo;
                    bulletHole.loc = new Vector3d(SBulletHolePacket.this.x, SBulletHolePacket.this.y, SBulletHolePacket.this.z);
                    bulletHole.pos = SBulletHolePacket.this.pos;
                    bulletHole.timestamp = System.currentTimeMillis();
                    ModernLifeClient.bulletHoles.add(bulletHole);
                }
            });
        }
    }
}

