/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.network.play.client;

import com.dairymoose.modernlife.items.FlashlightItem;
import java.util.function.Supplier;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.network.play.IClientPlayNetHandler;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SFlashlightUpdatePacket
implements IPacket<IClientPlayNetHandler> {
    private int playerId;
    private boolean flashlightState;
    private static final Logger LOGGER = LogManager.getLogger();

    public SFlashlightUpdatePacket() {
    }

    public SFlashlightUpdatePacket(PacketBuffer buffer) {
        this.func_148837_a(buffer);
    }

    public SFlashlightUpdatePacket(int playerId, boolean flashlightState) {
        this.playerId = playerId;
        this.flashlightState = flashlightState;
    }

    public void func_148837_a(PacketBuffer p_148837_1_) {
        this.playerId = p_148837_1_.readInt();
        this.flashlightState = p_148837_1_.readBoolean();
    }

    public void func_148840_b(PacketBuffer p_148840_1_) {
        p_148840_1_.writeInt(this.playerId);
        p_148840_1_.writeBoolean(this.flashlightState);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> this.handle((IClientPlayNetHandler)((NetworkEvent.Context)ctx.get()).getNetworkManager().func_150729_e()));
        ctx.get().setPacketHandled(true);
    }

    public void handle(final IClientPlayNetHandler handler) {
        LOGGER.debug("Handle SFlashlightUpdatePacket");
        if (this.playerId < 0) {
            return;
        }
        if (handler instanceof ClientPlayNetHandler) {
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> new Runnable(){

                @Override
                public void run() {
                    ClientPlayNetHandler clientHandler = (ClientPlayNetHandler)handler;
                    ClientWorld world = clientHandler.func_195514_j();
                    Entity entity = world.func_73045_a(SFlashlightUpdatePacket.this.playerId);
                    if (entity instanceof PlayerEntity) {
                        PlayerEntity player = (PlayerEntity)entity;
                        FlashlightItem.usingFlashlight.put(player, SFlashlightUpdatePacket.this.flashlightState);
                    }
                }
            });
        }
    }
}

