/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.network.play.client;

import com.dairymoose.modernlife.core.ModernLifeClient;
import com.dairymoose.modernlife.core.ModernLifeCommon;
import com.dairymoose.modernlife.network.play.client.CMultipartCameraPacket;
import com.dairymoose.modernlife.network.play.client.ICanvasReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.play.IClientPlayNetHandler;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SMultipartCanvasPacket
implements IPacket<IClientPlayNetHandler> {
    private long uniqueId;
    private int texSize;
    private int seqNo;
    private int series;
    private boolean last;
    private byte[] image;
    private BlockPos pos;
    private static final Logger LOGGER = LogManager.getLogger();
    public static AtomicInteger seriesCounter = new AtomicInteger(0);
    private static Map<DualKey, List<SMultipartCanvasPacket>> cameraPackets = new ConcurrentHashMap<DualKey, List<SMultipartCanvasPacket>>();
    private static List<ICanvasReader> updateSubscribers = new CopyOnWriteArrayList<ICanvasReader>();
    private ScheduledExecutorService threadExecutor = Executors.newScheduledThreadPool(3);

    public static void subscribe(ICanvasReader reader) {
        if (reader != null) {
            updateSubscribers.add(reader);
        }
    }

    public static void unsubscribe(ICanvasReader reader) {
        if (reader != null) {
            updateSubscribers.remove(reader);
        }
    }

    public SMultipartCanvasPacket() {
    }

    public SMultipartCanvasPacket(int series, long uniqueId, int seqNo, boolean last, byte[] image, int texSize, BlockPos pos) {
        this.series = series;
        this.uniqueId = uniqueId;
        this.seqNo = seqNo;
        this.last = last;
        this.image = image;
        this.texSize = texSize;
        this.pos = pos;
    }

    public SMultipartCanvasPacket(PacketBuffer buffer) {
        this.func_148837_a(buffer);
    }

    public void func_148837_a(PacketBuffer buffer) {
        this.series = buffer.readInt();
        this.uniqueId = buffer.readLong();
        this.seqNo = buffer.readInt();
        this.last = buffer.readBoolean();
        this.image = buffer.func_179251_a();
        this.texSize = buffer.readInt();
    }

    public void func_148840_b(PacketBuffer buffer) {
        buffer.writeInt(this.series);
        buffer.writeLong(this.uniqueId);
        buffer.writeInt(this.seqNo);
        buffer.writeBoolean(this.last);
        buffer.func_179250_a(this.image);
        buffer.writeInt(this.texSize);
        buffer.func_179255_a(this.pos);
    }

    public void handle(final Supplier<NetworkEvent.Context> ctx) {
        final SMultipartCanvasPacket thisHandler = this;
        this.threadExecutor.execute(new Runnable(){

            @Override
            public void run() {
                thisHandler.handle((IClientPlayNetHandler)((NetworkEvent.Context)ctx.get()).getNetworkManager().func_150729_e());
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private SMultipartCanvasPacket getLastPacket(List<SMultipartCanvasPacket> packets) {
        for (SMultipartCanvasPacket packet : packets) {
            if (!packet.last) continue;
            return packet;
        }
        return null;
    }

    public static boolean ensureDirectory(String subDir) {
        if (StringUtils.isEmpty((CharSequence)subDir)) {
            return false;
        }
        String dir = subDir;
        File f = new File(dir);
        return f.mkdirs();
    }

    public static String getFolderPath() {
        String root = "";
        String folderName = null;
        String prefix = "";
        if (FMLEnvironment.dist == Dist.CLIENT) {
            prefix = "multiplayer/";
            if (Minecraft.func_71410_x().func_71356_B()) {
                prefix = "singleplayer/";
                folderName = Minecraft.func_71410_x().func_71401_C().func_240793_aU_().func_76065_j();
                LOGGER.debug("currentServer name: " + folderName);
            } else if (Minecraft.func_71410_x().func_147104_D() != null) {
                folderName = Minecraft.func_71410_x().func_147104_D().field_78847_a;
                if (StringUtils.isEmpty((CharSequence)(folderName = folderName.replaceAll("\\W+", "_").trim()).replaceAll("_", ""))) {
                    folderName = Minecraft.func_71410_x().func_147104_D().field_78845_b;
                }
                LOGGER.debug("getServer name: " + folderName);
            } else {
                folderName = "offline";
            }
        } else {
            folderName = "";
            if (ModernLifeCommon.serverWorldFolderName != null) {
                root = ModernLifeCommon.serverWorldFolderName;
            }
        }
        String path = root + "modernlife/" + prefix + folderName;
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        SMultipartCanvasPacket.ensureDirectory(path);
        return path;
    }

    public static synchronized void syncHandle(SMultipartCanvasPacket thisPacket, IClientPlayNetHandler p_148833_1_) {
        LOGGER.debug("Handle SMultipartCanvasPacket for series = " + thisPacket.series + " with unique ID = " + thisPacket.uniqueId);
        DualKey dk = new DualKey(Minecraft.func_71410_x().field_71439_g, thisPacket.series);
        List<SMultipartCanvasPacket> packets = cameraPackets.get(dk);
        if (packets == null) {
            packets = new ArrayList<SMultipartCanvasPacket>();
            cameraPackets.put(dk, packets);
        }
        packets.add(thisPacket);
        SMultipartCanvasPacket lastPacket = thisPacket.getLastPacket(packets);
        byte[] stitchedImage = null;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        if (lastPacket != null && packets.size() == lastPacket.seqNo) {
            packets.sort(new Comparator<SMultipartCanvasPacket>(){

                @Override
                public int compare(SMultipartCanvasPacket var1, SMultipartCanvasPacket var2) {
                    return var1.seqNo - var2.seqNo;
                }
            });
            for (SMultipartCanvasPacket packet : packets) {
                try {
                    stream.write(packet.image);
                }
                catch (IOException e) {
                    LOGGER.debug("error writing image part", (Throwable)e);
                }
            }
            stitchedImage = stream.toByteArray();
        }
        if (stitchedImage != null) {
            LOGGER.debug("image length = " + stitchedImage.length + " for series = " + thisPacket.series);
        }
        if (stitchedImage != null && stitchedImage.length != 0) {
            packets.clear();
            LOGGER.debug("Got image update with ID = " + thisPacket.uniqueId);
            CMultipartCameraPacket.savePng(thisPacket.uniqueId, stitchedImage, thisPacket.texSize);
            ModernLifeClient.putCachedData(System.currentTimeMillis(), thisPacket.uniqueId, stitchedImage, thisPacket.texSize);
            for (ICanvasReader reader : updateSubscribers) {
                reader.onUpdate(thisPacket.uniqueId);
            }
        } else if (stitchedImage != null) {
            packets.clear();
            LOGGER.debug("incoming image is too big");
        }
    }

    public void handle(IClientPlayNetHandler p_148833_1_) {
        SMultipartCanvasPacket.syncHandle(this, p_148833_1_);
    }

    public byte[] getImage() {
        return this.image;
    }

    private static class DualKey {
        public PlayerEntity player;
        public int series;

        public DualKey(Object player, int series) {
            this.player = (PlayerEntity)player;
            this.series = series;
        }

        public int hashCode() {
            return 31 + 7 * this.player.hashCode() + 11 * Integer.hashCode(this.series);
        }

        public boolean equals(Object var1) {
            if (var1 instanceof DualKey) {
                if (this.player != ((DualKey)var1).player) {
                    return false;
                }
                return this.series == ((DualKey)var1).series;
            }
            return false;
        }
    }
}

