/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.renderer.tileentity;

import com.dairymoose.modernlife.blocks.CanvasBlock;
import com.dairymoose.modernlife.tileentities.CanvasTileEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class CanvasTileEntityRenderer
extends TileEntityRenderer<CanvasTileEntity> {
    private static final Logger LOGGER = LogManager.getLogger();

    public CanvasTileEntityRenderer(TileEntityRendererDispatcher p_i226002_1_) {
        super(p_i226002_1_);
    }

    public void render(CanvasTileEntity tileEntity, float v, MatrixStack matrixStack, IRenderTypeBuffer iRenderTypeBuffer, int lightmap, int i1) {
        switch ((Direction)tileEntity.func_195044_w().func_177229_b((Property)CanvasBlock.FACING)) {
            case EAST: {
                if (Minecraft.func_71410_x().field_71439_g.func_233580_cy_().func_177958_n() >= tileEntity.func_174877_v().func_177958_n()) break;
                return;
            }
            case WEST: {
                if (Minecraft.func_71410_x().field_71439_g.func_233580_cy_().func_177958_n() <= tileEntity.func_174877_v().func_177958_n()) break;
                return;
            }
            case NORTH: {
                if (Minecraft.func_71410_x().field_71439_g.func_233580_cy_().func_177952_p() <= tileEntity.func_174877_v().func_177952_p()) break;
                return;
            }
            case SOUTH: {
                if (Minecraft.func_71410_x().field_71439_g.func_233580_cy_().func_177952_p() >= tileEntity.func_174877_v().func_177952_p()) break;
                return;
            }
        }
        tileEntity.initImage();
        matrixStack.func_227860_a_();
        switch ((Direction)tileEntity.func_195044_w().func_177229_b((Property)CanvasBlock.FACING)) {
            case EAST: {
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(270.0f));
                break;
            }
            case WEST: {
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
                matrixStack.func_227861_a_(-1.0, 0.0, 1.0);
                break;
            }
            case NORTH: {
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(0.0f));
                matrixStack.func_227861_a_(0.0, 0.0, 1.0);
                break;
            }
            case SOUTH: {
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
                matrixStack.func_227861_a_(-1.0, 0.0, 0.0);
            }
        }
        matrixStack.func_227861_a_(0.0, 0.0, (double)-0.095f);
        int canvasSize = (Integer)tileEntity.func_195044_w().func_177229_b((Property)CanvasBlock.SIZE);
        Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
        RenderType renderType = tileEntity.getDynamicRenderType();
        if (renderType != null) {
            IVertexBuilder dynamicBuilder = iRenderTypeBuffer.getBuffer(tileEntity.getDynamicRenderType());
            float mod = 0.0f;
            if (canvasSize == 4) {
                mod = 1.0f;
            } else if (canvasSize == 3) {
                mod = 0.5f;
            } else if (canvasSize == 2) {
                mod = 0.25f;
            }
            dynamicBuilder.func_227888_a_(matrix4f, 0.0f - mod, 1.0f + mod, 0.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_(0.0f, 1.0f).func_227886_a_(lightmap).func_181675_d();
            dynamicBuilder.func_227888_a_(matrix4f, 1.0f + mod, 1.0f + mod, 0.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_(1.0f, 1.0f).func_227886_a_(lightmap).func_181675_d();
            dynamicBuilder.func_227888_a_(matrix4f, 1.0f + mod, 0.0f, 0.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_(1.0f, 0.0f).func_227886_a_(lightmap).func_181675_d();
            dynamicBuilder.func_227888_a_(matrix4f, 0.0f - mod, 0.0f, 0.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_(0.0f, 0.0f).func_227886_a_(lightmap).func_181675_d();
        }
        matrixStack.func_227865_b_();
    }
}

