/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.renderer.tileentity;

import com.dairymoose.modernlife.blocks.gui.chess.BishopPiece;
import com.dairymoose.modernlife.blocks.gui.chess.KingPiece;
import com.dairymoose.modernlife.blocks.gui.chess.KnightPiece;
import com.dairymoose.modernlife.blocks.gui.chess.PawnPiece;
import com.dairymoose.modernlife.blocks.gui.chess.Piece;
import com.dairymoose.modernlife.blocks.gui.chess.QueenPiece;
import com.dairymoose.modernlife.blocks.gui.chess.RookPiece;
import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.network.play.client.CChessStatePacket;
import com.dairymoose.modernlife.tileentities.ChessBoardTileEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ChessBoardTileEntityRenderer
extends TileEntityRenderer<ChessBoardTileEntity> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ItemStack IS_ROOK = new ItemStack(new IItemProvider(){

        public Item func_199767_j() {
            return CustomBlocks.ITEM_CHESS_ROOK;
        }
    });
    private static final ItemStack IS_BISHOP = new ItemStack(new IItemProvider(){

        public Item func_199767_j() {
            return CustomBlocks.ITEM_CHESS_BISHOP;
        }
    });
    private static final ItemStack IS_PAWN = new ItemStack(new IItemProvider(){

        public Item func_199767_j() {
            return CustomBlocks.ITEM_CHESS_PAWN;
        }
    });
    private static final ItemStack IS_KNIGHT = new ItemStack(new IItemProvider(){

        public Item func_199767_j() {
            return CustomBlocks.ITEM_CHESS_KNIGHT;
        }
    });
    private static final ItemStack IS_KING = new ItemStack(new IItemProvider(){

        public Item func_199767_j() {
            return CustomBlocks.ITEM_CHESS_KING;
        }
    });
    private static final ItemStack IS_QUEEN = new ItemStack(new IItemProvider(){

        public Item func_199767_j() {
            return CustomBlocks.ITEM_CHESS_QUEEN;
        }
    });
    public static Map<BlockPos, GameState> stateMap = new HashMap<BlockPos, GameState>();
    private static final float WHITE_OVERLAY_PACK_VALUE = 0.5f;

    public ChessBoardTileEntityRenderer(TileEntityRendererDispatcher p_i226002_1_) {
        super(p_i226002_1_);
    }

    public void renderPiece(ItemStack toRender, int x, int y, MatrixStack matrixStack, int lightmap, int i1, IRenderTypeBuffer iRenderTypeBuffer) {
        matrixStack.func_227860_a_();
        double xStart = 0.225;
        double yStart = 0.12;
        double zStart = 0.225;
        double gridSize = 0.0782;
        matrixStack.func_227861_a_(xStart + (double)x * gridSize, yStart, zStart + (double)y * gridSize);
        matrixStack.func_227862_a_(0.12f, 0.12f, 0.12f);
        Minecraft.func_71410_x().func_175599_af().func_229110_a_(toRender, ItemCameraTransforms.TransformType.FIXED, lightmap, i1, matrixStack, iRenderTypeBuffer);
        matrixStack.func_227865_b_();
    }

    private void defaultPiecesOneSide(int startY, int yIncrement, MatrixStack matrixStack, int lightmap, int overlay, IRenderTypeBuffer iRenderTypeBuffer) {
        this.renderPiece(IS_ROOK, 0, startY, matrixStack, lightmap, overlay, iRenderTypeBuffer);
        this.renderPiece(IS_KNIGHT, 1, startY, matrixStack, lightmap, overlay, iRenderTypeBuffer);
        this.renderPiece(IS_BISHOP, 2, startY, matrixStack, lightmap, overlay, iRenderTypeBuffer);
        this.renderPiece(IS_KING, 3, startY, matrixStack, lightmap, overlay, iRenderTypeBuffer);
        this.renderPiece(IS_QUEEN, 4, startY, matrixStack, lightmap, overlay, iRenderTypeBuffer);
        this.renderPiece(IS_BISHOP, 5, startY, matrixStack, lightmap, overlay, iRenderTypeBuffer);
        this.renderPiece(IS_KNIGHT, 6, startY, matrixStack, lightmap, overlay, iRenderTypeBuffer);
        this.renderPiece(IS_ROOK, 7, startY, matrixStack, lightmap, overlay, iRenderTypeBuffer);
        for (int i = 0; i < 8; ++i) {
            this.renderPiece(IS_PAWN, i, startY + yIncrement, matrixStack, lightmap, overlay, iRenderTypeBuffer);
        }
    }

    public void defaultBoardState(MatrixStack matrixStack, int lightmap, int overlay, IRenderTypeBuffer iRenderTypeBuffer) {
        this.defaultPiecesOneSide(0, 1, matrixStack, lightmap, overlay, iRenderTypeBuffer);
        overlay = OverlayTexture.func_229200_a_((float)0.5f, (boolean)false);
        this.defaultPiecesOneSide(7, -1, matrixStack, lightmap, overlay, iRenderTypeBuffer);
    }

    public ItemStack getItemStackForPiece(Piece p) {
        ItemStack pieceType = null;
        if (p instanceof RookPiece) {
            pieceType = IS_ROOK;
        } else if (p instanceof BishopPiece) {
            pieceType = IS_BISHOP;
        } else if (p instanceof PawnPiece) {
            pieceType = IS_PAWN;
        } else if (p instanceof KnightPiece) {
            pieceType = IS_KNIGHT;
        } else if (p instanceof KingPiece) {
            pieceType = IS_KING;
        } else if (p instanceof QueenPiece) {
            pieceType = IS_QUEEN;
        }
        return pieceType;
    }

    public void nbtBoardState(MatrixStack matrixStack, int lightmap, int overlay, IRenderTypeBuffer iRenderTypeBuffer, GameState gameState) {
        int y;
        int x;
        ItemStack pieceType;
        boolean mirrorBoard = gameState.isWhiteTurn;
        for (Piece p : gameState.blackPieces) {
            pieceType = this.getItemStackForPiece(p);
            if (pieceType == null) continue;
            x = p.x;
            y = p.y;
            if (mirrorBoard) {
                x = 7 - x;
                y = 7 - y;
            }
            this.renderPiece(pieceType, x, y, matrixStack, lightmap, overlay, iRenderTypeBuffer);
        }
        overlay = OverlayTexture.func_229200_a_((float)0.5f, (boolean)false);
        for (Piece p : gameState.whitePieces) {
            pieceType = this.getItemStackForPiece(p);
            if (pieceType == null) continue;
            x = p.x;
            y = p.y;
            if (mirrorBoard) {
                x = 7 - x;
                y = 7 - y;
            }
            this.renderPiece(pieceType, x, y, matrixStack, lightmap, overlay, iRenderTypeBuffer);
        }
    }

    public void render(ChessBoardTileEntity tileEntity, float v, MatrixStack matrixStack, IRenderTypeBuffer iRenderTypeBuffer, int lightmap, int overlay) {
        ItemStack itemStack;
        if (!tileEntity.func_191420_l() && (itemStack = tileEntity.func_70301_a(0)).func_77973_b() == CustomBlocks.ITEM_CHESS_BOARD) {
            CompoundNBT nbt = itemStack.func_77978_p();
            if (nbt != null && nbt.func_74764_b("BoardState")) {
                int newHash;
                GameState gameState = stateMap.get(tileEntity.func_174877_v());
                if (gameState == null) {
                    gameState = new GameState();
                    stateMap.put(tileEntity.func_174877_v(), gameState);
                }
                if ((newHash = nbt.hashCode()) != gameState.lastHash) {
                    LOGGER.debug("check nbt: " + newHash + "/" + gameState.lastHash);
                    LOGGER.debug("nbt=" + nbt);
                    gameState.lastHash = newHash;
                    CChessStatePacket packet = CChessStatePacket.fromNbt(nbt);
                    gameState.whitePieces = new ArrayList<Piece>(packet.whitePieces);
                    gameState.blackPieces = new ArrayList<Piece>(packet.blackPieces);
                    gameState.isWhiteTurn = packet.isWhiteTurn;
                }
                this.nbtBoardState(matrixStack, lightmap, overlay, iRenderTypeBuffer, gameState);
            } else {
                this.defaultBoardState(matrixStack, lightmap, overlay, iRenderTypeBuffer);
            }
        }
    }

    public class GameState {
        private int lastHash = 0;
        private List<Piece> whitePieces;
        private List<Piece> blackPieces;
        private boolean isWhiteTurn = true;
    }
}

