/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.renderer.tileentity;

import com.dairymoose.modernlife.blocks.CanvasBlock;
import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.core.ModernLifeClient;
import com.dairymoose.modernlife.tileentities.CCTVCameraTileEntity;
import com.dairymoose.modernlife.tileentities.MirrorTileEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class MirrorTileEntityRenderer
extends TileEntityRenderer<MirrorTileEntity> {
    private static final Logger LOGGER = LogManager.getLogger();
    private boolean ignoreRender = false;
    public static Framebuffer mirrorFramebuffer = null;
    public static Map<BlockPos, MirrorTileEntity> mirrorMap = new HashMap<BlockPos, MirrorTileEntity>();
    private boolean insetIntoMirror = true;

    public MirrorTileEntityRenderer(TileEntityRendererDispatcher p_i226002_1_) {
        super(p_i226002_1_);
    }

    private void renderTexture(float size, MatrixStack matrixStack, int lightmap, boolean flipX) {
        this.renderTextureRect(size, size, matrixStack, lightmap, flipX);
    }

    private void renderTextureRect(float width, float height, MatrixStack matrixStack, int lightmap, boolean flipX) {
        BufferBuilder builder = Tessellator.func_178181_a().func_178180_c();
        builder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        Matrix4f poseMatrix = matrixStack.func_227866_c_().func_227870_a_();
        float uMin = 0.0f;
        float uMax = 1.0f;
        if (flipX) {
            uMin = 1.0f;
            uMax = 0.0f;
        }
        builder.func_227888_a_(poseMatrix, 0.0f, height, 0.0f).func_225583_a_(uMin, 1.0f).func_227886_a_(lightmap).func_181675_d();
        builder.func_227888_a_(poseMatrix, width, height, 0.0f).func_225583_a_(uMax, 1.0f).func_227886_a_(lightmap).func_181675_d();
        builder.func_227888_a_(poseMatrix, width, 0.0f, 0.0f).func_225583_a_(uMax, 0.0f).func_227886_a_(lightmap).func_181675_d();
        builder.func_227888_a_(poseMatrix, 0.0f, 0.0f, 0.0f).func_225583_a_(uMin, 0.0f).func_227886_a_(lightmap).func_181675_d();
        builder.func_178977_d();
        RenderSystem.enableDepthTest();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)builder);
    }

    public void render(MirrorTileEntity tileEntity, float v, MatrixStack matrixStack, IRenderTypeBuffer iRenderTypeBuffer, int lightmap, int overlayColor) {
        if (this.ignoreRender) {
            return;
        }
        if (mirrorFramebuffer == null) {
            return;
        }
        mirrorMap.put(tileEntity.func_174877_v(), tileEntity);
        if (ModernLifeClient.getChosenMirror() != tileEntity) {
            return;
        }
        matrixStack.func_227860_a_();
        switch ((Direction)tileEntity.func_195044_w().func_177229_b((Property)CanvasBlock.FACING)) {
            case EAST: {
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(270.0f));
                break;
            }
            case WEST: {
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
                matrixStack.func_227861_a_(-1.0, 0.0, 1.0);
                break;
            }
            case NORTH: {
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(0.0f));
                matrixStack.func_227861_a_(0.0, 0.0, 1.0);
                break;
            }
            case SOUTH: {
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
                matrixStack.func_227861_a_(-1.0, 0.0, 0.0);
            }
        }
        matrixStack.func_227861_a_(0.0, 0.0, (double)-0.0623f);
        if (this.insetIntoMirror) {
            matrixStack.func_227861_a_((double)0.05f, (double)0.05f, 0.0);
        }
        mirrorFramebuffer.func_147612_c();
        float size = 1.0f;
        if (this.insetIntoMirror) {
            size = 0.9f;
        }
        if (tileEntity.func_195044_w().func_177230_c() == CustomBlocks.BLOCK_TALL_MIRROR) {
            matrixStack.func_227861_a_(0.0, (double)0.05f, 0.0);
            this.renderTextureRect(0.9f, 1.85f, matrixStack, lightmap, false);
        } else if (tileEntity.func_195044_w().func_177230_c() == CustomBlocks.BLOCK_LARGE_MIRROR) {
            matrixStack.func_227861_a_(-0.5, (double)0.05f, 0.0);
            this.renderTexture(1.8f, matrixStack, lightmap, false);
        } else if (tileEntity.func_195044_w().func_177230_c() == CustomBlocks.BLOCK_MASSIVE_MIRROR) {
            matrixStack.func_227861_a_((double)-0.9f, (double)0.05f, 0.0);
            this.renderTextureRect(2.7f, 1.85f, matrixStack, lightmap, false);
        } else if (tileEntity.func_195044_w().func_177230_c() == CustomBlocks.BLOCK_CCTV_SCREEN) {
            if (ModernLifeClient.cctvCurrentCamera != null) {
                matrixStack.func_227861_a_(0.0, 0.0, (double)-0.001f);
                this.renderTexture(size, matrixStack, lightmap, true);
                if (CCTVCameraTileEntity.cctvCameras.size() > 0) {
                    matrixStack.func_227860_a_();
                    matrixStack.func_227861_a_((double)0.87f, (double)0.1f, (double)-0.01f);
                    float scaleValue = -0.01f;
                    matrixStack.func_227862_a_(scaleValue, scaleValue, scaleValue);
                    int camValue = tileEntity.cctvScreenCurrentCameraDisplayValue + 1;
                    String camText = "CAM" + String.valueOf(camValue);
                    Minecraft.func_71410_x().field_71466_p.func_238405_a_(matrixStack, camText, 0.0f, 0.0f, 0xFFFFFF);
                    matrixStack.func_227865_b_();
                }
            }
        } else {
            this.renderTexture(size, matrixStack, lightmap, false);
        }
        mirrorFramebuffer.func_147606_d();
        Minecraft.func_71410_x().func_147110_a().func_147606_d();
        matrixStack.func_227865_b_();
    }
}

