/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.tileentities;

import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.core.ModernLifeClient;
import com.dairymoose.modernlife.network.play.client.ICanvasReader;
import com.dairymoose.modernlife.network.play.client.SMultipartCanvasPacket;
import com.dairymoose.modernlife.util.CanvasData;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CanvasTileEntity
extends TileEntity
implements IInventory,
ICanvasReader {
    public static final TileEntityType<CanvasTileEntity> CANVAS = TileEntityType.Builder.func_223042_a(CanvasTileEntity::new, (Block[])new Block[]{CustomBlocks.BLOCK_CANVAS}).func_206865_a(null);
    private static final Logger LOGGER = LogManager.getLogger();
    public static final int CANVAS_CONTAINER_SIZE = 1;
    private NonNullList<ItemStack> canvasStack = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
    CanvasData canvasData = new CanvasData();
    private DynamicTexture texture = null;
    private RenderType dynamicRenderType;
    @OnlyIn(value=Dist.CLIENT)
    private TextureManager textureManager;

    public CanvasTileEntity() {
        super(CANVAS);
        SMultipartCanvasPacket.subscribe(this);
    }

    @Override
    public void onUpdate(long uniqueId) {
        long thisUniqueId;
        CompoundNBT nbt;
        if (this.func_145837_r()) {
            SMultipartCanvasPacket.unsubscribe(this);
            return;
        }
        if (!this.func_191420_l() && this.func_70301_a(0).func_77973_b() == CustomBlocks.ITEM_CANVAS && (nbt = this.func_70301_a(0).func_77978_p()).func_74764_b("UniqueId") && (thisUniqueId = nbt.func_74763_f("UniqueId")) == uniqueId) {
            this.updateToNewTexture();
        }
    }

    private void updateToNewTexture() {
        final CanvasTileEntity thisEntity = this;
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> new Runnable(){

            @Override
            public void run() {
                CompoundNBT nbt;
                if (!thisEntity.func_191420_l() && thisEntity.func_70301_a(0).func_77973_b() == CustomBlocks.ITEM_CANVAS && (nbt = thisEntity.func_70301_a(0).func_77978_p()) != null && nbt.func_74764_b("UniqueId")) {
                    int texSize;
                    long uniqueId = nbt.func_74763_f("UniqueId");
                    LOGGER.debug("updating texture for ID=" + uniqueId + " at pos = " + thisEntity.func_174877_v());
                    if (CanvasTileEntity.this.texture != null) {
                        CanvasTileEntity.this.texture.close();
                    }
                    CanvasTileEntity.this.texture = null;
                    byte[] compressed = ModernLifeClient.getCanvasData(uniqueId);
                    if (compressed != null && (texSize = ModernLifeClient.getCanvasSize(uniqueId)) > 0) {
                        CanvasTileEntity.this.canvasData.disable();
                        CanvasTileEntity.this.canvasData.setTextureSize(texSize);
                        CanvasTileEntity.this.canvasData.fromCompressedNbt(compressed);
                        CanvasTileEntity.this.canvasData.reenable();
                    }
                }
            }
        });
    }

    private void updateToNewTexture(ItemStack item) {
        if (!item.func_190926_b() && item.func_77942_o()) {
            if (item.func_77978_p().func_74764_b("TextureSize")) {
                int tex = item.func_77978_p().func_74762_e("TextureSize");
                this.canvasData.setTextureSize(tex);
            }
            if (this.texture != null) {
                this.texture.close();
            }
            this.texture = null;
        }
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        if (this.func_191420_l() || this.func_70301_a(0).func_77973_b() == CustomBlocks.ITEM_CANVAS) {
            // empty if block
        }
        ItemStackHelper.func_191282_a((CompoundNBT)nbt, this.canvasStack);
        return nbt;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        ItemStackHelper.func_191283_b((CompoundNBT)tag, this.canvasStack);
        ItemStack item = this.func_70301_a(0);
        CompoundNBT nbt = null;
        if (item != null) {
            nbt = item.func_77978_p();
        }
        if (!this.func_191420_l() && item != null && item.func_77973_b() == CustomBlocks.ITEM_CANVAS && nbt != null && nbt.func_74764_b("UniqueId")) {
            long uniqueId = this.func_70301_a(0).func_77978_p().func_74763_f("UniqueId");
            ModernLifeClient.requestUpdateForCanvas(System.currentTimeMillis(), uniqueId);
        }
        this.updateToNewTexture();
        super.handleUpdateTag(state, tag);
    }

    public void func_230337_a_(BlockState p_230337_1_, CompoundNBT p_230337_2_) {
        super.func_230337_a_(p_230337_1_, p_230337_2_);
        ItemStackHelper.func_191283_b((CompoundNBT)p_230337_2_, this.canvasStack);
        ItemStack item = this.func_70301_a(0);
        if (!item.func_190926_b() && item.func_77942_o()) {
            this.updateToNewTexture();
        }
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbtTag = new CompoundNBT();
        ItemStackHelper.func_191282_a((CompoundNBT)nbtTag, this.canvasStack);
        return new SUpdateTileEntityPacket(this.func_174877_v(), -1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT tag = pkt.func_148857_g();
        ItemStackHelper.func_191283_b((CompoundNBT)tag, this.canvasStack);
        ItemStack item = this.func_70301_a(0);
        if (!item.func_190926_b() && item.func_77942_o()) {
            this.updateToNewTexture();
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        ItemStackHelper.func_191282_a((CompoundNBT)nbt, this.canvasStack);
        return nbt;
    }

    public void func_174888_l() {
        this.canvasStack.set(0, (Object)ItemStack.field_190927_a);
    }

    public int func_70302_i_() {
        return 1;
    }

    public boolean func_191420_l() {
        return ((ItemStack)this.canvasStack.get(0)).func_190926_b();
    }

    public ItemStack func_70301_a(int var1) {
        return (ItemStack)this.canvasStack.get(var1);
    }

    public ItemStack func_70298_a(int var1, int var2) {
        return ItemStackHelper.func_188382_a(this.canvasStack, (int)var1, (int)var2);
    }

    public ItemStack func_70304_b(int var1) {
        return ItemStackHelper.func_188383_a(this.canvasStack, (int)var1);
    }

    public void func_70299_a(int var1, ItemStack item) {
        this.canvasStack.set(var1, (Object)item);
        if (item.func_77973_b() != CustomBlocks.ITEM_CANVAS || item.func_77942_o()) {
            // empty if block
        }
    }

    public boolean func_70300_a(PlayerEntity p_70300_1_) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return p_70300_1_.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public RenderType getDynamicRenderType() {
        return this.dynamicRenderType;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initImage() {
        if (this.textureManager == null) {
            this.textureManager = Minecraft.func_71410_x().func_110434_K();
        }
        this.canvasData.initImage();
        if (this.func_145831_w() instanceof ClientWorld && this.texture == null && this.canvasData.isValid()) {
            this.texture = new DynamicTexture(this.canvasData.textureSize(), this.canvasData.textureSize(), true);
            ResourceLocation resourcelocation = this.textureManager.func_110578_a("artpad/dyn", this.texture);
            this.dynamicRenderType = RenderType.func_228658_l_((ResourceLocation)resourcelocation);
            this.updateTexture();
        }
    }

    private void updateTexture() {
        if (!this.canvasData.isValid()) {
            return;
        }
        if (this.func_145831_w() instanceof ClientWorld) {
            for (int i = 0; i < this.canvasData.textureSize(); ++i) {
                for (int j = 0; j < this.canvasData.textureSize(); ++j) {
                    int k = j + i * this.canvasData.textureSize();
                    if (this.texture == null || this.texture.func_195414_e() == null || !this.canvasData.isValid()) continue;
                    try {
                        this.texture.func_195414_e().func_195700_a(j, i, this.canvasData.getAbgrOutputPixel(j, i));
                        continue;
                    }
                    catch (IllegalStateException e) {
                        LOGGER.warn("Unallocated image error");
                    }
                }
            }
            try {
                if (this.texture != null && this.canvasData.isValid()) {
                    this.texture.func_110564_a();
                }
            }
            catch (IllegalStateException e) {
                LOGGER.warn("Unallocated image error");
            }
        }
        if (this.func_145831_w() instanceof ServerWorld) {
            this.func_145831_w().markAndNotifyBlock(this.func_174877_v(), this.func_145831_w().func_175726_f(this.func_174877_v()), this.func_195044_w(), this.func_195044_w(), 2, 0);
        }
    }
}

