/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.tileentities;

import com.dairymoose.modernlife.blocks.ExtractorBlock;
import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.tileentities.ExtractorItemHandler;
import com.dairymoose.modernlife.tileentities.IHorizontalHopper;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ChestBlock;
import net.minecraft.block.HopperBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ISidedInventoryProvider;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.HopperContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.VanillaInventoryCodeHooks;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExtractorTileEntity
extends LockableLootTileEntity
implements IHorizontalHopper,
ITickableTileEntity {
    public static final TileEntityType<ExtractorTileEntity> EXTRACTOR = TileEntityType.Builder.func_223042_a(ExtractorTileEntity::new, (Block[])new Block[]{CustomBlocks.BLOCK_EXTRACTOR}).func_206865_a(null);
    private static final Logger LOGGER = LogManager.getLogger();
    private NonNullList<ItemStack> items = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
    private int cooldownTime = -1;
    private long tickedGameTime;

    public ExtractorTileEntity() {
        super(EXTRACTOR);
    }

    public void func_230337_a_(BlockState p_230337_1_, CompoundNBT p_230337_2_) {
        super.func_230337_a_(p_230337_1_, p_230337_2_);
        this.items = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        if (!this.func_184283_b(p_230337_2_)) {
            ItemStackHelper.func_191283_b((CompoundNBT)p_230337_2_, this.items);
        }
        this.cooldownTime = p_230337_2_.func_74762_e("TransferCooldown");
    }

    public CompoundNBT func_189515_b(CompoundNBT p_189515_1_) {
        super.func_189515_b(p_189515_1_);
        if (!this.func_184282_c(p_189515_1_)) {
            ItemStackHelper.func_191282_a((CompoundNBT)p_189515_1_, this.items);
        }
        p_189515_1_.func_74768_a("TransferCooldown", this.cooldownTime);
        return p_189515_1_;
    }

    public int func_70302_i_() {
        return this.items.size();
    }

    public ItemStack func_70298_a(int p_70298_1_, int p_70298_2_) {
        this.func_184281_d(null);
        return ItemStackHelper.func_188382_a(this.func_190576_q(), (int)p_70298_1_, (int)p_70298_2_);
    }

    public void func_70299_a(int p_70299_1_, ItemStack p_70299_2_) {
        this.func_184281_d(null);
        this.func_190576_q().set(p_70299_1_, (Object)p_70299_2_);
        if (p_70299_2_.func_190916_E() > this.func_70297_j_()) {
            p_70299_2_.func_190920_e(this.func_70297_j_());
        }
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.extractor");
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            --this.cooldownTime;
            this.tickedGameTime = this.field_145850_b.func_82737_E();
            if (!this.isOnCooldown()) {
                this.setCooldown(0);
                this.tryMoveItems(() -> ExtractorTileEntity.suckInItems(this));
            }
        }
    }

    private boolean tryMoveItems(Supplier<Boolean> p_200109_1_) {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            if (!this.isOnCooldown() && ((Boolean)this.func_195044_w().func_177229_b((Property)HopperBlock.field_176429_b)).booleanValue()) {
                boolean flag = false;
                if (!this.func_191420_l()) {
                    flag = this.ejectItems();
                }
                if (!this.inventoryFull()) {
                    flag |= p_200109_1_.get().booleanValue();
                }
                if (flag) {
                    this.setCooldown(8);
                    this.func_70296_d();
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private boolean inventoryFull() {
        for (ItemStack itemstack : this.items) {
            if (!itemstack.func_190926_b() && itemstack.func_190916_E() == itemstack.func_77976_d()) continue;
            return false;
        }
        return true;
    }

    @Override
    public World getWorld() {
        return this.field_145850_b;
    }

    private static Optional<Pair<IItemHandler, Object>> getItemHandler(IHorizontalHopper hopper, Direction hopperFacing) {
        double x = hopper.getLevelX() + (double)hopperFacing.func_82601_c();
        double y = hopper.getLevelY() + (double)hopperFacing.func_96559_d();
        double z = hopper.getLevelZ() + (double)hopperFacing.func_82599_e();
        return VanillaInventoryCodeHooks.getItemHandler((World)hopper.getWorld(), (double)x, (double)y, (double)z, (Direction)hopperFacing.func_176734_d());
    }

    private static boolean isFull(IItemHandler itemHandler) {
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stackInSlot = itemHandler.getStackInSlot(slot);
            if (!stackInSlot.func_190926_b() && stackInSlot.func_190916_E() >= itemHandler.getSlotLimit(slot)) continue;
            return false;
        }
        return true;
    }

    private static boolean isEmpty(IItemHandler itemHandler) {
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stackInSlot = itemHandler.getStackInSlot(slot);
            if (stackInSlot.func_190916_E() <= 0) continue;
            return false;
        }
        return true;
    }

    public static boolean insertHook(ExtractorTileEntity hopper) {
        Direction hopperFacing = ((Direction)hopper.func_195044_w().func_177229_b((Property)HopperBlock.field_176430_a)).func_176734_d();
        return ExtractorTileEntity.getItemHandler(hopper, hopperFacing).map(destinationResult -> {
            IItemHandler itemHandler = (IItemHandler)destinationResult.getKey();
            Object destination = destinationResult.getValue();
            if (ExtractorTileEntity.isFull(itemHandler)) {
                return false;
            }
            for (int i = 0; i < hopper.func_70302_i_(); ++i) {
                if (hopper.func_70301_a(i).func_190926_b()) continue;
                ItemStack originalSlotContents = hopper.func_70301_a(i).func_77946_l();
                ItemStack insertStack = hopper.func_70298_a(i, 1);
                ItemStack remainder = ExtractorTileEntity.putStackInInventoryAllSlots((TileEntity)hopper, destination, itemHandler, insertStack);
                if (remainder.func_190926_b()) {
                    return true;
                }
                hopper.func_70299_a(i, originalSlotContents);
            }
            return false;
        }).orElse(false);
    }

    private static ItemStack putStackInInventoryAllSlots(TileEntity source, Object destination, IItemHandler destInventory, ItemStack stack) {
        for (int slot = 0; slot < destInventory.getSlots() && !stack.func_190926_b(); ++slot) {
            stack = ExtractorTileEntity.insertStack(source, destination, destInventory, stack, slot);
        }
        return stack;
    }

    private static ItemStack insertStack(TileEntity source, Object destination, IItemHandler destInventory, ItemStack stack, int slot) {
        ItemStack itemstack = destInventory.getStackInSlot(slot);
        if (destInventory.insertItem(slot, stack, true).func_190926_b()) {
            ExtractorTileEntity destinationHopper;
            boolean insertedItem = false;
            boolean inventoryWasEmpty = ExtractorTileEntity.isEmpty(destInventory);
            if (itemstack.func_190926_b()) {
                destInventory.insertItem(slot, stack, false);
                stack = ItemStack.field_190927_a;
                insertedItem = true;
            } else if (ItemHandlerHelper.canItemStacksStack((ItemStack)itemstack, (ItemStack)stack)) {
                int originalSize = stack.func_190916_E();
                boolean bl = insertedItem = originalSize < (stack = destInventory.insertItem(slot, stack, false)).func_190916_E();
            }
            if (insertedItem && inventoryWasEmpty && destination instanceof ExtractorTileEntity && !(destinationHopper = (ExtractorTileEntity)destination).isOnCustomCooldown()) {
                int k = 0;
                if (source instanceof ExtractorTileEntity && destinationHopper.getLastUpdateTime() >= ((ExtractorTileEntity)source).getLastUpdateTime()) {
                    k = 1;
                }
                destinationHopper.setCooldown(8 - k);
            }
        }
        return stack;
    }

    private boolean ejectItems() {
        if (ExtractorTileEntity.insertHook(this)) {
            return true;
        }
        IInventory iinventory = this.getAttachedContainer();
        if (iinventory == null) {
            return false;
        }
        Direction direction = (Direction)this.func_195044_w().func_177229_b((Property)HopperBlock.field_176430_a);
        if (this.isFullContainer(iinventory, direction)) {
            return false;
        }
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i).func_190926_b()) continue;
            ItemStack itemstack = this.func_70301_a(i).func_77946_l();
            ItemStack itemstack1 = ExtractorTileEntity.addItem(this, iinventory, this.func_70298_a(i, 1), direction);
            if (itemstack1.func_190926_b()) {
                iinventory.func_70296_d();
                return true;
            }
            this.func_70299_a(i, itemstack);
        }
        return false;
    }

    private static IntStream getSlots(IInventory p_213972_0_, Direction p_213972_1_) {
        return p_213972_0_ instanceof ISidedInventory ? IntStream.of(((ISidedInventory)p_213972_0_).func_180463_a(p_213972_1_)) : IntStream.range(0, p_213972_0_.func_70302_i_());
    }

    private boolean isFullContainer(IInventory p_174919_1_, Direction p_174919_2_) {
        return ExtractorTileEntity.getSlots(p_174919_1_, p_174919_2_).allMatch(p_213970_1_ -> {
            ItemStack itemstack = p_174919_1_.func_70301_a(p_213970_1_);
            return itemstack.func_190916_E() >= itemstack.func_77976_d();
        });
    }

    private static boolean isEmptyContainer(IInventory p_174917_0_, Direction p_174917_1_) {
        return ExtractorTileEntity.getSlots(p_174917_0_, p_174917_1_).allMatch(p_213973_1_ -> p_174917_0_.func_70301_a(p_213973_1_).func_190926_b());
    }

    @Nullable
    public static Boolean extractHook(ExtractorTileEntity dest) {
        return ExtractorTileEntity.getItemHandler(dest, (Direction)dest.func_195044_w().func_177229_b((Property)ExtractorBlock.field_176430_a)).map(itemHandlerResult -> {
            IItemHandler handler = (IItemHandler)itemHandlerResult.getKey();
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack extractItem = handler.extractItem(i, 1, true);
                if (extractItem.func_190926_b()) continue;
                for (int j = 0; j < dest.func_70302_i_(); ++j) {
                    ItemStack destStack = dest.func_70301_a(j);
                    if (!dest.func_94041_b(j, extractItem) || !destStack.func_190926_b() && (destStack.func_190916_E() >= destStack.func_77976_d() || destStack.func_190916_E() >= dest.func_70297_j_() || !ItemHandlerHelper.canItemStacksStack((ItemStack)extractItem, (ItemStack)destStack))) continue;
                    extractItem = handler.extractItem(i, 1, false);
                    if (destStack.func_190926_b()) {
                        dest.func_70299_a(j, extractItem);
                    } else {
                        destStack.func_190917_f(1);
                        dest.func_70299_a(j, destStack);
                    }
                    dest.func_70296_d();
                    return true;
                }
            }
            return false;
        }).orElse(null);
    }

    public static boolean suckInItems(ExtractorTileEntity p_145891_0_) {
        Boolean ret = ExtractorTileEntity.extractHook(p_145891_0_);
        if (ret != null) {
            return ret;
        }
        IInventory iinventory = ExtractorTileEntity.getSourceContainer(p_145891_0_, p_145891_0_.func_195044_w());
        if (iinventory != null) {
            Direction direction = Direction.DOWN;
            switch ((Direction)p_145891_0_.func_195044_w().func_177229_b((Property)HopperBlock.field_176430_a)) {
                case EAST: {
                    direction = Direction.WEST;
                    break;
                }
                case NORTH: {
                    direction = Direction.SOUTH;
                    break;
                }
                case SOUTH: {
                    direction = Direction.NORTH;
                    break;
                }
                case WEST: {
                    direction = Direction.EAST;
                }
            }
            Direction finalDirection = direction;
            return ExtractorTileEntity.isEmptyContainer(iinventory, finalDirection) ? false : ExtractorTileEntity.getSlots(iinventory, finalDirection).anyMatch(p_213971_3_ -> ExtractorTileEntity.tryTakeInItemFromSlot(p_145891_0_, iinventory, p_213971_3_, finalDirection));
        }
        for (ItemEntity itementity : ExtractorTileEntity.getFrontalItems(p_145891_0_, p_145891_0_.func_195044_w())) {
            if (!ExtractorTileEntity.addItem(p_145891_0_, itementity)) continue;
            return true;
        }
        return false;
    }

    private static boolean tryTakeInItemFromSlot(IHorizontalHopper p_174915_0_, IInventory p_174915_1_, int p_174915_2_, Direction p_174915_3_) {
        ItemStack itemstack = p_174915_1_.func_70301_a(p_174915_2_);
        if (!itemstack.func_190926_b() && ExtractorTileEntity.canTakeItemFromContainer(p_174915_1_, itemstack, p_174915_2_, p_174915_3_)) {
            ItemStack itemstack1 = itemstack.func_77946_l();
            ItemStack itemstack2 = ExtractorTileEntity.addItem(p_174915_1_, p_174915_0_, p_174915_1_.func_70298_a(p_174915_2_, 1), null);
            if (itemstack2.func_190926_b()) {
                p_174915_1_.func_70296_d();
                return true;
            }
            p_174915_1_.func_70299_a(p_174915_2_, itemstack1);
        }
        return false;
    }

    public static boolean addItem(IInventory p_200114_0_, ItemEntity p_200114_1_) {
        boolean flag = false;
        ItemStack itemstack = p_200114_1_.func_92059_d().func_77946_l();
        ItemStack itemstack1 = ExtractorTileEntity.addItem(null, p_200114_0_, itemstack, null);
        if (itemstack1.func_190926_b()) {
            flag = true;
            p_200114_1_.func_70106_y();
        } else {
            p_200114_1_.func_92058_a(itemstack1);
        }
        return flag;
    }

    public static ItemStack addItem(@Nullable IInventory p_174918_0_, IInventory p_174918_1_, ItemStack p_174918_2_, @Nullable Direction p_174918_3_) {
        if (p_174918_1_ instanceof ISidedInventory && p_174918_3_ != null) {
            ISidedInventory isidedinventory = (ISidedInventory)p_174918_1_;
            int[] aint = isidedinventory.func_180463_a(p_174918_3_);
            for (int k = 0; k < aint.length && !p_174918_2_.func_190926_b(); ++k) {
                p_174918_2_ = ExtractorTileEntity.tryMoveInItem(p_174918_0_, p_174918_1_, p_174918_2_, aint[k], p_174918_3_);
            }
        } else {
            int i = p_174918_1_.func_70302_i_();
            for (int j = 0; j < i && !p_174918_2_.func_190926_b(); ++j) {
                p_174918_2_ = ExtractorTileEntity.tryMoveInItem(p_174918_0_, p_174918_1_, p_174918_2_, j, p_174918_3_);
            }
        }
        return p_174918_2_;
    }

    private static boolean canPlaceItemInContainer(IInventory p_174920_0_, ItemStack p_174920_1_, int p_174920_2_, @Nullable Direction p_174920_3_) {
        if (!p_174920_0_.func_94041_b(p_174920_2_, p_174920_1_)) {
            return false;
        }
        return !(p_174920_0_ instanceof ISidedInventory) || ((ISidedInventory)p_174920_0_).func_180462_a(p_174920_2_, p_174920_1_, p_174920_3_);
    }

    private static boolean canTakeItemFromContainer(IInventory p_174921_0_, ItemStack p_174921_1_, int p_174921_2_, Direction p_174921_3_) {
        return !(p_174921_0_ instanceof ISidedInventory) || ((ISidedInventory)p_174921_0_).func_180461_b(p_174921_2_, p_174921_1_, p_174921_3_);
    }

    private static ItemStack tryMoveInItem(@Nullable IInventory p_174916_0_, IInventory p_174916_1_, ItemStack p_174916_2_, int p_174916_3_, @Nullable Direction p_174916_4_) {
        ItemStack itemstack = p_174916_1_.func_70301_a(p_174916_3_);
        if (ExtractorTileEntity.canPlaceItemInContainer(p_174916_1_, p_174916_2_, p_174916_3_, p_174916_4_)) {
            boolean flag = false;
            boolean flag1 = p_174916_1_.func_191420_l();
            if (itemstack.func_190926_b()) {
                p_174916_1_.func_70299_a(p_174916_3_, p_174916_2_);
                p_174916_2_ = ItemStack.field_190927_a;
                flag = true;
            } else if (ExtractorTileEntity.canMergeItems(itemstack, p_174916_2_)) {
                int i = p_174916_2_.func_77976_d() - itemstack.func_190916_E();
                int j = Math.min(p_174916_2_.func_190916_E(), i);
                p_174916_2_.func_190918_g(j);
                itemstack.func_190917_f(j);
                boolean bl = flag = j > 0;
            }
            if (flag) {
                ExtractorTileEntity ExtractorTileEntity1;
                if (flag1 && p_174916_1_ instanceof ExtractorTileEntity && !(ExtractorTileEntity1 = (ExtractorTileEntity)p_174916_1_).isOnCustomCooldown()) {
                    int k = 0;
                    if (p_174916_0_ instanceof ExtractorTileEntity) {
                        ExtractorTileEntity ExtractorTileEntity2 = (ExtractorTileEntity)p_174916_0_;
                        if (ExtractorTileEntity1.tickedGameTime >= ExtractorTileEntity2.tickedGameTime) {
                            k = 1;
                        }
                    }
                    ExtractorTileEntity1.setCooldown(8 - k);
                }
                p_174916_1_.func_70296_d();
            }
        }
        return p_174916_2_;
    }

    @Nullable
    private IInventory getAttachedContainer() {
        Direction direction = ((Direction)this.func_195044_w().func_177229_b((Property)HopperBlock.field_176430_a)).func_176734_d();
        return ExtractorTileEntity.getContainerAt(this.getWorld(), this.field_174879_c.func_177972_a(direction));
    }

    @Nullable
    public static IInventory getSourceContainer(IHorizontalHopper p_145884_0_, BlockState state) {
        switch ((Direction)state.func_177229_b((Property)HopperBlock.field_176430_a)) {
            case EAST: {
                return ExtractorTileEntity.getContainerAt(p_145884_0_.getWorld(), p_145884_0_.getLevelX() + 1.0, p_145884_0_.getLevelY(), p_145884_0_.getLevelZ());
            }
            case NORTH: {
                return ExtractorTileEntity.getContainerAt(p_145884_0_.getWorld(), p_145884_0_.getLevelX(), p_145884_0_.getLevelY(), p_145884_0_.getLevelZ() - 1.0);
            }
            case SOUTH: {
                return ExtractorTileEntity.getContainerAt(p_145884_0_.getWorld(), p_145884_0_.getLevelX(), p_145884_0_.getLevelY(), p_145884_0_.getLevelZ() + 1.0);
            }
            case WEST: {
                return ExtractorTileEntity.getContainerAt(p_145884_0_.getWorld(), p_145884_0_.getLevelX() - 1.0, p_145884_0_.getLevelY(), p_145884_0_.getLevelZ());
            }
        }
        return ExtractorTileEntity.getContainerAt(p_145884_0_.getWorld(), p_145884_0_.getLevelX(), p_145884_0_.getLevelY() + 1.0, p_145884_0_.getLevelZ());
    }

    public static List<ItemEntity> getFrontalItems(IHorizontalHopper p_200115_0_, BlockState state) {
        return p_200115_0_.getSuckShape(state).func_197756_d().stream().flatMap(p_200110_1_ -> p_200115_0_.getWorld().func_175647_a(ItemEntity.class, p_200110_1_.func_72317_d(p_200115_0_.getLevelX() - 0.5, p_200115_0_.getLevelY() - 0.5, p_200115_0_.getLevelZ() - 0.5), EntityPredicates.field_94557_a).stream()).collect(Collectors.toList());
    }

    @Nullable
    public static IInventory getContainerAt(World p_195484_0_, BlockPos p_195484_1_) {
        return ExtractorTileEntity.getContainerAt(p_195484_0_, (double)p_195484_1_.func_177958_n() + 0.5, (double)p_195484_1_.func_177956_o() + 0.5, (double)p_195484_1_.func_177952_p() + 0.5);
    }

    @Nullable
    public static IInventory getContainerAt(World p_145893_0_, double p_145893_1_, double p_145893_3_, double p_145893_5_) {
        List list;
        TileEntity tileentity;
        ISidedInventory iinventory = null;
        BlockPos blockpos = new BlockPos(p_145893_1_, p_145893_3_, p_145893_5_);
        BlockState blockstate = p_145893_0_.func_180495_p(blockpos);
        Block block = blockstate.func_177230_c();
        if (block instanceof ISidedInventoryProvider) {
            iinventory = ((ISidedInventoryProvider)block).func_219966_a(blockstate, (IWorld)p_145893_0_, blockpos);
        } else if (blockstate.hasTileEntity() && (tileentity = p_145893_0_.func_175625_s(blockpos)) instanceof IInventory && (iinventory = (IInventory)tileentity) instanceof ChestTileEntity && block instanceof ChestBlock) {
            iinventory = ChestBlock.func_226916_a_((ChestBlock)((ChestBlock)block), (BlockState)blockstate, (World)p_145893_0_, (BlockPos)blockpos, (boolean)true);
        }
        if (iinventory == null && !(list = p_145893_0_.func_175674_a((Entity)null, new AxisAlignedBB(p_145893_1_ - 0.5, p_145893_3_ - 0.5, p_145893_5_ - 0.5, p_145893_1_ + 0.5, p_145893_3_ + 0.5, p_145893_5_ + 0.5), EntityPredicates.field_96566_b)).isEmpty()) {
            iinventory = (IInventory)list.get(p_145893_0_.field_73012_v.nextInt(list.size()));
        }
        return iinventory;
    }

    private static boolean canMergeItems(ItemStack p_145894_0_, ItemStack p_145894_1_) {
        if (p_145894_0_.func_77973_b() != p_145894_1_.func_77973_b()) {
            return false;
        }
        if (p_145894_0_.func_77952_i() != p_145894_1_.func_77952_i()) {
            return false;
        }
        if (p_145894_0_.func_190916_E() > p_145894_0_.func_77976_d()) {
            return false;
        }
        return ItemStack.func_77970_a((ItemStack)p_145894_0_, (ItemStack)p_145894_1_);
    }

    @Override
    public double getLevelX() {
        return (double)this.field_174879_c.func_177958_n() + 0.5;
    }

    @Override
    public double getLevelY() {
        return (double)this.field_174879_c.func_177956_o() + 0.5;
    }

    @Override
    public double getLevelZ() {
        return (double)this.field_174879_c.func_177952_p() + 0.5;
    }

    public void setCooldown(int p_145896_1_) {
        this.cooldownTime = p_145896_1_;
    }

    private boolean isOnCooldown() {
        return this.cooldownTime > 0;
    }

    public boolean isOnCustomCooldown() {
        return this.cooldownTime > 8;
    }

    protected NonNullList<ItemStack> func_190576_q() {
        return this.items;
    }

    protected void func_199721_a(NonNullList<ItemStack> p_199721_1_) {
        this.items = p_199721_1_;
    }

    public void entityInside(Entity p_200113_1_) {
        if (p_200113_1_ instanceof ItemEntity) {
            BlockPos blockpos = this.func_174877_v();
            if (VoxelShapes.func_197879_c((VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)p_200113_1_.func_174813_aQ().func_72317_d((double)(-blockpos.func_177958_n()), (double)(-blockpos.func_177956_o()), (double)(-blockpos.func_177952_p()))), (VoxelShape)this.getSuckShape(this.func_195044_w()), (IBooleanFunction)IBooleanFunction.field_223238_i_)) {
                this.tryMoveItems(() -> ExtractorTileEntity.addItem(this, (ItemEntity)p_200113_1_));
            }
        }
    }

    protected Container func_213906_a(int p_213906_1_, PlayerInventory p_213906_2_) {
        return new HopperContainer(p_213906_1_, p_213906_2_, (IInventory)this);
    }

    protected IItemHandler createUnSidedHandler() {
        return new ExtractorItemHandler(this);
    }

    public long getLastUpdateTime() {
        return this.tickedGameTime;
    }
}

