/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.tileentities;

import com.dairymoose.modernlife.blocks.MicrowaveBlock;
import com.dairymoose.modernlife.blocks.StoveBlock;
import com.dairymoose.modernlife.core.CustomBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CampfireCookingRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MicrowaveTileEntity
extends TileEntity
implements ITickableTileEntity,
IInventory {
    public static final TileEntityType<MicrowaveTileEntity> MICROWAVE = TileEntityType.Builder.func_223042_a(MicrowaveTileEntity::new, (Block[])new Block[]{CustomBlocks.BLOCK_MICROWAVE}).func_206865_a(null);
    private static final Logger LOGGER = LogManager.getLogger();
    public static final int MICROWAVE_CONTAINER_SIZE = 1;
    private NonNullList<ItemStack> microwaveStack = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
    private int cookProgress = 0;
    private int cookTime = 0;
    public int tickCounter = 0;

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        ItemStackHelper.func_191282_a((CompoundNBT)nbt, this.microwaveStack);
        return nbt;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        ItemStackHelper.func_191283_b((CompoundNBT)tag, this.microwaveStack);
        ItemStack item = this.func_70301_a(0);
        super.handleUpdateTag(state, tag);
    }

    public void func_230337_a_(BlockState p_230337_1_, CompoundNBT p_230337_2_) {
        super.func_230337_a_(p_230337_1_, p_230337_2_);
        ItemStackHelper.func_191283_b((CompoundNBT)p_230337_2_, this.microwaveStack);
        if (p_230337_2_.func_74764_b("CookProgress")) {
            this.cookProgress = p_230337_2_.func_74762_e("CookProgress");
        }
        if (p_230337_2_.func_74764_b("CookTime")) {
            this.cookTime = p_230337_2_.func_74762_e("CookTime");
        }
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbtTag = new CompoundNBT();
        ItemStackHelper.func_191282_a((CompoundNBT)nbtTag, this.microwaveStack);
        return new SUpdateTileEntityPacket(this.func_174877_v(), -1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT tag = pkt.func_148857_g();
        this.microwaveStack.clear();
        ItemStackHelper.func_191283_b((CompoundNBT)tag, this.microwaveStack);
    }

    public CompoundNBT func_189515_b(CompoundNBT p_189515_1_) {
        super.func_189515_b(p_189515_1_);
        ItemStackHelper.func_191282_a((CompoundNBT)p_189515_1_, this.microwaveStack);
        p_189515_1_.func_74768_a("CookProgress", this.cookProgress);
        p_189515_1_.func_74768_a("CookTime", this.cookTime);
        return p_189515_1_;
    }

    public void func_174888_l() {
        this.microwaveStack.set(0, (Object)ItemStack.field_190927_a);
    }

    public int func_70302_i_() {
        return 1;
    }

    public boolean func_191420_l() {
        return ((ItemStack)this.microwaveStack.get(0)).func_190926_b();
    }

    public ItemStack func_70301_a(int var1) {
        return (ItemStack)this.microwaveStack.get(var1);
    }

    public ItemStack func_70298_a(int var1, int var2) {
        return ItemStackHelper.func_188382_a(this.microwaveStack, (int)var1, (int)var2);
    }

    public ItemStack func_70304_b(int var1) {
        return ItemStackHelper.func_188383_a(this.microwaveStack, (int)var1);
    }

    public void func_70299_a(int var1, ItemStack item) {
        this.microwaveStack.set(var1, (Object)item);
    }

    public boolean func_70300_a(PlayerEntity p_70300_1_) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return p_70300_1_.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public MicrowaveTileEntity() {
        super(MICROWAVE);
    }

    public void cookItem(ItemStack itemStack, int cookTime) {
        this.cookProgress = 0;
        this.cookTime = cookTime;
        this.func_70299_a(0, itemStack.func_77946_l());
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && !this.func_191420_l() && this.cookTime > 0) {
            if (((Boolean)this.func_195044_w().func_177229_b((Property)MicrowaveBlock.OPEN_DOOR)).booleanValue()) {
                --this.cookProgress;
                if (this.cookProgress < 0) {
                    this.cookProgress = 0;
                }
            } else {
                ++this.cookProgress;
                if (this.cookProgress >= this.cookTime) {
                    this.cookTime = 0;
                    ItemStack toCook = this.func_70301_a(0);
                    Inventory lvt_3_1_ = new Inventory(new ItemStack[]{toCook});
                    ItemStack lvt_4_1_ = this.field_145850_b.func_199532_z().func_215371_a(IRecipeType.field_222153_e, (IInventory)lvt_3_1_, this.field_145850_b).map(arg_0 -> MicrowaveTileEntity.lambda$tick$0((IInventory)lvt_3_1_, arg_0)).orElse(toCook);
                    BlockPos pos = this.func_174877_v();
                    double xMod = 0.0;
                    double zMod = 0.0;
                    double dropDistance = 0.6;
                    Direction microwaveFacing = (Direction)this.func_195044_w().func_177229_b((Property)StoveBlock.field_185512_D);
                    if (microwaveFacing == Direction.NORTH) {
                        zMod += dropDistance;
                    } else if (microwaveFacing == Direction.EAST) {
                        xMod -= dropDistance;
                    } else if (microwaveFacing == Direction.WEST) {
                        xMod += dropDistance;
                    } else if (microwaveFacing == Direction.SOUTH) {
                        zMod -= dropDistance;
                    }
                    InventoryHelper.func_180173_a((World)this.field_145850_b, (double)((double)pos.func_177958_n() + 0.5 + xMod), (double)((double)pos.func_177956_o() + 0.5), (double)((double)pos.func_177952_p() + 0.5 + zMod), (ItemStack)lvt_4_1_);
                    this.func_70299_a(0, ItemStack.field_190927_a);
                    BlockState oldState = this.func_195044_w();
                    BlockState newState = (BlockState)oldState.func_206870_a((Property)MicrowaveBlock.OPEN_DOOR, (Comparable)Boolean.valueOf(true));
                    this.func_145831_w().func_175656_a(pos, newState);
                    ((ServerWorld)this.func_145831_w()).func_184138_a(pos, oldState, newState, 2);
                }
            }
        }
        if (this.field_145850_b.field_72995_K) {
            if (this.func_191420_l()) {
                this.tickCounter = 0;
            } else if (!((Boolean)this.func_195044_w().func_177229_b((Property)MicrowaveBlock.OPEN_DOOR)).booleanValue()) {
                ++this.tickCounter;
            }
        }
    }

    private static /* synthetic */ ItemStack lambda$tick$0(IInventory lvt_3_1_, CampfireCookingRecipe p_213979_1_) {
        return p_213979_1_.func_77572_b(lvt_3_1_);
    }
}

