/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.tileentities;

import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.tileentities.IChannelHolder;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PowerReceiverTileEntity
extends TileEntity
implements IChannelHolder {
    public static Map<Integer, Set<PowerReceiverTileEntity>> perChannelPowerReceivers = new ConcurrentHashMap<Integer, Set<PowerReceiverTileEntity>>();
    private int currentChannel = 0;
    public static final TileEntityType<PowerReceiverTileEntity> POWER_RECEIVER = TileEntityType.Builder.func_223042_a(PowerReceiverTileEntity::new, (Block[])new Block[]{CustomBlocks.BLOCK_POWER_RECEIVER}).func_206865_a(null);
    private static final Logger LOGGER = LogManager.getLogger();

    public String toString() {
        return "(channel=" + this.getCurrentChannel() + ", pos=" + this.func_174877_v() + ")";
    }

    public void func_226984_a_(World world, BlockPos pos) {
        super.func_226984_a_(world, pos);
        LOGGER.debug("adding receiver=" + this + " to channel=" + this.currentChannel);
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        nbt.func_74768_a("channel", this.currentChannel);
        return nbt;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        if (tag.func_74764_b("channel")) {
            this.currentChannel = tag.func_74762_e("channel");
        }
        super.handleUpdateTag(state, tag);
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("channel", this.currentChannel);
        LOGGER.debug("save with channel=" + this.currentChannel + " at pos=" + this.func_174877_v());
        return nbt;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        if (nbt.func_74764_b("channel")) {
            this.currentChannel = nbt.func_74762_e("channel");
            this.addToChannel(this.currentChannel);
        }
        LOGGER.debug("load with channel=" + this.currentChannel);
    }

    public boolean equals(Object other) {
        if (other instanceof PowerReceiverTileEntity) {
            PowerReceiverTileEntity otherTransmitter = (PowerReceiverTileEntity)other;
            return this.func_174877_v().equals((Object)otherTransmitter.func_174877_v());
        }
        return false;
    }

    public int hashCode() {
        return this.func_174877_v().hashCode();
    }

    public void addToChannel(int channel) {
        LOGGER.debug("adding receiver at " + this.func_174877_v() + " with channel: " + this.currentChannel);
        Set<PowerReceiverTileEntity> entities = perChannelPowerReceivers.get(channel);
        if (entities == null) {
            entities = new HashSet<PowerReceiverTileEntity>();
            perChannelPowerReceivers.put(channel, entities);
        }
        entities.add(this);
        LOGGER.debug("receiver count = " + perChannelPowerReceivers.size());
    }

    public void removeFromChannel(int channel) {
        LOGGER.debug("removing receiver at " + this.func_174877_v() + " with channel: " + this.currentChannel);
        Set<PowerReceiverTileEntity> entities = perChannelPowerReceivers.get(channel);
        if (entities == null) {
            entities = new HashSet<PowerReceiverTileEntity>();
            perChannelPowerReceivers.put(channel, entities);
        }
        entities.remove(this);
        LOGGER.debug("receiver count = " + perChannelPowerReceivers.size());
    }

    public PowerReceiverTileEntity() {
        super(POWER_RECEIVER);
        LOGGER.debug("PowerReceiverTileEntity CONSTRUCTOR");
    }

    @Override
    public int getCurrentChannel() {
        return this.currentChannel;
    }

    @Override
    public void setCurrentChannel(int newChannel) {
        this.removeFromChannel(this.currentChannel);
        this.currentChannel = newChannel;
        this.addToChannel(newChannel);
        LOGGER.debug("updating channel with world=" + this.func_145831_w());
        this.func_145831_w().func_195593_d(this.func_174877_v(), this.func_195044_w().func_177230_c());
    }
}

