/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.tileentities;

import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.network.play.client.CWirelessChannelPacket;
import com.dairymoose.modernlife.tileentities.IChannelHolder;
import com.dairymoose.modernlife.tileentities.PowerReceiverTileEntity;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PowerTransmitterTileEntity
extends TileEntity
implements IChannelHolder {
    public static Map<Integer, Set<PowerTransmitterTileEntity>> perChannelPowerTransmitters = new ConcurrentHashMap<Integer, Set<PowerTransmitterTileEntity>>();
    private int currentChannel = 0;
    public static final TileEntityType<PowerTransmitterTileEntity> POWER_TRANSMITTER = TileEntityType.Builder.func_223042_a(PowerTransmitterTileEntity::new, (Block[])new Block[]{CustomBlocks.BLOCK_POWER_TRANSMITTER}).func_206865_a(null);
    private static final Logger LOGGER = LogManager.getLogger();

    public String toString() {
        return "(channel=" + this.getCurrentChannel() + ", pos=" + this.func_174877_v() + ")";
    }

    public void updateReceivers(World world) {
        Set<PowerReceiverTileEntity> receivers = PowerReceiverTileEntity.perChannelPowerReceivers.get(this.currentChannel);
        if (receivers != null) {
            CWirelessChannelPacket.purgeRemovedChannelHolders(receivers);
            for (PowerReceiverTileEntity receiver : receivers) {
                LOGGER.debug("issued update to " + receiver.func_174877_v());
                if (!world.func_195588_v(receiver.func_174877_v())) continue;
                world.func_195593_d(receiver.func_174877_v(), receiver.func_195044_w().func_177230_c());
            }
        }
    }

    public void func_226984_a_(World world, BlockPos pos) {
        super.func_226984_a_(world, pos);
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        nbt.func_74768_a("channel", this.currentChannel);
        return nbt;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        if (tag.func_74764_b("channel")) {
            this.currentChannel = tag.func_74762_e("channel");
        }
        super.handleUpdateTag(state, tag);
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("channel", this.currentChannel);
        LOGGER.debug("save with channel=" + this.currentChannel + " at pos=" + this.func_174877_v());
        return nbt;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        if (nbt.func_74764_b("channel")) {
            this.currentChannel = nbt.func_74762_e("channel");
            this.addToChannel(this.currentChannel);
        }
        LOGGER.debug("load with channel=" + this.currentChannel);
    }

    public void func_174878_a(BlockPos pos) {
        super.func_174878_a(pos);
        LOGGER.debug("setPosition");
    }

    public void func_70296_d() {
        super.func_70296_d();
        LOGGER.debug("setChanged");
    }

    public boolean equals(Object other) {
        if (other instanceof PowerTransmitterTileEntity) {
            PowerTransmitterTileEntity otherTransmitter = (PowerTransmitterTileEntity)other;
            return this.func_174877_v().equals((Object)otherTransmitter.func_174877_v());
        }
        return false;
    }

    public int hashCode() {
        return this.func_174877_v().hashCode();
    }

    public void addToChannel(int channel) {
        LOGGER.debug("adding transmitter at " + this.func_174877_v() + " with channel: " + this.currentChannel);
        Set<PowerTransmitterTileEntity> entities = perChannelPowerTransmitters.get(channel);
        if (entities == null) {
            entities = new HashSet<PowerTransmitterTileEntity>();
            perChannelPowerTransmitters.put(channel, entities);
        }
        LOGGER.debug("add " + this + " to channel " + channel + " with BlockPos=" + this.func_174877_v());
        entities.add(this);
        LOGGER.debug("transmitter count = " + perChannelPowerTransmitters.size());
    }

    public void removeFromChannel(int channel) {
        LOGGER.debug("removing transmitter at " + this.func_174877_v() + " with channel: " + this.currentChannel);
        Set<PowerTransmitterTileEntity> entities = perChannelPowerTransmitters.get(channel);
        if (entities == null) {
            entities = new HashSet<PowerTransmitterTileEntity>();
            perChannelPowerTransmitters.put(channel, entities);
        }
        LOGGER.debug("remove " + this);
        entities.remove(this);
        LOGGER.debug("transmitter count = " + perChannelPowerTransmitters.size());
    }

    public PowerTransmitterTileEntity() {
        super(POWER_TRANSMITTER);
        LOGGER.debug("PowerTransmitterTileEntity CONSTRUCTOR");
    }

    @Override
    public int getCurrentChannel() {
        return this.currentChannel;
    }

    @Override
    public void setCurrentChannel(int newChannel) {
        this.removeFromChannel(this.currentChannel);
        this.updateReceivers(this.func_145831_w());
        this.currentChannel = newChannel;
        this.addToChannel(this.currentChannel);
        this.updateReceivers(this.func_145831_w());
    }
}

