/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.tileentities;

import com.dairymoose.modernlife.blocks.RadiatorBlock;
import com.dairymoose.modernlife.core.CustomBlocks;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RadiatorTileEntity
extends TileEntity
implements ITickableTileEntity {
    public static final TileEntityType<RadiatorTileEntity> RADIATOR = TileEntityType.Builder.func_223042_a(RadiatorTileEntity::new, (Block[])new Block[]{CustomBlocks.BLOCK_RADIATOR}).func_206865_a(null);
    private static final Logger LOGGER = LogManager.getLogger();
    private double multLow = 1.0;
    private double multMed = 1.6;
    private double multHigh = 2.56;
    final int LOW_DIAMETER = 9;
    final int MED_DIAMETER = 13;
    final int HIGH_DIAMETER = 19;

    public RadiatorTileEntity() {
        super(RADIATOR);
    }

    private void meltTargetedSpot(ServerWorld world, BlockPos targetPos, double meltMult) {
        double meltChance = 1.0 / targetPos.func_177951_i((Vector3i)this.func_174877_v());
        meltChance *= 1.0;
        meltChance *= meltMult;
        if (Math.random() >= meltChance) {
            return;
        }
        BlockState targetBlockState = world.func_180495_p(targetPos);
        if (targetBlockState.func_203425_a(Blocks.field_150432_aD) || targetBlockState.func_203425_a(Blocks.field_150403_cj) || targetBlockState.func_203425_a(Blocks.field_205164_gk) || targetBlockState.func_203425_a(Blocks.field_185778_de)) {
            world.func_175656_a(targetPos, Blocks.field_150355_j.func_176223_P());
            world.func_190524_a(targetPos, Blocks.field_150355_j, targetPos);
        } else if (targetBlockState.func_203425_a(Blocks.field_150433_aE) || targetBlockState.func_203425_a(Blocks.field_196604_cC)) {
            Optional snowyValue = targetBlockState.func_235903_d_((Property)BlockStateProperties.field_208196_w);
            world.func_195598_a((IParticleData)ParticleTypes.field_197594_E, (double)targetPos.func_177958_n() + 0.5, (double)targetPos.func_177956_o() + 0.5, (double)targetPos.func_177952_p() + 0.5, 0, 0.0, 0.0, 0.0, 0.0);
            world.func_175655_b(targetPos, false);
        }
    }

    public void meltSnow(int meltDiameter, double meltMult, int n) {
        for (int i = 0; i < n; ++i) {
            int xOffset = (int)((double)meltDiameter * Math.random()) - meltDiameter / 2;
            int zOffset = (int)((double)meltDiameter * Math.random()) - meltDiameter / 2;
            World level = this.func_145831_w();
            if (!(level instanceof ServerWorld)) continue;
            ServerWorld world = (ServerWorld)level;
            BlockPos targetPos = new BlockPos(this.func_174877_v().func_177958_n() + xOffset, this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p() + zOffset);
            this.meltTargetedSpot(world, targetPos, meltMult);
            this.meltTargetedSpot(world, targetPos.func_177977_b(), meltMult);
            this.meltTargetedSpot(world, targetPos.func_177977_b().func_177977_b(), meltMult);
            this.meltTargetedSpot(world, targetPos.func_177984_a(), meltMult);
            this.meltTargetedSpot(world, targetPos.func_177984_a().func_177984_a(), meltMult);
        }
    }

    public void func_73660_a() {
        RadiatorBlock.HeatType heat = (RadiatorBlock.HeatType)((Object)this.func_195044_w().func_177229_b(RadiatorBlock.HEAT));
        switch (heat) {
            case off: {
                break;
            }
            case low: {
                this.meltSnow(9, this.multLow, 1);
                break;
            }
            case medium: {
                this.meltSnow(13, this.multMed, 2);
                break;
            }
            case high: {
                this.meltSnow(19, this.multHigh, 5);
            }
        }
    }
}

