/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.tileentities;

import com.dairymoose.entity.projectile.ThrownSeedEntity;
import com.dairymoose.modernlife.core.CustomBlocks;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SeedSpreaderTileEntity
extends TileEntity
implements ITickableTileEntity,
IInventory {
    public static final TileEntityType<SeedSpreaderTileEntity> SEED_SPREADER = TileEntityType.Builder.func_223042_a(SeedSpreaderTileEntity::new, (Block[])new Block[]{CustomBlocks.BLOCK_SEED_SPREADER}).func_206865_a(null);
    private static final Logger LOGGER = LogManager.getLogger();
    public static final int SEED_SPREADER_CONTAINER_SIZE = 9;
    private NonNullList<ItemStack> items = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
    final int DIAMETER = 9;
    final int VERTICAL_SPAN = 5;
    public static final double LAUNCHER_HEIGHT = 0.109375;
    public static final double LAUNCHER_HEIGHT_SAME_LEVEL = 0.75;
    public static final double LAUNCHER_RADIUS = 0.5;
    public static int RECENT_LOCATIONS_EXPIRY_MS = 5000;
    public static List<Item> extraItems = new ArrayList<Item>();
    int counter = 0;
    Map<BlockPos, Long> recentLocations = new HashMap<BlockPos, Long>();
    public static final double PROJECTILE_GRAVITY = 0.03;

    public SeedSpreaderTileEntity() {
        super(SEED_SPREADER);
    }

    double freeFallTime(double h, double g) {
        return Math.sqrt(2.0 * h / g);
    }

    void launchTo(ThrownSeedEntity thrownSeed, double x, double y, double z, BlockPos pos) {
        this.recentLocations.put(pos, System.currentTimeMillis());
        double xMid = (double)pos.func_177958_n() + 0.5;
        double zMid = (double)pos.func_177952_p() + 0.5;
        double xDiff = xMid - x;
        double zDiff = zMid - z;
        double launchYaw = Math.atan2(zDiff, xDiff);
        double launchX = Math.cos(launchYaw) * 0.5 + x;
        double launchZ = Math.sin(launchYaw) * 0.5 + z;
        double xDiffNew = xMid - launchX;
        double zDiffNew = zMid - launchZ;
        double yDiff = y - (double)pos.func_177956_o();
        double time = this.freeFallTime(yDiff, 0.03);
        double Vx = xDiffNew / (time -= 3.0);
        double Vz = zDiffNew / time;
        thrownSeed.func_225653_b_(launchX, y, launchZ);
        double v = Math.sqrt(Vx * Vx + Vz * Vz);
        thrownSeed.func_70186_c(Vx, 0.0, Vz, (float)v, 0.0f);
    }

    public BlockPos getNextFarmland(World world, BlockPos start, ItemStack seedStack) {
        ArrayList<BlockPos> farmlandSpots = new ArrayList<BlockPos>();
        int radius = 4;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                if (x == 0 && z == 0) continue;
                BlockPos current = new BlockPos((Vector3i)start);
                current = current.func_177965_g(x).func_177970_e(z);
                BlockState state = world.func_180495_p(current);
                BlockState aboveState = world.func_180495_p(current.func_177984_a());
                if (seedStack.func_77973_b() == Items.field_151075_bm) {
                    if (!state.func_203425_a(Blocks.field_150425_aM) || !aboveState.func_196958_f() || this.recentLocations.containsKey(current)) continue;
                    farmlandSpots.add(current);
                    continue;
                }
                if (!state.func_203425_a(Blocks.field_150458_ak) || !aboveState.func_196958_f() || this.recentLocations.containsKey(current)) continue;
                farmlandSpots.add(current);
            }
        }
        if (farmlandSpots.size() == 0) {
            return null;
        }
        return (BlockPos)farmlandSpots.get((int)(Math.random() * (double)farmlandSpots.size()));
    }

    private void purgeRecentLocations() {
        long currentTime = System.currentTimeMillis();
        ArrayList<BlockPos> toPurge = new ArrayList<BlockPos>();
        for (Map.Entry<BlockPos, Long> entry : this.recentLocations.entrySet()) {
            BlockPos pos = entry.getKey();
            long time = entry.getValue();
            long timeDiff = currentTime - time;
            if (timeDiff <= (long)RECENT_LOCATIONS_EXPIRY_MS) continue;
            toPurge.add(pos);
        }
        for (BlockPos pos : toPurge) {
            this.recentLocations.remove(pos);
        }
    }

    public ItemStack getSeedFromInventory() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack itemStack = this.func_70301_a(i);
            if (!ItemTags.createOptional((ResourceLocation)new ResourceLocation("forge", "seeds")).func_230235_a_((Object)itemStack.func_77973_b()) && !extraItems.contains(itemStack.func_77973_b())) continue;
            return itemStack;
        }
        return ItemStack.field_190927_a;
    }

    public void func_73660_a() {
        ++this.counter;
        if (this.counter % 8 == 0) {
            BlockPos pos = this.func_174877_v();
            double x = (double)pos.func_177958_n() + 0.5;
            double y = (double)pos.func_177956_o() + 0.109375;
            double z = (double)pos.func_177952_p() + 0.5;
            ItemStack seedStack = this.getSeedFromInventory();
            if (seedStack != ItemStack.field_190927_a) {
                this.purgeRecentLocations();
                BlockPos farmlandPos = null;
                for (int yDelta = 0; yDelta < 5; ++yDelta) {
                    BlockPos toCheck = new BlockPos((Vector3i)pos);
                    farmlandPos = this.getNextFarmland(this.field_145850_b, toCheck = toCheck.func_177979_c(yDelta), seedStack);
                    if (farmlandPos != null) break;
                }
                if (farmlandPos != null) {
                    ThrownSeedEntity lvt_5_1_ = new ThrownSeedEntity(this.func_145831_w(), x, y, z);
                    ItemStack seed = seedStack.func_77979_a(1);
                    lvt_5_1_.func_213884_b(seed);
                    if (farmlandPos.func_177984_a().func_177956_o() == pos.func_177956_o()) {
                        y = (double)pos.func_177956_o() + 0.75;
                    }
                    this.launchTo(lvt_5_1_, x, y, z, farmlandPos);
                    this.func_145831_w().func_217376_c((Entity)lvt_5_1_);
                }
            }
        }
    }

    public void func_230337_a_(BlockState p_230337_1_, CompoundNBT p_230337_2_) {
        super.func_230337_a_(p_230337_1_, p_230337_2_);
        ItemStackHelper.func_191283_b((CompoundNBT)p_230337_2_, this.items);
    }

    public CompoundNBT func_189515_b(CompoundNBT p_189515_1_) {
        super.func_189515_b(p_189515_1_);
        ItemStackHelper.func_191282_a((CompoundNBT)p_189515_1_, this.items);
        return p_189515_1_;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.items.size(); ++i) {
            this.items.set(i, (Object)ItemStack.field_190927_a);
        }
    }

    public int func_70302_i_() {
        return 9;
    }

    public boolean func_191420_l() {
        for (int i = 0; i < this.items.size(); ++i) {
            if (this.items.get(i) == ItemStack.field_190927_a) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int var1) {
        return (ItemStack)this.items.get(var1);
    }

    public ItemStack func_70298_a(int var1, int var2) {
        return ItemStackHelper.func_188382_a(this.items, (int)var1, (int)var2);
    }

    public ItemStack func_70304_b(int var1) {
        return ItemStackHelper.func_188383_a(this.items, (int)var1);
    }

    public void func_70299_a(int var1, ItemStack var2) {
        this.items.set(var1, (Object)var2);
    }

    public boolean func_70300_a(PlayerEntity p_70300_1_) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return p_70300_1_.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    static {
        extraItems.add(Items.field_151075_bm);
        extraItems.add(Items.field_151174_bG);
        extraItems.add(Items.field_151172_bF);
    }
}

