/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.tileentities;

import com.dairymoose.modernlife.blocks.ShowerHeadBlock;
import com.dairymoose.modernlife.core.CustomBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShowerHeadTileEntity
extends TileEntity
implements ITickableTileEntity {
    public static final TileEntityType<ShowerHeadTileEntity> SHOWER_HEAD = TileEntityType.Builder.func_223042_a(ShowerHeadTileEntity::new, (Block[])new Block[]{CustomBlocks.BLOCK_SHOWER_HEAD}).func_206865_a(null);
    private static final Logger LOGGER = LogManager.getLogger();
    private boolean running = false;
    private int tickCount = 0;
    private int waterEscalateTicks = 15;
    private int currentParticleCount = 0;
    private int maxParticleCount = 20;
    private int soundStartTick = 25;

    public void startRunning() {
        this.tickCount = 0;
        this.running = true;
    }

    public void stopRunning() {
        if (this.tickCount > 0) {
            this.tickCount = 35;
        }
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        nbt.func_74757_a("running", this.running);
        return nbt;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        if (tag.func_74764_b("running")) {
            this.running = tag.func_74767_n("running");
        }
        super.handleUpdateTag(state, tag);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbtTag = new CompoundNBT();
        nbtTag.func_74757_a("running", this.running);
        return new SUpdateTileEntityPacket(this.func_174877_v(), -1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT tag = pkt.func_148857_g();
        if (tag.func_74764_b("running")) {
            this.running = tag.func_74767_n("running");
        }
    }

    public void func_230337_a_(BlockState p_230337_1_, CompoundNBT p_230337_2_) {
        super.func_230337_a_(p_230337_1_, p_230337_2_);
        if (p_230337_2_.func_74764_b("running")) {
            this.running = p_230337_2_.func_74767_n("running");
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT p_189515_1_) {
        super.func_189515_b(p_189515_1_);
        p_189515_1_.func_74757_a("running", this.running);
        return p_189515_1_;
    }

    public ShowerHeadTileEntity() {
        super(SHOWER_HEAD);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            double xStartOriginal;
            int particleCount = this.currentParticleCount;
            double horzSpread = 0.2;
            double verticalSpread = 0.37;
            double xStart = 0.5;
            double yStart = 0.51;
            double zStart = 0.65;
            if (this.func_195044_w().func_177229_b((Property)ShowerHeadBlock.FACING) == Direction.SOUTH) {
                xStart = 1.0 - xStart;
                zStart = 1.0 - zStart;
            } else if (this.func_195044_w().func_177229_b((Property)ShowerHeadBlock.FACING) == Direction.EAST) {
                xStartOriginal = xStart;
                xStart = 1.0 - zStart;
                zStart = 1.0 - xStartOriginal;
            } else if (this.func_195044_w().func_177229_b((Property)ShowerHeadBlock.FACING) == Direction.WEST) {
                xStartOriginal = xStart;
                xStart = zStart;
                zStart = xStartOriginal;
            }
            if (this.running) {
                if (this.tickCount == 0) {
                    this.currentParticleCount = 0;
                }
                if (this.tickCount % this.waterEscalateTicks == 0 && this.currentParticleCount < this.maxParticleCount) {
                    ++this.currentParticleCount;
                }
                BlockPos pos = this.func_174877_v();
                if (this.tickCount % 2 == 0) {
                    for (int i = 0; i < particleCount; ++i) {
                        if (this.field_145850_b.func_230315_m_().func_242725_p() == DimensionType.field_242711_b) {
                            double smokeRandom = 0.02;
                            if (this.tickCount % 6 != 0) continue;
                            this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)pos.func_177958_n() + xStart + (Math.random() * horzSpread - horzSpread / 2.0), (double)pos.func_177956_o() + yStart - Math.random() * verticalSpread, (double)pos.func_177952_p() + zStart + (Math.random() * horzSpread - horzSpread / 2.0), Math.random() * smokeRandom - smokeRandom / 2.0, Math.random() * smokeRandom - smokeRandom / 2.0, Math.random() * smokeRandom - smokeRandom / 2.0);
                            continue;
                        }
                        this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_218425_n, (double)pos.func_177958_n() + xStart + (Math.random() * horzSpread - horzSpread / 2.0), (double)pos.func_177956_o() + yStart - Math.random() * verticalSpread, (double)pos.func_177952_p() + zStart + (Math.random() * horzSpread - horzSpread / 2.0), 0.0, 1.0, 0.0);
                    }
                }
                if (this.tickCount % 10 == 0 && this.tickCount > this.soundStartTick) {
                    float soundRandom = 0.7f;
                    this.field_145850_b.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187917_gq, SoundCategory.BLOCKS, 1.0f, 1.0f + (float)(Math.random() * (double)soundRandom - (double)(soundRandom / 2.0f)), false);
                }
            } else if (this.tickCount > 0) {
                BlockPos pos = this.func_174877_v();
                if (this.field_145850_b.func_230315_m_().func_242725_p() == DimensionType.field_242711_b) {
                    double smokeRandom = 0.02;
                    if (this.tickCount % 6 == 0) {
                        this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)pos.func_177958_n() + xStart + (Math.random() * horzSpread - horzSpread / 2.0), (double)pos.func_177956_o() + yStart - Math.random() * verticalSpread, (double)pos.func_177952_p() + zStart + (Math.random() * horzSpread - horzSpread / 2.0), Math.random() * smokeRandom - smokeRandom / 2.0, Math.random() * smokeRandom - smokeRandom / 2.0, Math.random() * smokeRandom - smokeRandom / 2.0);
                    }
                } else {
                    this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_218425_n, (double)pos.func_177958_n() + xStart + (Math.random() * horzSpread - horzSpread / 2.0), (double)pos.func_177956_o() + yStart - Math.random() * verticalSpread, (double)pos.func_177952_p() + zStart + (Math.random() * horzSpread - horzSpread / 2.0), 0.0, 1.0, 0.0);
                }
                --this.tickCount;
            }
        }
        if (this.running) {
            ++this.tickCount;
        }
    }
}

