/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.tileentities;

import com.dairymoose.modernlife.core.CustomBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WallShelfTileEntity
extends TileEntity
implements IInventory {
    public static final TileEntityType<WallShelfTileEntity> WALL_SHELF = TileEntityType.Builder.func_223042_a(WallShelfTileEntity::wallShelf, (Block[])new Block[]{CustomBlocks.BLOCK_ACACIA_WALL_SHELF, CustomBlocks.BLOCK_BIRCH_WALL_SHELF, CustomBlocks.BLOCK_CRIMSON_WALL_SHELF, CustomBlocks.BLOCK_DARK_OAK_WALL_SHELF, CustomBlocks.BLOCK_JUNGLE_WALL_SHELF, CustomBlocks.BLOCK_OAK_WALL_SHELF, CustomBlocks.BLOCK_SPRUCE_WALL_SHELF, CustomBlocks.BLOCK_WARPED_WALL_SHELF}).func_206865_a(null);
    public static final TileEntityType<WallShelfTileEntity> DOUBLE_WALL_SHELF = TileEntityType.Builder.func_223042_a(WallShelfTileEntity::doubleWallShelf, (Block[])new Block[]{CustomBlocks.BLOCK_DOUBLE_ACACIA_WALL_SHELF, CustomBlocks.BLOCK_DOUBLE_BIRCH_WALL_SHELF, CustomBlocks.BLOCK_DOUBLE_CRIMSON_WALL_SHELF, CustomBlocks.BLOCK_DOUBLE_DARK_OAK_WALL_SHELF, CustomBlocks.BLOCK_DOUBLE_JUNGLE_WALL_SHELF, CustomBlocks.BLOCK_DOUBLE_OAK_WALL_SHELF, CustomBlocks.BLOCK_DOUBLE_SPRUCE_WALL_SHELF, CustomBlocks.BLOCK_DOUBLE_WARPED_WALL_SHELF}).func_206865_a(null);
    private static final Logger LOGGER = LogManager.getLogger();
    public static final int WALL_SHELF_CONTAINER_SIZE = 3;
    public static final int DOUBLE_WALL_SHELF_CONTAINER_SIZE = 6;
    private NonNullList<ItemStack> items = null;

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public void initItems() {
        TileEntityType type;
        if (this.items == null && (type = this.func_200662_C()) != null) {
            if (type == DOUBLE_WALL_SHELF) {
                LOGGER.debug("init with size = 6");
                this.items = NonNullList.func_191197_a((int)6, (Object)ItemStack.field_190927_a);
            } else {
                LOGGER.debug("init with size = 3");
                this.items = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
            }
        }
    }

    public boolean isFull() {
        int count = 0;
        for (int i = 0; i < this.items.size(); ++i) {
            if (((ItemStack)this.items.get(i)).func_190926_b()) continue;
            ++count;
        }
        return count == this.items.size();
    }

    public int getNextFreeSlot() {
        for (int i = 0; i < this.items.size(); ++i) {
            if (!((ItemStack)this.items.get(i)).func_190926_b()) continue;
            return i;
        }
        return -1;
    }

    public int getNextOccupiedSlot() {
        for (int i = 0; i < this.items.size(); ++i) {
            if (((ItemStack)this.items.get(i)).func_190926_b()) continue;
            return i;
        }
        return -1;
    }

    public void placeItem(ItemStack itemStack) {
        int freeSlot = this.getNextFreeSlot();
        if (freeSlot != -1) {
            this.func_70299_a(freeSlot, itemStack.func_77946_l());
        }
    }

    public void func_226984_a_(World world, BlockPos pos) {
        super.func_226984_a_(world, pos);
        this.initItems();
    }

    public WallShelfTileEntity(boolean doubleShelf) {
        super(doubleShelf ? DOUBLE_WALL_SHELF : WALL_SHELF);
    }

    public static WallShelfTileEntity wallShelf() {
        return new WallShelfTileEntity(false);
    }

    public static WallShelfTileEntity doubleWallShelf() {
        return new WallShelfTileEntity(true);
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        ItemStackHelper.func_191282_a((CompoundNBT)nbt, this.items);
        return nbt;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.initItems();
        ItemStackHelper.func_191283_b((CompoundNBT)tag, this.items);
        super.handleUpdateTag(state, tag);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbtTag = new CompoundNBT();
        ItemStackHelper.func_191282_a((CompoundNBT)nbtTag, this.items);
        return new SUpdateTileEntityPacket(this.func_174877_v(), -1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT tag = pkt.func_148857_g();
        this.initItems();
        this.items.clear();
        ItemStackHelper.func_191283_b((CompoundNBT)tag, this.items);
    }

    public void func_230337_a_(BlockState p_230337_1_, CompoundNBT p_230337_2_) {
        super.func_230337_a_(p_230337_1_, p_230337_2_);
        this.initItems();
        ItemStackHelper.func_191283_b((CompoundNBT)p_230337_2_, this.items);
    }

    public CompoundNBT func_189515_b(CompoundNBT p_189515_1_) {
        super.func_189515_b(p_189515_1_);
        ItemStackHelper.func_191282_a((CompoundNBT)p_189515_1_, this.items);
        return p_189515_1_;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.items.size(); ++i) {
            this.items.set(i, (Object)ItemStack.field_190927_a);
        }
    }

    public int func_70302_i_() {
        return this.items.size();
    }

    public boolean func_191420_l() {
        for (int i = 0; i < this.items.size(); ++i) {
            if (this.items.get(i) == ItemStack.field_190927_a) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int var1) {
        return (ItemStack)this.items.get(var1);
    }

    public ItemStack func_70298_a(int var1, int var2) {
        return ItemStackHelper.func_188382_a(this.items, (int)var1, (int)var2);
    }

    public ItemStack func_70304_b(int var1) {
        return ItemStackHelper.func_188383_a(this.items, (int)var1);
    }

    public void func_70299_a(int var1, ItemStack var2) {
        this.items.set(var1, (Object)var2);
    }

    public boolean func_70300_a(PlayerEntity p_70300_1_) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return p_70300_1_.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }
}

