/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CanvasData {
    private static final Logger LOGGER = LogManager.getLogger();
    private ByteBuffer RGBs = null;
    private int hashCode = 0;
    public static final int DEFAULT_TEXTURE_SIZE = 64;
    private int TEXTURE_SIZE = 64;
    private int MAX_SIZE_BYTES = this.TEXTURE_SIZE * this.TEXTURE_SIZE * 3;
    private boolean disabled = false;

    public void disable() {
        this.disabled = true;
    }

    public void reenable() {
        this.disabled = false;
    }

    public void setTextureSize(int tex) {
        this.TEXTURE_SIZE = tex;
        this.MAX_SIZE_BYTES = this.TEXTURE_SIZE * this.TEXTURE_SIZE * 3;
    }

    public int textureSize() {
        return this.TEXTURE_SIZE;
    }

    public boolean copyDataFrom(CanvasData other) {
        if (other.RGBs != null && other.RGBs.limit() <= this.MAX_SIZE_BYTES) {
            this.RGBs = ByteBuffer.allocate(this.MAX_SIZE_BYTES);
            other.RGBs.position(0);
            this.RGBs.put(other.RGBs);
            this.recomputeHashCode();
            return true;
        }
        return false;
    }

    public static int calculateHashCode(byte[] data) {
        int h = 1;
        for (int i = 0; i < data.length; ++i) {
            h = 31 * h + data[i];
        }
        return h;
    }

    public void recomputeHashCode() {
        this.hashCode = this.RGBs == null ? -1 : CanvasData.calculateHashCode(this.RGBs.array());
    }

    public int hashCode() {
        return this.hashCode;
    }

    public void initImage() {
        if (this.RGBs == null && !this.disabled) {
            LOGGER.debug("initImage'd RGB WAS NULL");
            this.RGBs = ByteBuffer.allocate(this.MAX_SIZE_BYTES);
            for (int x = 0; x < this.TEXTURE_SIZE; ++x) {
                for (int y = 0; y < this.TEXTURE_SIZE; ++y) {
                    this.setRgbPixel(x, y, 0xFFFFFF);
                }
            }
            this.recomputeHashCode();
        }
    }

    public boolean isValid() {
        return this.RGBs != null && this.RGBs.limit() != 0 && this.textureSize() > 0 && !this.disabled;
    }

    public byte[] toNbt() {
        return this.RGBs.array();
    }

    public byte[] toCompressedNbt() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ZipOutputStream zs = new ZipOutputStream(bos);
        byte[] nbt = this.toNbt();
        try {
            ZipEntry ze = new ZipEntry("z");
            ze.setTime(0L);
            zs.putNextEntry(ze);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        try {
            zs.write(nbt);
            zs.closeEntry();
            zs.finish();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bos.toByteArray();
    }

    public void fromNbt(byte[] nbt) {
        if (nbt == null || nbt.length <= 0 || nbt.length > this.MAX_SIZE_BYTES) {
            return;
        }
        this.RGBs = ByteBuffer.allocate(this.MAX_SIZE_BYTES);
        this.RGBs.put(nbt);
        this.recomputeHashCode();
    }

    public void fromCompressedNbt(byte[] nbt) {
        if (nbt == null || nbt.length == 0) {
            return;
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(nbt);
        ZipInputStream zs = new ZipInputStream(bis);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            zs.getNextEntry();
        }
        catch (IOException e1) {
            this.RGBs = null;
            this.recomputeHashCode();
            return;
        }
        try {
            while (true) {
                byte[] buffer;
                int readResult;
                if ((readResult = zs.read(buffer = new byte[1024])) == -1) {
                    zs.closeEntry();
                    zs.close();
                    break;
                }
                baos.write(buffer, 0, readResult);
            }
        }
        catch (IOException e) {
            LOGGER.error("error opening compressed nbt");
            this.RGBs = null;
            this.recomputeHashCode();
            return;
        }
        if (baos.size() <= 0) {
            this.RGBs = null;
            this.recomputeHashCode();
            return;
        }
        byte[] output = baos.toByteArray();
        this.fromNbt(output);
    }

    public int getAbgrOutputPixel(int x, int y) {
        if (this.RGBs == null || this.disabled) {
            return 0;
        }
        int newX = this.TEXTURE_SIZE - x - 1;
        int newY = this.TEXTURE_SIZE - y - 1;
        int logicalIndex = newY * this.TEXTURE_SIZE + newX;
        int byteIndex = logicalIndex * 3;
        this.RGBs.position(byteIndex);
        int r = this.RGBs.get() + 128;
        int g = this.RGBs.get() + 128;
        int b = this.RGBs.get() + 128;
        return r | g << 8 | b << 16 | 0xFF000000;
    }

    public void setRgbPixel(int x, int y, int rgb) {
        if (this.RGBs == null || this.disabled) {
            return;
        }
        int logicalIndex = y * this.TEXTURE_SIZE + x;
        int byteIndex = logicalIndex * 3;
        this.RGBs.position(byteIndex);
        int r = (rgb & 0xFF0000) >> 16;
        int g = (rgb & 0xFF00) >> 8;
        int b = rgb & 0xFF;
        this.RGBs.put((byte)(r - 128));
        this.RGBs.put((byte)(g - 128));
        this.RGBs.put((byte)(b - 128));
    }

    public int getRgbPixel(int x, int y) {
        if (this.RGBs == null || this.disabled) {
            return 0;
        }
        int logicalIndex = y * this.TEXTURE_SIZE + x;
        int byteIndex = logicalIndex * 3;
        this.RGBs.position(byteIndex);
        int r = this.RGBs.get() + 128;
        int g = this.RGBs.get() + 128;
        int b = this.RGBs.get() + 128;
        return r << 16 | g << 8 | b;
    }

    public int convertToRgbOutput(int rgb) {
        int r = (rgb & 0xFF0000) >> 16;
        int g = (rgb & 0xFF00) >> 8;
        int b = rgb & 0xFF;
        return r | g << 8 | b << 16 | 0xFF000000;
    }

    public static int getRValue(int rgb) {
        int r = (rgb & 0xFF0000) >> 16;
        return r;
    }

    public static int getGValue(int rgb) {
        int g = (rgb & 0xFF00) >> 8;
        return g;
    }

    public static int getBValue(int rgb) {
        int b = rgb & 0xFF;
        return b;
    }

    public static int toRgb(int r, int g, int b) {
        return r << 16 | g << 8 | b;
    }

    public int applyBlend(int newColor, int backgroundColor, double blendFactor) {
        int r = CanvasData.getRValue(newColor);
        int g = CanvasData.getGValue(newColor);
        int b = CanvasData.getBValue(newColor);
        int bgR = CanvasData.getRValue(backgroundColor);
        int bgG = CanvasData.getGValue(backgroundColor);
        int bgB = CanvasData.getBValue(backgroundColor);
        r = (int)((double)r * blendFactor) + (int)((double)bgR * (1.0 - blendFactor));
        g = (int)((double)g * blendFactor) + (int)((double)bgG * (1.0 - blendFactor));
        b = (int)((double)b * blendFactor) + (int)((double)bgB * (1.0 - blendFactor));
        int finalColor = r << 16 | (g << 8 | b);
        return finalColor;
    }

    public int getRgbOutputPixel(int x, int y) {
        if (this.RGBs == null || this.disabled) {
            return 0;
        }
        int logicalIndex = y * this.TEXTURE_SIZE + x;
        int byteIndex = logicalIndex * 3;
        this.RGBs.position(byteIndex);
        int r = this.RGBs.get() + 128;
        int g = this.RGBs.get() + 128;
        int b = this.RGBs.get() + 128;
        return r | g << 8 | b << 16 | 0xFF000000;
    }
}

