/*
 * Decompiled with CFR 0.152.
 */
package com.samebutdifferent.morevillagers.forge;

import com.samebutdifferent.morevillagers.MoreVillagers;
import com.samebutdifferent.morevillagers.mixin.PoiTypesInvoker;
import com.samebutdifferent.morevillagers.platform.forge.CommonPlatformHelperImpl;
import com.samebutdifferent.morevillagers.registry.MVBlocks;
import com.samebutdifferent.morevillagers.registry.MVProfessions;
import com.samebutdifferent.morevillagers.registry.forge.MVConfigForge;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.CreativeModeTabEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.RegistryObject;

@Mod(value="morevillagers")
public class MoreVillagersForge {
    public static CreativeModeTab TAB = null;

    public MoreVillagersForge() {
        MoreVillagers.init();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)MVConfigForge.COMMON_CONFIG);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        CommonPlatformHelperImpl.BLOCKS.register(bus);
        CommonPlatformHelperImpl.ITEMS.register(bus);
        CommonPlatformHelperImpl.POI_TYPES.register(bus);
        CommonPlatformHelperImpl.PROFESSIONS.register(bus);
        bus.addListener(this::addCreativeModeTab);
        bus.addListener(this::setup);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onServerAboutToStartEvent(ServerAboutToStartEvent event) {
        MoreVillagers.registerJigsaws(event.getServer());
    }

    private void addCreativeModeTab(CreativeModeTabEvent.Register event) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (RegistryObject registeredBlock : CommonPlatformHelperImpl.BLOCKS.getEntries()) {
            Block block = (Block)registeredBlock.get();
            if (block == null) continue;
            stacks.add(new ItemStack((ItemLike)block));
        }
        TAB = event.registerCreativeModeTab(new ResourceLocation("morevillagers", "tab"), builder -> builder.m_257941_((Component)Component.m_237115_((String)"itemGroup.morevillagers.tab")).m_257737_(() -> new ItemStack((ItemLike)Items.f_42616_)).m_257501_((enabledFlags, populator, hasPermissions) -> populator.m_246601_((Collection)stacks)));
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            MVProfessions.fillTradeData();
            MoreVillagersForge.registerBlockStates();
        });
    }

    public static void registerBlockStates() {
        PoiTypesInvoker.invokeGetBlockStates(MVBlocks.OCEANOGRAPHY_TABLE.get()).forEach(state -> PoiTypesInvoker.getTypeByState().put((BlockState)state, (Holder<PoiType>)((Holder)BuiltInRegistries.f_256941_.m_203636_(ResourceKey.m_135785_((ResourceKey)Registries.f_256805_, (ResourceLocation)new ResourceLocation("morevillagers", "oceanography_table"))).get())));
        PoiTypesInvoker.invokeGetBlockStates(MVBlocks.WOODWORKING_TABLE.get()).forEach(state -> PoiTypesInvoker.getTypeByState().put((BlockState)state, (Holder<PoiType>)((Holder)BuiltInRegistries.f_256941_.m_203636_(ResourceKey.m_135785_((ResourceKey)Registries.f_256805_, (ResourceLocation)new ResourceLocation("morevillagers", "woodworking_table"))).get())));
        PoiTypesInvoker.invokeGetBlockStates(MVBlocks.DECAYED_WORKBENCH.get()).forEach(state -> PoiTypesInvoker.getTypeByState().put((BlockState)state, (Holder<PoiType>)((Holder)BuiltInRegistries.f_256941_.m_203636_(ResourceKey.m_135785_((ResourceKey)Registries.f_256805_, (ResourceLocation)new ResourceLocation("morevillagers", "decayed_workbench"))).get())));
        PoiTypesInvoker.invokeGetBlockStates(MVBlocks.PURPUR_ALTAR.get()).forEach(state -> PoiTypesInvoker.getTypeByState().put((BlockState)state, (Holder<PoiType>)((Holder)BuiltInRegistries.f_256941_.m_203636_(ResourceKey.m_135785_((ResourceKey)Registries.f_256805_, (ResourceLocation)new ResourceLocation("morevillagers", "purpur_altar"))).get())));
        PoiTypesInvoker.invokeGetBlockStates(MVBlocks.BLUEPRINT_TABLE.get()).forEach(state -> PoiTypesInvoker.getTypeByState().put((BlockState)state, (Holder<PoiType>)((Holder)BuiltInRegistries.f_256941_.m_203636_(ResourceKey.m_135785_((ResourceKey)Registries.f_256805_, (ResourceLocation)new ResourceLocation("morevillagers", "blueprint_table"))).get())));
        PoiTypesInvoker.invokeGetBlockStates(MVBlocks.GARDENING_TABLE.get()).forEach(state -> PoiTypesInvoker.getTypeByState().put((BlockState)state, (Holder<PoiType>)((Holder)BuiltInRegistries.f_256941_.m_203636_(ResourceKey.m_135785_((ResourceKey)Registries.f_256805_, (ResourceLocation)new ResourceLocation("morevillagers", "gardening_table"))).get())));
        PoiTypesInvoker.invokeGetBlockStates(MVBlocks.HUNTING_POST.get()).forEach(state -> PoiTypesInvoker.getTypeByState().put((BlockState)state, (Holder<PoiType>)((Holder)BuiltInRegistries.f_256941_.m_203636_(ResourceKey.m_135785_((ResourceKey)Registries.f_256805_, (ResourceLocation)new ResourceLocation("morevillagers", "hunting_post"))).get())));
        PoiTypesInvoker.invokeGetBlockStates(MVBlocks.MINING_BENCH.get()).forEach(state -> PoiTypesInvoker.getTypeByState().put((BlockState)state, (Holder<PoiType>)((Holder)BuiltInRegistries.f_256941_.m_203636_(ResourceKey.m_135785_((ResourceKey)Registries.f_256805_, (ResourceLocation)new ResourceLocation("morevillagers", "mining_bench"))).get())));
    }
}

