/*
 * Decompiled with CFR 0.152.
 */
package drunkblood.netheriteelytra.item;

import drunkblood.netheriteelytra.NetheriteElytra;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ElytraItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class NetheriteElytraItem
extends ElytraItem
implements ICurio {
    public NetheriteElytraItem(Item.Properties properties) {
        super(properties);
        DispenserBlock.registerDispenseBehavior((IItemProvider)this, (IDispenseItemBehavior)ArmorItem.DISPENSER_BEHAVIOR);
    }

    public static boolean isUsable(ItemStack stack) {
        return stack.getDamage() < stack.getMaxDamage() - 1;
    }

    @ParametersAreNonnullByDefault
    public boolean getIsRepairable(ItemStack toRepair, ItemStack repair) {
        return repair.getItem() == NetheriteElytra.NETHERITE_MEMBRANE.get();
    }

    @ParametersAreNonnullByDefault
    @MethodsReturnNonnullByDefault
    public ActionResult<ItemStack> onItemRightClick(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.getHeldItem(handIn);
        EquipmentSlotType equipmentslottype = MobEntity.getSlotForItemStack((ItemStack)itemstack);
        ItemStack armorStack = playerIn.getItemStackFromSlot(equipmentslottype);
        LazyOptional curiosHandler = CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)playerIn);
        AtomicBoolean replacedCurio = new AtomicBoolean(false);
        curiosHandler.ifPresent(handler -> {
            Map curios = handler.getCurios();
            if (curios.containsKey("back")) {
                ICurioStacksHandler backHandler = (ICurioStacksHandler)curios.get("back");
                IDynamicStackHandler stackHandler = backHandler.getStacks();
                for (int i = 0; i < stackHandler.getSlots(); ++i) {
                    ItemStack stackInSlot = stackHandler.getStackInSlot(i);
                    if (!stackInSlot.isEmpty() || !armorStack.isEmpty()) continue;
                    stackHandler.setStackInSlot(i, itemstack.copy());
                    itemstack.setCount(0);
                    replacedCurio.set(true);
                    return;
                }
            }
        });
        if (replacedCurio.get()) {
            playerIn.world.playSound(null, new BlockPos(playerIn.getPositionVec()), SoundEvents.ITEM_ARMOR_EQUIP_ELYTRA, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            return ActionResult.resultSuccess((Object)itemstack);
        }
        if (armorStack.isEmpty()) {
            if (CuriosApi.getCuriosHelper().findEquippedCurio(itemstack.getItem(), (LivingEntity)playerIn).isPresent()) {
                return ActionResult.resultFail((Object)itemstack);
            }
            playerIn.setItemStackToSlot(equipmentslottype, itemstack.copy());
            itemstack.setCount(0);
            playerIn.world.playSound(null, new BlockPos(playerIn.getPositionVec()), SoundEvents.ITEM_ARMOR_EQUIP_ELYTRA, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            return ActionResult.resultSuccess((Object)itemstack);
        }
        return ActionResult.resultFail((Object)itemstack);
    }

    @Nullable
    public EquipmentSlotType getEquipmentSlot(ItemStack stack) {
        return EquipmentSlotType.CHEST;
    }

    @ParametersAreNonnullByDefault
    public boolean canElytraFly(ItemStack stack, LivingEntity entity) {
        return NetheriteElytraItem.isUsable(stack);
    }

    @ParametersAreNonnullByDefault
    public boolean elytraFlightTick(ItemStack stack, LivingEntity entity, int flightTicks) {
        if (!entity.world.isRemote && (flightTicks + 1) % 25 == 0) {
            stack.damageItem(1, entity, e -> e.sendBreakAnimation(EquipmentSlotType.CHEST));
        }
        return true;
    }

    public void curioTick(String identifier, int index, LivingEntity livingEntity) {
        super.curioTick(identifier, index, livingEntity);
        Integer ticksFlying = (Integer)ObfuscationReflectionHelper.getPrivateValue(LivingEntity.class, (Object)livingEntity, (String)"field_184629_bo");
        LazyOptional curiosHandler = CuriosApi.getCuriosHelper().getCuriosHandler(livingEntity);
        curiosHandler.ifPresent(handler -> {
            Map curios = handler.getCurios();
            ICurioStacksHandler stacksHandler = (ICurioStacksHandler)curios.get(identifier);
            IDynamicStackHandler stacks = stacksHandler.getStacks();
            ItemStack stackInSlot = stacks.getStackInSlot(index);
            stackInSlot.elytraFlightTick(livingEntity, ticksFlying.intValue());
        });
    }
}

